/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-04-28 10:13:12 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=454 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=8948 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=1185 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=161 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_duplicator_pro_entities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(100) DEFAULT NULL,
  `data` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=27 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_duplicator_pro_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=49 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_notes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `route_url` text DEFAULT NULL COMMENT 'Clean url where the note was created.',
  `route_title` varchar(255) DEFAULT NULL,
  `route_post_id` bigint(20) unsigned DEFAULT NULL COMMENT 'The post id of the route that the note was created on.',
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `element_id` varchar(60) DEFAULT NULL COMMENT 'The Elementor element ID the note is attached to.',
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `author_id` bigint(20) unsigned DEFAULT NULL,
  `author_display_name` varchar(250) DEFAULT NULL COMMENT 'Save the author name when the author was deleted.',
  `status` varchar(20) NOT NULL DEFAULT 'publish',
  `position` text DEFAULT NULL COMMENT 'A JSON string that represents the position of the note inside the element in percentages. e.g. {x:10, y:15}',
  `content` longtext DEFAULT NULL,
  `is_resolved` tinyint(1) NOT NULL DEFAULT 0,
  `is_public` tinyint(1) NOT NULL DEFAULT 1,
  `last_activity_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `route_url_index` (`route_url`(191)),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `parent_id_index` (`parent_id`),
  KEY `author_id_index` (`author_id`),
  KEY `status_index` (`status`),
  KEY `is_resolved_index` (`is_resolved`),
  KEY `is_public_index` (`is_public`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `last_activity_at_index` (`last_activity_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_notes_users_relations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) NOT NULL COMMENT 'The relation type between user and note (e.g mention, watch, read).',
  `note_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`),
  KEY `note_id_index` (`note_id`),
  KEY `user_id_index` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) DEFAULT NULL,
  `hash_id` varchar(60) NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) NOT NULL,
  `referer_title` varchar(300) DEFAULT NULL,
  `element_id` varchar(20) NOT NULL,
  `form_name` varchar(60) NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) NOT NULL,
  `user_agent` text NOT NULL,
  `actions_count` int(11) DEFAULT 0,
  `actions_succeeded_count` int(11) DEFAULT 0,
  `status` varchar(20) NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `meta` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) NOT NULL,
  `action_label` varchar(60) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `log` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `key` varchar(60) DEFAULT NULL,
  `value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=33813 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=12627 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=3894 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=MyISAM AUTO_INCREMENT=110 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_css_bkp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=48 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_layer_animations_bkp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_navigations_bkp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_sliders7` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_sliders_bkp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_slides7` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(11) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  `static` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_slides_bkp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `slider_id` int(11) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_static_slides_bkp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `slider_id` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=102 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=48 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=102 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=616 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=17953 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=182 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM AUTO_INCREMENT=196 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20)),
  KEY `zone_id` (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("130", "woocommerce_run_update_callback", "failed", "2022-05-13 08:52:28", "2022-05-13 13:22:28", "{\"update_callback\":\"wc_update_630_create_product_attributes_lookup_table\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1652431948;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1652431948;}", "3", "1", "2022-05-13 08:52:53", "2022-05-13 13:22:53", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("375", "woocommerce_cleanup_draft_orders", "complete", "2025-04-10 19:14:08", "2025-04-10 22:44:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744312448;s:18:\"\0*\0first_timestamp\";i:1665395059;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744312448;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-04-11 00:36:05", "2025-04-11 04:06:05", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("370", "woocommerce_cleanup_draft_orders", "complete", "2025-04-04 03:05:20", "2025-04-04 06:35:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743735920;s:18:\"\0*\0first_timestamp\";i:1665395059;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743735920;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-04-05 09:14:28", "2025-04-05 12:44:28", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("369", "woocommerce_cleanup_draft_orders", "complete", "2025-04-02 21:39:34", "2025-04-03 01:09:34", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743629974;s:18:\"\0*\0first_timestamp\";i:1665395059;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743629974;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-04-03 03:05:20", "2025-04-03 06:35:20", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("373", "woocommerce_cleanup_draft_orders", "complete", "2025-04-08 15:43:26", "2025-04-08 19:13:26", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744127006;s:18:\"\0*\0first_timestamp\";i:1665395059;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744127006;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-04-08 16:52:27", "2025-04-08 20:22:27", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("377", "woocommerce_run_product_attribute_lookup_regeneration_callback", "pending", "2025-04-28 09:40:00", "2025-04-28 14:10:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745833200;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745833200;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("376", "woocommerce_cleanup_draft_orders", "pending", "2025-04-12 00:36:05", "2025-04-12 04:06:05", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744418165;s:18:\"\0*\0first_timestamp\";i:1665395059;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744418165;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("368", "woocommerce_cleanup_draft_orders", "complete", "2025-03-31 15:33:12", "2025-03-31 19:03:12", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743435192;s:18:\"\0*\0first_timestamp\";i:1665395059;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743435192;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-04-01 21:39:34", "2025-04-02 01:09:34", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("366", "woocommerce_cleanup_draft_orders", "complete", "2025-03-29 11:02:24", "2025-03-29 14:32:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743246144;s:18:\"\0*\0first_timestamp\";i:1665395059;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743246144;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-03-29 13:06:48", "2025-03-29 16:36:48", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("365", "woocommerce_cleanup_draft_orders", "complete", "2025-03-27 19:04:52", "2025-03-27 22:34:52", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743102292;s:18:\"\0*\0first_timestamp\";i:1665395059;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743102292;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-03-28 11:02:24", "2025-03-28 14:32:24", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("372", "woocommerce_cleanup_draft_orders", "complete", "2025-04-07 10:22:55", "2025-04-07 13:52:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744021375;s:18:\"\0*\0first_timestamp\";i:1665395059;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744021375;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-04-07 15:43:26", "2025-04-07 19:13:26", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("371", "woocommerce_cleanup_draft_orders", "complete", "2025-04-06 09:14:28", "2025-04-06 12:44:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743930868;s:18:\"\0*\0first_timestamp\";i:1665395059;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743930868;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-04-06 10:22:55", "2025-04-06 13:52:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("361", "woocommerce_cleanup_draft_orders", "complete", "2025-03-13 10:16:16", "2025-03-13 13:46:16", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1741860976;s:18:\"\0*\0first_timestamp\";i:1665395059;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1741860976;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-03-15 09:05:16", "2025-03-15 12:35:16", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("360", "woocommerce_cleanup_draft_orders", "complete", "2025-03-11 10:10:32", "2025-03-11 13:40:32", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1741687832;s:18:\"\0*\0first_timestamp\";i:1665395059;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1741687832;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-03-12 10:16:16", "2025-03-12 13:46:16", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("362", "woocommerce_cleanup_draft_orders", "complete", "2025-03-16 09:05:16", "2025-03-16 12:35:16", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742115916;s:18:\"\0*\0first_timestamp\";i:1665395059;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742115916;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-03-18 12:44:47", "2025-03-18 16:14:47", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("363", "woocommerce_cleanup_draft_orders", "complete", "2025-03-19 12:44:47", "2025-03-19 16:14:47", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742388287;s:18:\"\0*\0first_timestamp\";i:1665395059;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742388287;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-03-19 20:40:46", "2025-03-20 00:10:46", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("364", "woocommerce_cleanup_draft_orders", "complete", "2025-03-20 20:40:46", "2025-03-21 00:10:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1742503246;s:18:\"\0*\0first_timestamp\";i:1665395059;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1742503246;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-03-26 19:04:52", "2025-03-26 22:34:52", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("367", "woocommerce_cleanup_draft_orders", "complete", "2025-03-30 13:06:48", "2025-03-30 16:36:48", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743340008;s:18:\"\0*\0first_timestamp\";i:1665395059;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743340008;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-03-30 15:33:12", "2025-03-30 19:03:12", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("374", "woocommerce_cleanup_draft_orders", "complete", "2025-04-09 16:52:27", "2025-04-09 20:22:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1744217547;s:18:\"\0*\0first_timestamp\";i:1665395059;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1744217547;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-04-09 19:14:08", "2025-04-09 22:44:08", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("378", "woocommerce_run_update_callback", "pending", "2025-04-28 09:53:05", "2025-04-28 13:23:05", "{\"update_callback\":\"wc_update_860_remove_recommended_marketing_plugins_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745833985;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745833985;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("379", "woocommerce_run_update_callback", "pending", "2025-04-28 09:53:06", "2025-04-28 13:23:06", "{\"update_callback\":\"wc_update_870_prevent_listing_of_transient_files_directory\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745833986;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745833986;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("380", "woocommerce_run_update_callback", "pending", "2025-04-28 09:53:07", "2025-04-28 13:23:07", "{\"update_callback\":\"wc_update_890_update_connect_to_woocommerce_note\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745833987;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745833987;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("381", "woocommerce_run_update_callback", "pending", "2025-04-28 09:53:08", "2025-04-28 13:23:08", "{\"update_callback\":\"wc_update_890_update_paypal_standard_load_eligibility\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745833988;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745833988;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("382", "woocommerce_run_update_callback", "pending", "2025-04-28 09:53:09", "2025-04-28 13:23:09", "{\"update_callback\":\"wc_update_891_create_plugin_autoinstall_history_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745833989;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745833989;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("383", "woocommerce_run_update_callback", "pending", "2025-04-28 09:53:10", "2025-04-28 13:23:10", "{\"update_callback\":\"wc_update_910_add_launch_your_store_tour_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745833990;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745833990;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("384", "woocommerce_run_update_callback", "pending", "2025-04-28 09:53:11", "2025-04-28 13:23:11", "{\"update_callback\":\"wc_update_910_remove_obsolete_user_meta\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745833991;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745833991;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("385", "woocommerce_run_update_callback", "pending", "2025-04-28 09:53:12", "2025-04-28 13:23:12", "{\"update_callback\":\"wc_update_920_add_wc_hooked_blocks_version_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745833992;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745833992;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("386", "woocommerce_run_update_callback", "pending", "2025-04-28 09:53:13", "2025-04-28 13:23:13", "{\"update_callback\":\"wc_update_930_add_woocommerce_coming_soon_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745833993;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745833993;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("387", "woocommerce_run_update_callback", "pending", "2025-04-28 09:53:14", "2025-04-28 13:23:14", "{\"update_callback\":\"wc_update_930_migrate_user_meta_for_launch_your_store_tour\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745833994;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745833994;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("388", "woocommerce_run_update_callback", "pending", "2025-04-28 09:53:15", "2025-04-28 13:23:15", "{\"update_callback\":\"wc_update_940_add_phone_to_order_address_fts_index\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745833995;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745833995;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("389", "woocommerce_run_update_callback", "pending", "2025-04-28 09:53:16", "2025-04-28 13:23:16", "{\"update_callback\":\"wc_update_940_remove_help_panel_highlight_shown\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745833996;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745833996;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("390", "woocommerce_run_update_callback", "pending", "2025-04-28 09:53:17", "2025-04-28 13:23:17", "{\"update_callback\":\"wc_update_950_tracking_option_autoload\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745833997;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745833997;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("391", "woocommerce_run_update_callback", "pending", "2025-04-28 09:53:18", "2025-04-28 13:23:18", "{\"update_callback\":\"wc_update_961_migrate_default_email_base_color\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745833998;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745833998;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("392", "woocommerce_run_update_callback", "pending", "2025-04-28 09:53:19", "2025-04-28 13:23:19", "{\"update_callback\":\"wc_update_980_remove_order_attribution_install_banner_dismissed_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745833999;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745833999;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("393", "woocommerce_update_db_to_current_version", "pending", "2025-04-28 09:53:20", "2025-04-28 13:23:20", "{\"version\":\"9.8.2\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834000;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834000;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("394", "woocommerce_run_update_callback", "pending", "2025-04-28 09:53:20", "2025-04-28 13:23:20", "{\"update_callback\":\"wc_update_860_remove_recommended_marketing_plugins_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834000;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834000;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("395", "woocommerce_run_update_callback", "pending", "2025-04-28 09:53:21", "2025-04-28 13:23:21", "{\"update_callback\":\"wc_update_870_prevent_listing_of_transient_files_directory\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834001;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834001;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("396", "woocommerce_run_update_callback", "pending", "2025-04-28 09:53:22", "2025-04-28 13:23:22", "{\"update_callback\":\"wc_update_890_update_connect_to_woocommerce_note\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834002;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834002;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("397", "woocommerce_run_update_callback", "pending", "2025-04-28 09:53:23", "2025-04-28 13:23:23", "{\"update_callback\":\"wc_update_890_update_paypal_standard_load_eligibility\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834003;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834003;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("398", "woocommerce_run_update_callback", "pending", "2025-04-28 09:53:24", "2025-04-28 13:23:24", "{\"update_callback\":\"wc_update_891_create_plugin_autoinstall_history_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834004;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834004;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("399", "woocommerce_run_update_callback", "pending", "2025-04-28 09:53:25", "2025-04-28 13:23:25", "{\"update_callback\":\"wc_update_910_add_launch_your_store_tour_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834005;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834005;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("400", "woocommerce_run_update_callback", "pending", "2025-04-28 09:53:26", "2025-04-28 13:23:26", "{\"update_callback\":\"wc_update_910_remove_obsolete_user_meta\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834006;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834006;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("401", "woocommerce_run_update_callback", "pending", "2025-04-28 09:53:27", "2025-04-28 13:23:27", "{\"update_callback\":\"wc_update_920_add_wc_hooked_blocks_version_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834007;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834007;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("402", "woocommerce_run_update_callback", "pending", "2025-04-28 09:53:28", "2025-04-28 13:23:28", "{\"update_callback\":\"wc_update_930_add_woocommerce_coming_soon_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834008;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834008;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("403", "woocommerce_run_update_callback", "pending", "2025-04-28 09:53:29", "2025-04-28 13:23:29", "{\"update_callback\":\"wc_update_930_migrate_user_meta_for_launch_your_store_tour\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834009;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834009;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("404", "woocommerce_run_update_callback", "pending", "2025-04-28 09:53:30", "2025-04-28 13:23:30", "{\"update_callback\":\"wc_update_940_add_phone_to_order_address_fts_index\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834010;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834010;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("405", "woocommerce_run_update_callback", "pending", "2025-04-28 09:53:31", "2025-04-28 13:23:31", "{\"update_callback\":\"wc_update_940_remove_help_panel_highlight_shown\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834011;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834011;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("406", "woocommerce_run_update_callback", "pending", "2025-04-28 09:53:32", "2025-04-28 13:23:32", "{\"update_callback\":\"wc_update_950_tracking_option_autoload\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834012;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834012;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("407", "woocommerce_run_update_callback", "pending", "2025-04-28 09:53:33", "2025-04-28 13:23:33", "{\"update_callback\":\"wc_update_961_migrate_default_email_base_color\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834013;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834013;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("408", "woocommerce_run_update_callback", "pending", "2025-04-28 09:53:34", "2025-04-28 13:23:34", "{\"update_callback\":\"wc_update_980_remove_order_attribution_install_banner_dismissed_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834014;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834014;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("409", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:19", "2025-04-28 13:24:19", "{\"update_callback\":\"wc_update_860_remove_recommended_marketing_plugins_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834059;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834059;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("410", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:20", "2025-04-28 13:24:20", "{\"update_callback\":\"wc_update_870_prevent_listing_of_transient_files_directory\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834060;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834060;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("411", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:21", "2025-04-28 13:24:21", "{\"update_callback\":\"wc_update_890_update_connect_to_woocommerce_note\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834061;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834061;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("412", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:22", "2025-04-28 13:24:22", "{\"update_callback\":\"wc_update_890_update_paypal_standard_load_eligibility\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834062;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834062;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("413", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:23", "2025-04-28 13:24:23", "{\"update_callback\":\"wc_update_891_create_plugin_autoinstall_history_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834063;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834063;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("414", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:24", "2025-04-28 13:24:24", "{\"update_callback\":\"wc_update_910_add_launch_your_store_tour_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834064;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834064;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("415", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:25", "2025-04-28 13:24:25", "{\"update_callback\":\"wc_update_910_remove_obsolete_user_meta\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834065;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834065;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("416", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:26", "2025-04-28 13:24:26", "{\"update_callback\":\"wc_update_920_add_wc_hooked_blocks_version_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834066;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834066;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("417", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:27", "2025-04-28 13:24:27", "{\"update_callback\":\"wc_update_930_add_woocommerce_coming_soon_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834067;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834067;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("418", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:28", "2025-04-28 13:24:28", "{\"update_callback\":\"wc_update_930_migrate_user_meta_for_launch_your_store_tour\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834068;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834068;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("419", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:29", "2025-04-28 13:24:29", "{\"update_callback\":\"wc_update_940_add_phone_to_order_address_fts_index\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834069;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834069;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("420", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:30", "2025-04-28 13:24:30", "{\"update_callback\":\"wc_update_940_remove_help_panel_highlight_shown\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834070;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834070;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("421", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:31", "2025-04-28 13:24:31", "{\"update_callback\":\"wc_update_950_tracking_option_autoload\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834071;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834071;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("422", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:32", "2025-04-28 13:24:32", "{\"update_callback\":\"wc_update_961_migrate_default_email_base_color\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834072;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834072;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("423", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:33", "2025-04-28 13:24:33", "{\"update_callback\":\"wc_update_980_remove_order_attribution_install_banner_dismissed_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834073;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834073;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("424", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:28", "2025-04-28 13:24:28", "{\"update_callback\":\"wc_update_860_remove_recommended_marketing_plugins_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834068;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834068;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("425", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:29", "2025-04-28 13:24:29", "{\"update_callback\":\"wc_update_870_prevent_listing_of_transient_files_directory\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834069;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834069;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("426", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:30", "2025-04-28 13:24:30", "{\"update_callback\":\"wc_update_890_update_connect_to_woocommerce_note\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834070;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834070;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("427", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:31", "2025-04-28 13:24:31", "{\"update_callback\":\"wc_update_890_update_paypal_standard_load_eligibility\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834071;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834071;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("428", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:32", "2025-04-28 13:24:32", "{\"update_callback\":\"wc_update_891_create_plugin_autoinstall_history_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834072;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834072;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("429", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:33", "2025-04-28 13:24:33", "{\"update_callback\":\"wc_update_910_add_launch_your_store_tour_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834073;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834073;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("430", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:34", "2025-04-28 13:24:34", "{\"update_callback\":\"wc_update_910_remove_obsolete_user_meta\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834074;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834074;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("431", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:35", "2025-04-28 13:24:35", "{\"update_callback\":\"wc_update_920_add_wc_hooked_blocks_version_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834075;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834075;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("432", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:36", "2025-04-28 13:24:36", "{\"update_callback\":\"wc_update_930_add_woocommerce_coming_soon_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834076;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834076;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("433", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:37", "2025-04-28 13:24:37", "{\"update_callback\":\"wc_update_930_migrate_user_meta_for_launch_your_store_tour\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834077;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834077;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("434", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:38", "2025-04-28 13:24:38", "{\"update_callback\":\"wc_update_940_add_phone_to_order_address_fts_index\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834078;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834078;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("435", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:39", "2025-04-28 13:24:39", "{\"update_callback\":\"wc_update_940_remove_help_panel_highlight_shown\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834079;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834079;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("436", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:40", "2025-04-28 13:24:40", "{\"update_callback\":\"wc_update_950_tracking_option_autoload\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834080;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834080;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("437", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:41", "2025-04-28 13:24:41", "{\"update_callback\":\"wc_update_961_migrate_default_email_base_color\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834081;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834081;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("438", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:42", "2025-04-28 13:24:42", "{\"update_callback\":\"wc_update_980_remove_order_attribution_install_banner_dismissed_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834082;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834082;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("439", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:42", "2025-04-28 13:24:42", "{\"update_callback\":\"wc_update_860_remove_recommended_marketing_plugins_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834082;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834082;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("440", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:43", "2025-04-28 13:24:43", "{\"update_callback\":\"wc_update_870_prevent_listing_of_transient_files_directory\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834083;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834083;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("441", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:44", "2025-04-28 13:24:44", "{\"update_callback\":\"wc_update_890_update_connect_to_woocommerce_note\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834084;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834084;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("442", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:45", "2025-04-28 13:24:45", "{\"update_callback\":\"wc_update_890_update_paypal_standard_load_eligibility\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834085;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834085;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("443", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:46", "2025-04-28 13:24:46", "{\"update_callback\":\"wc_update_891_create_plugin_autoinstall_history_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834086;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834086;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("444", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:47", "2025-04-28 13:24:47", "{\"update_callback\":\"wc_update_910_add_launch_your_store_tour_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834087;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834087;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("445", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:48", "2025-04-28 13:24:48", "{\"update_callback\":\"wc_update_910_remove_obsolete_user_meta\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834088;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834088;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("446", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:49", "2025-04-28 13:24:49", "{\"update_callback\":\"wc_update_920_add_wc_hooked_blocks_version_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834089;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834089;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("447", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:50", "2025-04-28 13:24:50", "{\"update_callback\":\"wc_update_930_add_woocommerce_coming_soon_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834090;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834090;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("448", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:51", "2025-04-28 13:24:51", "{\"update_callback\":\"wc_update_930_migrate_user_meta_for_launch_your_store_tour\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834091;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834091;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("449", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:52", "2025-04-28 13:24:52", "{\"update_callback\":\"wc_update_940_add_phone_to_order_address_fts_index\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834092;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834092;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("450", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:53", "2025-04-28 13:24:53", "{\"update_callback\":\"wc_update_940_remove_help_panel_highlight_shown\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834093;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834093;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("451", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:54", "2025-04-28 13:24:54", "{\"update_callback\":\"wc_update_950_tracking_option_autoload\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834094;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834094;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("452", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:55", "2025-04-28 13:24:55", "{\"update_callback\":\"wc_update_961_migrate_default_email_base_color\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834095;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834095;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("453", "woocommerce_run_update_callback", "pending", "2025-04-28 09:54:56", "2025-04-28 13:24:56", "{\"update_callback\":\"wc_update_980_remove_order_attribution_install_banner_dismissed_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745834096;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745834096;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "wc-admin-data");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "woocommerce-remote-inbox-engine");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("351", "130", "ایجاد فعالیت", "2022-05-13 08:52:28", "2022-05-13 13:22:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("379", "130", "عملیات توسط WP Cron شروع شد", "2022-05-13 08:52:53", "2022-05-13 13:22:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("380", "130", "action failed via WP Cron: Can\'t enable or disable the attributes lookup table usage while it\'s regenerating.", "2022-05-13 08:52:53", "2022-05-13 13:22:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1097", "372", "عملیات توسط WP Cron کامل شد", "2025-04-07 15:43:26", "2025-04-07 19:13:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1091", "370", "عملیات توسط WP Cron کامل شد", "2025-04-05 09:14:28", "2025-04-05 12:44:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1094", "371", "عملیات توسط WP Cron کامل شد", "2025-04-06 10:22:55", "2025-04-06 13:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1085", "368", "عملیات توسط WP Cron کامل شد", "2025-04-01 21:39:34", "2025-04-02 01:09:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("1074", "365", "ایجاد فعالیت", "2025-03-26 19:04:52", "2025-03-26 22:34:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1082", "367", "عملیات توسط WP Cron کامل شد", "2025-03-30 15:33:12", "2025-03-30 19:03:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1073", "364", "عملیات توسط WP Cron کامل شد", "2025-03-26 19:04:52", "2025-03-26 22:34:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1104", "375", "ایجاد فعالیت", "2025-04-09 19:14:08", "2025-04-09 22:44:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1096", "372", "عملیات توسط WP Cron شروع شد", "2025-04-07 15:43:26", "2025-04-07 19:13:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1107", "376", "ایجاد فعالیت", "2025-04-11 00:36:05", "2025-04-11 04:06:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1103", "374", "عملیات توسط WP Cron کامل شد", "2025-04-09 19:14:08", "2025-04-09 22:44:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1102", "374", "عملیات توسط WP Cron شروع شد", "2025-04-09 19:14:08", "2025-04-09 22:44:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1075", "365", "عملیات توسط WP Cron شروع شد", "2025-03-28 11:02:24", "2025-03-28 14:32:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("1072", "364", "عملیات توسط WP Cron شروع شد", "2025-03-26 19:04:52", "2025-03-26 22:34:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1081", "367", "عملیات توسط WP Cron شروع شد", "2025-03-30 15:33:12", "2025-03-30 19:03:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1084", "368", "عملیات توسط WP Cron شروع شد", "2025-04-01 21:39:34", "2025-04-02 01:09:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("1093", "371", "عملیات توسط WP Cron شروع شد", "2025-04-06 10:22:55", "2025-04-06 13:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1092", "371", "ایجاد فعالیت", "2025-04-05 09:14:28", "2025-04-05 12:44:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1090", "370", "عملیات توسط WP Cron شروع شد", "2025-04-05 09:14:28", "2025-04-05 12:44:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1106", "375", "عملیات توسط WP Cron کامل شد", "2025-04-11 00:36:05", "2025-04-11 04:06:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1105", "375", "عملیات توسط WP Cron شروع شد", "2025-04-11 00:36:05", "2025-04-11 04:06:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1059", "360", "ایجاد فعالیت", "2025-03-10 10:10:32", "2025-03-10 13:40:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1060", "360", "عملیات توسط WP Cron شروع شد", "2025-03-12 10:16:16", "2025-03-12 13:46:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("1061", "360", "عملیات توسط WP Cron کامل شد", "2025-03-12 10:16:16", "2025-03-12 13:46:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("1062", "361", "ایجاد فعالیت", "2025-03-12 10:16:16", "2025-03-12 13:46:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("1063", "361", "عملیات توسط WP Cron شروع شد", "2025-03-15 09:05:16", "2025-03-15 12:35:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("1064", "361", "عملیات توسط WP Cron کامل شد", "2025-03-15 09:05:16", "2025-03-15 12:35:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("1065", "362", "ایجاد فعالیت", "2025-03-15 09:05:16", "2025-03-15 12:35:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("1066", "362", "عملیات توسط WP Cron شروع شد", "2025-03-18 12:44:47", "2025-03-18 16:14:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("1067", "362", "عملیات توسط WP Cron کامل شد", "2025-03-18 12:44:47", "2025-03-18 16:14:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("1068", "363", "ایجاد فعالیت", "2025-03-18 12:44:47", "2025-03-18 16:14:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("1069", "363", "عملیات توسط WP Cron شروع شد", "2025-03-19 20:40:46", "2025-03-20 00:10:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1070", "363", "عملیات توسط WP Cron کامل شد", "2025-03-19 20:40:46", "2025-03-20 00:10:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1071", "364", "ایجاد فعالیت", "2025-03-19 20:40:46", "2025-03-20 00:10:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1076", "365", "عملیات توسط WP Cron کامل شد", "2025-03-28 11:02:24", "2025-03-28 14:32:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("1077", "366", "ایجاد فعالیت", "2025-03-28 11:02:24", "2025-03-28 14:32:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("1078", "366", "عملیات توسط WP Cron شروع شد", "2025-03-29 13:06:48", "2025-03-29 16:36:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("1079", "366", "عملیات توسط WP Cron کامل شد", "2025-03-29 13:06:48", "2025-03-29 16:36:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("1080", "367", "ایجاد فعالیت", "2025-03-29 13:06:48", "2025-03-29 16:36:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("1083", "368", "ایجاد فعالیت", "2025-03-30 15:33:12", "2025-03-30 19:03:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1086", "369", "ایجاد فعالیت", "2025-04-01 21:39:34", "2025-04-02 01:09:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("1087", "369", "عملیات توسط WP Cron شروع شد", "2025-04-03 03:05:20", "2025-04-03 06:35:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1088", "369", "عملیات توسط WP Cron کامل شد", "2025-04-03 03:05:20", "2025-04-03 06:35:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1089", "370", "ایجاد فعالیت", "2025-04-03 03:05:20", "2025-04-03 06:35:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1095", "372", "ایجاد فعالیت", "2025-04-06 10:22:55", "2025-04-06 13:52:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1098", "373", "ایجاد فعالیت", "2025-04-07 15:43:26", "2025-04-07 19:13:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1099", "373", "عملیات توسط WP Cron شروع شد", "2025-04-08 16:52:27", "2025-04-08 20:22:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1100", "373", "عملیات توسط WP Cron کامل شد", "2025-04-08 16:52:27", "2025-04-08 20:22:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1101", "374", "ایجاد فعالیت", "2025-04-08 16:52:27", "2025-04-08 20:22:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1108", "377", "ایجاد فعالیت", "2025-04-28 09:39:59", "2025-04-28 14:09:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1109", "378", "ایجاد فعالیت", "2025-04-28 09:53:05", "2025-04-28 13:23:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1110", "379", "ایجاد فعالیت", "2025-04-28 09:53:05", "2025-04-28 13:23:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1111", "380", "ایجاد فعالیت", "2025-04-28 09:53:05", "2025-04-28 13:23:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1112", "381", "ایجاد فعالیت", "2025-04-28 09:53:05", "2025-04-28 13:23:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1113", "382", "ایجاد فعالیت", "2025-04-28 09:53:05", "2025-04-28 13:23:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1114", "383", "ایجاد فعالیت", "2025-04-28 09:53:05", "2025-04-28 13:23:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1115", "384", "ایجاد فعالیت", "2025-04-28 09:53:05", "2025-04-28 13:23:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1116", "385", "ایجاد فعالیت", "2025-04-28 09:53:05", "2025-04-28 13:23:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1117", "386", "ایجاد فعالیت", "2025-04-28 09:53:05", "2025-04-28 13:23:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1118", "387", "ایجاد فعالیت", "2025-04-28 09:53:05", "2025-04-28 13:23:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1119", "388", "ایجاد فعالیت", "2025-04-28 09:53:05", "2025-04-28 13:23:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1120", "389", "ایجاد فعالیت", "2025-04-28 09:53:05", "2025-04-28 13:23:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1121", "390", "ایجاد فعالیت", "2025-04-28 09:53:05", "2025-04-28 13:23:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1122", "391", "ایجاد فعالیت", "2025-04-28 09:53:05", "2025-04-28 13:23:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1123", "392", "ایجاد فعالیت", "2025-04-28 09:53:05", "2025-04-28 13:23:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1124", "393", "ایجاد فعالیت", "2025-04-28 09:53:05", "2025-04-28 13:23:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1125", "394", "ایجاد فعالیت", "2025-04-28 09:53:20", "2025-04-28 13:23:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1126", "395", "ایجاد فعالیت", "2025-04-28 09:53:20", "2025-04-28 13:23:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1127", "396", "ایجاد فعالیت", "2025-04-28 09:53:20", "2025-04-28 13:23:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1128", "397", "ایجاد فعالیت", "2025-04-28 09:53:20", "2025-04-28 13:23:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1129", "398", "ایجاد فعالیت", "2025-04-28 09:53:20", "2025-04-28 13:23:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1130", "399", "ایجاد فعالیت", "2025-04-28 09:53:20", "2025-04-28 13:23:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1131", "400", "ایجاد فعالیت", "2025-04-28 09:53:20", "2025-04-28 13:23:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1132", "401", "ایجاد فعالیت", "2025-04-28 09:53:20", "2025-04-28 13:23:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1133", "402", "ایجاد فعالیت", "2025-04-28 09:53:20", "2025-04-28 13:23:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1134", "403", "ایجاد فعالیت", "2025-04-28 09:53:20", "2025-04-28 13:23:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1135", "404", "ایجاد فعالیت", "2025-04-28 09:53:20", "2025-04-28 13:23:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1136", "405", "ایجاد فعالیت", "2025-04-28 09:53:20", "2025-04-28 13:23:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1137", "406", "ایجاد فعالیت", "2025-04-28 09:53:20", "2025-04-28 13:23:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1138", "407", "ایجاد فعالیت", "2025-04-28 09:53:20", "2025-04-28 13:23:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1139", "408", "ایجاد فعالیت", "2025-04-28 09:53:20", "2025-04-28 13:23:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1140", "409", "ایجاد فعالیت", "2025-04-28 09:54:19", "2025-04-28 13:24:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("1141", "410", "ایجاد فعالیت", "2025-04-28 09:54:19", "2025-04-28 13:24:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("1142", "411", "ایجاد فعالیت", "2025-04-28 09:54:19", "2025-04-28 13:24:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("1143", "412", "ایجاد فعالیت", "2025-04-28 09:54:19", "2025-04-28 13:24:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("1144", "413", "ایجاد فعالیت", "2025-04-28 09:54:19", "2025-04-28 13:24:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("1145", "414", "ایجاد فعالیت", "2025-04-28 09:54:19", "2025-04-28 13:24:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("1146", "415", "ایجاد فعالیت", "2025-04-28 09:54:19", "2025-04-28 13:24:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("1147", "416", "ایجاد فعالیت", "2025-04-28 09:54:19", "2025-04-28 13:24:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("1148", "417", "ایجاد فعالیت", "2025-04-28 09:54:19", "2025-04-28 13:24:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("1149", "418", "ایجاد فعالیت", "2025-04-28 09:54:19", "2025-04-28 13:24:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("1150", "419", "ایجاد فعالیت", "2025-04-28 09:54:19", "2025-04-28 13:24:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("1151", "420", "ایجاد فعالیت", "2025-04-28 09:54:19", "2025-04-28 13:24:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("1152", "421", "ایجاد فعالیت", "2025-04-28 09:54:19", "2025-04-28 13:24:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("1153", "422", "ایجاد فعالیت", "2025-04-28 09:54:19", "2025-04-28 13:24:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("1154", "423", "ایجاد فعالیت", "2025-04-28 09:54:19", "2025-04-28 13:24:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("1155", "424", "ایجاد فعالیت", "2025-04-28 09:54:28", "2025-04-28 13:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1156", "425", "ایجاد فعالیت", "2025-04-28 09:54:28", "2025-04-28 13:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1157", "426", "ایجاد فعالیت", "2025-04-28 09:54:28", "2025-04-28 13:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1158", "427", "ایجاد فعالیت", "2025-04-28 09:54:28", "2025-04-28 13:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1159", "428", "ایجاد فعالیت", "2025-04-28 09:54:28", "2025-04-28 13:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1160", "429", "ایجاد فعالیت", "2025-04-28 09:54:28", "2025-04-28 13:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1161", "430", "ایجاد فعالیت", "2025-04-28 09:54:28", "2025-04-28 13:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1162", "431", "ایجاد فعالیت", "2025-04-28 09:54:28", "2025-04-28 13:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1163", "432", "ایجاد فعالیت", "2025-04-28 09:54:28", "2025-04-28 13:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1164", "433", "ایجاد فعالیت", "2025-04-28 09:54:28", "2025-04-28 13:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1165", "434", "ایجاد فعالیت", "2025-04-28 09:54:28", "2025-04-28 13:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1166", "435", "ایجاد فعالیت", "2025-04-28 09:54:28", "2025-04-28 13:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1167", "436", "ایجاد فعالیت", "2025-04-28 09:54:28", "2025-04-28 13:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1168", "437", "ایجاد فعالیت", "2025-04-28 09:54:28", "2025-04-28 13:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1169", "438", "ایجاد فعالیت", "2025-04-28 09:54:28", "2025-04-28 13:24:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1170", "439", "ایجاد فعالیت", "2025-04-28 09:54:42", "2025-04-28 13:24:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1171", "440", "ایجاد فعالیت", "2025-04-28 09:54:42", "2025-04-28 13:24:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1172", "441", "ایجاد فعالیت", "2025-04-28 09:54:42", "2025-04-28 13:24:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1173", "442", "ایجاد فعالیت", "2025-04-28 09:54:42", "2025-04-28 13:24:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1174", "443", "ایجاد فعالیت", "2025-04-28 09:54:42", "2025-04-28 13:24:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1175", "444", "ایجاد فعالیت", "2025-04-28 09:54:42", "2025-04-28 13:24:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1176", "445", "ایجاد فعالیت", "2025-04-28 09:54:42", "2025-04-28 13:24:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1177", "446", "ایجاد فعالیت", "2025-04-28 09:54:42", "2025-04-28 13:24:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1178", "447", "ایجاد فعالیت", "2025-04-28 09:54:42", "2025-04-28 13:24:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1179", "448", "ایجاد فعالیت", "2025-04-28 09:54:42", "2025-04-28 13:24:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1180", "449", "ایجاد فعالیت", "2025-04-28 09:54:42", "2025-04-28 13:24:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1181", "450", "ایجاد فعالیت", "2025-04-28 09:54:42", "2025-04-28 13:24:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1182", "451", "ایجاد فعالیت", "2025-04-28 09:54:42", "2025-04-28 13:24:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1183", "452", "ایجاد فعالیت", "2025-04-28 09:54:42", "2025-04-28 13:24:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1184", "453", "ایجاد فعالیت", "2025-04-28 09:54:42", "2025-04-28 13:24:42");

/* INSERT TABLE DATA: wp_commentmeta */
INSERT INTO `wp_commentmeta` VALUES("141", "43", "_rating", "a:1:{s:11:\"default-key\";s:1:\"5\";}");
INSERT INTO `wp_commentmeta` VALUES("142", "43", "_rating_avg", "5");
INSERT INTO `wp_commentmeta` VALUES("143", "44", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("144", "44", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("49", "12", "akismet_error", "1582942993");
INSERT INTO `wp_commentmeta` VALUES("50", "12", "akismet_history", "a:4:{s:4:\"time\";s:15:\"1582942993.5134\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:5:\"admin\";s:4:\"meta\";a:1:{s:8:\"response\";s:7:\"invalid\";}}");
INSERT INTO `wp_commentmeta` VALUES("51", "12", "rating", "4");
INSERT INTO `wp_commentmeta` VALUES("52", "12", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("53", "12", "_wxr_import_user", "1");
INSERT INTO `wp_commentmeta` VALUES("54", "13", "akismet_error", "1582943063");
INSERT INTO `wp_commentmeta` VALUES("55", "13", "akismet_history", "a:3:{s:4:\"time\";s:15:\"1582943063.3872\";s:5:\"event\";s:11:\"check-error\";s:4:\"meta\";a:1:{s:8:\"response\";s:7:\"invalid\";}}");
INSERT INTO `wp_commentmeta` VALUES("56", "13", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("57", "13", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("58", "13", "akismet_history", "a:3:{s:4:\"time\";s:15:\"1582943078.8202\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:5:\"admin\";}");
INSERT INTO `wp_commentmeta` VALUES("59", "14", "akismet_error", "1583900430");
INSERT INTO `wp_commentmeta` VALUES("60", "14", "akismet_history", "a:3:{s:4:\"time\";s:15:\"1583900430.4321\";s:5:\"event\";s:11:\"check-error\";s:4:\"meta\";a:1:{s:8:\"response\";s:7:\"invalid\";}}");
INSERT INTO `wp_commentmeta` VALUES("61", "14", "_rating", "a:1:{s:11:\"default-key\";s:1:\"4\";}");
INSERT INTO `wp_commentmeta` VALUES("62", "14", "_rating_avg", "4");
INSERT INTO `wp_commentmeta` VALUES("63", "14", "akismet_history", "a:3:{s:4:\"time\";s:14:\"1583900457.224\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:5:\"admin\";}");
INSERT INTO `wp_commentmeta` VALUES("69", "16", "akismet_error", "1585043191");
INSERT INTO `wp_commentmeta` VALUES("70", "16", "akismet_history", "a:4:{s:4:\"time\";s:15:\"1585043191.9559\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:5:\"admin\";s:4:\"meta\";a:1:{s:8:\"response\";s:7:\"invalid\";}}");
INSERT INTO `wp_commentmeta` VALUES("71", "16", "_rating", "a:1:{s:11:\"default-key\";s:1:\"4\";}");
INSERT INTO `wp_commentmeta` VALUES("72", "16", "_rating_avg", "4");
INSERT INTO `wp_commentmeta` VALUES("73", "16", "_wxr_import_user", "1");
INSERT INTO `wp_commentmeta` VALUES("74", "17", "akismet_error", "1586421927");
INSERT INTO `wp_commentmeta` VALUES("75", "17", "akismet_history", "a:4:{s:4:\"time\";s:15:\"1586421927.0571\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:11:\"SamuelSmith\";s:4:\"meta\";a:1:{s:8:\"response\";s:7:\"invalid\";}}");
INSERT INTO `wp_commentmeta` VALUES("76", "17", "_rating", "a:1:{s:11:\"default-key\";s:1:\"5\";}");
INSERT INTO `wp_commentmeta` VALUES("77", "17", "_rating_avg", "5");
INSERT INTO `wp_commentmeta` VALUES("78", "17", "akismet_history", "a:3:{s:4:\"time\";s:15:\"1586421939.4826\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:5:\"admin\";}");
INSERT INTO `wp_commentmeta` VALUES("79", "17", "_wxr_import_user", "4");
INSERT INTO `wp_commentmeta` VALUES("86", "19", "akismet_error", "1586422039");
INSERT INTO `wp_commentmeta` VALUES("87", "19", "akismet_history", "a:4:{s:4:\"time\";s:15:\"1586422039.1178\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:5:\"admin\";s:4:\"meta\";a:1:{s:8:\"response\";s:7:\"invalid\";}}");
INSERT INTO `wp_commentmeta` VALUES("88", "19", "_rating", "a:1:{s:11:\"default-key\";s:1:\"3\";}");
INSERT INTO `wp_commentmeta` VALUES("89", "19", "_rating_avg", "3");
INSERT INTO `wp_commentmeta` VALUES("90", "19", "_wxr_import_user", "1");
INSERT INTO `wp_commentmeta` VALUES("91", "20", "akismet_error", "1586422001");
INSERT INTO `wp_commentmeta` VALUES("92", "20", "akismet_history", "a:4:{s:4:\"time\";s:15:\"1586422002.0199\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:5:\"admin\";s:4:\"meta\";a:1:{s:8:\"response\";s:7:\"invalid\";}}");
INSERT INTO `wp_commentmeta` VALUES("93", "20", "_rating", "a:1:{s:11:\"default-key\";s:1:\"4\";}");
INSERT INTO `wp_commentmeta` VALUES("94", "20", "_rating_avg", "4");
INSERT INTO `wp_commentmeta` VALUES("95", "20", "_wxr_import_user", "1");
INSERT INTO `wp_commentmeta` VALUES("96", "21", "akismet_error", "1585816533");
INSERT INTO `wp_commentmeta` VALUES("97", "21", "akismet_history", "a:4:{s:4:\"time\";s:15:\"1585816533.5377\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:5:\"admin\";s:4:\"meta\";a:1:{s:8:\"response\";s:7:\"invalid\";}}");
INSERT INTO `wp_commentmeta` VALUES("98", "21", "_rating", "a:1:{s:11:\"default-key\";s:1:\"4\";}");
INSERT INTO `wp_commentmeta` VALUES("99", "21", "_rating_avg", "4");
INSERT INTO `wp_commentmeta` VALUES("100", "21", "_wxr_import_user", "1");
INSERT INTO `wp_commentmeta` VALUES("106", "23", "akismet_error", "1585816497");
INSERT INTO `wp_commentmeta` VALUES("107", "23", "akismet_history", "a:4:{s:4:\"time\";s:15:\"1585816497.6833\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:5:\"admin\";s:4:\"meta\";a:1:{s:8:\"response\";s:7:\"invalid\";}}");
INSERT INTO `wp_commentmeta` VALUES("108", "23", "_rating", "a:1:{s:11:\"default-key\";s:1:\"4\";}");
INSERT INTO `wp_commentmeta` VALUES("109", "23", "_rating_avg", "4");
INSERT INTO `wp_commentmeta` VALUES("110", "23", "_wxr_import_user", "1");
INSERT INTO `wp_commentmeta` VALUES("111", "24", "akismet_error", "1585816260");
INSERT INTO `wp_commentmeta` VALUES("112", "24", "akismet_history", "a:4:{s:4:\"time\";s:15:\"1585816260.1057\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:5:\"admin\";s:4:\"meta\";a:1:{s:8:\"response\";s:7:\"invalid\";}}");
INSERT INTO `wp_commentmeta` VALUES("113", "24", "_rating", "a:1:{s:11:\"default-key\";s:1:\"4\";}");
INSERT INTO `wp_commentmeta` VALUES("114", "24", "_rating_avg", "4");
INSERT INTO `wp_commentmeta` VALUES("115", "24", "_wxr_import_user", "1");
INSERT INTO `wp_commentmeta` VALUES("121", "26", "akismet_error", "1585816080");
INSERT INTO `wp_commentmeta` VALUES("122", "26", "akismet_history", "a:4:{s:4:\"time\";s:15:\"1585816080.9293\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:5:\"admin\";s:4:\"meta\";a:1:{s:8:\"response\";s:7:\"invalid\";}}");
INSERT INTO `wp_commentmeta` VALUES("123", "26", "_rating", "a:1:{s:11:\"default-key\";s:1:\"4\";}");
INSERT INTO `wp_commentmeta` VALUES("124", "26", "_rating_avg", "4");
INSERT INTO `wp_commentmeta` VALUES("125", "26", "_wxr_import_user", "1");
INSERT INTO `wp_commentmeta` VALUES("131", "28", "akismet_error", "1585815239");
INSERT INTO `wp_commentmeta` VALUES("132", "28", "akismet_history", "a:4:{s:4:\"time\";s:15:\"1585815239.1376\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:5:\"admin\";s:4:\"meta\";a:1:{s:8:\"response\";s:7:\"invalid\";}}");
INSERT INTO `wp_commentmeta` VALUES("133", "28", "_rating", "a:1:{s:11:\"default-key\";s:1:\"4\";}");
INSERT INTO `wp_commentmeta` VALUES("134", "28", "_rating_avg", "4");
INSERT INTO `wp_commentmeta` VALUES("135", "28", "_wxr_import_user", "1");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("46", "3052", "علی نیازی", "aliniyazi.email@gmail.com", "", "", "2020-07-17 12:49:27", "2020-07-17 08:19:27", "وضعیت سفارش توسط ویرایش توده‌ای تغییر یافت: وضعیت سفارش از در انتظار بررسی به تکمیل شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("44", "1385", "toswp", "aref.dariavi@gmail.com", "", "::1", "2020-05-23 19:50:31", "2020-05-23 15:20:31", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است.", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36 OPR/68.0.3618.125", "review", "0", "2");
INSERT INTO `wp_comments` VALUES("50", "3688", "علی نیازی", "aliniyazi.email@gmail.com", "", "", "2020-08-10 20:06:01", "2020-08-10 15:36:01", "وضعیت سفارش از در انتظار بررسی به تکمیل شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("48", "3695", "علی نیازی", "aliniyazi.email@gmail.com", "", "", "2020-07-19 13:28:48", "2020-07-19 08:58:48", "موارد اضافه شده: طرح استاندارد (#1389)", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("49", "3695", "علی نیازی", "aliniyazi.email@gmail.com", "", "", "2020-07-19 13:29:16", "2020-07-19 08:59:16", "وضعیت سفارش از در انتظار پرداخت به تکمیل شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("12", "1375", "admin", "aliniyazi.email@gmail.com", "", "::1", "2020-02-29 02:23:13", "2020-02-29 02:23:13", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است", "0", "1", "", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("13", "1375", "هستی", "aref.dariavi@gmail.com", "", "::1", "2020-02-29 02:24:23", "2020-02-28 22:54:23", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است", "0", "1", "", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("14", "1458", "توس وردپرس", "aref.dariavi@gmail.com", "", "::1", "2020-03-11 04:20:30", "2020-03-11 00:50:30", "خانه ای زیبا ، بسیار زیبا و نزدیک به همه چیز در درخت! برای یک آخر هفته گرم کمی گرم است ، اما دوست دارم در فصول سردتر برگردید!", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("16", "1460", "admin", "aliniyazi.email@gmail.com", "", "::1", "2020-03-24 09:46:31", "2020-03-24 09:46:31", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("17", "2470", "عارف", "to@aliniyazi.info", "https://www.aliniyazi.info", "::1", "2020-04-09 08:45:26", "2020-04-09 04:15:26", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("19", "2473", "admin", "aliniyazi.email@gmail.com", "", "::1", "2020-04-09 08:47:19", "2020-04-09 08:47:19", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("20", "2474", "admin", "aliniyazi.email@gmail.com", "", "::1", "2020-04-09 08:46:41", "2020-04-09 08:46:41", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("21", "2476", "admin", "aliniyazi.email@gmail.com", "https://www.aliniyazi.info", "::1", "2020-04-02 08:35:33", "2020-04-02 08:35:33", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("23", "2477", "admin", "aliniyazi.email@gmail.com", "", "::1", "2020-04-02 08:34:57", "2020-04-02 08:34:57", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("24", "2478", "admin", "aliniyazi.email@gmail.com", "", "::1", "2020-04-02 08:31:00", "2020-04-02 08:31:00", "آشپزخانه دارای فضایی شگفت انگیز ، لوازم جدید و یک اتاق لباسشویی است. از دیگر ویژگی های آن می توان به کف غنی از شاه ماهی بذر ، قالبهای تاج و سقف های تابستانی در سراسر آپارتمان اشاره کرد.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("26", "2479", "admin", "aliniyazi.email@gmail.com", "", "::1", "2020-04-02 08:28:00", "2020-04-02 08:28:00", "با اسباب و اثاثیه کامل. واحد کاربری زیبا منصوب در محل برتر واقع شده است. PS6 سالن ورودی گسترده به یک اتاق نشیمن بزرگ با فضای غذاخوری منتهی می شود.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("28", "2480", "admin", "aliniyazi.email@gmail.com", "https://www.aliniyazi.info", "::1", "2020-04-02 08:13:59", "2020-04-02 08:13:59", "اتاق خواب دوم اتاق گوشه ای با پنجره های دو نفره است. آشپزخانه دارای فضایی شگفت انگیز ، لوازم جدید و یک اتاق لباسشویی است.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("30", "1395", "WooCommerce", "", "", "", "2020-02-29 03:47:14", "2020-02-29 03:47:14", "Awaiting BACS payment Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("31", "1396", "WooCommerce", "", "", "", "2020-02-29 04:22:22", "2020-02-29 04:22:22", "Awaiting BACS payment Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("32", "1751", "WooCommerce", "", "", "", "2020-03-06 07:50:22", "2020-03-06 07:50:22", "Awaiting BACS payment Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("33", "1751", "admin", "admin@apus.com", "", "", "2020-03-24 08:50:05", "2020-03-24 08:50:05", "Order status changed from On hold to Completed.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("34", "2273", "WooCommerce", "", "", "", "2020-03-24 08:52:55", "2020-03-24 08:52:55", "Awaiting BACS payment Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("35", "2273", "admin", "admin@apus.com", "", "", "2020-03-24 08:53:34", "2020-03-24 08:53:34", "Order status changed from On hold to Completed.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("36", "2277", "WooCommerce", "", "", "", "2020-03-24 08:54:28", "2020-03-24 08:54:28", "Awaiting BACS payment Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("37", "2277", "admin", "admin@apus.com", "", "", "2020-03-24 08:54:55", "2020-03-24 08:54:55", "Order status changed from On hold to Completed.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("38", "2907", "WooCommerce", "", "", "", "2020-04-09 07:47:09", "2020-04-09 07:47:09", "Awaiting BACS payment Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("39", "2933", "WooCommerce", "", "", "", "2020-04-10 09:42:25", "2020-04-10 09:42:25", "Awaiting BACS payment Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("40", "3020", "WooCommerce", "", "", "", "2020-04-17 09:03:42", "2020-04-17 09:03:42", "Awaiting BACS payment Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("41", "3052", "WooCommerce", "", "", "", "2020-04-18 03:18:02", "2020-04-18 03:18:02", "Awaiting BACS payment Order status changed from Pending payment to On hold.", "0", "1", "", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("45", "3688", "ووکامرس", "", "", "", "2020-07-17 12:48:37", "2020-07-17 08:18:37", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("42", "252", "toswp", "", "", "::1", "2020-05-19 17:27:44", "2020-05-19 12:57:44", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36 OPR/68.0.3618.104", "comment", "0", "2");
INSERT INTO `wp_comments` VALUES("43", "3612", "toswp", "", "", "::1", "2020-05-23 19:36:45", "2020-05-23 15:06:45", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است.", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36 OPR/68.0.3618.125", "comment", "0", "2");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("5", "Homeo_1254_elementor_toswpir", "da99c9c2512c4f246449_20250428101258", "20", "2025-04-28 10:13:12", "toswp", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-04-28 10:12:58\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:3:\"6.8\";s:9:\"VersionDB\";s:6:\"11.4.5\";s:10:\"VersionPHP\";s:6:\"8.2.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:5;s:4:\"Name\";s:28:\"Homeo_1254_elementor_toswpir\";s:4:\"Hash\";s:35:\"da99c9c2512c4f246449_20250428101258\";s:8:\"NameHash\";s:64:\"Homeo_1254_elementor_toswpir_da99c9c2512c4f246449_20250428101258\";s:4:\"Type\";i:0;s:5:\"Notes\";s:8:\"toswp.ir\";s:8:\"ScanFile\";s:74:\"Homeo_1254_elementor_toswpir_da99c9c2512c4f246449_20250428101258_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.8\";s:6:\"WPUser\";s:5:\"toswp\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:76:\"Homeo_1254_elementor_toswpir_da99c9c2512c4f246449_20250428101258_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:29:\"/home/toswpir/homeo.tooswp.ir\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:4185;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:23936;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-04-28 10:12:58\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:3:\"6.8\";s:9:\"VersionDB\";s:6:\"11.4.5\";s:10:\"VersionPHP\";s:6:\"8.2.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:28:\"Homeo_1254_elementor_toswpir\";s:4:\"Hash\";s:35:\"da99c9c2512c4f246449_20250428101258\";s:8:\"NameHash\";s:64:\"Homeo_1254_elementor_toswpir_da99c9c2512c4f246449_20250428101258\";s:4:\"Type\";i:0;s:5:\"Notes\";s:8:\"toswp.ir\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:82:\"Homeo_1254_elementor_toswpir_da99c9c2512c4f246449_20250428101258_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:43:\"/home/toswpir/homeo.tooswp.ir/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:77:\"Homeo_1254_elementor_toswpir_da99c9c2512c4f246449_20250428101258_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:139:\"/home/toswpir/homeo.tooswp.ir/wp-content/backups-dup-lite/tmp/Homeo_1254_elementor_toswpir_da99c9c2512c4f246449_20250428101258_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:38:\"/home/toswpir/homeo.tooswp.ir/wp-admin\";i:1;s:41:\"/home/toswpir/homeo.tooswp.ir/wp-includes\";i:2;s:50:\"/home/toswpir/homeo.tooswp.ir/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:29:\"/home/toswpir/homeo.tooswp.ir\";i:1;s:29:\"/home/toswpir/homeo.tooswp.ir\";i:2;s:40:\"/home/toswpir/homeo.tooswp.ir/wp-content\";i:3;s:48:\"/home/toswpir/homeo.tooswp.ir/wp-content/uploads\";i:4;s:48:\"/home/toswpir/homeo.tooswp.ir/wp-content/plugins\";i:5;s:51:\"/home/toswpir/homeo.tooswp.ir/wp-content/mu-plugins\";i:6;s:47:\"/home/toswpir/homeo.tooswp.ir/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:61:\"/home/toswpir/homeo.tooswp.ir/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_duplicator_pro_entities */
INSERT INTO `wp_duplicator_pro_entities` VALUES("1", "DUP_PRO_Global_Entity", "{\n    \"uninstall_settings\": 0,\n    \"uninstall_packages\": 0,\n    \"uninstall_tables\": true,\n    \"crypt\": false,\n    \"wpfront_integrate\": 0,\n    \"package_ui_created\": 1,\n    \"package_mysqldump\": 0,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 1,\n    \"package_phpdump_qrylimit\": 500,\n    \"package_php_chunking\": null,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"archive_build_mode\": 3,\n    \"archive_compression\": false,\n    \"ziparchive_validation\": null,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 6,\n    \"homepath_as_abspath\": false,\n    \"archive_build_mode_schedule\": -1,\n    \"archive_compression_schedule\": true,\n    \"server_load_reduction\": 1,\n    \"max_package_runtime_in_min\": 0,\n    \"php_max_worker_time_in_sec\": 18,\n    \"lock_mode\": 1,\n    \"json_mode\": 0,\n    \"ajax_protocol\": \"https\",\n    \"custom_ajax_url\": \"https:\\/\\/homeo.tooswp.ir\\/wp-admin\\/admin-ajax.php\",\n    \"server_kick_off_sslverify\": true,\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"basic_auth_password\": \"\",\n    \"installer_base_name\": \"installer.php\",\n    \"chunk_size\": 2048,\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"max_default_store_files\": 20,\n    \"purge_default_package_record\": false,\n    \"dropbox_upload_chunksize_in_kb\": 2000,\n    \"dropbox_transfer_mode\": 1,\n    \"gdrive_upload_chunksize_in_kb\": 1024,\n    \"s3_upload_part_size_in_kb\": 6000,\n    \"manual_mode_storage_ids\": [\n        \"-2\"\n    ],\n    \"license_status\": 0,\n    \"license_expiration_time\": 1588804485,\n    \"license_no_activations_left\": false,\n    \"license_key_visible\": true,\n    \"lkp\": \"\",\n    \"license_limit\": -1,\n    \"last_edd_api_response\": null,\n    \"last_edd_api_timestamp\": 0,\n    \"last_system_check_timestamp\": 1700550770,\n    \"initial_activation_timestamp\": 1588804496,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"ipv4_only\": false,\n    \"debug_on\": 0,\n    \"trace_profiler_on\": 0,\n    \"unhook_third_party_js\": 0,\n    \"unhook_third_party_css\": 0,\n    \"profile_idea\": false,\n    \"profile_beta\": false,\n    \"dupHidePackagesGiftFeatures\": false,\n    \"type\": \"DUP_PRO_Global_Entity\",\n    \"installer_name_mode\": \"simple\",\n    \"onedrive_upload_chunksize_in_kb\": 3200,\n    \"import_chunk_size\": 1024,\n    \"notices\": {\n        \"dupArchiveSwitch\": false\n    }\n}");
INSERT INTO `wp_duplicator_pro_entities` VALUES("2", "DUP_PRO_Secure_Global_Entity", "{\n    \"basic_auth_password\": null,\n    \"lkp\": \"\",\n    \"type\": \"DUP_PRO_Secure_Global_Entity\"\n}");
INSERT INTO `wp_duplicator_pro_entities` VALUES("3", "DUP_PRO_System_Global_Entity", "{\n    \"recommended_fixes\": [\n        {\n            \"recommended_fix_type\": 0,\n            \"error_text\": \"Communication to AJAX is blocked.\",\n            \"parameter1\": \"See FAQ: <a href=\'http:\\/\\/snapcreek.com\\/duplicator\\/docs\\/faqs-tech\\/#faq-package-100-q\' target=\'_blank\'>Why is the package build stuck at 5%?<\\/a>\",\n            \"parameter2\": \"\"\n        }\n    ],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1700555778,\n    \"type\": \"DUP_PRO_System_Global_Entity\"\n}");
INSERT INTO `wp_duplicator_pro_entities` VALUES("4", "DUP_PRO_Package_Template_Entity", "{\"name\":\"Default\",\"notes\":\"The default template.\",\"filter_sites\":[],\"archive_export_onlydb\":0,\"archive_filter_on\":0,\"archive_filter_dirs\":\"\",\"archive_filter_exts\":\"\",\"archive_filter_files\":\"\",\"database_filter_on\":0,\"database_filter_tables\":\"\",\"database_compatibility_modes\":[],\"installer_opts_secure_on\":null,\"installer_opts_secure_pass\":null,\"installer_opts_skip_scan\":null,\"installer_opts_db_host\":null,\"installer_opts_db_name\":null,\"installer_opts_db_user\":null,\"installer_opts_cpnl_enable\":false,\"installer_opts_cpnl_host\":\"\",\"installer_opts_cpnl_user\":\"\",\"installer_opts_cpnl_pass\":\"\",\"installer_opts_cpnl_db_action\":\"create\",\"installer_opts_cpnl_db_host\":\"\",\"installer_opts_cpnl_db_name\":\"\",\"installer_opts_cpnl_db_user\":\"\",\"installer_opts_brand\":-2,\"is_default\":true,\"is_manual\":false,\"type\":\"DUP_PRO_Package_Template_Entity\"}");
INSERT INTO `wp_duplicator_pro_entities` VALUES("5", "DUP_PRO_Package_Template_Entity", "{\n    \"name\": \"[Manual Mode]\",\n    \"notes\": \"toswp.ir\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"database_filter_on\": 0,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": 0,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"type\": \"DUP_PRO_Package_Template_Entity\"\n}");
INSERT INTO `wp_duplicator_pro_entities` VALUES("26", "DUP_PRO_DupArchive_Expand_State_Entity", "{\n    \"package_id\": 43,\n    \"basePath\": \"\\/home\\/toswpir\\/homeo.tooswp.ir\\/wp-content\\/backups-dup-pro\\/tmp\\/validate\",\n    \"archivePath\": \"\\/home\\/toswpir\\/homeo.tooswp.ir\\/wp-content\\/backups-dup-pro\\/tmp\\/20230610_d982d8a7d984d8a8d8a7d985d984d8_ce6843106031433d6822_20230610164458_archive.daf\",\n    \"isCompressed\": true,\n    \"currentFileOffset\": 0,\n    \"archiveOffset\": 219351886,\n    \"timeSliceInSecs\": 10,\n    \"working\": false,\n    \"startTimestamp\": -1,\n    \"throttleDelayInUs\": 500,\n    \"timeoutTimestamp\": 1686415801,\n    \"timerEnabled\": true,\n    \"archiveHeaderString\": \"{\\\"version\\\":\\\"3.8.9.1\\\",\\\"isCompressed\\\":true}\",\n    \"currentFileHeaderString\": null,\n    \"failuresString\": \"[]\",\n    \"validateOnly\": true,\n    \"validationType\": 1,\n    \"fileWriteCount\": 21014,\n    \"directoryWriteCount\": 3718,\n    \"expectedFileCount\": 21014,\n    \"expectedDirectoryCount\": 3718,\n    \"isRobust\": false,\n    \"type\": \"DUP_PRO_DupArchive_Expand_State_Entity\",\n    \"currentFileHeader\": null,\n    \"skipWpCoreFiles\": false,\n    \"filteredDirectories\": [],\n    \"filteredFiles\": [],\n    \"includedFiles\": [],\n    \"fileRenames\": [],\n    \"directoryModeOverride\": -1,\n    \"fileModeOverride\": -1,\n    \"lastHeaderOffset\": -1,\n    \"failures\": [],\n    \"failureCount\": 0\n}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://homeo.tooswp.ir", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://homeo.tooswp.ir", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "قالب املاک هومیو|homeo|توس وردپرس", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "ابرپوسته وردپرس در زمینه املاک", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "aref.dariavi@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "j F Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:485:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:11:\"property/?$\";s:28:\"index.php?post_type=property\";s:41:\"property/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=property&feed=$matches[1]\";s:36:\"property/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=property&feed=$matches[1]\";s:28:\"property/page/([0-9]{1,})/?$\";s:46:\"index.php?post_type=property&paged=$matches[1]\";s:9:\"agency/?$\";s:26:\"index.php?post_type=agency\";s:39:\"agency/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?post_type=agency&feed=$matches[1]\";s:34:\"agency/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?post_type=agency&feed=$matches[1]\";s:26:\"agency/page/([0-9]{1,})/?$\";s:44:\"index.php?post_type=agency&paged=$matches[1]\";s:8:\"agent/?$\";s:25:\"index.php?post_type=agent\";s:38:\"agent/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=agent&feed=$matches[1]\";s:33:\"agent/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=agent&feed=$matches[1]\";s:25:\"agent/page/([0-9]{1,})/?$\";s:43:\"index.php?post_type=agent&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:54:\"property-type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?property_type=$matches[1]&feed=$matches[2]\";s:49:\"property-type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?property_type=$matches[1]&feed=$matches[2]\";s:30:\"property-type/([^/]+)/embed/?$\";s:46:\"index.php?property_type=$matches[1]&embed=true\";s:42:\"property-type/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?property_type=$matches[1]&paged=$matches[2]\";s:24:\"property-type/([^/]+)/?$\";s:35:\"index.php?property_type=$matches[1]\";s:58:\"property-location/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?property_location=$matches[1]&feed=$matches[2]\";s:53:\"property-location/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?property_location=$matches[1]&feed=$matches[2]\";s:34:\"property-location/([^/]+)/embed/?$\";s:50:\"index.php?property_location=$matches[1]&embed=true\";s:46:\"property-location/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?property_location=$matches[1]&paged=$matches[2]\";s:28:\"property-location/([^/]+)/?$\";s:39:\"index.php?property_location=$matches[1]\";s:56:\"property-status/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?property_status=$matches[1]&feed=$matches[2]\";s:51:\"property-status/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?property_status=$matches[1]&feed=$matches[2]\";s:32:\"property-status/([^/]+)/embed/?$\";s:48:\"index.php?property_status=$matches[1]&embed=true\";s:44:\"property-status/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?property_status=$matches[1]&paged=$matches[2]\";s:26:\"property-status/([^/]+)/?$\";s:37:\"index.php?property_status=$matches[1]\";s:55:\"property-label/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?property_label=$matches[1]&feed=$matches[2]\";s:50:\"property-label/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?property_label=$matches[1]&feed=$matches[2]\";s:31:\"property-label/([^/]+)/embed/?$\";s:47:\"index.php?property_label=$matches[1]&embed=true\";s:43:\"property-label/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?property_label=$matches[1]&paged=$matches[2]\";s:25:\"property-label/([^/]+)/?$\";s:36:\"index.php?property_label=$matches[1]\";s:57:\"property-amenity/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?property_amenity=$matches[1]&feed=$matches[2]\";s:52:\"property-amenity/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?property_amenity=$matches[1]&feed=$matches[2]\";s:33:\"property-amenity/([^/]+)/embed/?$\";s:49:\"index.php?property_amenity=$matches[1]&embed=true\";s:45:\"property-amenity/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?property_amenity=$matches[1]&paged=$matches[2]\";s:27:\"property-amenity/([^/]+)/?$\";s:38:\"index.php?property_amenity=$matches[1]\";s:58:\"property-material/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?property_material=$matches[1]&feed=$matches[2]\";s:53:\"property-material/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?property_material=$matches[1]&feed=$matches[2]\";s:34:\"property-material/([^/]+)/embed/?$\";s:50:\"index.php?property_material=$matches[1]&embed=true\";s:46:\"property-material/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?property_material=$matches[1]&paged=$matches[2]\";s:28:\"property-material/([^/]+)/?$\";s:39:\"index.php?property_material=$matches[1]\";s:55:\"agent-location/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?agent_location=$matches[1]&feed=$matches[2]\";s:50:\"agent-location/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?agent_location=$matches[1]&feed=$matches[2]\";s:31:\"agent-location/([^/]+)/embed/?$\";s:47:\"index.php?agent_location=$matches[1]&embed=true\";s:43:\"agent-location/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?agent_location=$matches[1]&paged=$matches[2]\";s:25:\"agent-location/([^/]+)/?$\";s:36:\"index.php?agent_location=$matches[1]\";s:55:\"agent-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?agent_category=$matches[1]&feed=$matches[2]\";s:50:\"agent-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?agent_category=$matches[1]&feed=$matches[2]\";s:31:\"agent-category/([^/]+)/embed/?$\";s:47:\"index.php?agent_category=$matches[1]&embed=true\";s:43:\"agent-category/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?agent_category=$matches[1]&paged=$matches[2]\";s:25:\"agent-category/([^/]+)/?$\";s:36:\"index.php?agent_category=$matches[1]\";s:56:\"agency-location/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?agency_location=$matches[1]&feed=$matches[2]\";s:51:\"agency-location/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?agency_location=$matches[1]&feed=$matches[2]\";s:32:\"agency-location/([^/]+)/embed/?$\";s:48:\"index.php?agency_location=$matches[1]&embed=true\";s:44:\"agency-location/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?agency_location=$matches[1]&paged=$matches[2]\";s:26:\"agency-location/([^/]+)/?$\";s:37:\"index.php?agency_location=$matches[1]\";s:56:\"agency-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?agency_category=$matches[1]&feed=$matches[2]\";s:51:\"agency-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?agency_category=$matches[1]&feed=$matches[2]\";s:32:\"agency-category/([^/]+)/embed/?$\";s:48:\"index.php?agency_category=$matches[1]&embed=true\";s:44:\"agency-category/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?agency_category=$matches[1]&paged=$matches[2]\";s:26:\"agency-category/([^/]+)/?$\";s:37:\"index.php?agency_category=$matches[1]\";s:47:\"برند/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:42:\"برند/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:23:\"برند/(.+?)/embed/?$\";s:46:\"index.php?product_brand=$matches[1]&embed=true\";s:35:\"برند/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?product_brand=$matches[1]&paged=$matches[2]\";s:17:\"برند/(.+?)/?$\";s:35:\"index.php?product_brand=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:44:\"product/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"product/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"mc4wp-form/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"mc4wp-form/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"mc4wp-form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"mc4wp-form/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"mc4wp-form/([^/]+)/embed/?$\";s:43:\"index.php?mc4wp-form=$matches[1]&embed=true\";s:31:\"mc4wp-form/([^/]+)/trackback/?$\";s:37:\"index.php?mc4wp-form=$matches[1]&tb=1\";s:39:\"mc4wp-form/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&paged=$matches[2]\";s:46:\"mc4wp-form/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&cpage=$matches[2]\";s:47:\"mc4wp-form/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?mc4wp-form=$matches[1]&wc/file/transient=$matches[3]\";s:36:\"mc4wp-form/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?mc4wp-form=$matches[1]&wc-api=$matches[3]\";s:53:\"mc4wp-form/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:64:\"mc4wp-form/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"mc4wp-form/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:53:\"mc4wp-form/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:35:\"mc4wp-form/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?mc4wp-form=$matches[1]&page=$matches[2]\";s:27:\"mc4wp-form/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"mc4wp-form/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"mc4wp-form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"mc4wp-form/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:36:\"property/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"property/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"property/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"property/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"property/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"property/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:25:\"property/([^/]+)/embed/?$\";s:41:\"index.php?property=$matches[1]&embed=true\";s:29:\"property/([^/]+)/trackback/?$\";s:35:\"index.php?property=$matches[1]&tb=1\";s:49:\"property/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?property=$matches[1]&feed=$matches[2]\";s:44:\"property/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?property=$matches[1]&feed=$matches[2]\";s:37:\"property/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?property=$matches[1]&paged=$matches[2]\";s:44:\"property/([^/]+)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?property=$matches[1]&cpage=$matches[2]\";s:45:\"property/([^/]+)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?property=$matches[1]&wc/file/transient=$matches[3]\";s:34:\"property/([^/]+)/wc-api(/(.*))?/?$\";s:49:\"index.php?property=$matches[1]&wc-api=$matches[3]\";s:51:\"property/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:62:\"property/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:40:\"property/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:51:\"property/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:33:\"property/([^/]+)(?:/([0-9]+))?/?$\";s:47:\"index.php?property=$matches[1]&page=$matches[2]\";s:25:\"property/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:35:\"property/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:55:\"property/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"property/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"property/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"property/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"agency/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"agency/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"agency/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"agency/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"agency/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"agency/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"agency/([^/]+)/embed/?$\";s:39:\"index.php?agency=$matches[1]&embed=true\";s:27:\"agency/([^/]+)/trackback/?$\";s:33:\"index.php?agency=$matches[1]&tb=1\";s:47:\"agency/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?agency=$matches[1]&feed=$matches[2]\";s:42:\"agency/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?agency=$matches[1]&feed=$matches[2]\";s:35:\"agency/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?agency=$matches[1]&paged=$matches[2]\";s:42:\"agency/([^/]+)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?agency=$matches[1]&cpage=$matches[2]\";s:43:\"agency/([^/]+)/wc/file/transient(/(.*))?/?$\";s:58:\"index.php?agency=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"agency/([^/]+)/wc-api(/(.*))?/?$\";s:47:\"index.php?agency=$matches[1]&wc-api=$matches[3]\";s:49:\"agency/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:60:\"agency/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:38:\"agency/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:49:\"agency/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:31:\"agency/([^/]+)(?:/([0-9]+))?/?$\";s:45:\"index.php?agency=$matches[1]&page=$matches[2]\";s:23:\"agency/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"agency/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"agency/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"agency/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"agency/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"agency/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"agent/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"agent/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"agent/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"agent/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"agent/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"agent/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"agent/([^/]+)/embed/?$\";s:38:\"index.php?agent=$matches[1]&embed=true\";s:26:\"agent/([^/]+)/trackback/?$\";s:32:\"index.php?agent=$matches[1]&tb=1\";s:46:\"agent/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?agent=$matches[1]&feed=$matches[2]\";s:41:\"agent/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?agent=$matches[1]&feed=$matches[2]\";s:34:\"agent/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?agent=$matches[1]&paged=$matches[2]\";s:41:\"agent/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?agent=$matches[1]&cpage=$matches[2]\";s:42:\"agent/([^/]+)/wc/file/transient(/(.*))?/?$\";s:57:\"index.php?agent=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"agent/([^/]+)/wc-api(/(.*))?/?$\";s:46:\"index.php?agent=$matches[1]&wc-api=$matches[3]\";s:48:\"agent/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:59:\"agent/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:37:\"agent/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:48:\"agent/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:30:\"agent/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?agent=$matches[1]&page=$matches[2]\";s:22:\"agent/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"agent/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"agent/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"agent/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"agent/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"agent/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"saved_search/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"saved_search/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"saved_search/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"saved_search/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"saved_search/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"saved_search/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"saved_search/([^/]+)/embed/?$\";s:45:\"index.php?saved_search=$matches[1]&embed=true\";s:33:\"saved_search/([^/]+)/trackback/?$\";s:39:\"index.php?saved_search=$matches[1]&tb=1\";s:41:\"saved_search/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?saved_search=$matches[1]&paged=$matches[2]\";s:48:\"saved_search/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?saved_search=$matches[1]&cpage=$matches[2]\";s:49:\"saved_search/([^/]+)/wc/file/transient(/(.*))?/?$\";s:64:\"index.php?saved_search=$matches[1]&wc/file/transient=$matches[3]\";s:38:\"saved_search/([^/]+)/wc-api(/(.*))?/?$\";s:53:\"index.php?saved_search=$matches[1]&wc-api=$matches[3]\";s:55:\"saved_search/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:66:\"saved_search/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:44:\"saved_search/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:55:\"saved_search/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:37:\"saved_search/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?saved_search=$matches[1]&page=$matches[2]\";s:29:\"saved_search/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"saved_search/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"saved_search/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"saved_search/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"saved_search/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"saved_search/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"private_message/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"private_message/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"private_message/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"private_message/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"private_message/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"private_message/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"private_message/([^/]+)/embed/?$\";s:48:\"index.php?private_message=$matches[1]&embed=true\";s:36:\"private_message/([^/]+)/trackback/?$\";s:42:\"index.php?private_message=$matches[1]&tb=1\";s:44:\"private_message/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?private_message=$matches[1]&paged=$matches[2]\";s:51:\"private_message/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?private_message=$matches[1]&cpage=$matches[2]\";s:52:\"private_message/([^/]+)/wc/file/transient(/(.*))?/?$\";s:67:\"index.php?private_message=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"private_message/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?private_message=$matches[1]&wc-api=$matches[3]\";s:58:\"private_message/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:69:\"private_message/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:47:\"private_message/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:58:\"private_message/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:40:\"private_message/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?private_message=$matches[1]&page=$matches[2]\";s:32:\"private_message/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"private_message/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"private_message/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"private_message/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"private_message/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"private_message/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"property_package/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"property_package/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"property_package/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"property_package/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"property_package/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"property_package/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"property_package/([^/]+)/embed/?$\";s:49:\"index.php?property_package=$matches[1]&embed=true\";s:37:\"property_package/([^/]+)/trackback/?$\";s:43:\"index.php?property_package=$matches[1]&tb=1\";s:45:\"property_package/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?property_package=$matches[1]&paged=$matches[2]\";s:52:\"property_package/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?property_package=$matches[1]&cpage=$matches[2]\";s:53:\"property_package/([^/]+)/wc/file/transient(/(.*))?/?$\";s:68:\"index.php?property_package=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"property_package/([^/]+)/wc-api(/(.*))?/?$\";s:57:\"index.php?property_package=$matches[1]&wc-api=$matches[3]\";s:59:\"property_package/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:70:\"property_package/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:48:\"property_package/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:59:\"property_package/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:41:\"property_package/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?property_package=$matches[1]&page=$matches[2]\";s:33:\"property_package/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"property_package/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"property_package/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"property_package/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"property_package/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"property_package/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"apus_footer/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"apus_footer/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"apus_footer/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"apus_footer/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"apus_footer/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"apus_footer/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"apus_footer/([^/]+)/embed/?$\";s:44:\"index.php?apus_footer=$matches[1]&embed=true\";s:32:\"apus_footer/([^/]+)/trackback/?$\";s:38:\"index.php?apus_footer=$matches[1]&tb=1\";s:40:\"apus_footer/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?apus_footer=$matches[1]&paged=$matches[2]\";s:47:\"apus_footer/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?apus_footer=$matches[1]&cpage=$matches[2]\";s:48:\"apus_footer/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?apus_footer=$matches[1]&wc/file/transient=$matches[3]\";s:37:\"apus_footer/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?apus_footer=$matches[1]&wc-api=$matches[3]\";s:54:\"apus_footer/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:65:\"apus_footer/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:43:\"apus_footer/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:54:\"apus_footer/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:36:\"apus_footer/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?apus_footer=$matches[1]&page=$matches[2]\";s:28:\"apus_footer/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"apus_footer/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"apus_footer/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"apus_footer/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"apus_footer/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"apus_footer/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:41:\"apus_megamenu/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"apus_megamenu/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"apus_megamenu/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"apus_megamenu/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"apus_megamenu/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"apus_megamenu/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"apus_megamenu/([^/]+)/embed/?$\";s:46:\"index.php?apus_megamenu=$matches[1]&embed=true\";s:34:\"apus_megamenu/([^/]+)/trackback/?$\";s:40:\"index.php?apus_megamenu=$matches[1]&tb=1\";s:42:\"apus_megamenu/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?apus_megamenu=$matches[1]&paged=$matches[2]\";s:49:\"apus_megamenu/([^/]+)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?apus_megamenu=$matches[1]&cpage=$matches[2]\";s:50:\"apus_megamenu/([^/]+)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?apus_megamenu=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"apus_megamenu/([^/]+)/wc-api(/(.*))?/?$\";s:54:\"index.php?apus_megamenu=$matches[1]&wc-api=$matches[3]\";s:56:\"apus_megamenu/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:67:\"apus_megamenu/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:45:\"apus_megamenu/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:56:\"apus_megamenu/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:38:\"apus_megamenu/([^/]+)(?:/([0-9]+))?/?$\";s:52:\"index.php?apus_megamenu=$matches[1]&page=$matches[2]\";s:30:\"apus_megamenu/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"apus_megamenu/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"apus_megamenu/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"apus_megamenu/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"apus_megamenu/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"apus_megamenu/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"apus_header/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"apus_header/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"apus_header/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"apus_header/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"apus_header/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"apus_header/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"apus_header/([^/]+)/embed/?$\";s:44:\"index.php?apus_header=$matches[1]&embed=true\";s:32:\"apus_header/([^/]+)/trackback/?$\";s:38:\"index.php?apus_header=$matches[1]&tb=1\";s:40:\"apus_header/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?apus_header=$matches[1]&paged=$matches[2]\";s:47:\"apus_header/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?apus_header=$matches[1]&cpage=$matches[2]\";s:48:\"apus_header/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?apus_header=$matches[1]&wc/file/transient=$matches[3]\";s:37:\"apus_header/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?apus_header=$matches[1]&wc-api=$matches[3]\";s:54:\"apus_header/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:65:\"apus_header/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:43:\"apus_header/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:54:\"apus_header/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:36:\"apus_header/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?apus_header=$matches[1]&page=$matches[2]\";s:28:\"apus_header/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"apus_header/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"apus_header/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"apus_header/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"apus_header/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"apus_header/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=13&cpage=$matches[1]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:36:\"([^/]+)/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?name=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\"[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("33772", "_transient_timeout_wre_cats_dcf81f7507e70781e5dd58fec31cafec", "1746438938", "off");
INSERT INTO `wp_options` VALUES("30667", "elementor_clear_cache", "", "yes");
INSERT INTO `wp_options` VALUES("30668", "elementor_reset_api_data", "", "yes");
INSERT INTO `wp_options` VALUES("30670", "elementor_enable_inspector", "", "yes");
INSERT INTO `wp_options` VALUES("30671", "elementor_replace_url", "", "yes");
INSERT INTO `wp_options` VALUES("30672", "elementor_rollback", "", "yes");
INSERT INTO `wp_options` VALUES("30673", "elementor_rollback_pro_separator", "", "yes");
INSERT INTO `wp_options` VALUES("30674", "elementor_rollback_pro", "", "yes");
INSERT INTO `wp_options` VALUES("30675", "elementor_beta", "no", "yes");
INSERT INTO `wp_options` VALUES("30676", "elementor_maintenance_mode_mode", "", "yes");
INSERT INTO `wp_options` VALUES("30677", "elementor_maintenance_mode_exclude_mode", "logged_in", "yes");
INSERT INTO `wp_options` VALUES("30678", "elementor_maintenance_mode_exclude_roles", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("30679", "elementor_maintenance_mode_template_id", "", "yes");
INSERT INTO `wp_options` VALUES("30686", "e_editor_counter", "6", "yes");
INSERT INTO `wp_options` VALUES("30687", "_transient_timeout__elementor_ab_test_plg_site_mailer_submission", "1747717650", "no");
INSERT INTO `wp_options` VALUES("30688", "_transient__elementor_ab_test_plg_site_mailer_submission", "1", "no");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:13:{i:0;s:31:\"wp-realestate/wp-realestate.php\";i:1;s:33:\"apus-framework/apus-framework.php\";i:2;s:13:\"cmb2/init.php\";i:3;s:36:\"contact-form-7/wp-contact-form-7.php\";i:4;s:25:\"duplicator/duplicator.php\";i:5;s:31:\"elementor-pro/elementor-pro.php\";i:6;s:23:\"elementor/elementor.php\";i:7;s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";i:8;s:23:\"revslider/revslider.php\";i:9;s:27:\"woocommerce/woocommerce.php\";i:10;s:29:\"wp-parsidate/wp-parsidate.php\";i:11;s:41:\"wp-private-message/wp-private-message.php\";i:12;s:65:\"wp-realestate-wc-paid-listings/wp-realestate-wc-paid-listings.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:3:{i:0;s:63:\"/home/toswpir/homeo.tooswp.ir/wp-content/themes/homeo/style.css\";i:2;s:69:\"/home/toswpir/homeo.tooswp.ir/wp-content/themes/homeo-child/style.css\";i:3;s:0:\"\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "homeo", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "homeo", "yes");
INSERT INTO `wp_options` VALUES("10221", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("44", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("48", "db_version", "58975", "yes");
INSERT INTO `wp_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("73", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_categories", "a:3:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}i:3;a:4:{s:5:\"title\";s:22:\"دسته بندی ها\";s:5:\"count\";i:1;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("81", "uninstall_plugins", "a:1:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}}", "no");
INSERT INTO `wp_options` VALUES("82", "timezone_string", "Asia/Tehran", "yes");
INSERT INTO `wp_options` VALUES("83", "page_for_posts", "33", "yes");
INSERT INTO `wp_options` VALUES("84", "page_on_front", "13", "yes");
INSERT INTO `wp_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("91", "wp_page_for_privacy_policy", "", "yes");
INSERT INTO `wp_options` VALUES("92", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("93", "admin_email_lifespan", "1750061891", "yes");
INSERT INTO `wp_options` VALUES("94", "initial_db_version", "47018", "yes");
INSERT INTO `wp_options` VALUES("95", "wp_user_roles", "a:10:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:123:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:10:\"loco_admin\";b:1;s:27:\"can_manage_citynet_settings\";b:1;s:26:\"create_notes_elementor-pro\";b:1;s:24:\"edit_notes_elementor-pro\";b:1;s:26:\"delete_notes_elementor-pro\";b:1;s:24:\"read_notes_elementor-pro\";b:1;s:31:\"edit_others_notes_elementor-pro\";b:1;s:33:\"delete_others_notes_elementor-pro\";b:1;s:39:\"read_others_private_notes_elementor-pro\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:27:\"can_manage_citynet_settings\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}s:20:\"wp_realestate_agency\";a:2:{s:4:\"name\";s:6:\"Agency\";s:12:\"capabilities\";a:8:{s:4:\"read\";b:0;s:10:\"edit_posts\";b:0;s:12:\"delete_posts\";b:0;s:12:\"upload_files\";b:1;s:9:\"edit_post\";b:1;s:20:\"edit_published_pages\";b:1;s:17:\"edit_others_pages\";b:1;s:17:\"edit_others_posts\";b:1;}}s:19:\"wp_realestate_agent\";a:2:{s:4:\"name\";s:5:\"Agent\";s:12:\"capabilities\";a:8:{s:4:\"read\";b:0;s:10:\"edit_posts\";b:0;s:12:\"delete_posts\";b:0;s:12:\"upload_files\";b:1;s:9:\"edit_post\";b:1;s:20:\"edit_published_pages\";b:1;s:17:\"edit_others_pages\";b:1;s:17:\"edit_others_posts\";b:1;}}s:10:\"translator\";a:2:{s:4:\"name\";s:10:\"Translator\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:10:\"loco_admin\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("96", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("97", "widget_search", "a:3:{i:2;a:1:{s:5:\"title\";s:0:\"\";}i:3;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("98", "widget_recent-posts", "a:3:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}i:3;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("99", "widget_recent-comments", "a:3:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}i:3;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("100", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("101", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("102", "sidebars_widgets", "a:15:{s:19:\"wp_inactive_widgets\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:15:\"sidebar-default\";a:3:{i:0;s:8:\"search-3\";i:1;s:14:\"recent-posts-3\";i:2;s:17:\"recent-comments-3\";}s:25:\"properties-filter-sidebar\";a:2:{i:0;s:25:\"apus_elementor_template-1\";i:1;s:27:\"apus_widget_property_list-1\";}s:31:\"properties-filter-sidebar-fixed\";a:1:{i:0;s:25:\"apus_elementor_template-2\";}s:29:\"properties-filter-top-sidebar\";a:1:{i:0;s:25:\"apus_elementor_template-3\";}s:30:\"properties-filter-top-half-map\";a:1:{i:0;s:25:\"apus_elementor_template-4\";}s:23:\"property-single-sidebar\";a:5:{i:0;s:28:\"apus_property_contact_form-1\";i:1;s:25:\"apus_elementor_template-5\";i:2;s:27:\"apus_widget_property_list-2\";i:3;s:27:\"apus_private_message_form-1\";i:4;s:26:\"apus_mortgage_calculator-1\";}s:21:\"agents-filter-sidebar\";a:2:{i:0;s:22:\"agency_filter_widget-1\";i:1;s:27:\"apus_widget_property_list-3\";}s:20:\"agent-single-sidebar\";a:3:{i:0;s:19:\"apus_contact_form-1\";i:1;s:21:\"agent_filter_widget-1\";i:2;s:27:\"apus_private_message_form-2\";}s:23:\"agencies-filter-sidebar\";a:2:{i:0;s:22:\"agency_filter_widget-2\";i:1;s:27:\"apus_widget_property_list-4\";}s:21:\"agency-single-sidebar\";a:3:{i:0;s:27:\"apus_private_message_form-3\";i:1;s:22:\"agency_filter_widget-3\";i:2;s:19:\"apus_contact_form-2\";}s:20:\"user-profile-sidebar\";a:2:{i:0;s:13:\"media_image-1\";i:1;s:25:\"apus_user_short_profile-1\";}s:12:\"blog-sidebar\";a:4:{i:0;s:13:\"apus_search-1\";i:1;s:12:\"categories-3\";i:2;s:27:\"apus_widget_property_list-5\";i:3;s:11:\"tag_cloud-1\";}s:12:\"shop-sidebar\";a:3:{i:0;s:13:\"apus_search-2\";i:1;s:32:\"woocommerce_product_categories-1\";i:2;s:22:\"woocommerce_products-1\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("103", "cron", "a:32:{i:1744381706;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1744382789;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1744383562;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1744384300;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1744384421;a:1:{s:29:\"superio-theme-ir_notify_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1744385112;a:1:{s:42:\"wp_realestate_check_for_expired_properties\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1744385177;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1744385279;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1744396337;a:1:{s:30:\"puc_cron_check_updates-citynet\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1744403647;a:1:{s:21:\"ai1wm_storage_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1744406801;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1744407865;a:1:{s:53:\"puc_cron_check_updates-wp-realestate-wc-paid-listings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1744409500;a:3:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1744409519;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1744409520;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1744410312;a:2:{s:33:\"wp_realestate_delete_old_previews\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:33:\"wp_realestate_email_daily_notices\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1744410377;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1744412031;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1744415025;a:1:{s:36:\"puc_cron_check_updates-wp-realestate\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1744440389;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1744699545;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1744927900;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1745833208;a:1:{s:30:\"generate_category_lookup_table\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1745833979;a:1:{s:45:\"woocommerce_marketplace_cron_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1745833986;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1745834036;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}i:1745837576;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1745844776;a:2:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"woocommerce_cleanup_rate_limits\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1745855576;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1745874000;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1746707886;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("104", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("105", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("106", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_media_image", "a:2:{i:1;a:15:{s:4:\"size\";s:4:\"full\";s:5:\"width\";i:150;s:6:\"height\";i:47;s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:9:\"link_type\";s:6:\"custom\";s:8:\"link_url\";s:24:\"https://homeo.tooswp.ir/\";s:13:\"image_classes\";s:0:\"\";s:12:\"link_classes\";s:0:\"\";s:8:\"link_rel\";s:0:\"\";s:17:\"link_target_blank\";b:0;s:11:\"image_title\";s:0:\"\";s:13:\"attachment_id\";i:3127;s:3:\"url\";s:67:\"https://homeo.tooswp.ir/wp-content/uploads/2020/02/logo-white-2.png\";s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_tag_cloud", "a:2:{i:1;a:3:{s:5:\"title\";s:15:\"برچسب ها\";s:5:\"count\";i:0;s:8:\"taxonomy\";s:8:\"post_tag\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "recovery_keys", "a:1:{s:22:\"uan2Jab3x37TPGdcyJWEdg\";a:2:{s:10:\"hashed_key\";s:34:\"$P$BS8LvA./C2Mxw0Z0TZrx/zmYR7Ok94.\";s:10:\"created_at\";i:1745833199;}}", "off");
INSERT INTO `wp_options` VALUES("118", "theme_mods_twentytwenty", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1588803808;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}}}}", "off");
INSERT INTO `wp_options` VALUES("10222", "db_upgraded", "", "on");
INSERT INTO `wp_options` VALUES("3198", "_elementor_general_settings", "a:3:{s:15:\"container_width\";s:4:\"1170\";s:21:\"default_generic_fonts\";s:10:\"Sans-serif\";s:21:\"global_image_lightbox\";s:3:\"yes\";}", "yes");
INSERT INTO `wp_options` VALUES("3199", "_elementor_settings_update_time", "1739945624", "yes");
INSERT INTO `wp_options` VALUES("2009", "ztjalali_options", "{\"force_timezone\":true,\"change_date_to_jalali\":true,\"change_jdate_number_to_persian\":true,\"change_url_date_to_jalali\":true,\"afghan_month_name\":false,\"disallow_month_short_name\":true,\"change_title_number_to_persian\":true,\"change_content_number_to_persian\":true,\"change_excerpt_number_to_persian\":true,\"change_comment_number_to_persian\":true,\"change_commentcount_number_to_persian\":true,\"change_category_number_to_persian\":true,\"change_point_to_persian\":false,\"change_arabic_to_persian\":false,\"change_archive_title\":true,\"save_changes_in_db\":false,\"ztjalali_admin_style\":false,\"persian_planet\":true}", "yes");
INSERT INTO `wp_options` VALUES("2010", "ztjalali_version", "5.0.1", "yes");
INSERT INTO `wp_options` VALUES("2012", "widget_ztjalali_archive", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("2013", "widget_ztjalali_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("8459", "woocommerce_schema_version", "920", "yes");
INSERT INTO `wp_options` VALUES("8470", "wc_blocks_db_schema_version", "260", "yes");
INSERT INTO `wp_options` VALUES("9814", "elementor_fonts_manager_font_types", "a:1:{s:5:\"Aviny\";s:6:\"custom\";}", "yes");
INSERT INTO `wp_options` VALUES("9815", "elementor_fonts_manager_fonts", "a:1:{s:5:\"Aviny\";a:2:{s:9:\"font_face\";s:626:\"@font-face {\n	font-family: \'Aviny\';\n	font-style: normal;\n	font-weight: normal;\n	font-display: auto;\n	src: url(\'https://homeo.tooswp.ir/wp-content/uploads/2020/05/Av.eot\');\n	src: url(\'https://homeo.tooswp.ir/wp-content/uploads/2020/05/Av.eot?#iefix\') format(\'embedded-opentype\'),\n		url(\'https://homeo.tooswp.ir/wp-content/uploads/2020/05/Av.woff2\') format(\'woff2\'),\n		url(\'https://homeo.tooswp.ir/wp-content/uploads/2020/05/Av.woff\') format(\'woff\'),\n		url(\'https://homeo.tooswp.ir/wp-content/uploads/2020/05/Av.ttf\') format(\'truetype\'),\n		url(\'https://homeo.tooswp.ir/wp-content/uploads/2020/05/Av.svg#Aviny\') format(\'svg\');\n}\n\";s:7:\"post_id\";i:3295;}}", "yes");
INSERT INTO `wp_options` VALUES("7338", "duplicator_pro_plugin_version", "3.8.8", "yes");
INSERT INTO `wp_options` VALUES("3829", "theme_mods_homeo-child", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:4:{s:7:\"primary\";i:93;s:10:\"agent-menu\";i:88;s:11:\"agency-menu\";i:87;s:9:\"user-menu\";i:98;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1589976276;s:4:\"data\";a:14:{s:19:\"wp_inactive_widgets\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:15:\"sidebar-default\";a:3:{i:0;s:8:\"search-3\";i:1;s:14:\"recent-posts-3\";i:2;s:17:\"recent-comments-3\";}s:25:\"properties-filter-sidebar\";a:2:{i:0;s:25:\"apus_elementor_template-1\";i:1;s:27:\"apus_widget_property_list-1\";}s:31:\"properties-filter-sidebar-fixed\";a:1:{i:0;s:25:\"apus_elementor_template-2\";}s:29:\"properties-filter-top-sidebar\";a:1:{i:0;s:25:\"apus_elementor_template-3\";}s:30:\"properties-filter-top-half-map\";a:1:{i:0;s:25:\"apus_elementor_template-4\";}s:23:\"property-single-sidebar\";a:5:{i:0;s:28:\"apus_property_contact_form-1\";i:1;s:25:\"apus_elementor_template-5\";i:2;s:27:\"apus_widget_property_list-2\";i:3;s:27:\"apus_private_message_form-1\";i:4;s:26:\"apus_mortgage_calculator-1\";}s:21:\"agents-filter-sidebar\";a:2:{i:0;s:22:\"agency_filter_widget-1\";i:1;s:27:\"apus_widget_property_list-3\";}s:20:\"agent-single-sidebar\";a:3:{i:0;s:19:\"apus_contact_form-1\";i:1;s:21:\"agent_filter_widget-1\";i:2;s:27:\"apus_private_message_form-2\";}s:23:\"agencies-filter-sidebar\";a:2:{i:0;s:22:\"agency_filter_widget-2\";i:1;s:27:\"apus_widget_property_list-4\";}s:21:\"agency-single-sidebar\";a:3:{i:0;s:27:\"apus_private_message_form-3\";i:1;s:22:\"agency_filter_widget-3\";i:2;s:19:\"apus_contact_form-2\";}s:20:\"user-profile-sidebar\";a:2:{i:0;s:13:\"media_image-1\";i:1;s:25:\"apus_user_short_profile-1\";}s:12:\"blog-sidebar\";a:4:{i:0;s:13:\"apus_search-1\";i:1;s:12:\"categories-3\";i:2;s:27:\"apus_widget_property_list-5\";i:3;s:11:\"tag_cloud-1\";}s:12:\"shop-sidebar\";a:3:{i:0;s:13:\"apus_search-2\";i:1;s:32:\"woocommerce_product_categories-1\";i:2;s:22:\"woocommerce_products-1\";}}}}", "off");
INSERT INTO `wp_options` VALUES("2088", "elementor_tracker_last_send", "1743847844", "yes");
INSERT INTO `wp_options` VALUES("2330", "woocommerce_maybe_regenerate_images_hash", "0556693a0f0a5f9821eda02a33dc7ed7", "yes");
INSERT INTO `wp_options` VALUES("2333", "elementor_pro_theme_builder_conditions", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("3592", "wp_realestate_property_base_slug", "", "yes");
INSERT INTO `wp_options` VALUES("3593", "wp_realestate_property_amenity_slug", "", "yes");
INSERT INTO `wp_options` VALUES("3594", "wp_realestate_property_status_slug", "", "yes");
INSERT INTO `wp_options` VALUES("3595", "wp_realestate_property_label_slug", "", "yes");
INSERT INTO `wp_options` VALUES("3596", "wp_realestate_property_material_slug", "", "yes");
INSERT INTO `wp_options` VALUES("3597", "wp_realestate_property_type_slug", "", "yes");
INSERT INTO `wp_options` VALUES("3598", "wp_realestate_property_location_slug", "", "yes");
INSERT INTO `wp_options` VALUES("3599", "wp_realestate_property_archive_slug", "", "yes");
INSERT INTO `wp_options` VALUES("3600", "wp_realestate_agent_base_slug", "", "yes");
INSERT INTO `wp_options` VALUES("3601", "wp_realestate_agent_category_slug", "", "yes");
INSERT INTO `wp_options` VALUES("3602", "wp_realestate_agent_location_slug", "", "yes");
INSERT INTO `wp_options` VALUES("3603", "wp_realestate_agent_archive_slug", "", "yes");
INSERT INTO `wp_options` VALUES("3604", "wp_realestate_agency_base_slug", "", "yes");
INSERT INTO `wp_options` VALUES("3605", "wp_realestate_agency_category_slug", "", "yes");
INSERT INTO `wp_options` VALUES("3606", "wp_realestate_agency_location_slug", "", "yes");
INSERT INTO `wp_options` VALUES("3607", "wp_realestate_agency_archive_slug", "", "yes");
INSERT INTO `wp_options` VALUES("5387", "homeo_theme_options1590823956", "a:101:{s:7:\"preload\";b:1;s:18:\"image_lazy_loading\";b:1;s:11:\"keep_header\";b:0;s:19:\"header_mobile_login\";b:1;s:30:\"header_mobile_add_property_btn\";b:1;s:11:\"back_to_top\";b:1;s:21:\"show_blog_breadcrumbs\";i:1;s:21:\"blog_breadcrumb_style\";s:10:\"horizontal\";s:19:\"blog_archive_layout\";s:9:\"left-main\";s:22:\"blog_archive_fullwidth\";b:0;s:17:\"blog_display_mode\";s:4:\"list\";s:12:\"blog_columns\";i:1;s:18:\"blog_single_layout\";s:9:\"left-main\";s:21:\"blog_single_fullwidth\";b:0;s:22:\"show_blog_social_share\";i:1;s:18:\"show_blog_releated\";i:1;s:20:\"number_blog_releated\";i:2;s:21:\"releated_blog_columns\";i:2;s:24:\"show_product_breadcrumbs\";i:1;s:20:\"woo_breadcrumb_style\";s:7:\"default\";s:19:\"show_shop_cat_title\";i:1;s:20:\"product_display_mode\";s:4:\"grid\";s:15:\"product_columns\";i:4;s:24:\"number_products_per_page\";i:12;s:17:\"enable_swap_image\";i:1;s:25:\"product_archive_fullwidth\";b:0;s:22:\"product_archive_layout\";s:4:\"main\";s:23:\"product_thumbs_position\";s:17:\"thumbnails-bottom\";s:21:\"number_product_thumbs\";i:5;s:25:\"show_product_social_share\";i:1;s:23:\"show_product_review_tab\";i:1;s:21:\"product_single_layout\";s:4:\"main\";s:24:\"product_single_fullwidth\";b:0;s:21:\"show_product_releated\";i:1;s:23:\"number_product_releated\";i:3;s:24:\"releated_product_columns\";i:3;s:20:\"show_product_upsells\";i:1;s:23:\"upsells_product_columns\";i:3;s:25:\"show_property_breadcrumbs\";i:1;s:25:\"property_breadcrumb_style\";s:8:\"vertical\";s:23:\"listing_show_full_phone\";i:0;s:20:\"properties_fullwidth\";b:0;s:22:\"properties_layout_type\";s:7:\"default\";s:29:\"properties_elementor_template\";s:0:\"\";s:25:\"properties_layout_sidebar\";s:10:\"main-right\";s:23:\"properties_display_mode\";s:4:\"grid\";s:27:\"properties_inner_grid_style\";s:4:\"grid\";s:18:\"properties_columns\";i:3;s:18:\"properties_gallery\";b:1;s:21:\"properties_pagination\";s:7:\"default\";s:18:\"property_fullwidth\";b:0;s:20:\"property_layout_type\";s:2:\"v1\";s:26:\"show_property_social_share\";i:1;s:25:\"show_property_description\";i:1;s:20:\"show_property_detail\";i:1;s:25:\"show_property_attachments\";i:1;s:23:\"show_property_amenities\";i:1;s:22:\"show_property_location\";i:1;s:25:\"show_property_floor-plans\";i:1;s:32:\"show_property_tabs-video-virtual\";i:1;s:24:\"show_property_facilities\";i:1;s:23:\"show_property_valuation\";i:1;s:25:\"show_property_stats_graph\";i:1;s:25:\"show_property_nearby_yelp\";i:1;s:24:\"show_property_walk_score\";i:1;s:27:\"show_property_subproperties\";i:1;s:21:\"show_property_related\";i:1;s:29:\"property_subproperties_number\";i:2;s:23:\"property_related_number\";i:2;s:22:\"show_agent_breadcrumbs\";i:1;s:22:\"agent_breadcrumb_style\";s:8:\"vertical\";s:16:\"agents_fullwidth\";b:0;s:21:\"agents_layout_sidebar\";s:10:\"main-right\";s:19:\"agents_display_mode\";s:4:\"grid\";s:14:\"agents_columns\";i:4;s:17:\"agents_pagination\";s:7:\"default\";s:15:\"agent_fullwidth\";b:0;s:23:\"show_agent_social_share\";i:1;s:19:\"agent_property_show\";i:1;s:23:\"show_agency_breadcrumbs\";i:1;s:23:\"agency_breadcrumb_style\";s:8:\"vertical\";s:18:\"agencies_fullwidth\";b:0;s:23:\"agencies_layout_sidebar\";s:10:\"main-right\";s:21:\"agencies_display_mode\";s:4:\"grid\";s:16:\"agencies_columns\";i:4;s:19:\"agencies_pagination\";s:7:\"default\";s:16:\"agency_fullwidth\";b:0;s:24:\"show_agency_social_share\";i:1;s:17:\"agency_agent_show\";i:1;s:20:\"agency_property_show\";i:1;s:27:\"register_form_enable_agency\";b:1;s:26:\"register_form_enable_agent\";b:1;s:9:\"404_title\";s:3:\"404\";s:15:\"404_description\";s:117:\"Sorry but the page you are looking for does not exist, have been removed, name changed or is temporarity unavailable.\";s:9:\"main_font\";a:2:{s:11:\"font-family\";s:0:\"\";s:7:\"subsets\";s:0:\"\";}s:12:\"heading_font\";a:2:{s:11:\"font-family\";s:0:\"\";s:7:\"subsets\";s:0:\"\";}s:14:\"facebook_share\";i:1;s:13:\"twitter_share\";i:1;s:14:\"linkedin_share\";i:1;s:15:\"pinterest_share\";i:1;s:10:\"more_share\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("4811", "recovery_mode_email_last_sent", "1745833199", "yes");
INSERT INTO `wp_options` VALUES("5542", "homeo_theme_options1590856945", "a:101:{s:7:\"preload\";b:1;s:18:\"image_lazy_loading\";b:1;s:11:\"keep_header\";b:0;s:19:\"header_mobile_login\";b:1;s:30:\"header_mobile_add_property_btn\";b:1;s:11:\"back_to_top\";b:1;s:21:\"show_blog_breadcrumbs\";i:1;s:21:\"blog_breadcrumb_style\";s:10:\"horizontal\";s:19:\"blog_archive_layout\";s:9:\"left-main\";s:22:\"blog_archive_fullwidth\";b:0;s:17:\"blog_display_mode\";s:4:\"list\";s:12:\"blog_columns\";i:1;s:18:\"blog_single_layout\";s:9:\"left-main\";s:21:\"blog_single_fullwidth\";b:0;s:22:\"show_blog_social_share\";i:1;s:18:\"show_blog_releated\";i:1;s:20:\"number_blog_releated\";i:2;s:21:\"releated_blog_columns\";i:2;s:24:\"show_product_breadcrumbs\";i:1;s:20:\"woo_breadcrumb_style\";s:7:\"default\";s:19:\"show_shop_cat_title\";i:1;s:20:\"product_display_mode\";s:4:\"grid\";s:15:\"product_columns\";i:4;s:24:\"number_products_per_page\";i:12;s:17:\"enable_swap_image\";i:1;s:25:\"product_archive_fullwidth\";b:0;s:22:\"product_archive_layout\";s:4:\"main\";s:23:\"product_thumbs_position\";s:17:\"thumbnails-bottom\";s:21:\"number_product_thumbs\";i:5;s:25:\"show_product_social_share\";i:1;s:23:\"show_product_review_tab\";i:1;s:21:\"product_single_layout\";s:4:\"main\";s:24:\"product_single_fullwidth\";b:0;s:21:\"show_product_releated\";i:1;s:23:\"number_product_releated\";i:3;s:24:\"releated_product_columns\";i:3;s:20:\"show_product_upsells\";i:1;s:23:\"upsells_product_columns\";i:3;s:25:\"show_property_breadcrumbs\";i:1;s:25:\"property_breadcrumb_style\";s:8:\"vertical\";s:23:\"listing_show_full_phone\";i:0;s:20:\"properties_fullwidth\";b:0;s:22:\"properties_layout_type\";s:7:\"default\";s:29:\"properties_elementor_template\";s:0:\"\";s:25:\"properties_layout_sidebar\";s:10:\"main-right\";s:23:\"properties_display_mode\";s:4:\"grid\";s:27:\"properties_inner_grid_style\";s:4:\"grid\";s:18:\"properties_columns\";i:3;s:18:\"properties_gallery\";b:1;s:21:\"properties_pagination\";s:7:\"default\";s:18:\"property_fullwidth\";b:0;s:20:\"property_layout_type\";s:2:\"v1\";s:26:\"show_property_social_share\";i:1;s:25:\"show_property_description\";i:1;s:20:\"show_property_detail\";i:1;s:25:\"show_property_attachments\";i:1;s:23:\"show_property_amenities\";i:1;s:22:\"show_property_location\";i:1;s:25:\"show_property_floor-plans\";i:1;s:32:\"show_property_tabs-video-virtual\";i:1;s:24:\"show_property_facilities\";i:1;s:23:\"show_property_valuation\";i:1;s:25:\"show_property_stats_graph\";i:1;s:25:\"show_property_nearby_yelp\";i:1;s:24:\"show_property_walk_score\";i:1;s:27:\"show_property_subproperties\";i:1;s:21:\"show_property_related\";i:1;s:29:\"property_subproperties_number\";i:2;s:23:\"property_related_number\";i:2;s:22:\"show_agent_breadcrumbs\";i:1;s:22:\"agent_breadcrumb_style\";s:8:\"vertical\";s:16:\"agents_fullwidth\";b:0;s:21:\"agents_layout_sidebar\";s:10:\"main-right\";s:19:\"agents_display_mode\";s:4:\"grid\";s:14:\"agents_columns\";i:4;s:17:\"agents_pagination\";s:7:\"default\";s:15:\"agent_fullwidth\";b:0;s:23:\"show_agent_social_share\";i:1;s:19:\"agent_property_show\";i:1;s:23:\"show_agency_breadcrumbs\";i:1;s:23:\"agency_breadcrumb_style\";s:8:\"vertical\";s:18:\"agencies_fullwidth\";b:0;s:23:\"agencies_layout_sidebar\";s:10:\"main-right\";s:21:\"agencies_display_mode\";s:4:\"grid\";s:16:\"agencies_columns\";i:4;s:19:\"agencies_pagination\";s:7:\"default\";s:16:\"agency_fullwidth\";b:0;s:24:\"show_agency_social_share\";i:1;s:17:\"agency_agent_show\";i:1;s:20:\"agency_property_show\";i:1;s:27:\"register_form_enable_agency\";b:1;s:26:\"register_form_enable_agent\";b:1;s:9:\"404_title\";s:3:\"404\";s:15:\"404_description\";s:117:\"Sorry but the page you are looking for does not exist, have been removed, name changed or is temporarity unavailable.\";s:9:\"main_font\";a:2:{s:11:\"font-family\";s:0:\"\";s:7:\"subsets\";s:0:\"\";}s:12:\"heading_font\";a:2:{s:11:\"font-family\";s:0:\"\";s:7:\"subsets\";s:0:\"\";}s:14:\"facebook_share\";i:1;s:13:\"twitter_share\";i:1;s:14:\"linkedin_share\";i:1;s:15:\"pinterest_share\";i:1;s:10:\"more_share\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1138", "wpp_settings", "a:19:{s:10:\"admin_lang\";s:7:\"disable\";s:9:\"user_lang\";s:7:\"disable\";s:12:\"submenu_move\";s:6:\"enable\";s:12:\"persian_date\";s:6:\"enable\";s:10:\"conv_title\";s:6:\"enable\";s:13:\"conv_contents\";s:6:\"enable\";s:12:\"conv_excerpt\";s:6:\"enable\";s:13:\"conv_comments\";s:6:\"enable\";s:18:\"conv_comment_count\";s:6:\"enable\";s:10:\"conv_dates\";s:6:\"enable\";s:9:\"conv_cats\";s:6:\"enable\";s:11:\"conv_arabic\";s:7:\"disable\";s:15:\"conv_permalinks\";s:6:\"enable\";s:11:\"news_source\";s:5:\"parsi\";s:15:\"conv_page_title\";s:6:\"enable\";s:13:\"woo_per_price\";s:6:\"enable\";s:10:\"edd_prices\";s:7:\"disable\";s:12:\"edd_rial_fix\";s:7:\"disable\";s:9:\"dis_input\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("1139", "widget_parsidate_archive", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1140", "widget_parsidate_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("5543", "homeo_theme_options1590856945-transients", "a:2:{s:14:\"changed_values\";a:0:{}s:9:\"last_save\";i:1590856947;}", "yes");
INSERT INTO `wp_options` VALUES("5547", "homeo_theme_options1590857034", "a:101:{s:7:\"preload\";b:1;s:18:\"image_lazy_loading\";b:1;s:11:\"keep_header\";b:0;s:19:\"header_mobile_login\";b:1;s:30:\"header_mobile_add_property_btn\";b:1;s:11:\"back_to_top\";b:1;s:21:\"show_blog_breadcrumbs\";i:1;s:21:\"blog_breadcrumb_style\";s:10:\"horizontal\";s:19:\"blog_archive_layout\";s:9:\"left-main\";s:22:\"blog_archive_fullwidth\";b:0;s:17:\"blog_display_mode\";s:4:\"list\";s:12:\"blog_columns\";i:1;s:18:\"blog_single_layout\";s:9:\"left-main\";s:21:\"blog_single_fullwidth\";b:0;s:22:\"show_blog_social_share\";i:1;s:18:\"show_blog_releated\";i:1;s:20:\"number_blog_releated\";i:2;s:21:\"releated_blog_columns\";i:2;s:24:\"show_product_breadcrumbs\";i:1;s:20:\"woo_breadcrumb_style\";s:7:\"default\";s:19:\"show_shop_cat_title\";i:1;s:20:\"product_display_mode\";s:4:\"grid\";s:15:\"product_columns\";i:4;s:24:\"number_products_per_page\";i:12;s:17:\"enable_swap_image\";i:1;s:25:\"product_archive_fullwidth\";b:0;s:22:\"product_archive_layout\";s:4:\"main\";s:23:\"product_thumbs_position\";s:17:\"thumbnails-bottom\";s:21:\"number_product_thumbs\";i:5;s:25:\"show_product_social_share\";i:1;s:23:\"show_product_review_tab\";i:1;s:21:\"product_single_layout\";s:4:\"main\";s:24:\"product_single_fullwidth\";b:0;s:21:\"show_product_releated\";i:1;s:23:\"number_product_releated\";i:3;s:24:\"releated_product_columns\";i:3;s:20:\"show_product_upsells\";i:1;s:23:\"upsells_product_columns\";i:3;s:25:\"show_property_breadcrumbs\";i:1;s:25:\"property_breadcrumb_style\";s:8:\"vertical\";s:23:\"listing_show_full_phone\";i:0;s:20:\"properties_fullwidth\";b:0;s:22:\"properties_layout_type\";s:7:\"default\";s:29:\"properties_elementor_template\";s:0:\"\";s:25:\"properties_layout_sidebar\";s:10:\"main-right\";s:23:\"properties_display_mode\";s:4:\"grid\";s:27:\"properties_inner_grid_style\";s:4:\"grid\";s:18:\"properties_columns\";i:3;s:18:\"properties_gallery\";b:1;s:21:\"properties_pagination\";s:7:\"default\";s:18:\"property_fullwidth\";b:0;s:20:\"property_layout_type\";s:2:\"v1\";s:26:\"show_property_social_share\";i:1;s:25:\"show_property_description\";i:1;s:20:\"show_property_detail\";i:1;s:25:\"show_property_attachments\";i:1;s:23:\"show_property_amenities\";i:1;s:22:\"show_property_location\";i:1;s:25:\"show_property_floor-plans\";i:1;s:32:\"show_property_tabs-video-virtual\";i:1;s:24:\"show_property_facilities\";i:1;s:23:\"show_property_valuation\";i:1;s:25:\"show_property_stats_graph\";i:1;s:25:\"show_property_nearby_yelp\";i:1;s:24:\"show_property_walk_score\";i:1;s:27:\"show_property_subproperties\";i:1;s:21:\"show_property_related\";i:1;s:29:\"property_subproperties_number\";i:2;s:23:\"property_related_number\";i:2;s:22:\"show_agent_breadcrumbs\";i:1;s:22:\"agent_breadcrumb_style\";s:8:\"vertical\";s:16:\"agents_fullwidth\";b:0;s:21:\"agents_layout_sidebar\";s:10:\"main-right\";s:19:\"agents_display_mode\";s:4:\"grid\";s:14:\"agents_columns\";i:4;s:17:\"agents_pagination\";s:7:\"default\";s:15:\"agent_fullwidth\";b:0;s:23:\"show_agent_social_share\";i:1;s:19:\"agent_property_show\";i:1;s:23:\"show_agency_breadcrumbs\";i:1;s:23:\"agency_breadcrumb_style\";s:8:\"vertical\";s:18:\"agencies_fullwidth\";b:0;s:23:\"agencies_layout_sidebar\";s:10:\"main-right\";s:21:\"agencies_display_mode\";s:4:\"grid\";s:16:\"agencies_columns\";i:4;s:19:\"agencies_pagination\";s:7:\"default\";s:16:\"agency_fullwidth\";b:0;s:24:\"show_agency_social_share\";i:1;s:17:\"agency_agent_show\";i:1;s:20:\"agency_property_show\";i:1;s:27:\"register_form_enable_agency\";b:1;s:26:\"register_form_enable_agent\";b:1;s:9:\"404_title\";s:3:\"404\";s:15:\"404_description\";s:117:\"Sorry but the page you are looking for does not exist, have been removed, name changed or is temporarity unavailable.\";s:9:\"main_font\";a:2:{s:11:\"font-family\";s:0:\"\";s:7:\"subsets\";s:0:\"\";}s:12:\"heading_font\";a:2:{s:11:\"font-family\";s:0:\"\";s:7:\"subsets\";s:0:\"\";}s:14:\"facebook_share\";i:1;s:13:\"twitter_share\";i:1;s:14:\"linkedin_share\";i:1;s:15:\"pinterest_share\";i:1;s:10:\"more_share\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("5545", "homeo_theme_options1590856993", "a:101:{s:7:\"preload\";b:1;s:18:\"image_lazy_loading\";b:1;s:11:\"keep_header\";b:0;s:19:\"header_mobile_login\";b:1;s:30:\"header_mobile_add_property_btn\";b:1;s:11:\"back_to_top\";b:1;s:21:\"show_blog_breadcrumbs\";i:1;s:21:\"blog_breadcrumb_style\";s:10:\"horizontal\";s:19:\"blog_archive_layout\";s:9:\"left-main\";s:22:\"blog_archive_fullwidth\";b:0;s:17:\"blog_display_mode\";s:4:\"list\";s:12:\"blog_columns\";i:1;s:18:\"blog_single_layout\";s:9:\"left-main\";s:21:\"blog_single_fullwidth\";b:0;s:22:\"show_blog_social_share\";i:1;s:18:\"show_blog_releated\";i:1;s:20:\"number_blog_releated\";i:2;s:21:\"releated_blog_columns\";i:2;s:24:\"show_product_breadcrumbs\";i:1;s:20:\"woo_breadcrumb_style\";s:7:\"default\";s:19:\"show_shop_cat_title\";i:1;s:20:\"product_display_mode\";s:4:\"grid\";s:15:\"product_columns\";i:4;s:24:\"number_products_per_page\";i:12;s:17:\"enable_swap_image\";i:1;s:25:\"product_archive_fullwidth\";b:0;s:22:\"product_archive_layout\";s:4:\"main\";s:23:\"product_thumbs_position\";s:17:\"thumbnails-bottom\";s:21:\"number_product_thumbs\";i:5;s:25:\"show_product_social_share\";i:1;s:23:\"show_product_review_tab\";i:1;s:21:\"product_single_layout\";s:4:\"main\";s:24:\"product_single_fullwidth\";b:0;s:21:\"show_product_releated\";i:1;s:23:\"number_product_releated\";i:3;s:24:\"releated_product_columns\";i:3;s:20:\"show_product_upsells\";i:1;s:23:\"upsells_product_columns\";i:3;s:25:\"show_property_breadcrumbs\";i:1;s:25:\"property_breadcrumb_style\";s:8:\"vertical\";s:23:\"listing_show_full_phone\";i:0;s:20:\"properties_fullwidth\";b:0;s:22:\"properties_layout_type\";s:7:\"default\";s:29:\"properties_elementor_template\";s:0:\"\";s:25:\"properties_layout_sidebar\";s:10:\"main-right\";s:23:\"properties_display_mode\";s:4:\"grid\";s:27:\"properties_inner_grid_style\";s:4:\"grid\";s:18:\"properties_columns\";i:3;s:18:\"properties_gallery\";b:1;s:21:\"properties_pagination\";s:7:\"default\";s:18:\"property_fullwidth\";b:0;s:20:\"property_layout_type\";s:2:\"v1\";s:26:\"show_property_social_share\";i:1;s:25:\"show_property_description\";i:1;s:20:\"show_property_detail\";i:1;s:25:\"show_property_attachments\";i:1;s:23:\"show_property_amenities\";i:1;s:22:\"show_property_location\";i:1;s:25:\"show_property_floor-plans\";i:1;s:32:\"show_property_tabs-video-virtual\";i:1;s:24:\"show_property_facilities\";i:1;s:23:\"show_property_valuation\";i:1;s:25:\"show_property_stats_graph\";i:1;s:25:\"show_property_nearby_yelp\";i:1;s:24:\"show_property_walk_score\";i:1;s:27:\"show_property_subproperties\";i:1;s:21:\"show_property_related\";i:1;s:29:\"property_subproperties_number\";i:2;s:23:\"property_related_number\";i:2;s:22:\"show_agent_breadcrumbs\";i:1;s:22:\"agent_breadcrumb_style\";s:8:\"vertical\";s:16:\"agents_fullwidth\";b:0;s:21:\"agents_layout_sidebar\";s:10:\"main-right\";s:19:\"agents_display_mode\";s:4:\"grid\";s:14:\"agents_columns\";i:4;s:17:\"agents_pagination\";s:7:\"default\";s:15:\"agent_fullwidth\";b:0;s:23:\"show_agent_social_share\";i:1;s:19:\"agent_property_show\";i:1;s:23:\"show_agency_breadcrumbs\";i:1;s:23:\"agency_breadcrumb_style\";s:8:\"vertical\";s:18:\"agencies_fullwidth\";b:0;s:23:\"agencies_layout_sidebar\";s:10:\"main-right\";s:21:\"agencies_display_mode\";s:4:\"grid\";s:16:\"agencies_columns\";i:4;s:19:\"agencies_pagination\";s:7:\"default\";s:16:\"agency_fullwidth\";b:0;s:24:\"show_agency_social_share\";i:1;s:17:\"agency_agent_show\";i:1;s:20:\"agency_property_show\";i:1;s:27:\"register_form_enable_agency\";b:1;s:26:\"register_form_enable_agent\";b:1;s:9:\"404_title\";s:3:\"404\";s:15:\"404_description\";s:117:\"Sorry but the page you are looking for does not exist, have been removed, name changed or is temporarity unavailable.\";s:9:\"main_font\";a:2:{s:11:\"font-family\";s:0:\"\";s:7:\"subsets\";s:0:\"\";}s:12:\"heading_font\";a:2:{s:11:\"font-family\";s:0:\"\";s:7:\"subsets\";s:0:\"\";}s:14:\"facebook_share\";i:1;s:13:\"twitter_share\";i:1;s:14:\"linkedin_share\";i:1;s:15:\"pinterest_share\";i:1;s:10:\"more_share\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("5546", "homeo_theme_options1590856993-transients", "a:1:{s:14:\"changed_values\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("5548", "homeo_theme_options1590857034-transients", "a:2:{s:14:\"changed_values\";a:0:{}s:9:\"last_save\";i:1590857035;}", "yes");
INSERT INTO `wp_options` VALUES("5388", "homeo_theme_options1590823956-transients", "a:2:{s:14:\"changed_values\";a:0:{}s:9:\"last_save\";i:1590823957;}", "yes");
INSERT INTO `wp_options` VALUES("1464", "elementor_custom_icon_sets_config", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("1422", "elementor_pro_license_key", "*********", "yes");
INSERT INTO `wp_options` VALUES("1425", "elementor_pro_version", "3.28.3", "yes");
INSERT INTO `wp_options` VALUES("1426", "widget_elementor-library", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("1429", "_elementor_pro_installed_time", "1589625357", "yes");
INSERT INTO `wp_options` VALUES("3200", "elementor_default_generic_fonts", "Sans-serif", "yes");
INSERT INTO `wp_options` VALUES("3201", "elementor_space_between_widgets", "", "yes");
INSERT INTO `wp_options` VALUES("3202", "elementor_stretched_section_container", "", "yes");
INSERT INTO `wp_options` VALUES("3203", "elementor_page_title_selector", "", "yes");
INSERT INTO `wp_options` VALUES("3204", "elementor_viewport_lg", "", "yes");
INSERT INTO `wp_options` VALUES("3225", "elementor_editor_break_lines", "", "yes");
INSERT INTO `wp_options` VALUES("3226", "elementor_allow_svg", "", "yes");
INSERT INTO `wp_options` VALUES("3227", "elementor_load_fa4_shim", "yes", "yes");
INSERT INTO `wp_options` VALUES("3206", "elementor_viewport_md", "", "yes");
INSERT INTO `wp_options` VALUES("3207", "elementor_pro_recaptcha_site_key", "", "yes");
INSERT INTO `wp_options` VALUES("3208", "elementor_pro_recaptcha_secret_key", "", "yes");
INSERT INTO `wp_options` VALUES("3209", "elementor_pro_recaptcha_v3_site_key", "", "yes");
INSERT INTO `wp_options` VALUES("3210", "elementor_pro_recaptcha_v3_secret_key", "", "yes");
INSERT INTO `wp_options` VALUES("3211", "elementor_pro_recaptcha_v3_threshold", "0.5", "yes");
INSERT INTO `wp_options` VALUES("3212", "elementor_pro_facebook_app_id", "", "yes");
INSERT INTO `wp_options` VALUES("3213", "elementor_pro_mailchimp_api_key", "", "yes");
INSERT INTO `wp_options` VALUES("3214", "elementor_validate_api_data", "", "yes");
INSERT INTO `wp_options` VALUES("3215", "elementor_pro_drip_api_token", "", "yes");
INSERT INTO `wp_options` VALUES("3216", "elementor_pro_activecampaign_api_key", "", "yes");
INSERT INTO `wp_options` VALUES("3217", "elementor_pro_activecampaign_api_url", "", "yes");
INSERT INTO `wp_options` VALUES("3218", "elementor_pro_getresponse_api_key", "", "yes");
INSERT INTO `wp_options` VALUES("3219", "elementor_pro_convertkit_api_key", "", "yes");
INSERT INTO `wp_options` VALUES("3220", "elementor_pro_mailerlite_api_key", "", "yes");
INSERT INTO `wp_options` VALUES("3221", "elementor_use_mini_cart_template", "initial", "yes");
INSERT INTO `wp_options` VALUES("3222", "elementor_typekit-kit-id", "", "yes");
INSERT INTO `wp_options` VALUES("30762", "elementor_font_awesome_pro_kit_id", "", "yes");
INSERT INTO `wp_options` VALUES("3224", "elementor_css_print_method", "external", "yes");
INSERT INTO `wp_options` VALUES("11261", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:0;s:22:\"there_are_now_products\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("8888", "woocommerce_sales_record_date", "2020-07-17", "yes");
INSERT INTO `wp_options` VALUES("8889", "woocommerce_sales_record_amount", "56000", "yes");
INSERT INTO `wp_options` VALUES("5798", "elementor_enable_unfiltered_files_upload", "", "yes");
INSERT INTO `wp_options` VALUES("4824", "elementor_log", "a:43:{s:32:\"1ce554eea4327918463dc243886047f2\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-01 01:27:23\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-01 01:27:23\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"e16969ee289fc1861e9e7271fed64955\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-01 01:52:30\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-01 01:52:30\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"6f325e08995174d5ec68f118ee297af0\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-01 01:52:30\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-01 01:52:30\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"26d02911b66912e3a2be94478e259438\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-01 09:14:05\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-01 09:14:05\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"a8cb736b8385696f6de6d5c73d702e43\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-01 09:14:05\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-01 09:14:05\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"e4ea895310bbf20bca293562c1a9a654\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-03 11:47:05\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-03 11:47:05\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"cca6764ceba1f51fcf4813cd9f13b7da\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-03 11:47:05\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-03 11:47:05\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"5f7b3527585e4ffaedf33b03d05d372e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-03 19:06:17\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-03 19:06:17\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"fac6b2bb7ff7c388946382b3b8080eb4\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-03 19:06:17\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-03 19:06:17\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"4e24c9995adb123d9fdc01adcbbfccee\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-06 09:46:00\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-06 09:46:00\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"b82b1e2159ee1b1769c8cc8470607c13\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-06 09:46:00\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-06 09:46:00\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"d8251616ff1d29240fe226f1c631a429\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-19 08:35:57\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-19 08:35:57\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"088f9c103802f23becb1fec4db6a5749\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-19 08:35:57\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-19 08:35:57\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"b2317fc0778eba1ef50f73bacad28e20\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-19 08:35:57\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-19 08:35:57\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"09f0e18012ccc984452ff3e7654505bd\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-19 08:35:57\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:42:\"المنتور/Upgrades - _v_3_26_0 Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-19 08:35:57\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:42:\"المنتور/Upgrades - _v_3_26_0 Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"faab8c933a75172a9eb3d4ed2803cd97\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-19 08:35:57\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"المنتور/Upgrades - _v_3_26_0 Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-19 08:35:57\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"المنتور/Upgrades - _v_3_26_0 Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"8040edab4b76e8c9cf7a3b3de3592f62\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-19 08:35:57\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.19.2\";s:2:\"to\";s:6:\"3.27.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-19 08:35:57\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.19.2\";s:2:\"to\";s:6:\"3.27.5\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"ea79d3e158d393ad117c8aa2d7fed0d6\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-19 08:36:03\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-19 08:36:03\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"f75bb61218f6621b87a2d6c1bfa9992a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-19 08:36:03\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:48:\"Elementor Pro/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-19 08:36:03\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:48:\"Elementor Pro/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"409f4b28737ed2c4caf7883f2a38f20a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-19 08:36:03\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor Pro/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-19 08:36:03\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:50:\"Elementor Pro/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"e5a945b634afe5ebe6a714f71d50fcf7\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-19 08:36:03\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:13:\"Elementor Pro\";s:4:\"from\";s:6:\"3.19.2\";s:2:\"to\";s:6:\"3.27.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-19 08:36:03\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:13:\"Elementor Pro\";s:4:\"from\";s:6:\"3.19.2\";s:2:\"to\";s:6:\"3.27.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"640427c635a155a5b75c82917a2878fd\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-19 08:53:22\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.27.5\";s:2:\"to\";s:6:\"3.27.6\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-19 08:53:22\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.27.5\";s:2:\"to\";s:6:\"3.27.6\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"9e2db32f571dac0fdc19a436bcea04ec\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-19 09:36:59\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-19 09:36:59\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"17b667dab9563038cb879f85c4c377e8\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-19 09:36:59\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-19 09:36:59\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"dc8799caf5c2d3df8c1560ba3c70cda1\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-19 09:36:59\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-19 09:36:59\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"919f6d3f4be15b3196b3653bea05bc15\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-02-19 09:36:59\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.27.5\";s:2:\"to\";s:6:\"3.27.6\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-19 09:36:59\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.27.5\";s:2:\"to\";s:6:\"3.27.6\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"f99eb5ed417492ef28b6b3000203a316\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-02-19 06:20:12\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:61:\"Cannot read properties of undefined (reading &#039;get&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-02-19 06:20:12\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1739946012\";s:7:\"message\";s:51:\"Cannot read properties of undefined (reading \'get\')\";s:3:\"url\";s:87:\"https://homeo.tooswp.ir/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.27.6\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"781150\";}s:7:\"\0*\0file\";s:87:\"https://homeo.tooswp.ir/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.27.6\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:6:\"781150\";}s:32:\"814b004cf84165dd6061a1b5c9d5a6fe\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-14 07:08:19\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.27.6\";s:2:\"to\";s:6:\"3.27.7\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-14 07:08:19\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.27.6\";s:2:\"to\";s:6:\"3.27.7\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"064cd2755a9709308554955f73db007a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-15 12:35:37\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-15 12:35:37\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"f919ed656f33e4b0b6dc0af6b543e856\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-15 12:35:37\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-15 12:35:37\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"d84445818ed160ad8765946c8c9f64ac\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-15 12:35:38\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-15 12:35:38\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"9ba125c85c3c35e4f06c2d795469a4ba\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-15 12:35:38\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.27.6\";s:2:\"to\";s:6:\"3.27.7\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-15 12:35:38\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.27.6\";s:2:\"to\";s:6:\"3.27.7\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"ecd1b8fef63dcb07352b72e789ef71e0\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:7:\"\0*\0date\";s:19:\"2025-04-28 09:32:31\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:66:\"Cannot read properties of undefined (reading &#039;activate&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-28 09:32:31\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1745832751\";s:7:\"message\";s:56:\"Cannot read properties of undefined (reading \'activate\')\";s:3:\"url\";s:87:\"https://homeo.tooswp.ir/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.27.7\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:5:\"54282\";}s:7:\"\0*\0file\";s:87:\"https://homeo.tooswp.ir/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.27.7\";s:7:\"\0*\0line\";s:1:\"3\";s:9:\"\0*\0column\";s:5:\"54282\";}s:32:\"691b81ec82b43ed0eeac26286d63f62e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-28 14:13:44\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.27.7\";s:2:\"to\";s:6:\"3.28.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-28 14:13:44\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.27.7\";s:2:\"to\";s:6:\"3.28.3\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"d584303af949c5fd554ca1533b6d312f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-28 14:13:45\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:13:\"Elementor Pro\";s:4:\"from\";s:6:\"3.27.4\";s:2:\"to\";s:6:\"3.28.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-28 14:13:45\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:13:\"Elementor Pro\";s:4:\"from\";s:6:\"3.27.4\";s:2:\"to\";s:6:\"3.28.3\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"b44d2ddf36529e1e721ae9538f163e02\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-28 13:24:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-28 13:24:16\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"3cc01e6745e6ea620dd04506860d6884\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-28 13:24:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:48:\"Elementor Pro/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-28 13:24:16\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:48:\"Elementor Pro/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"7cd1f651b32ab054db726397ee445941\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-28 13:24:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor Pro/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-28 13:24:16\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:50:\"Elementor Pro/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"5fdfbd946ab19a5b54b7a55ea63b8ccd\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-28 13:24:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:13:\"Elementor Pro\";s:4:\"from\";s:6:\"3.27.4\";s:2:\"to\";s:6:\"3.28.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-28 13:24:16\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:13:\"Elementor Pro\";s:4:\"from\";s:6:\"3.27.4\";s:2:\"to\";s:6:\"3.28.3\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"08cc5f9644ab83bf128a2813269143aa\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-28 13:24:25\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-28 13:24:25\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"a7317009d9d45aa9b99db9408fe96575\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-28 13:24:25\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-28 13:24:25\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"9fdb265ba7e3eb34a0076761a8036d2b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-28 13:24:26\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-28 13:24:26\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"1ead96ebc0a13bc25fc103cb8c76c5f3\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-28 13:24:26\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.27.7\";s:2:\"to\";s:6:\"3.28.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-28 13:24:26\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.27.7\";s:2:\"to\";s:6:\"3.28.3\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}}", "off");
INSERT INTO `wp_options` VALUES("6777", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:22:\"aref.dariavi@gmail.com\";s:7:\"version\";s:5:\"6.4.3\";s:9:\"timestamp\";i:1707750553;}", "no");
INSERT INTO `wp_options` VALUES("141", "current_theme", "Homeo", "yes");
INSERT INTO `wp_options` VALUES("142", "theme_mods_homeo", "a:5:{i:0;b:0;s:18:\"nav_menu_locations\";a:4:{s:7:\"primary\";i:93;s:10:\"agent-menu\";i:88;s:11:\"agency-menu\";i:87;s:9:\"user-menu\";i:98;}s:18:\"custom_css_post_id\";i:3184;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1597044733;s:4:\"data\";a:14:{s:19:\"wp_inactive_widgets\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:15:\"sidebar-default\";a:3:{i:0;s:8:\"search-3\";i:1;s:14:\"recent-posts-3\";i:2;s:17:\"recent-comments-3\";}s:25:\"properties-filter-sidebar\";a:2:{i:0;s:25:\"apus_elementor_template-1\";i:1;s:27:\"apus_widget_property_list-1\";}s:31:\"properties-filter-sidebar-fixed\";a:1:{i:0;s:25:\"apus_elementor_template-2\";}s:29:\"properties-filter-top-sidebar\";a:1:{i:0;s:25:\"apus_elementor_template-3\";}s:30:\"properties-filter-top-half-map\";a:1:{i:0;s:25:\"apus_elementor_template-4\";}s:23:\"property-single-sidebar\";a:5:{i:0;s:28:\"apus_property_contact_form-1\";i:1;s:25:\"apus_elementor_template-5\";i:2;s:27:\"apus_widget_property_list-2\";i:3;s:27:\"apus_private_message_form-1\";i:4;s:26:\"apus_mortgage_calculator-1\";}s:21:\"agents-filter-sidebar\";a:2:{i:0;s:22:\"agency_filter_widget-1\";i:1;s:27:\"apus_widget_property_list-3\";}s:20:\"agent-single-sidebar\";a:3:{i:0;s:19:\"apus_contact_form-1\";i:1;s:21:\"agent_filter_widget-1\";i:2;s:27:\"apus_private_message_form-2\";}s:23:\"agencies-filter-sidebar\";a:2:{i:0;s:22:\"agency_filter_widget-2\";i:1;s:27:\"apus_widget_property_list-4\";}s:21:\"agency-single-sidebar\";a:3:{i:0;s:27:\"apus_private_message_form-3\";i:1;s:22:\"agency_filter_widget-3\";i:2;s:19:\"apus_contact_form-2\";}s:20:\"user-profile-sidebar\";a:2:{i:0;s:13:\"media_image-1\";i:1;s:25:\"apus_user_short_profile-1\";}s:12:\"blog-sidebar\";a:4:{i:0;s:13:\"apus_search-1\";i:1;s:12:\"categories-3\";i:2;s:27:\"apus_widget_property_list-5\";i:3;s:11:\"tag_cloud-1\";}s:12:\"shop-sidebar\";a:3:{i:0;s:13:\"apus_search-2\";i:1;s:32:\"woocommerce_product_categories-1\";i:2;s:22:\"woocommerce_products-1\";}}}s:19:\"homeo_theme_options\";a:1:{s:17:\"media-mobile-logo\";a:9:{s:3:\"url\";s:61:\"https://homeo.tooswp.ir/wp-content/uploads/2020/02/logo-1.png\";s:2:\"id\";s:4:\"3126\";s:6:\"height\";s:2:\"47\";s:5:\"width\";s:3:\"150\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:4:\"logo\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}}}", "yes");
INSERT INTO `wp_options` VALUES("143", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("146", "wpcf7", "a:2:{s:7:\"version\";s:5:\"6.0.6\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1588803911;s:7:\"version\";s:5:\"5.1.7\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "yes");
INSERT INTO `wp_options` VALUES("335", "woocommerce_meta_box_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("149", "revslider_servers", "a:3:{i:0;s:22:\"themepunch-ext-b.tools\";i:1;s:22:\"themepunch-ext-c.tools\";i:2;s:22:\"themepunch-ext-a.tools\";}", "yes");
INSERT INTO `wp_options` VALUES("150", "revslider_server_refresh", "1744611634", "yes");
INSERT INTO `wp_options` VALUES("151", "revslider-update-check-short", "1745832180", "yes");
INSERT INTO `wp_options` VALUES("152", "revslider-connection", "1", "yes");
INSERT INTO `wp_options` VALUES("153", "revslider-update-hash", "236397f229ddb804750b81b7add07e12", "yes");
INSERT INTO `wp_options` VALUES("154", "revslider-latest-version", "6.7.32", "yes");
INSERT INTO `wp_options` VALUES("155", "revslider-stable-version", "4.2.0", "yes");
INSERT INTO `wp_options` VALUES("156", "revslider-notices", "a:4:{i:0;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:952:\"<div style=\"display: block; background: #1b0e41;text-align: center; height:300px;\"><noscript><img src=\"//updates.themepunch-ext-b.tools//banners/rs60/cyberweek.jpg\" usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\"></noscript><img usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\" src=\"//updates.themepunch-ext-b.tools//banners/rs60/cyberweek.jpg\"></div>\n<map name=\"srbannermap\">\n    <area target=\"_blank\" alt=\"Slider Revolution\" title=\"Slider Revolution\" href=\"https://www.sliderrevolution.com/black-friday-and-cyber-monday-sale/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=cyberweeks22\" coords=\"569,135,890,196\" shape=\"rect\">\n    <area target=\"_blank\" alt=\"Essential Grid\" title=\"Essential Grid\" href=\"https://www.essential-grid.com/?utm_source=admin&utm_medium=banner&utm_campaign=esgusers&utm_content=cyberweeks22\" coords=\"570,200,889,260\" shape=\"rect\">\n</map>\";s:4:\"code\";s:9:\"TPSRCW111\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:1;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:956:\"<div style=\"display: block; background: #1c0950;text-align: center; height:300px;\"><noscript><img src=\"//updates.themepunch-ext-b.tools//banners/blackfriday2024-admin2.jpg\" usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\"></noscript><img usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\" src=\"//updates.themepunch-ext-b.tools//banners/blackfriday2024-admin2.jpg\"></div><map name=\"srbannermap\"><area target=\"_blank\" alt=\"Slider Revolution\" title=\"Slider Revolution\" href=\"https://www.sliderrevolution.com/black-friday-and-cyber-monday-sale/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=cyberweeks24\" coords=\"569,135,890,196\" shape=\"rect\"><area target=\"_blank\" alt=\"Essential Grid\" title=\"Essential Grid\" href=\"https://www.essential-grid.com/?utm_source=admin&utm_medium=banner&utm_campaign=esgusers&utm_content=cyberweeks24\" coords=\"570,200,889,260\" shape=\"rect\"></map>\";s:4:\"code\";s:8:\"TPSRBF24\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:2;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"9.9.9\";s:4:\"text\";s:527:\"<div style=\"display: block; background: #0d0d0e;text-align: center; height: 504px;\"><a href=\"https://account.sliderrevolution.com/portal/pricing/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getpremium3\" target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: cover; background-size: cover; opacity: 1; width: 900px; height: 504px; display: inline-block;\" muted loop autoplay preload=\"auto\"><source src=\"//updates.themepunch-ext-b.tools//banners/rs60/buypremium3.mp4\" type=\"video/mp4\"></video></a></div>\";s:4:\"code\";s:11:\"TPSNOTR3011\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:3;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:302:\"<div style=\"display: block; background: #0d0d0e;text-align: center; height: 250px;\"><a href=\"https://forms.gle/jrzzrpu34VvrFDsMA\" target=\"_blank\" rel=\"noopener\">\n<img style=\"min-width:920px;height:250px;display: inline-block;\" src=\"//updates.themepunch-ext-b.tools//banners/SR2024survey.jpg\"></a></div>\";s:4:\"code\";s:12:\"TPSURVEY2024\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:1;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("157", "revslider-additions", "O:8:\"stdClass\":2:{s:9:\"templates\";O:8:\"stdClass\":3:{s:9:\"tutorials\";a:3:{i:0;O:8:\"stdClass\":2:{s:5:\"title\";s:19:\"Rapid Fire Overview\";s:3:\"url\";s:49:\"https://www.youtube.com/watch?v=LRNTFu-MFgw&t=25s\";}i:1;O:8:\"stdClass\":2:{s:5:\"title\";s:34:\"Responsiveness in Edited Templates\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=hP4oV8SWgKY\";}i:2;O:8:\"stdClass\":2:{s:5:\"title\";s:16:\"Animation Basics\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=nn3azizwpbs\";}}s:5:\"guide\";O:8:\"stdClass\":3:{s:5:\"title\";s:78:\"Require Expert Technical Advice?<br />Submit a Ticket for Dedicated 1on1 Help.\";s:3:\"url\";s:36:\"https://support.sliderrevolution.com\";s:3:\"img\";s:67:\"//updates.themepunch-ext-b.tools/banners/default_template_guide.jpg\";}s:6:\"bottom\";O:8:\"stdClass\":2:{s:5:\"title\";s:32:\"Load A Template From The Library\";s:3:\"img\";s:61:\"//updates.themepunch-ext-b.tools/banners/guide_mod_banner.png\";}}s:7:\"selling\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("158", "rs-addons-counter", "1", "yes");
INSERT INTO `wp_options` VALUES("159", "revslider-addons", "O:8:\"stdClass\":36:{s:28:\"revslider-particlewave-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"559\";s:9:\"releaseid\";s:2:\"29\";s:4:\"slug\";s:28:\"revslider-particlewave-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Particle Wave\";s:6:\"line_1\";s:36:\"Create 3D particle and polygon grids\";s:6:\"line_2\";s:40:\"with lots of style and animation options\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:1:\"9\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:79:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_particlewave.jpg\";s:8:\"img_file\";s:46:\"revslider/addons/images/addon_particlewave.jpg\";s:7:\"img_md5\";s:32:\"623bec30f175f4cc541048f1d6d5fd07\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PW\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-particles-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"558\";s:9:\"releaseid\";s:1:\"7\";s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"6.7.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:2:\"10\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_particles.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_particles.jpg\";s:7:\"img_md5\";s:32:\"b668a4015ddc6a532b43bb558967a062\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"405\";s:9:\"releaseid\";s:2:\"20\";s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"20\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_bubblemorph.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_bubblemorph.jpg\";s:7:\"img_md5\";s:32:\"22d03d5de3034069c6db1fdeafd467cd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-thecluster-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"567\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:26:\"revslider-thecluster-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"The Cluster\";s:6:\"line_1\";s:24:\"Cluster Particle Effects\";s:6:\"line_2\";s:27:\"with millions of Variations\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"22\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_cluster.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_cluster.jpg\";s:7:\"img_md5\";s:32:\"7ada93a9f08a3bcfddc078699674d755\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TC\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:29:\"revslider-fluiddynamics-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"551\";s:9:\"releaseid\";s:2:\"31\";s:4:\"slug\";s:29:\"revslider-fluiddynamics-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Fluid Dynamics\";s:6:\"line_1\";s:46:\"Creating breathtaking Dynamic Fluid animations\";s:6:\"line_2\";s:25:\"as layer or as background\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"27\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:72:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_fluid.png\";s:8:\"img_file\";s:39:\"revslider/addons/images/addon_fluid.png\";s:7:\"img_md5\";s:32:\"4e52333540d80bcb2a41b8ed5961e088\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FD\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-transitionpack-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"568\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:30:\"revslider-transitionpack-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:6:\"6.7.31\";s:5:\"title\";s:20:\"Advanced Transitions\";s:6:\"line_1\";s:43:\"Add never-before-seen slide transitions to \";s:6:\"line_2\";s:42:\"Slider Revolution with the power of WEBGL.\";s:9:\"available\";s:5:\"6.7.7\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"30\";s:11:\"last_update\";s:10:\"2025-01-17\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_transition.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_transition.jpg\";s:7:\"img_md5\";s:32:\"fe0f1c539053620039a0ad96c4ac27e6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"AT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"545\";s:9:\"releaseid\";s:2:\"15\";s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"6.7.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"40\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_beforeafter.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_beforeafter.jpg\";s:7:\"img_md5\";s:32:\"5a34f20417a7874e1b95693ef37a0758\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"569\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:2:\"50\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_typewriter.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_typewriter.jpg\";s:7:\"img_md5\";s:32:\"727b604f6fd3fc55894ba50eb566efed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-mousetrap-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"555\";s:9:\"releaseid\";s:2:\"24\";s:4:\"slug\";s:25:\"revslider-mousetrap-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Mousetrap\";s:6:\"line_1\";s:31:\"Create all kinds of interesting\";s:6:\"line_2\";s:19:\" mouse interactions\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"60\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_mousetrap.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_mousetrap.jpg\";s:7:\"img_md5\";s:32:\"2329053c3b1d19bdaee131c3dc258d3a\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"552\";s:9:\"releaseid\";s:2:\"21\";s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"70\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_distortion.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_distortion.jpg\";s:7:\"img_md5\";s:32:\"c26c52a563008b7dc907a288c1e4bb8e\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-lottie-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"553\";s:9:\"releaseid\";s:2:\"25\";s:4:\"slug\";s:22:\"revslider-lottie-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Lottie\";s:6:\"line_1\";s:53:\"Adds support for the popular Lottie Animation format,\";s:6:\"line_2\";s:70:\" including animation control, style customization and a local library.\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"80\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_lottie.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_lottie.jpg\";s:7:\"img_md5\";s:32:\"4aa677a45bb13732e4f10bcb632afcce\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"556\";s:9:\"releaseid\";s:2:\"23\";s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"90\";s:11:\"last_update\";s:10:\"2025-01-15\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_paintbrush.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_paintbrush.jpg\";s:7:\"img_md5\";s:32:\"308a56289b9a29d1916c2acfc141b699\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-charts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"547\";s:9:\"releaseid\";s:2:\"27\";s:4:\"slug\";s:22:\"revslider-charts-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Charts\";s:6:\"line_1\";s:93:\"The Charts addon allows you to create visually impressive line or bar graphs from .csv data, \";s:6:\"line_2\";s:56:\"with tons of options to take full control of the design.\";s:9:\"available\";s:5:\"6.7.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:3:\"100\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_charts.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_charts.jpg\";s:7:\"img_md5\";s:32:\"d2c184371a575faade425c0377c1fdbd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"CH\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"417\";s:9:\"releaseid\";s:2:\"13\";s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"110\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_slicey.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_slicey.jpg\";s:7:\"img_md5\";s:32:\"28afd29b7738a452194f0a0bc1d21cbe\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"550\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"6.7.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"125\";s:11:\"last_update\";s:10:\"2024-12-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_filmstrip.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_filmstrip.jpg\";s:7:\"img_md5\";s:32:\"dac40ee57d2be9aaf01faacf51ccb412\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"554\";s:9:\"releaseid\";s:1:\"4\";s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"127\";s:11:\"last_update\";s:10:\"2024-12-06\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:84:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_underconstruction.jpg\";s:8:\"img_file\";s:51:\"revslider/addons/images/addon_underconstruction.jpg\";s:7:\"img_md5\";s:32:\"17f8cba84931541c065cfb1943edafb2\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"562\";s:9:\"releaseid\";s:2:\"19\";s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"6.7.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"6.7.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"130\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_reveal.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_reveal.jpg\";s:7:\"img_md5\";s:32:\"a7ce4bf5eb6fdc1497ed6276ca623046\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"616\";s:9:\"releaseid\";s:2:\"17\";s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:6:\"6.7.21\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:28:\"Display images in 360 degree\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"135\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:75:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_panorama.jpg\";s:8:\"img_file\";s:42:\"revslider/addons/images/addon_panorama.jpg\";s:7:\"img_md5\";s:32:\"210953d59903bed91688138cb60777d2\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-scrollvideo-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"575\";s:9:\"releaseid\";s:2:\"26\";s:4:\"slug\";s:27:\"revslider-scrollvideo-addon\";s:12:\"version_from\";s:5:\"6.7.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Scroll Video\";s:6:\"line_1\";s:114:\"This addon allows you to generate a sequence of images from any html5 video and play them with scroll interaction.\";s:6:\"line_2\";s:49:\"Quality options are included for optimal results!\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:15:\"background_file\";s:45:\"revslider/addons/images/addon_scrollvideo.jpg\";s:14:\"background_md5\";s:32:\"82b2706dfa20a7b0cfabfe7ff28562f9\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"140\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_scrollvideo.jpg\";s:7:\"img_md5\";s:32:\"82b2706dfa20a7b0cfabfe7ff28562f9\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SV\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"549\";s:9:\"releaseid\";s:2:\"22\";s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"150\";s:11:\"last_update\";s:10:\"2025-02-18\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_exploding.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_exploding.jpg\";s:7:\"img_md5\";s:32:\"44d60b83cdf5b29033d41feb516b47e1\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"564\";s:9:\"releaseid\";s:1:\"5\";s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"165\";s:11:\"last_update\";s:10:\"2024-12-19\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:80:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_socialsharing.jpg\";s:8:\"img_file\";s:47:\"revslider/addons/images/addon_socialsharing.jpg\";s:7:\"img_md5\";s:32:\"6b074630853c4f95d5337bc85e496cbe\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"571\";s:9:\"releaseid\";s:1:\"1\";s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:81:\"//updates.themepunch-ext-b.tools/revslider/addons/images/whiteboard_widget_bg.jpg\";s:15:\"background_file\";s:48:\"revslider/addons/images/whiteboard_widget_bg.jpg\";s:14:\"background_md5\";s:32:\"cc69160eb95469dc033e0cc094a24847\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"170\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_whiteboard.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_whiteboard.jpg\";s:7:\"img_md5\";s:32:\"b0bb636fb30ffc3d112ba4c563395ee6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"560\";s:9:\"releaseid\";s:2:\"14\";s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"180\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:75:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_polyfold.jpg\";s:8:\"img_file\";s:42:\"revslider/addons/images/addon_polyfold.jpg\";s:7:\"img_md5\";s:32:\"02c6af89e4208f0da5920c6c3e6bb744\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:29:\"revslider-domain-switch-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"78\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:29:\"revslider-domain-switch-addon\";s:12:\"version_from\";s:5:\"6.0.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Domain Switch\";s:6:\"line_1\";s:17:\"Switch Image URLs\";s:6:\"line_2\";s:37:\"in sliders from one domain to another\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"300\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:79:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_domainswitch.jpg\";s:8:\"img_file\";s:46:\"revslider/addons/images/addon_domainswitch.jpg\";s:7:\"img_md5\";s:32:\"f2036924e7993f94bd5c9876fa0bf09b\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"DS\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"561\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"330\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_reload.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_reload.jpg\";s:7:\"img_md5\";s:32:\"d1d34d204e627168f4cc4e7422a6d40c\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"55\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"340\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wprelated.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_wprelated.jpg\";s:7:\"img_md5\";s:32:\"e2e7d6c3a428a55442ba90131556c930\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"566\";s:9:\"releaseid\";s:1:\"6\";s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"380\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:71:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_snow.jpg\";s:8:\"img_file\";s:38:\"revslider/addons/images/addon_snow.jpg\";s:7:\"img_md5\";s:32:\"d6bac718866b0070198a4340041bc60b\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"378\";s:9:\"releaseid\";s:1:\"2\";s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"2.0.7\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"430\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wpgallery.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_wpgallery.jpg\";s:7:\"img_md5\";s:32:\"74392a04b741d83c51e55059dbb388ef\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-backup-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"53\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"2.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"500\";s:11:\"last_update\";s:10:\"2024-11-20\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_backup.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_backup.jpg\";s:7:\"img_md5\";s:32:\"104797323a0293cd3f200b0172db1186\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"62\";s:9:\"releaseid\";s:1:\"8\";s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"620\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:70:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_404.jpg\";s:8:\"img_file\";s:37:\"revslider/addons/images/addon_404.jpg\";s:7:\"img_md5\";s:32:\"217b0d118a107dc50979740dd61228df\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"63\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"630\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wpadjacent.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_wpadjacent.jpg\";s:7:\"img_md5\";s:32:\"cb1feb1257e55d0f42c29dfde2d809ed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"388\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"650\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:72:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_login.jpg\";s:8:\"img_file\";s:39:\"revslider/addons/images/addon_login.jpg\";s:7:\"img_md5\";s:32:\"f0f2edffb4e155acf67799692428644d\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"379\";s:9:\"releaseid\";s:2:\"12\";s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"2.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"660\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wpfeatured.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_wpfeatured.jpg\";s:7:\"img_md5\";s:32:\"bcc840e68194f3eb05795e1353954bda\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-shapeburst-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"613\";s:9:\"releaseid\";s:2:\"29\";s:4:\"slug\";s:26:\"revslider-shapeburst-addon\";s:12:\"version_from\";s:6:\"6.7.23\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"ShapeBurst\";s:6:\"line_1\";s:8:\"Shape...\";s:6:\"line_2\";s:9:\"and Burst\";s:9:\"available\";s:5:\"7.0.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:3:\"670\";s:11:\"last_update\";s:10:\"2024-11-20\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_shape_burst.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_shape_burst.jpg\";s:7:\"img_md5\";s:32:\"2b1b6cb4613bdfcfff4c8c46660be8f5\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:1:{i:0;s:14:\"Visual Effects\";}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"570\";s:9:\"releaseid\";s:2:\"16\";s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"690\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_weather.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_weather.jpg\";s:7:\"img_md5\";s:32:\"c69d1c9a69c2dec43ca0578ac35792bd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"548\";s:9:\"releaseid\";s:2:\"18\";s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"710\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_duotone.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_duotone.jpg\";s:7:\"img_md5\";s:32:\"fb666e487e7ac28e6a2a157eed1fb682\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("160", "revslider-library-check", "1745832180", "yes");
INSERT INTO `wp_options` VALUES("161", "revslider-library-hash", "324e6ba47fb68dfb7f1bd5b0b203bdc5", "yes");
INSERT INTO `wp_options` VALUES("162", "rs-library", "a:3:{s:4:\"hash\";s:32:\"324e6ba47fb68dfb7f1bd5b0b203bdc5\";s:7:\"objects\";a:417:{i:0;a:13:{s:2:\"id\";s:3:\"198\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14130;s:4:\"orig\";i:220294;}}i:1;a:13:{s:2:\"id\";s:3:\"188\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:27127;s:4:\"orig\";i:1192484;}}i:2;a:13:{s:2:\"id\";s:3:\"187\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:1745;s:4:\"orig\";i:36243;}}i:3;a:13:{s:2:\"id\";s:3:\"172\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10511;s:4:\"orig\";i:102067;}}i:4;a:13:{s:2:\"id\";s:3:\"171\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18581;s:4:\"orig\";i:776243;}}i:5;a:13:{s:2:\"id\";s:3:\"170\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4745;s:4:\"orig\";i:330658;}}i:6;a:13:{s:2:\"id\";s:3:\"169\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4461;s:4:\"orig\";i:109963;}}i:7;a:13:{s:2:\"id\";s:3:\"168\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6790;s:4:\"orig\";i:407746;}}i:8;a:13:{s:2:\"id\";s:3:\"167\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18710;s:4:\"orig\";i:985569;}}i:9;a:13:{s:2:\"id\";s:3:\"166\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6113;s:4:\"orig\";i:75865;}}i:10;a:13:{s:2:\"id\";s:3:\"165\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8145;s:4:\"orig\";i:400329;}}i:11;a:13:{s:2:\"id\";s:3:\"164\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"name\";s:10:\"Hole punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5251;s:4:\"orig\";i:358141;}}i:12;a:13:{s:2:\"id\";s:3:\"163\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:127536;s:4:\"orig\";i:838279;}}i:13;a:13:{s:2:\"id\";s:3:\"162\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4081;s:4:\"orig\";i:22391;}}i:14;a:13:{s:2:\"id\";s:3:\"161\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9331;s:4:\"orig\";i:516465;}}i:15;a:13:{s:2:\"id\";s:3:\"160\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7834;s:4:\"orig\";i:463818;}}i:16;a:13:{s:2:\"id\";s:3:\"159\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6359;s:4:\"orig\";i:102578;}}i:17;a:13:{s:2:\"id\";s:3:\"158\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22078;s:4:\"orig\";i:1107904;}}i:18;a:13:{s:2:\"id\";s:3:\"157\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15660;s:4:\"orig\";i:355784;}}i:19;a:13:{s:2:\"id\";s:3:\"156\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5586;s:4:\"orig\";i:106514;}}i:20;a:13:{s:2:\"id\";s:3:\"155\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20909;s:4:\"orig\";i:988589;}}i:21;a:13:{s:2:\"id\";s:3:\"154\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6807;s:4:\"orig\";i:604409;}}i:22;a:13:{s:2:\"id\";s:3:\"153\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10484;s:4:\"orig\";i:229243;}}i:23;a:13:{s:2:\"id\";s:3:\"152\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6034;s:4:\"orig\";i:516575;}}i:24;a:13:{s:2:\"id\";s:3:\"151\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:30999;s:4:\"orig\";i:627862;}}i:25;a:13:{s:2:\"id\";s:3:\"150\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11735;s:4:\"orig\";i:658948;}}i:26;a:13:{s:2:\"id\";s:3:\"149\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16432;s:4:\"orig\";i:531684;}}i:27;a:13:{s:2:\"id\";s:3:\"148\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15860;s:4:\"orig\";i:212685;}}i:28;a:13:{s:2:\"id\";s:3:\"147\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12774;s:4:\"orig\";i:290128;}}i:29;a:13:{s:2:\"id\";s:3:\"146\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8558;s:4:\"orig\";i:264887;}}i:30;a:13:{s:2:\"id\";s:3:\"145\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23349;s:4:\"orig\";i:324946;}}i:31;a:13:{s:2:\"id\";s:3:\"144\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18439;s:4:\"orig\";i:583276;}}i:32;a:13:{s:2:\"id\";s:3:\"143\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8475;s:4:\"orig\";i:241613;}}i:33;a:13:{s:2:\"id\";s:3:\"142\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12227;s:4:\"orig\";i:465092;}}i:34;a:13:{s:2:\"id\";s:3:\"141\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23476;s:4:\"orig\";i:838985;}}i:35;a:13:{s:2:\"id\";s:3:\"140\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:128594;s:4:\"orig\";i:323284;}}i:36;a:13:{s:2:\"id\";s:3:\"139\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15763;s:4:\"orig\";i:606028;}}i:37;a:13:{s:2:\"id\";s:3:\"138\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8743;s:4:\"orig\";i:230696;}}i:38;a:13:{s:2:\"id\";s:3:\"137\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18213;s:4:\"orig\";i:963650;}}i:39;a:13:{s:2:\"id\";s:3:\"136\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9109;s:4:\"orig\";i:190560;}}i:40;a:13:{s:2:\"id\";s:3:\"135\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7469;s:4:\"orig\";i:161910;}}i:41;a:13:{s:2:\"id\";s:3:\"134\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8883;s:4:\"orig\";i:223813;}}i:42;a:13:{s:2:\"id\";s:3:\"133\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13021;s:4:\"orig\";i:334845;}}i:43;a:13:{s:2:\"id\";s:3:\"132\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20718;s:4:\"orig\";i:626836;}}i:44;a:13:{s:2:\"id\";s:3:\"131\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:135139;s:4:\"orig\";i:761240;}}i:45;a:13:{s:2:\"id\";s:3:\"130\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13099;s:4:\"orig\";i:337348;}}i:46;a:13:{s:2:\"id\";s:3:\"129\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13096;s:4:\"orig\";i:413010;}}i:47;a:13:{s:2:\"id\";s:3:\"128\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8043;s:4:\"orig\";i:146037;}}i:48;a:13:{s:2:\"id\";s:3:\"127\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:37011;s:4:\"orig\";i:2569343;}}i:49;a:13:{s:2:\"id\";s:3:\"126\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:118650;s:4:\"orig\";i:83713;}}i:50;a:13:{s:2:\"id\";s:3:\"125\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16941;s:4:\"orig\";i:419726;}}i:51;a:13:{s:2:\"id\";s:3:\"124\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23620;s:4:\"orig\";i:734047;}}i:52;a:13:{s:2:\"id\";s:3:\"123\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21088;s:4:\"orig\";i:683735;}}i:53;a:13:{s:2:\"id\";s:3:\"122\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:121307;s:4:\"orig\";i:454357;}}i:54;a:13:{s:2:\"id\";s:3:\"121\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:39586;s:4:\"orig\";i:1296460;}}i:55;a:13:{s:2:\"id\";s:3:\"120\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21396;s:4:\"orig\";i:835061;}}i:56;a:13:{s:2:\"id\";s:3:\"119\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9545;s:4:\"orig\";i:197811;}}i:57;a:13:{s:2:\"id\";s:3:\"118\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12033;s:4:\"orig\";i:168991;}}i:58;a:13:{s:2:\"id\";s:3:\"117\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:39587;s:4:\"orig\";i:1318549;}}i:59;a:13:{s:2:\"id\";s:2:\"88\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:137321;s:4:\"orig\";i:211275;}}i:60;a:13:{s:2:\"id\";s:2:\"87\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14164;s:4:\"orig\";i:731428;}}i:61;a:13:{s:2:\"id\";s:2:\"86\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:130362;s:4:\"orig\";i:908876;}}i:62;a:13:{s:2:\"id\";s:2:\"85\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:132862;s:4:\"orig\";i:925492;}}i:63;a:13:{s:2:\"id\";s:2:\"84\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:119015;s:4:\"orig\";i:133010;}}i:64;a:13:{s:2:\"id\";s:2:\"83\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:28476;s:4:\"orig\";i:203448;}}i:65;a:13:{s:2:\"id\";s:2:\"82\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:120592;s:4:\"orig\";i:133753;}}i:66;a:13:{s:2:\"id\";s:2:\"81\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:119554;s:4:\"orig\";i:160622;}}i:67;a:13:{s:2:\"id\";s:2:\"80\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14058;s:4:\"orig\";i:98209;}}i:68;a:13:{s:2:\"id\";s:2:\"79\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:126007;s:4:\"orig\";i:137953;}}i:69;a:13:{s:2:\"id\";s:2:\"78\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:124418;s:4:\"orig\";i:108064;}}i:70;a:13:{s:2:\"id\";s:2:\"77\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:125639;s:4:\"orig\";i:131820;}}i:71;a:13:{s:2:\"id\";s:2:\"76\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11948;s:4:\"orig\";i:74707;}}i:72;a:13:{s:2:\"id\";s:2:\"75\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:115633;s:4:\"orig\";i:176188;}}i:73;a:13:{s:2:\"id\";s:2:\"74\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:121535;s:4:\"orig\";i:315586;}}i:74;a:13:{s:2:\"id\";s:2:\"73\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:133693;s:4:\"orig\";i:907152;}}i:75;a:13:{s:2:\"id\";s:2:\"72\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11689;s:4:\"orig\";i:183976;}}i:76;a:13:{s:2:\"id\";s:2:\"71\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:119147;s:4:\"orig\";i:164255;}}i:77;a:13:{s:2:\"id\";s:2:\"70\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9499;s:4:\"orig\";i:358634;}}i:78;a:13:{s:2:\"id\";s:2:\"69\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14203;s:4:\"orig\";i:523017;}}i:79;a:13:{s:2:\"id\";s:2:\"68\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10702;s:4:\"orig\";i:121030;}}i:80;a:13:{s:2:\"id\";s:2:\"67\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9002;s:4:\"orig\";i:338072;}}i:81;a:13:{s:2:\"id\";s:2:\"66\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:121622;s:4:\"orig\";i:211345;}}i:82;a:13:{s:2:\"id\";s:2:\"65\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:122962;s:4:\"orig\";i:353407;}}i:83;a:13:{s:2:\"id\";s:2:\"64\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7170;s:4:\"orig\";i:118827;}}i:84;a:13:{s:2:\"id\";s:2:\"63\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:125910;s:4:\"orig\";i:126452;}}i:85;a:13:{s:2:\"id\";s:2:\"62\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12207;s:4:\"orig\";i:177730;}}i:86;a:13:{s:2:\"id\";s:2:\"49\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13663;s:4:\"orig\";i:833006;}}i:87;a:13:{s:2:\"id\";s:2:\"48\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9899;s:4:\"orig\";i:247486;}}i:88;a:13:{s:2:\"id\";s:2:\"47\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7169;s:4:\"orig\";i:522980;}}i:89;a:13:{s:2:\"id\";s:2:\"46\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12411;s:4:\"orig\";i:1051815;}}i:90;a:13:{s:2:\"id\";s:2:\"45\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14974;s:4:\"orig\";i:1082610;}}i:91;a:13:{s:2:\"id\";s:2:\"44\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26819;s:4:\"orig\";i:1283468;}}i:92;a:13:{s:2:\"id\";s:2:\"43\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22713;s:4:\"orig\";i:1335327;}}i:93;a:13:{s:2:\"id\";s:2:\"42\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5513;s:4:\"orig\";i:477513;}}i:94;a:13:{s:2:\"id\";s:2:\"41\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24077;s:4:\"orig\";i:1392352;}}i:95;a:13:{s:2:\"id\";s:2:\"40\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11502;s:4:\"orig\";i:779077;}}i:96;a:13:{s:2:\"id\";s:2:\"39\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7975;s:4:\"orig\";i:323107;}}i:97;a:13:{s:2:\"id\";s:2:\"38\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:129564;s:4:\"orig\";i:432451;}}i:98;a:13:{s:2:\"id\";s:2:\"37\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6743;s:4:\"orig\";i:479348;}}i:99;a:13:{s:2:\"id\";s:2:\"36\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3910;s:4:\"orig\";i:246373;}}i:100;a:13:{s:2:\"id\";s:2:\"35\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9677;s:4:\"orig\";i:154608;}}i:101;a:13:{s:2:\"id\";s:2:\"34\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5998;s:4:\"orig\";i:447839;}}i:102;a:13:{s:2:\"id\";s:2:\"33\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10117;s:4:\"orig\";i:559800;}}i:103;a:13:{s:2:\"id\";s:2:\"32\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24853;s:4:\"orig\";i:1214851;}}i:104;a:13:{s:2:\"id\";s:2:\"31\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18163;s:4:\"orig\";i:1098732;}}i:105;a:13:{s:2:\"id\";s:2:\"30\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5457;s:4:\"orig\";i:320148;}}i:106;a:13:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13313;s:4:\"orig\";i:828871;}}i:107;a:13:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5901;s:4:\"orig\";i:268842;}}i:108;a:13:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:37178;s:4:\"orig\";i:1972817;}}i:109;a:13:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26589;s:4:\"orig\";i:851135;}}i:110;a:13:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13334;s:4:\"orig\";i:225651;}}i:111;a:13:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17640;s:4:\"orig\";i:719125;}}i:112;a:13:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8897;s:4:\"orig\";i:83416;}}i:113;a:13:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:29174;s:4:\"orig\";i:1663503;}}i:114;a:13:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3668;s:4:\"orig\";i:69153;}}i:115;a:13:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3179;s:4:\"orig\";i:45340;}}i:116;a:13:{s:2:\"id\";s:2:\"11\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21907;s:4:\"orig\";i:937495;}}i:117;a:13:{s:2:\"id\";s:2:\"10\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:124560;s:4:\"orig\";i:575796;}}i:118;a:13:{s:2:\"id\";s:1:\"9\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20553;s:4:\"orig\";i:734042;}}i:119;a:13:{s:2:\"id\";s:1:\"8\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9048;s:4:\"orig\";i:129827;}}i:120;a:13:{s:2:\"id\";s:3:\"479\";s:6:\"handle\";s:31:\"Tram-beside-waiting-station.jpg\";s:4:\"name\";s:27:\"Tram beside waiting station\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:52:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19226;s:4:\"orig\";i:758093;}}i:121;a:13:{s:2:\"id\";s:3:\"478\";s:6:\"handle\";s:14:\"Pulling-up.jpg\";s:4:\"name\";s:10:\"Pulling up\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1297\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12387;s:4:\"orig\";i:472820;}}i:122;a:13:{s:2:\"id\";s:3:\"477\";s:6:\"handle\";s:16:\"Snowboarding.jpg\";s:4:\"name\";s:12:\"Snowboarding\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1290\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10972;s:4:\"orig\";i:380716;}}i:123;a:13:{s:2:\"id\";s:3:\"476\";s:6:\"handle\";s:16:\"Morning-yoga.jpg\";s:4:\"name\";s:12:\"Morning yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1346\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12394;s:4:\"orig\";i:959761;}}i:124;a:13:{s:2:\"id\";s:3:\"475\";s:6:\"handle\";s:8:\"Yoga.jpg\";s:4:\"name\";s:4:\"Yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11474;s:4:\"orig\";i:284282;}}i:125;a:13:{s:2:\"id\";s:3:\"474\";s:6:\"handle\";s:14:\"Golf-balls.jpg\";s:4:\"name\";s:10:\"Golf balls\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13395;s:4:\"orig\";i:519568;}}i:126;a:13:{s:2:\"id\";s:3:\"473\";s:6:\"handle\";s:19:\"Confident-Boxer.jpg\";s:4:\"name\";s:15:\"Confident Boxer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15367;s:4:\"orig\";i:364626;}}i:127;a:13:{s:2:\"id\";s:3:\"472\";s:6:\"handle\";s:11:\"Aerobic.jpg\";s:4:\"name\";s:7:\"Aerobic\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16174;s:4:\"orig\";i:265728;}}i:128;a:13:{s:2:\"id\";s:3:\"471\";s:6:\"handle\";s:18:\"Riding-bicycle.jpg\";s:4:\"name\";s:14:\"Riding bicycle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1358\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7677;s:4:\"orig\";i:256526;}}i:129;a:13:{s:2:\"id\";s:3:\"470\";s:6:\"handle\";s:27:\"woman-with-barbell-back.jpg\";s:4:\"name\";s:23:\"woman with barbell back\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12408;s:4:\"orig\";i:354771;}}i:130;a:13:{s:2:\"id\";s:3:\"469\";s:6:\"handle\";s:24:\"Woman-lying-on-floor.jpg\";s:4:\"name\";s:20:\"Woman lying on floor\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1318\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17621;s:4:\"orig\";i:673109;}}i:131;a:13:{s:2:\"id\";s:3:\"468\";s:6:\"handle\";s:27:\"Holding-black-dumbbells.jpg\";s:4:\"name\";s:23:\"Holding black dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9464;s:4:\"orig\";i:180683;}}i:132;a:13:{s:2:\"id\";s:3:\"467\";s:6:\"handle\";s:25:\"Woman-using-dumbbells.jpg\";s:4:\"name\";s:21:\"Woman using dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1425\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16190;s:4:\"orig\";i:381967;}}i:133;a:13:{s:2:\"id\";s:3:\"466\";s:6:\"handle\";s:16:\"Soccer-cleat.jpg\";s:4:\"name\";s:12:\"Soccer cleat\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26583;s:4:\"orig\";i:792941;}}i:134;a:13:{s:2:\"id\";s:3:\"465\";s:6:\"handle\";s:16:\"Soccer-field.jpg\";s:4:\"name\";s:12:\"Soccer field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17464;s:4:\"orig\";i:394604;}}i:135;a:13:{s:2:\"id\";s:3:\"464\";s:6:\"handle\";s:23:\"Man-tying-his-shoes.jpg\";s:4:\"name\";s:19:\"Man tying his shoes\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19126;s:4:\"orig\";i:403268;}}i:136;a:13:{s:2:\"id\";s:3:\"463\";s:6:\"handle\";s:10:\"Boxing.jpg\";s:4:\"name\";s:6:\"Boxing\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16597;s:4:\"orig\";i:552042;}}i:137;a:13:{s:2:\"id\";s:3:\"462\";s:6:\"handle\";s:22:\"woman-with-barbell.jpg\";s:4:\"name\";s:18:\"woman with barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16027;s:4:\"orig\";i:430912;}}i:138;a:13:{s:2:\"id\";s:3:\"461\";s:6:\"handle\";s:12:\"Crossfit.jpg\";s:4:\"name\";s:8:\"Crossfit\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15961;s:4:\"orig\";i:706482;}}i:139;a:13:{s:2:\"id\";s:3:\"460\";s:6:\"handle\";s:25:\"Man-and-woman-jogging.jpg\";s:4:\"name\";s:21:\"Man and woman jogging\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20286;s:4:\"orig\";i:704324;}}i:140;a:13:{s:2:\"id\";s:3:\"459\";s:6:\"handle\";s:16:\"Playing-golf.jpg\";s:4:\"name\";s:12:\"Playing golf\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10077;s:4:\"orig\";i:197347;}}i:141;a:13:{s:2:\"id\";s:3:\"458\";s:6:\"handle\";s:18:\"Surfer-in-wave.jpg\";s:4:\"name\";s:14:\"Surfer in wave\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14092;s:4:\"orig\";i:517927;}}i:142;a:13:{s:2:\"id\";s:3:\"457\";s:6:\"handle\";s:25:\"Woman-lifting-barbell.jpg\";s:4:\"name\";s:21:\"Woman lifting barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18629;s:4:\"orig\";i:620706;}}i:143;a:13:{s:2:\"id\";s:3:\"456\";s:6:\"handle\";s:14:\"Stretching.jpg\";s:4:\"name\";s:10:\"Stretching\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10220;s:4:\"orig\";i:348322;}}i:144;a:13:{s:2:\"id\";s:3:\"455\";s:6:\"handle\";s:18:\"Snowboarding-2.jpg\";s:4:\"name\";s:14:\"Snowboarding 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6348;s:4:\"orig\";i:211494;}}i:145;a:13:{s:2:\"id\";s:3:\"454\";s:6:\"handle\";s:11:\"Balance.jpg\";s:4:\"name\";s:7:\"Balance\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9826;s:4:\"orig\";i:377551;}}i:146;a:13:{s:2:\"id\";s:3:\"453\";s:6:\"handle\";s:19:\"Pool-meditation.jpg\";s:4:\"name\";s:15:\"Pool meditation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13862;s:4:\"orig\";i:454028;}}i:147;a:13:{s:2:\"id\";s:3:\"452\";s:6:\"handle\";s:18:\"Soccer-stadium.jpg\";s:4:\"name\";s:14:\"Soccer stadium\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18636;s:4:\"orig\";i:785357;}}i:148;a:13:{s:2:\"id\";s:3:\"451\";s:6:\"handle\";s:25:\"Soccer-field-top-view.jpg\";s:4:\"name\";s:21:\"Soccer field top view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17409;s:4:\"orig\";i:996686;}}i:149;a:13:{s:2:\"id\";s:3:\"450\";s:6:\"handle\";s:14:\"Basketball.jpg\";s:4:\"name\";s:10:\"Basketball\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12053;s:4:\"orig\";i:916937;}}i:150;a:13:{s:2:\"id\";s:3:\"449\";s:6:\"handle\";s:14:\"in-the-fog.jpg\";s:4:\"name\";s:10:\"in the fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3887;s:4:\"orig\";i:154603;}}i:151;a:13:{s:2:\"id\";s:3:\"448\";s:6:\"handle\";s:13:\"Handstand.jpg\";s:4:\"name\";s:9:\"Handstand\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16305;s:4:\"orig\";i:483681;}}i:152;a:13:{s:2:\"id\";s:3:\"447\";s:6:\"handle\";s:11:\"Friends.jpg\";s:4:\"name\";s:7:\"Friends\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12105;s:4:\"orig\";i:314746;}}i:153;a:13:{s:2:\"id\";s:3:\"446\";s:6:\"handle\";s:28:\"Sneakers-on-the-railroad.jpg\";s:4:\"name\";s:24:\"Sneakers on the railroad\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18137;s:4:\"orig\";i:371805;}}i:154;a:13:{s:2:\"id\";s:3:\"445\";s:6:\"handle\";s:23:\"Family-on-the-ocean.jpg\";s:4:\"name\";s:19:\"Family on the ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11586;s:4:\"orig\";i:354781;}}i:155;a:13:{s:2:\"id\";s:3:\"444\";s:6:\"handle\";s:10:\"Sunset.jpg\";s:4:\"name\";s:6:\"Sunset\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9848;s:4:\"orig\";i:195359;}}i:156;a:13:{s:2:\"id\";s:3:\"443\";s:6:\"handle\";s:9:\"Books.jpg\";s:4:\"name\";s:5:\"Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10089;s:4:\"orig\";i:218538;}}i:157;a:13:{s:2:\"id\";s:3:\"442\";s:6:\"handle\";s:25:\"Looking-at-the-window.jpg\";s:4:\"name\";s:21:\"Looking at the window\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16403;s:4:\"orig\";i:547096;}}i:158;a:13:{s:2:\"id\";s:3:\"441\";s:6:\"handle\";s:48:\"woman-standing-near-buildings-during-daytime.jpg\";s:4:\"name\";s:44:\"woman standing near buildings during daytime\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19188;s:4:\"orig\";i:371592;}}i:159;a:13:{s:2:\"id\";s:3:\"440\";s:6:\"handle\";s:12:\"Lollipop.jpg\";s:4:\"name\";s:8:\"Lollipop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1395\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15157;s:4:\"orig\";i:658386;}}i:160;a:13:{s:2:\"id\";s:3:\"439\";s:6:\"handle\";s:26:\"People-crossing-street.jpg\";s:4:\"name\";s:22:\"People crossing street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24833;s:4:\"orig\";i:942816;}}i:161;a:13:{s:2:\"id\";s:3:\"438\";s:6:\"handle\";s:24:\"Friends-on-the-shore.jpg\";s:4:\"name\";s:20:\"Friends on the shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15887;s:4:\"orig\";i:345362;}}i:162;a:13:{s:2:\"id\";s:3:\"437\";s:6:\"handle\";s:13:\"Coworkers.jpg\";s:4:\"name\";s:9:\"Coworkers\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15665;s:4:\"orig\";i:407640;}}i:163;a:13:{s:2:\"id\";s:3:\"436\";s:6:\"handle\";s:27:\"Hiking-in-the-Dolomites.jpg\";s:4:\"name\";s:23:\"Hiking in the Dolomites\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19443;s:4:\"orig\";i:844506;}}i:164;a:13:{s:2:\"id\";s:3:\"435\";s:6:\"handle\";s:18:\"Successful-man.jpg\";s:4:\"name\";s:14:\"Successful man\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15564;s:4:\"orig\";i:573777;}}i:165;a:13:{s:2:\"id\";s:3:\"434\";s:6:\"handle\";s:23:\"Beautiful-sunny-day.jpg\";s:4:\"name\";s:19:\"Beautiful sunny day\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13337;s:4:\"orig\";i:762091;}}i:166;a:13:{s:2:\"id\";s:3:\"433\";s:6:\"handle\";s:8:\"Guys.jpg\";s:4:\"name\";s:4:\"Guys\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16746;s:4:\"orig\";i:365391;}}i:167;a:13:{s:2:\"id\";s:3:\"432\";s:6:\"handle\";s:19:\"Confetti-Shower.jpg\";s:4:\"name\";s:15:\"Confetti Shower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12699;s:4:\"orig\";i:427166;}}i:168;a:13:{s:2:\"id\";s:3:\"431\";s:6:\"handle\";s:24:\"Sun-was-setting-down.jpg\";s:4:\"name\";s:20:\"Sun was setting down\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4748;s:4:\"orig\";i:238506;}}i:169;a:13:{s:2:\"id\";s:3:\"430\";s:6:\"handle\";s:9:\"Jumps.jpg\";s:4:\"name\";s:5:\"Jumps\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19043;s:4:\"orig\";i:595277;}}i:170;a:13:{s:2:\"id\";s:3:\"429\";s:6:\"handle\";s:23:\"Friends-by-the-fire.jpg\";s:4:\"name\";s:19:\"Friends by the fire\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11863;s:4:\"orig\";i:228649;}}i:171;a:13:{s:2:\"id\";s:3:\"428\";s:6:\"handle\";s:21:\"Under-the-blanket.jpg\";s:4:\"name\";s:17:\"Under the blanket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1413\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10878;s:4:\"orig\";i:313238;}}i:172;a:13:{s:2:\"id\";s:3:\"427\";s:6:\"handle\";s:18:\"Pretty-in-Pink.jpg\";s:4:\"name\";s:14:\"Pretty in Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1394\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7596;s:4:\"orig\";i:193734;}}i:173;a:13:{s:2:\"id\";s:3:\"426\";s:6:\"handle\";s:31:\"Discussions-at-a-long-table.jpg\";s:4:\"name\";s:27:\"Discussions at a long table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1268\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9305;s:4:\"orig\";i:223763;}}i:174;a:13:{s:2:\"id\";s:3:\"425\";s:6:\"handle\";s:18:\"Lost-in-Lemons.jpg\";s:4:\"name\";s:14:\"Lost in Lemons\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23289;s:4:\"orig\";i:699269;}}i:175;a:13:{s:2:\"id\";s:3:\"424\";s:6:\"handle\";s:13:\"Team-work.jpg\";s:4:\"name\";s:9:\"Team work\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16638;s:4:\"orig\";i:415507;}}i:176;a:13:{s:2:\"id\";s:3:\"423\";s:6:\"handle\";s:20:\"Romantic-evening.jpg\";s:4:\"name\";s:16:\"Romantic evening\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1263\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11706;s:4:\"orig\";i:310875;}}i:177;a:13:{s:2:\"id\";s:3:\"422\";s:6:\"handle\";s:19:\"Crew-collective.jpg\";s:4:\"name\";s:15:\"Crew collective\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18880;s:4:\"orig\";i:531273;}}i:178;a:13:{s:2:\"id\";s:3:\"421\";s:6:\"handle\";s:8:\"Code.jpg\";s:4:\"name\";s:4:\"Code\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20175;s:4:\"orig\";i:554813;}}i:179;a:13:{s:2:\"id\";s:3:\"420\";s:6:\"handle\";s:48:\"Yellow-ceramic-mug-beside-gray-aluminum-iMac.jpg\";s:4:\"name\";s:44:\"Yellow ceramic mug beside gray aluminum iMac\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6818;s:4:\"orig\";i:122809;}}i:180;a:13:{s:2:\"id\";s:3:\"419\";s:6:\"handle\";s:11:\"My-desk.jpg\";s:4:\"name\";s:7:\"My desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1315\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8776;s:4:\"orig\";i:190452;}}i:181;a:13:{s:2:\"id\";s:3:\"418\";s:6:\"handle\";s:17:\"Cooperation-2.jpg\";s:4:\"name\";s:13:\"Cooperation 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:52127;s:4:\"orig\";i:352596;}}i:182;a:13:{s:2:\"id\";s:3:\"417\";s:6:\"handle\";s:33:\"MacBook-on-top-of-brown-table.jpg\";s:4:\"name\";s:29:\"MacBook on top of brown table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8878;s:4:\"orig\";i:183427;}}i:183;a:13:{s:2:\"id\";s:3:\"416\";s:6:\"handle\";s:27:\"Beautiful-working-place.jpg\";s:4:\"name\";s:23:\"Beautiful working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15887;s:4:\"orig\";i:368977;}}i:184;a:13:{s:2:\"id\";s:3:\"415\";s:6:\"handle\";s:14:\"Typewriter.jpg\";s:4:\"name\";s:10:\"Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15080;s:4:\"orig\";i:707157;}}i:185;a:13:{s:2:\"id\";s:3:\"414\";s:6:\"handle\";s:19:\"White-desk-lamp.jpg\";s:4:\"name\";s:15:\"White desk lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5473;s:4:\"orig\";i:288675;}}i:186;a:13:{s:2:\"id\";s:3:\"413\";s:6:\"handle\";s:18:\"Office-working.jpg\";s:4:\"name\";s:14:\"Office working\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19262;s:4:\"orig\";i:513524;}}i:187;a:13:{s:2:\"id\";s:3:\"412\";s:6:\"handle\";s:36:\"Silver-iMac-on-brown-wooden-desk.jpg\";s:4:\"name\";s:32:\"Silver iMac on brown wooden desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1240\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9810;s:4:\"orig\";i:317981;}}i:188;a:13:{s:2:\"id\";s:3:\"411\";s:6:\"handle\";s:23:\"Working-in-progress.jpg\";s:4:\"name\";s:19:\"Working in progress\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15773;s:4:\"orig\";i:519696;}}i:189;a:13:{s:2:\"id\";s:3:\"410\";s:6:\"handle\";s:15:\"Cooperation.jpg\";s:4:\"name\";s:11:\"Cooperation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:32647;s:4:\"orig\";i:350074;}}i:190;a:13:{s:2:\"id\";s:3:\"409\";s:6:\"handle\";s:17:\"Working-place.jpg\";s:4:\"name\";s:13:\"Working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14643;s:4:\"orig\";i:314424;}}i:191;a:13:{s:2:\"id\";s:3:\"408\";s:6:\"handle\";s:16:\"Working-desk.jpg\";s:4:\"name\";s:12:\"Working desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19823;s:4:\"orig\";i:511473;}}i:192;a:13:{s:2:\"id\";s:3:\"407\";s:6:\"handle\";s:23:\"low-angle-of-forest.jpg\";s:4:\"name\";s:19:\"low angle of forest\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:37262;s:4:\"orig\";i:1590451;}}i:193;a:13:{s:2:\"id\";s:3:\"406\";s:6:\"handle\";s:23:\"Lake-under-blue-sky.jpg\";s:4:\"name\";s:19:\"Lake under blue sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1351\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13647;s:4:\"orig\";i:408622;}}i:194;a:13:{s:2:\"id\";s:3:\"405\";s:6:\"handle\";s:21:\"Blue-starry-night.jpg\";s:4:\"name\";s:17:\"Blue starry night\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10075;s:4:\"orig\";i:216586;}}i:195;a:13:{s:2:\"id\";s:3:\"404\";s:6:\"handle\";s:22:\"Aerial-photography.jpg\";s:4:\"name\";s:18:\"Aerial photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10969;s:4:\"orig\";i:405945;}}i:196;a:13:{s:2:\"id\";s:3:\"403\";s:6:\"handle\";s:14:\"Red-clouds.jpg\";s:4:\"name\";s:10:\"Red clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9975;s:4:\"orig\";i:257177;}}i:197;a:13:{s:2:\"id\";s:3:\"402\";s:6:\"handle\";s:14:\"Snow-field.jpg\";s:4:\"name\";s:10:\"Snow field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1227\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9598;s:4:\"orig\";i:300066;}}i:198;a:13:{s:2:\"id\";s:3:\"401\";s:6:\"handle\";s:13:\"White-sky.jpg\";s:4:\"name\";s:9:\"White sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7588;s:4:\"orig\";i:184359;}}i:199;a:13:{s:2:\"id\";s:3:\"400\";s:6:\"handle\";s:24:\"Trees-covered-by-fog.jpg\";s:4:\"name\";s:20:\"Trees covered by fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9507;s:4:\"orig\";i:290246;}}i:200;a:13:{s:2:\"id\";s:3:\"399\";s:6:\"handle\";s:26:\"Red-and-white-mushroom.jpg\";s:4:\"name\";s:22:\"Red and white mushroom\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14875;s:4:\"orig\";i:324145;}}i:201;a:13:{s:2:\"id\";s:3:\"398\";s:6:\"handle\";s:24:\"Lake-near-pine-trees.jpg\";s:4:\"name\";s:20:\"Lake near pine trees\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18138;s:4:\"orig\";i:736181;}}i:202;a:13:{s:2:\"id\";s:3:\"397\";s:6:\"handle\";s:35:\"After-a-long-day-of-backpacking.jpg\";s:4:\"name\";s:31:\"After a long day of backpacking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10664;s:4:\"orig\";i:411404;}}i:203;a:13:{s:2:\"id\";s:3:\"396\";s:6:\"handle\";s:32:\"Mountains-during-golden-hour.jpg\";s:4:\"name\";s:28:\"Mountains during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11609;s:4:\"orig\";i:273103;}}i:204;a:13:{s:2:\"id\";s:3:\"395\";s:6:\"handle\";s:27:\"Man-looking-on-mountain.jpg\";s:4:\"name\";s:23:\"Man looking on mountain\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16837;s:4:\"orig\";i:456937;}}i:205;a:13:{s:2:\"id\";s:3:\"394\";s:6:\"handle\";s:19:\"Body-of-water-2.jpg\";s:4:\"name\";s:15:\"Body of water 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13774;s:4:\"orig\";i:385875;}}i:206;a:13:{s:2:\"id\";s:3:\"393\";s:6:\"handle\";s:15:\"Brown-cliff.jpg\";s:4:\"name\";s:11:\"Brown cliff\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12285;s:4:\"orig\";i:546492;}}i:207;a:13:{s:2:\"id\";s:3:\"392\";s:6:\"handle\";s:20:\"Green-foggy-tree.jpg\";s:4:\"name\";s:16:\"Green foggy tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1417\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12631;s:4:\"orig\";i:540206;}}i:208;a:13:{s:2:\"id\";s:3:\"391\";s:6:\"handle\";s:32:\"Grayscale-photo-of-mountains.jpg\";s:4:\"name\";s:28:\"Grayscale photo of mountains\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9964;s:4:\"orig\";i:309994;}}i:209;a:13:{s:2:\"id\";s:3:\"390\";s:6:\"handle\";s:19:\"Under-sunny-sky.jpg\";s:4:\"name\";s:15:\"Under sunny sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13683;s:4:\"orig\";i:369417;}}i:210;a:13:{s:2:\"id\";s:3:\"389\";s:6:\"handle\";s:16:\"Rock-concert.jpg\";s:4:\"name\";s:12:\"Rock concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1443\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15941;s:4:\"orig\";i:475914;}}i:211;a:13:{s:2:\"id\";s:3:\"388\";s:6:\"handle\";s:30:\"Group-of-people-in-concert.jpg\";s:4:\"name\";s:26:\"Group of people in concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17854;s:4:\"orig\";i:371480;}}i:212;a:13:{s:2:\"id\";s:3:\"387\";s:6:\"handle\";s:6:\"DJ.jpg\";s:4:\"name\";s:2:\"DJ\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17441;s:4:\"orig\";i:507045;}}i:213;a:13:{s:2:\"id\";s:3:\"386\";s:6:\"handle\";s:56:\"Woman-standing-watching-LED-light-musical-instrument.jpg\";s:4:\"name\";s:52:\"Woman standing watching LED light musical instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:32396;s:4:\"orig\";i:750503;}}i:214;a:13:{s:2:\"id\";s:3:\"385\";s:6:\"handle\";s:16:\"Concert-hall.jpg\";s:4:\"name\";s:12:\"Concert hall\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25355;s:4:\"orig\";i:517171;}}i:215;a:13:{s:2:\"id\";s:3:\"384\";s:6:\"handle\";s:18:\"Concert-hall-2.jpg\";s:4:\"name\";s:14:\"Concert hall 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:30467;s:4:\"orig\";i:1076108;}}i:216;a:13:{s:2:\"id\";s:3:\"383\";s:6:\"handle\";s:29:\"man-playing-upright-piano.jpg\";s:4:\"name\";s:25:\"man playing upright piano\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1340\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17629;s:4:\"orig\";i:804567;}}i:217;a:13:{s:2:\"id\";s:3:\"382\";s:6:\"handle\";s:30:\"person-performing-on-stage.jpg\";s:4:\"name\";s:26:\"person performing on stage\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12952;s:4:\"orig\";i:489898;}}i:218;a:13:{s:2:\"id\";s:3:\"381\";s:6:\"handle\";s:27:\"Brown-string-instrument.jpg\";s:4:\"name\";s:23:\"Brown string instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11065;s:4:\"orig\";i:384178;}}i:219;a:13:{s:2:\"id\";s:3:\"380\";s:6:\"handle\";s:36:\"silhouette-of-person-with-guitar.jpg\";s:4:\"name\";s:32:\"silhouette of person with guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6262;s:4:\"orig\";i:198960;}}i:220;a:13:{s:2:\"id\";s:3:\"379\";s:6:\"handle\";s:14:\"Party-fans.jpg\";s:4:\"name\";s:10:\"Party fans\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16353;s:4:\"orig\";i:245636;}}i:221;a:13:{s:2:\"id\";s:3:\"378\";s:6:\"handle\";s:24:\"Condenser-microphone.jpg\";s:4:\"name\";s:20:\"Condenser microphone\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6048;s:4:\"orig\";i:133907;}}i:222;a:13:{s:2:\"id\";s:3:\"377\";s:6:\"handle\";s:42:\"Low-angle-photo-of-high-rise-buildings.jpg\";s:4:\"name\";s:38:\"Low angle photo of high rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15187;s:4:\"orig\";i:450326;}}i:223;a:13:{s:2:\"id\";s:3:\"376\";s:6:\"handle\";s:23:\"High-rise-buildings.jpg\";s:4:\"name\";s:19:\"High rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17977;s:4:\"orig\";i:582673;}}i:224;a:13:{s:2:\"id\";s:3:\"375\";s:6:\"handle\";s:16:\"Cable-bridge.jpg\";s:4:\"name\";s:12:\"Cable bridge\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20171;s:4:\"orig\";i:617346;}}i:225;a:13:{s:2:\"id\";s:3:\"374\";s:6:\"handle\";s:35:\"Bokeh-effect-from-street-lights.jpg\";s:4:\"name\";s:31:\"Bokeh effect from street lights\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14937;s:4:\"orig\";i:227355;}}i:226;a:13:{s:2:\"id\";s:3:\"373\";s:6:\"handle\";s:18:\"Low-angle-view.jpg\";s:4:\"name\";s:14:\"Low angle view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9789;s:4:\"orig\";i:321713;}}i:227;a:13:{s:2:\"id\";s:3:\"372\";s:6:\"handle\";s:21:\"Double-decker-bus.jpg\";s:4:\"name\";s:17:\"Double decker bus\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1373\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18374;s:4:\"orig\";i:642218;}}i:228;a:13:{s:2:\"id\";s:3:\"371\";s:6:\"handle\";s:32:\"Buildings-near-body-of-water.jpg\";s:4:\"name\";s:28:\"Buildings near body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1370\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17332;s:4:\"orig\";i:791283;}}i:229;a:13:{s:2:\"id\";s:3:\"370\";s:6:\"handle\";s:18:\"Satellite-view.jpg\";s:4:\"name\";s:14:\"Satellite view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:28854;s:4:\"orig\";i:1228379;}}i:230;a:13:{s:2:\"id\";s:3:\"369\";s:6:\"handle\";s:14:\"Twin-Tower.jpg\";s:4:\"name\";s:10:\"Twin Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7529;s:4:\"orig\";i:263779;}}i:231;a:13:{s:2:\"id\";s:3:\"368\";s:6:\"handle\";s:22:\"Two-person-walking.jpg\";s:4:\"name\";s:18:\"Two person walking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1345\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18101;s:4:\"orig\";i:617407;}}i:232;a:13:{s:2:\"id\";s:3:\"367\";s:6:\"handle\";s:15:\"Sears-Tower.jpg\";s:4:\"name\";s:11:\"Sears Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18049;s:4:\"orig\";i:757700;}}i:233;a:13:{s:2:\"id\";s:3:\"366\";s:6:\"handle\";s:19:\"Night-cityscape.jpg\";s:4:\"name\";s:15:\"Night cityscape\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18133;s:4:\"orig\";i:633849;}}i:234;a:13:{s:2:\"id\";s:3:\"365\";s:6:\"handle\";s:25:\"Empire-State-Building.jpg\";s:4:\"name\";s:21:\"Empire State Building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24430;s:4:\"orig\";i:954378;}}i:235;a:13:{s:2:\"id\";s:3:\"364\";s:6:\"handle\";s:9:\"Paris.jpg\";s:4:\"name\";s:5:\"Paris\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16738;s:4:\"orig\";i:664032;}}i:236;a:13:{s:2:\"id\";s:3:\"363\";s:6:\"handle\";s:31:\"Building-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Building during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1288\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17594;s:4:\"orig\";i:503413;}}i:237;a:13:{s:2:\"id\";s:3:\"362\";s:6:\"handle\";s:21:\"Afternoon-skyline.jpg\";s:4:\"name\";s:17:\"Afternoon skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15558;s:4:\"orig\";i:508616;}}i:238;a:13:{s:2:\"id\";s:3:\"361\";s:6:\"handle\";s:22:\"Concrete-buildings.jpg\";s:4:\"name\";s:18:\"Concrete buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14665;s:4:\"orig\";i:429256;}}i:239;a:13:{s:2:\"id\";s:3:\"360\";s:6:\"handle\";s:26:\"Architectural-building.jpg\";s:4:\"name\";s:22:\"Architectural building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1382\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20433;s:4:\"orig\";i:1162968;}}i:240;a:13:{s:2:\"id\";s:3:\"359\";s:6:\"handle\";s:23:\"Skyline-photography.jpg\";s:4:\"name\";s:19:\"Skyline photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10872;s:4:\"orig\";i:289488;}}i:241;a:13:{s:2:\"id\";s:3:\"358\";s:6:\"handle\";s:38:\"People-standing-on-pedestrian-lane.jpg\";s:4:\"name\";s:34:\"People standing on pedestrian lane\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1154\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17988;s:4:\"orig\";i:602577;}}i:242;a:13:{s:2:\"id\";s:3:\"357\";s:6:\"handle\";s:16:\"Burj-Khalifa.jpg\";s:4:\"name\";s:12:\"Burj Khalifa\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9794;s:4:\"orig\";i:352053;}}i:243;a:13:{s:2:\"id\";s:3:\"356\";s:6:\"handle\";s:13:\"Skycraper.jpg\";s:4:\"name\";s:9:\"Skycraper\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11735;s:4:\"orig\";i:370551;}}i:244;a:13:{s:2:\"id\";s:3:\"355\";s:6:\"handle\";s:14:\"Gray-tower.jpg\";s:4:\"name\";s:10:\"Gray tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1433\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10397;s:4:\"orig\";i:280660;}}i:245;a:13:{s:2:\"id\";s:3:\"354\";s:6:\"handle\";s:28:\"One-fine-day-in-Maldives.jpg\";s:4:\"name\";s:24:\"One fine day in Maldives\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1116\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26832;s:4:\"orig\";i:677097;}}i:246;a:13:{s:2:\"id\";s:3:\"353\";s:6:\"handle\";s:25:\"Boat-on-body-of-water.jpg\";s:4:\"name\";s:21:\"Boat on body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13591;s:4:\"orig\";i:846550;}}i:247;a:13:{s:2:\"id\";s:3:\"352\";s:6:\"handle\";s:33:\"Aerial-photo-of-body-of-water.jpg\";s:4:\"name\";s:29:\"Aerial photo of body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1078\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12138;s:4:\"orig\";i:511326;}}i:248;a:13:{s:2:\"id\";s:3:\"351\";s:6:\"handle\";s:31:\"Assorted-color-beach-houses.jpg\";s:4:\"name\";s:27:\"Assorted color beach houses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1135\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14005;s:4:\"orig\";i:392648;}}i:249;a:13:{s:2:\"id\";s:3:\"350\";s:6:\"handle\";s:36:\"Woman-leaning-on-tree-near-beach.jpg\";s:4:\"name\";s:32:\"Woman leaning on tree near beach\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1559\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11612;s:4:\"orig\";i:688650;}}i:250;a:13:{s:2:\"id\";s:3:\"349\";s:6:\"handle\";s:17:\"Body-of-water.jpg\";s:4:\"name\";s:13:\"Body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1269\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:28096;s:4:\"orig\";i:766943;}}i:251;a:13:{s:2:\"id\";s:3:\"348\";s:6:\"handle\";s:17:\"People-on-sea.jpg\";s:4:\"name\";s:13:\"People on sea\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17419;s:4:\"orig\";i:759716;}}i:252;a:13:{s:2:\"id\";s:3:\"347\";s:6:\"handle\";s:31:\"Man-sitting-beside-of-woman.jpg\";s:4:\"name\";s:27:\"Man sitting beside of woman\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10910;s:4:\"orig\";i:191059;}}i:253;a:13:{s:2:\"id\";s:3:\"346\";s:6:\"handle\";s:22:\"woman-in-the-water.jpg\";s:4:\"name\";s:18:\"woman in the water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24825;s:4:\"orig\";i:706226;}}i:254;a:13:{s:2:\"id\";s:3:\"345\";s:6:\"handle\";s:39:\"Brown-stone-near-sea-at-golden-hour.jpg\";s:4:\"name\";s:35:\"Brown stone near sea at golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11091;s:4:\"orig\";i:300143;}}i:255;a:13:{s:2:\"id\";s:3:\"344\";s:6:\"handle\";s:18:\"Birds-eye-view.jpg\";s:4:\"name\";s:14:\"Birds eye view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15004;s:4:\"orig\";i:475888;}}i:256;a:13:{s:2:\"id\";s:3:\"343\";s:6:\"handle\";s:18:\"Empty-seashore.jpg\";s:4:\"name\";s:14:\"Empty seashore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1365\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13155;s:4:\"orig\";i:683645;}}i:257;a:13:{s:2:\"id\";s:3:\"342\";s:6:\"handle\";s:31:\"Seashore-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Seashore during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15305;s:4:\"orig\";i:655207;}}i:258;a:13:{s:2:\"id\";s:3:\"341\";s:6:\"handle\";s:16:\"Coconut-tree.jpg\";s:4:\"name\";s:12:\"Coconut tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17740;s:4:\"orig\";i:745183;}}i:259;a:13:{s:2:\"id\";s:3:\"340\";s:6:\"handle\";s:37:\"Aerial-photography-of-beach-shore.jpg\";s:4:\"name\";s:33:\"Aerial photography of beach shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17442;s:4:\"orig\";i:641873;}}i:260;a:13:{s:2:\"id\";s:3:\"197\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16088;s:4:\"orig\";i:241567;}}i:261;a:13:{s:2:\"id\";s:3:\"196\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8512;s:4:\"orig\";i:267430;}}i:262;a:13:{s:2:\"id\";s:3:\"195\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25804;s:4:\"orig\";i:908234;}}i:263;a:13:{s:2:\"id\";s:3:\"194\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4691;s:4:\"orig\";i:108160;}}i:264;a:13:{s:2:\"id\";s:3:\"193\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12753;s:4:\"orig\";i:218714;}}i:265;a:13:{s:2:\"id\";s:3:\"192\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19312;s:4:\"orig\";i:438345;}}i:266;a:13:{s:2:\"id\";s:3:\"191\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16224;s:4:\"orig\";i:409547;}}i:267;a:13:{s:2:\"id\";s:3:\"190\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22344;s:4:\"orig\";i:432904;}}i:268;a:13:{s:2:\"id\";s:3:\"189\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9431;s:4:\"orig\";i:220442;}}i:269;a:13:{s:2:\"id\";s:3:\"186\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:29538;s:4:\"orig\";i:733632;}}i:270;a:13:{s:2:\"id\";s:3:\"185\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12859;s:4:\"orig\";i:430959;}}i:271;a:13:{s:2:\"id\";s:3:\"184\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13413;s:4:\"orig\";i:324558;}}i:272;a:13:{s:2:\"id\";s:3:\"183\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11553;s:4:\"orig\";i:146076;}}i:273;a:13:{s:2:\"id\";s:3:\"182\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21184;s:4:\"orig\";i:537577;}}i:274;a:13:{s:2:\"id\";s:3:\"181\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14134;s:4:\"orig\";i:245565;}}i:275;a:13:{s:2:\"id\";s:3:\"180\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16035;s:4:\"orig\";i:401592;}}i:276;a:13:{s:2:\"id\";s:3:\"179\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12906;s:4:\"orig\";i:483885;}}i:277;a:13:{s:2:\"id\";s:3:\"177\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7834;s:4:\"orig\";i:80956;}}i:278;a:13:{s:2:\"id\";s:3:\"175\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11452;s:4:\"orig\";i:175118;}}i:279;a:13:{s:2:\"id\";s:3:\"174\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12170;s:4:\"orig\";i:236860;}}i:280;a:13:{s:2:\"id\";s:3:\"173\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10268;s:4:\"orig\";i:117315;}}i:281;a:13:{s:2:\"id\";s:3:\"116\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12485;s:4:\"orig\";i:374567;}}i:282;a:13:{s:2:\"id\";s:3:\"115\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8401;s:4:\"orig\";i:203253;}}i:283;a:13:{s:2:\"id\";s:3:\"114\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12578;s:4:\"orig\";i:287796;}}i:284;a:13:{s:2:\"id\";s:3:\"113\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8484;s:4:\"orig\";i:199508;}}i:285;a:13:{s:2:\"id\";s:3:\"112\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16659;s:4:\"orig\";i:524922;}}i:286;a:13:{s:2:\"id\";s:3:\"111\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9240;s:4:\"orig\";i:109310;}}i:287;a:13:{s:2:\"id\";s:3:\"110\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8288;s:4:\"orig\";i:216553;}}i:288;a:13:{s:2:\"id\";s:3:\"109\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6855;s:4:\"orig\";i:234043;}}i:289;a:13:{s:2:\"id\";s:3:\"108\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12347;s:4:\"orig\";i:238706;}}i:290;a:13:{s:2:\"id\";s:3:\"107\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7748;s:4:\"orig\";i:169462;}}i:291;a:13:{s:2:\"id\";s:3:\"106\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10402;s:4:\"orig\";i:358403;}}i:292;a:13:{s:2:\"id\";s:3:\"105\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12887;s:4:\"orig\";i:261525;}}i:293;a:13:{s:2:\"id\";s:3:\"104\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:2963;s:4:\"orig\";i:30890;}}i:294;a:13:{s:2:\"id\";s:3:\"103\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10266;s:4:\"orig\";i:183341;}}i:295;a:13:{s:2:\"id\";s:3:\"102\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8156;s:4:\"orig\";i:102119;}}i:296;a:13:{s:2:\"id\";s:3:\"101\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10271;s:4:\"orig\";i:138495;}}i:297;a:13:{s:2:\"id\";s:3:\"100\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11654;s:4:\"orig\";i:171098;}}i:298;a:13:{s:2:\"id\";s:2:\"99\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10569;s:4:\"orig\";i:437331;}}i:299;a:13:{s:2:\"id\";s:2:\"98\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15739;s:4:\"orig\";i:446809;}}i:300;a:13:{s:2:\"id\";s:2:\"97\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9456;s:4:\"orig\";i:206722;}}i:301;a:13:{s:2:\"id\";s:2:\"96\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13833;s:4:\"orig\";i:341185;}}i:302;a:13:{s:2:\"id\";s:2:\"95\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10647;s:4:\"orig\";i:193025;}}i:303;a:13:{s:2:\"id\";s:2:\"94\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6239;s:4:\"orig\";i:48178;}}i:304;a:13:{s:2:\"id\";s:2:\"93\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14454;s:4:\"orig\";i:454843;}}i:305;a:13:{s:2:\"id\";s:2:\"92\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7734;s:4:\"orig\";i:119909;}}i:306;a:13:{s:2:\"id\";s:2:\"91\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11927;s:4:\"orig\";i:209224;}}i:307;a:13:{s:2:\"id\";s:2:\"90\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9609;s:4:\"orig\";i:230249;}}i:308;a:13:{s:2:\"id\";s:2:\"89\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12396;s:4:\"orig\";i:290596;}}i:309;a:14:{s:2:\"id\";s:3:\"529\";s:6:\"handle\";s:13:\"Fitness-4.jpg\";s:5:\"video\";s:13:\"Fitness-4.mp4\";s:4:\"name\";s:10:\"Fitness 4 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:25803;s:11:\"video_thumb\";i:2753823;s:5:\"cover\";i:127867;s:4:\"orig\";i:5991847;}}i:310;a:14:{s:2:\"id\";s:3:\"528\";s:6:\"handle\";s:13:\"Fitness-3.jpg\";s:5:\"video\";s:13:\"Fitness-3.mp4\";s:4:\"name\";s:10:\"Fitness 3 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19154;s:11:\"video_thumb\";i:4783500;s:5:\"cover\";i:97843;s:4:\"orig\";i:12408832;}}i:311;a:14:{s:2:\"id\";s:3:\"527\";s:6:\"handle\";s:9:\"Chess.jpg\";s:5:\"video\";s:9:\"Chess.mp4\";s:4:\"name\";s:6:\"Chess \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:28284;s:11:\"video_thumb\";i:2150510;s:5:\"cover\";i:124176;s:4:\"orig\";i:7726114;}}i:312;a:14:{s:2:\"id\";s:3:\"526\";s:6:\"handle\";s:13:\"Fitness-2.jpg\";s:5:\"video\";s:13:\"Fitness-2.mp4\";s:4:\"name\";s:10:\"Fitness 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:23354;s:11:\"video_thumb\";i:3635377;s:5:\"cover\";i:106283;s:4:\"orig\";i:12688465;}}i:313;a:14:{s:2:\"id\";s:3:\"525\";s:6:\"handle\";s:11:\"Fitness.jpg\";s:5:\"video\";s:11:\"Fitness.mp4\";s:4:\"name\";s:8:\"Fitness \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:29858;s:11:\"video_thumb\";i:9614915;s:5:\"cover\";i:153660;s:4:\"orig\";i:13424151;}}i:314;a:14:{s:2:\"id\";s:3:\"524\";s:6:\"handle\";s:9:\"Earth.jpg\";s:5:\"video\";s:9:\"Earth.mp4\";s:4:\"name\";s:6:\"Earth \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19155;s:11:\"video_thumb\";i:2361089;s:5:\"cover\";i:103588;s:4:\"orig\";i:14717688;}}i:315;a:14:{s:2:\"id\";s:3:\"523\";s:6:\"handle\";s:11:\"Space-2.jpg\";s:5:\"video\";s:11:\"Space-2.mp4\";s:4:\"name\";s:8:\"Space 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1440\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:11719;s:11:\"video_thumb\";i:4841259;s:5:\"cover\";i:40309;s:4:\"orig\";i:11715637;}}i:316;a:14:{s:2:\"id\";s:3:\"522\";s:6:\"handle\";s:13:\"Asteroids.jpg\";s:5:\"video\";s:13:\"Asteroids.mp4\";s:4:\"name\";s:10:\"Asteroids \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:56469;s:11:\"video_thumb\";i:5107558;s:5:\"cover\";i:273635;s:4:\"orig\";i:13833056;}}i:317;a:14:{s:2:\"id\";s:3:\"521\";s:6:\"handle\";s:9:\"Space.jpg\";s:5:\"video\";s:9:\"Space.mp4\";s:4:\"name\";s:6:\"Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:30439;s:11:\"video_thumb\";i:3864288;s:5:\"cover\";i:133345;s:4:\"orig\";i:13159814;}}i:318;a:14:{s:2:\"id\";s:3:\"520\";s:6:\"handle\";s:10:\"People.jpg\";s:5:\"video\";s:10:\"People.mp4\";s:4:\"name\";s:7:\"People \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31267;s:11:\"video_thumb\";i:2732735;s:5:\"cover\";i:173636;s:4:\"orig\";i:5536475;}}i:319;a:14:{s:2:\"id\";s:3:\"519\";s:6:\"handle\";s:11:\"Walking.jpg\";s:5:\"video\";s:11:\"Walking.mp4\";s:4:\"name\";s:8:\"Walking \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:29090;s:11:\"video_thumb\";i:4861363;s:5:\"cover\";i:188894;s:4:\"orig\";i:13731609;}}i:320;a:14:{s:2:\"id\";s:3:\"518\";s:6:\"handle\";s:19:\"Double-Exposure.jpg\";s:5:\"video\";s:19:\"Double-Exposure.mp4\";s:4:\"name\";s:16:\"Double Exposure \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31123;s:11:\"video_thumb\";i:1386258;s:5:\"cover\";i:219740;s:4:\"orig\";i:6479275;}}i:321;a:14:{s:2:\"id\";s:3:\"517\";s:6:\"handle\";s:8:\"Girl.jpg\";s:5:\"video\";s:8:\"Girl.mp4\";s:4:\"name\";s:5:\"Girl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1088\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:21091;s:11:\"video_thumb\";i:11134706;s:5:\"cover\";i:115059;s:4:\"orig\";i:12313637;}}i:322;a:14:{s:2:\"id\";s:3:\"516\";s:6:\"handle\";s:17:\"Bengal-Lights.jpg\";s:5:\"video\";s:17:\"Bengal-Lights.mp4\";s:4:\"name\";s:14:\"Bengal Lights \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19624;s:11:\"video_thumb\";i:3913179;s:5:\"cover\";i:118864;s:4:\"orig\";i:14700830;}}i:323;a:14:{s:2:\"id\";s:3:\"515\";s:6:\"handle\";s:13:\"Swiping-2.jpg\";s:5:\"video\";s:13:\"Swiping-2.mp4\";s:4:\"name\";s:10:\"Swiping 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:45123;s:11:\"video_thumb\";i:2547876;s:5:\"cover\";i:268587;s:4:\"orig\";i:8823724;}}i:324;a:14:{s:2:\"id\";s:3:\"514\";s:6:\"handle\";s:11:\"Mock-Up.jpg\";s:5:\"video\";s:11:\"Mock-Up.mp4\";s:4:\"name\";s:8:\"Mock Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:33867;s:11:\"video_thumb\";i:5972511;s:5:\"cover\";i:172632;s:4:\"orig\";i:13869858;}}i:325;a:14:{s:2:\"id\";s:3:\"513\";s:6:\"handle\";s:13:\"Countdown.jpg\";s:5:\"video\";s:13:\"Countdown.mp4\";s:4:\"name\";s:10:\"Countdown \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:16185;s:11:\"video_thumb\";i:4097952;s:5:\"cover\";i:160912;s:4:\"orig\";i:12307362;}}i:326;a:14:{s:2:\"id\";s:3:\"512\";s:6:\"handle\";s:18:\"Wall-Sketching.jpg\";s:5:\"video\";s:18:\"Wall-Sketching.mp4\";s:4:\"name\";s:15:\"Wall Sketching \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:9324;s:11:\"video_thumb\";i:1843046;s:5:\"cover\";i:94919;s:4:\"orig\";i:4938526;}}i:327;a:14:{s:2:\"id\";s:3:\"511\";s:6:\"handle\";s:26:\"Typing-on-the-keyboard.jpg\";s:5:\"video\";s:26:\"Typing-on-the-keyboard.mp4\";s:4:\"name\";s:23:\"Typing on the keyboard \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:13455;s:11:\"video_thumb\";i:5101194;s:5:\"cover\";i:66493;s:4:\"orig\";i:11852447;}}i:328;a:14:{s:2:\"id\";s:3:\"510\";s:6:\"handle\";s:11:\"Meeting.jpg\";s:5:\"video\";s:11:\"Meeting.mp4\";s:4:\"name\";s:8:\"Meeting \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:20003;s:11:\"video_thumb\";i:1696754;s:5:\"cover\";i:103202;s:4:\"orig\";i:12515577;}}i:329;a:14:{s:2:\"id\";s:3:\"509\";s:6:\"handle\";s:11:\"Swiping.jpg\";s:5:\"video\";s:11:\"Swiping.mp4\";s:4:\"name\";s:8:\"Swiping \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19377;s:11:\"video_thumb\";i:3861934;s:5:\"cover\";i:101592;s:4:\"orig\";i:13370749;}}i:330;a:14:{s:2:\"id\";s:3:\"508\";s:6:\"handle\";s:9:\"Alarm.jpg\";s:5:\"video\";s:9:\"Alarm.mp4\";s:4:\"name\";s:6:\"Alarm \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1013\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31120;s:11:\"video_thumb\";i:2732488;s:5:\"cover\";i:190596;s:4:\"orig\";i:13625169;}}i:331;a:14:{s:2:\"id\";s:3:\"507\";s:6:\"handle\";s:13:\"Hey-World.jpg\";s:5:\"video\";s:13:\"Hey-World.mp4\";s:4:\"name\";s:10:\"Hey World \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:17475;s:11:\"video_thumb\";i:1248121;s:5:\"cover\";i:203284;s:4:\"orig\";i:4921567;}}i:332;a:14:{s:2:\"id\";s:3:\"506\";s:6:\"handle\";s:28:\"Typing-on-the-keyboard-2.jpg\";s:5:\"video\";s:28:\"Typing-on-the-keyboard-2.mp4\";s:4:\"name\";s:25:\"Typing on the keyboard 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:26132;s:11:\"video_thumb\";i:5777142;s:5:\"cover\";i:138198;s:4:\"orig\";i:12817212;}}i:333;a:14:{s:2:\"id\";s:3:\"505\";s:6:\"handle\";s:10:\"Valley.jpg\";s:5:\"video\";s:10:\"Valley.mp4\";s:4:\"name\";s:7:\"Valley \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:40668;s:11:\"video_thumb\";i:3711074;s:5:\"cover\";i:243587;s:4:\"orig\";i:12354374;}}i:334;a:14:{s:2:\"id\";s:3:\"504\";s:6:\"handle\";s:9:\"Stars.jpg\";s:5:\"video\";s:9:\"Stars.mp4\";s:4:\"name\";s:6:\"Stars \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:41275;s:11:\"video_thumb\";i:2631988;s:5:\"cover\";i:330226;s:4:\"orig\";i:8304831;}}i:335;a:14:{s:2:\"id\";s:3:\"503\";s:6:\"handle\";s:21:\"Car-in-the-forest.jpg\";s:5:\"video\";s:21:\"Car-in-the-forest.mp4\";s:4:\"name\";s:18:\"Car in the forest \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1012\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:54209;s:11:\"video_thumb\";i:4596191;s:5:\"cover\";i:335804;s:4:\"orig\";i:13306988;}}i:336;a:14:{s:2:\"id\";s:3:\"502\";s:6:\"handle\";s:15:\"Aerial-Shot.jpg\";s:5:\"video\";s:15:\"Aerial-Shot.mp4\";s:4:\"name\";s:12:\"Aerial Shot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:75484;s:11:\"video_thumb\";i:3134686;s:5:\"cover\";i:461854;s:4:\"orig\";i:20337064;}}i:337;a:14:{s:2:\"id\";s:3:\"501\";s:6:\"handle\";s:14:\"Disco-Ball.jpg\";s:5:\"video\";s:14:\"Disco-Ball.mp4\";s:4:\"name\";s:11:\"Disco Ball \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:25915;s:11:\"video_thumb\";i:2352326;s:5:\"cover\";i:136931;s:4:\"orig\";i:12104254;}}i:338;a:14:{s:2:\"id\";s:3:\"500\";s:6:\"handle\";s:22:\"Man-Playing-Guitar.jpg\";s:5:\"video\";s:22:\"Man-Playing-Guitar.mp4\";s:4:\"name\";s:19:\"Man Playing Guitar \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:40965;s:11:\"video_thumb\";i:8637814;s:5:\"cover\";i:195812;s:4:\"orig\";i:13878956;}}i:339;a:14:{s:2:\"id\";s:3:\"499\";s:6:\"handle\";s:14:\"Live-Music.jpg\";s:5:\"video\";s:14:\"Live-Music.mp4\";s:4:\"name\";s:11:\"Live Music \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19037;s:11:\"video_thumb\";i:3065043;s:5:\"cover\";i:65493;s:4:\"orig\";i:12935967;}}i:340;a:14:{s:2:\"id\";s:3:\"498\";s:6:\"handle\";s:12:\"Cheer-Up.jpg\";s:5:\"video\";s:12:\"Cheer-Up.mp4\";s:4:\"name\";s:9:\"Cheer Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:24344;s:11:\"video_thumb\";i:1911296;s:5:\"cover\";i:192540;s:4:\"orig\";i:4631422;}}i:341;a:14:{s:2:\"id\";s:3:\"497\";s:6:\"handle\";s:14:\"Night-club.jpg\";s:5:\"video\";s:14:\"Night-club.mp4\";s:4:\"name\";s:11:\"Night club \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:23517;s:11:\"video_thumb\";i:4899641;s:5:\"cover\";i:86737;s:4:\"orig\";i:12281833;}}i:342;a:14:{s:2:\"id\";s:3:\"496\";s:6:\"handle\";s:17:\"Cup-Of-Coffee.jpg\";s:5:\"video\";s:17:\"Cup-Of-Coffee.mp4\";s:4:\"name\";s:14:\"Cup Of Coffee \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31844;s:11:\"video_thumb\";i:4412295;s:5:\"cover\";i:154844;s:4:\"orig\";i:10753079;}}i:343;a:14:{s:2:\"id\";s:3:\"495\";s:6:\"handle\";s:7:\"Pot.jpg\";s:5:\"video\";s:7:\"Pot.mp4\";s:4:\"name\";s:4:\"Pot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:14905;s:11:\"video_thumb\";i:3394055;s:5:\"cover\";i:73276;s:4:\"orig\";i:11722124;}}i:344;a:14:{s:2:\"id\";s:3:\"494\";s:6:\"handle\";s:11:\"Grill-2.jpg\";s:5:\"video\";s:11:\"Grill-2.mp4\";s:4:\"name\";s:8:\"Grill 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:48591;s:11:\"video_thumb\";i:5268295;s:5:\"cover\";i:211021;s:4:\"orig\";i:11990742;}}i:345;a:14:{s:2:\"id\";s:3:\"493\";s:6:\"handle\";s:13:\"Rice-Bowl.jpg\";s:5:\"video\";s:13:\"Rice-Bowl.mp4\";s:4:\"name\";s:10:\"Rice Bowl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1010\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:27863;s:11:\"video_thumb\";i:2674570;s:5:\"cover\";i:119321;s:4:\"orig\";i:11602755;}}i:346;a:14:{s:2:\"id\";s:3:\"492\";s:6:\"handle\";s:9:\"Grill.jpg\";s:5:\"video\";s:9:\"Grill.mp4\";s:4:\"name\";s:6:\"Grill \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:27505;s:11:\"video_thumb\";i:3025283;s:5:\"cover\";i:144357;s:4:\"orig\";i:13176990;}}i:347;a:14:{s:2:\"id\";s:3:\"491\";s:6:\"handle\";s:9:\"Water.jpg\";s:5:\"video\";s:9:\"Water.mp4\";s:4:\"name\";s:6:\"Water \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:22543;s:11:\"video_thumb\";i:1327376;s:5:\"cover\";i:111224;s:4:\"orig\";i:4727340;}}i:348;a:14:{s:2:\"id\";s:3:\"490\";s:6:\"handle\";s:17:\"Feet-and-Sand.jpg\";s:5:\"video\";s:17:\"Feet-and-Sand.mp4\";s:4:\"name\";s:14:\"Feet and Sand \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:34936;s:11:\"video_thumb\";i:3198076;s:5:\"cover\";i:160493;s:4:\"orig\";i:12804022;}}i:349;a:14:{s:2:\"id\";s:3:\"489\";s:6:\"handle\";s:9:\"Ocean.jpg\";s:5:\"video\";s:9:\"Ocean.mp4\";s:4:\"name\";s:6:\"Ocean \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:28883;s:11:\"video_thumb\";i:4750283;s:5:\"cover\";i:153687;s:4:\"orig\";i:13054569;}}i:350;a:14:{s:2:\"id\";s:3:\"488\";s:6:\"handle\";s:9:\"Waves.jpg\";s:5:\"video\";s:9:\"Waves.mp4\";s:4:\"name\";s:6:\"Waves \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:53693;s:11:\"video_thumb\";i:9780815;s:5:\"cover\";i:341419;s:4:\"orig\";i:13738077;}}i:351;a:14:{s:2:\"id\";s:3:\"487\";s:6:\"handle\";s:10:\"Hearts.jpg\";s:5:\"video\";s:10:\"Hearts.mp4\";s:4:\"name\";s:7:\"Hearts \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:9494;s:11:\"video_thumb\";i:942533;s:5:\"cover\";i:52833;s:4:\"orig\";i:6629299;}}i:352;a:14:{s:2:\"id\";s:3:\"486\";s:6:\"handle\";s:12:\"Octagons.jpg\";s:5:\"video\";s:12:\"Octagons.mp4\";s:4:\"name\";s:9:\"Octagons \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:22781;s:11:\"video_thumb\";i:2415073;s:5:\"cover\";i:126450;s:4:\"orig\";i:11684367;}}i:353;a:14:{s:2:\"id\";s:3:\"485\";s:6:\"handle\";s:11:\"Squares.jpg\";s:5:\"video\";s:11:\"Squares.mp4\";s:4:\"name\";s:8:\"Squares \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:22296;s:11:\"video_thumb\";i:1465206;s:5:\"cover\";i:73047;s:4:\"orig\";i:4008355;}}i:354;a:14:{s:2:\"id\";s:3:\"484\";s:6:\"handle\";s:12:\"Pink-ink.jpg\";s:5:\"video\";s:12:\"Pink-ink.mp4\";s:4:\"name\";s:9:\"Pink ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19851;s:11:\"video_thumb\";i:3023599;s:5:\"cover\";i:25426;s:4:\"orig\";i:12847145;}}i:355;a:14:{s:2:\"id\";s:3:\"483\";s:6:\"handle\";s:22:\"Blurred-Background.jpg\";s:5:\"video\";s:22:\"Blurred-Background.mp4\";s:4:\"name\";s:19:\"Blurred Background \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:18002;s:11:\"video_thumb\";i:1791449;s:5:\"cover\";i:101725;s:4:\"orig\";i:13746552;}}i:356;a:14:{s:2:\"id\";s:3:\"482\";s:6:\"handle\";s:20:\"Blinking-bubbles.jpg\";s:5:\"video\";s:20:\"Blinking-bubbles.mp4\";s:4:\"name\";s:17:\"Blinking bubbles \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:8176;s:11:\"video_thumb\";i:4255586;s:5:\"cover\";i:75455;s:4:\"orig\";i:10948491;}}i:357;a:14:{s:2:\"id\";s:3:\"481\";s:6:\"handle\";s:13:\"Fireworks.jpg\";s:5:\"video\";s:13:\"Fireworks.mp4\";s:4:\"name\";s:10:\"Fireworks \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:46567;s:11:\"video_thumb\";i:3789289;s:5:\"cover\";i:25425;s:4:\"orig\";i:15943336;}}i:358;a:14:{s:2:\"id\";s:3:\"480\";s:6:\"handle\";s:12:\"Dark-ink.jpg\";s:5:\"video\";s:12:\"Dark-ink.mp4\";s:4:\"name\";s:9:\"Dark ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:26927;s:11:\"video_thumb\";i:2605391;s:5:\"cover\";i:149830;s:4:\"orig\";i:13232415;}}i:359;a:14:{s:2:\"id\";s:3:\"238\";s:6:\"handle\";s:12:\"Mt_Baker.jpg\";s:5:\"video\";s:12:\"Mt_Baker.mp4\";s:4:\"name\";s:9:\"Mt Baker \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:20000;s:11:\"video_thumb\";i:655504;s:5:\"cover\";i:620066;s:4:\"orig\";i:13229794;}}i:360;a:14:{s:2:\"id\";s:3:\"237\";s:6:\"handle\";s:16:\"Two-Swimmers.jpg\";s:5:\"video\";s:16:\"Two-Swimmers.mp4\";s:4:\"name\";s:13:\"Two Swimmers \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:23213;s:11:\"video_thumb\";i:498407;s:5:\"cover\";i:308442;s:4:\"orig\";i:11108924;}}i:361;a:14:{s:2:\"id\";s:3:\"236\";s:6:\"handle\";s:14:\"Boats_Maze.jpg\";s:5:\"video\";s:14:\"Boats_Maze.mp4\";s:4:\"name\";s:11:\"Boats Maze \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:21648;s:11:\"video_thumb\";i:109062;s:5:\"cover\";i:305957;s:4:\"orig\";i:6267674;}}i:362;a:14:{s:2:\"id\";s:3:\"235\";s:6:\"handle\";s:18:\"Candolim-Beach.jpg\";s:5:\"video\";s:18:\"Candolim-Beach.mp4\";s:4:\"name\";s:15:\"Candolim Beach \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19198;s:11:\"video_thumb\";i:326656;s:5:\"cover\";i:554701;s:4:\"orig\";i:10151652;}}i:363;a:14:{s:2:\"id\";s:3:\"234\";s:6:\"handle\";s:17:\"Working-Space.jpg\";s:5:\"video\";s:17:\"Working-Space.mp4\";s:4:\"name\";s:14:\"Working Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:14725;s:11:\"video_thumb\";i:72977;s:5:\"cover\";i:72535;s:4:\"orig\";i:4938006;}}i:364;a:14:{s:2:\"id\";s:3:\"233\";s:6:\"handle\";s:9:\"Wavez.jpg\";s:5:\"video\";s:9:\"Wavez.mp4\";s:4:\"name\";s:6:\"Wavez \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:12165;s:11:\"video_thumb\";i:256975;s:5:\"cover\";i:340550;s:4:\"orig\";i:9691449;}}i:365;a:14:{s:2:\"id\";s:3:\"232\";s:6:\"handle\";s:17:\"Coconut-Grove.jpg\";s:5:\"video\";s:17:\"Coconut-Grove.mp4\";s:4:\"name\";s:14:\"Coconut Grove \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:36900;s:11:\"video_thumb\";i:920631;s:5:\"cover\";i:949012;s:4:\"orig\";i:13422013;}}i:366;a:14:{s:2:\"id\";s:3:\"231\";s:6:\"handle\";s:19:\"Very-Open-Space.jpg\";s:5:\"video\";s:19:\"Very-Open-Space.mp4\";s:4:\"name\";s:16:\"Very Open Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:17289;s:11:\"video_thumb\";i:137402;s:5:\"cover\";i:300574;s:4:\"orig\";i:7528458;}}i:367;a:14:{s:2:\"id\";s:3:\"230\";s:6:\"handle\";s:14:\"Office-Day.jpg\";s:5:\"video\";s:14:\"Office-Day.mp4\";s:4:\"name\";s:11:\"Office Day \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:16562;s:11:\"video_thumb\";i:161004;s:5:\"cover\";i:291708;s:4:\"orig\";i:7596827;}}i:368;a:14:{s:2:\"id\";s:3:\"229\";s:6:\"handle\";s:12:\"The-Hill.jpg\";s:5:\"video\";s:12:\"The-Hill.mp4\";s:4:\"name\";s:9:\"The Hill \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19186;s:11:\"video_thumb\";i:404406;s:5:\"cover\";i:496556;s:4:\"orig\";i:15358645;}}i:369;a:14:{s:2:\"id\";s:3:\"339\";s:6:\"handle\";s:19:\"best_price_dark.jpg\";s:5:\"video\";s:19:\"best_price_dark.mp4\";s:4:\"name\";s:15:\"best_price_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"best_price_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11778;s:5:\"video\";i:126230;}}i:370;a:14:{s:2:\"id\";s:3:\"337\";s:6:\"handle\";s:27:\"limited_time_offer_dark.jpg\";s:5:\"video\";s:27:\"limited_time_offer_dark.mp4\";s:4:\"name\";s:23:\"limited_time_offer_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:23:\"limited_time_offer_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9342;s:5:\"video\";i:258890;}}i:371;a:14:{s:2:\"id\";s:3:\"336\";s:6:\"handle\";s:26:\"slider_revolution_dark.jpg\";s:5:\"video\";s:26:\"slider_revolution_dark.mp4\";s:4:\"name\";s:22:\"slider_revolution_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:22:\"slider_revolution_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22925;s:5:\"video\";i:337622;}}i:372;a:14:{s:2:\"id\";s:3:\"335\";s:6:\"handle\";s:19:\"mick_brown_dark.jpg\";s:5:\"video\";s:19:\"mick_brown_dark.mp4\";s:4:\"name\";s:15:\"mick_brown_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"mick_brown_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13590;s:5:\"video\";i:143116;}}i:373;a:14:{s:2:\"id\";s:3:\"334\";s:6:\"handle\";s:14:\"sales_dark.jpg\";s:5:\"video\";s:14:\"sales_dark.mp4\";s:4:\"name\";s:10:\"sales_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:10:\"sales_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12603;s:5:\"video\";i:267056;}}i:374;a:14:{s:2:\"id\";s:3:\"333\";s:6:\"handle\";s:21:\"robert_smith_dark.jpg\";s:5:\"video\";s:21:\"robert_smith_dark.mp4\";s:4:\"name\";s:17:\"robert_smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"robert_smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11225;s:5:\"video\";i:104722;}}i:375;a:14:{s:2:\"id\";s:3:\"332\";s:6:\"handle\";s:21:\"product_name_dark.jpg\";s:5:\"video\";s:21:\"product_name_dark.mp4\";s:4:\"name\";s:17:\"product_name_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"product_name_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16221;s:5:\"video\";i:183244;}}i:376;a:14:{s:2:\"id\";s:3:\"331\";s:6:\"handle\";s:21:\"high_quality_dark.jpg\";s:5:\"video\";s:21:\"high_quality_dark.mp4\";s:4:\"name\";s:17:\"high_quality_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"high_quality_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15072;s:5:\"video\";i:90577;}}i:377;a:14:{s:2:\"id\";s:3:\"330\";s:6:\"handle\";s:24:\"robert_johnson_light.jpg\";s:5:\"video\";s:24:\"robert_johnson_light.mp4\";s:4:\"name\";s:20:\"robert_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"robert_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11741;s:5:\"video\";i:96061;}}i:378;a:14:{s:2:\"id\";s:3:\"329\";s:6:\"handle\";s:21:\"jake_collins_dark.jpg\";s:5:\"video\";s:21:\"jake_collins_dark.mp4\";s:4:\"name\";s:17:\"jake_collins_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"jake_collins_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15979;s:5:\"video\";i:136040;}}i:379;a:14:{s:2:\"id\";s:3:\"328\";s:6:\"handle\";s:22:\"daniele_wood_light.jpg\";s:5:\"video\";s:22:\"daniele_wood_light.mp4\";s:4:\"name\";s:18:\"daniele_wood_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"daniele_wood_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:31:30\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13637;s:5:\"video\";i:98053;}}i:380;a:14:{s:2:\"id\";s:3:\"327\";s:6:\"handle\";s:23:\"michael_blake_light.jpg\";s:5:\"video\";s:23:\"michael_blake_light.mp4\";s:4:\"name\";s:19:\"michael_blake_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"michael_blake_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14892;s:5:\"video\";i:125449;}}i:381;a:14:{s:2:\"id\";s:3:\"326\";s:6:\"handle\";s:22:\"product_name_light.jpg\";s:5:\"video\";s:22:\"product_name_light.mp4\";s:4:\"name\";s:18:\"product_name_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"product_name_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16568;s:5:\"video\";i:127133;}}i:382;a:14:{s:2:\"id\";s:3:\"325\";s:6:\"handle\";s:24:\"rebecca_cooper_light.jpg\";s:5:\"video\";s:24:\"rebecca_cooper_light.mp4\";s:4:\"name\";s:20:\"rebecca_cooper_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"rebecca_cooper_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19099;s:5:\"video\";i:202784;}}i:383;a:14:{s:2:\"id\";s:3:\"324\";s:6:\"handle\";s:28:\"limited_time_offer_light.jpg\";s:5:\"video\";s:28:\"limited_time_offer_light.mp4\";s:4:\"name\";s:24:\"limited_time_offer_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:24:\"limited_time_offer_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21756;s:5:\"video\";i:295899;}}i:384;a:14:{s:2:\"id\";s:3:\"322\";s:6:\"handle\";s:22:\"jake_michael_light.jpg\";s:5:\"video\";s:22:\"jake_michael_light.mp4\";s:4:\"name\";s:18:\"jake_michael_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"jake_michael_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20783;s:5:\"video\";i:279347;}}i:385;a:14:{s:2:\"id\";s:3:\"321\";s:6:\"handle\";s:23:\"colin_johnson_light.jpg\";s:5:\"video\";s:23:\"colin_johnson_light.mp4\";s:4:\"name\";s:19:\"colin_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"colin_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17862;s:5:\"video\";i:111140;}}i:386;a:14:{s:2:\"id\";s:3:\"320\";s:6:\"handle\";s:21:\"colin_morris_dark.jpg\";s:5:\"video\";s:21:\"colin_morris_dark.mp4\";s:4:\"name\";s:17:\"colin_morris_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"colin_morris_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10799;s:5:\"video\";i:49269;}}i:387;a:14:{s:2:\"id\";s:3:\"319\";s:6:\"handle\";s:22:\"justin_cooper_dark.jpg\";s:5:\"video\";s:22:\"justin_cooper_dark.mp4\";s:4:\"name\";s:18:\"justin_cooper_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"justin_cooper_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14442;s:5:\"video\";i:143950;}}i:388;a:14:{s:2:\"id\";s:3:\"318\";s:6:\"handle\";s:21:\"james-dodson_dark.jpg\";s:5:\"video\";s:21:\"james-dodson_dark.mp4\";s:4:\"name\";s:17:\"james-dodson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"james-dodson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16819;s:5:\"video\";i:142842;}}i:389;a:14:{s:2:\"id\";s:3:\"317\";s:6:\"handle\";s:23:\"robert_sanders_dark.jpg\";s:5:\"video\";s:23:\"robert_sanders_dark.mp4\";s:4:\"name\";s:19:\"robert_sanders_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"robert_sanders_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12575;s:5:\"video\";i:106541;}}i:390;a:14:{s:2:\"id\";s:3:\"316\";s:6:\"handle\";s:21:\"emily_carney_dark.jpg\";s:5:\"video\";s:21:\"emily_carney_dark.mp4\";s:4:\"name\";s:17:\"emily_carney_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"emily_carney_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12931;s:5:\"video\";i:84922;}}i:391;a:14:{s:2:\"id\";s:3:\"315\";s:6:\"handle\";s:22:\"michael-smith_dark.jpg\";s:5:\"video\";s:22:\"michael-smith_dark.mp4\";s:4:\"name\";s:18:\"michael-smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"michael-smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18105;s:5:\"video\";i:184683;}}i:392;a:14:{s:2:\"id\";s:3:\"314\";s:6:\"handle\";s:23:\"sandra_johnson_dark.jpg\";s:5:\"video\";s:23:\"sandra_johnson_dark.mp4\";s:4:\"name\";s:19:\"sandra_johnson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"sandra_johnson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13440;s:5:\"video\";i:104866;}}i:393;a:14:{s:2:\"id\";s:3:\"313\";s:6:\"handle\";s:22:\"robert_bolton_dark.jpg\";s:5:\"video\";s:22:\"robert_bolton_dark.mp4\";s:4:\"name\";s:18:\"robert_bolton_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"robert_bolton_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17477;s:5:\"video\";i:147765;}}i:394;a:14:{s:2:\"id\";s:3:\"312\";s:6:\"handle\";s:25:\"elegant_captions_dark.png\";s:5:\"video\";s:25:\"elegant_captions_dark.mp4\";s:4:\"name\";s:21:\"elegant_captions_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:21:\"elegant_captions_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-18 14:41:45\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:36069;s:5:\"video\";i:104559;}}i:395;a:14:{s:2:\"id\";s:3:\"311\";s:6:\"handle\";s:19:\"Caption_Dark_06.png\";s:5:\"video\";s:19:\"Caption_Dark_06.mp4\";s:4:\"name\";s:15:\"Caption_Dark_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_06\";s:5:\"width\";s:3:\"414\";s:6:\"height\";s:3:\"225\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20095;s:5:\"video\";i:60429;}}i:396;a:14:{s:2:\"id\";s:3:\"310\";s:6:\"handle\";s:19:\"Header_Light_02.png\";s:5:\"video\";s:19:\"Header_Light_02.mp4\";s:4:\"name\";s:15:\"Header_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:38056;s:5:\"video\";i:45726;}}i:397;a:14:{s:2:\"id\";s:3:\"309\";s:6:\"handle\";s:21:\"Columns_4_Dark_01.png\";s:5:\"video\";s:21:\"Columns_4_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_4_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_4_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:54736;s:5:\"video\";i:26685;}}i:398;a:14:{s:2:\"id\";s:3:\"308\";s:6:\"handle\";s:18:\"Header_Dark_01.png\";s:5:\"video\";s:18:\"Header_Dark_01.mp4\";s:4:\"name\";s:14:\"Header_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:34717;s:5:\"video\";i:16283;}}i:399;a:14:{s:2:\"id\";s:3:\"307\";s:6:\"handle\";s:19:\"Caption_Dark_03.png\";s:5:\"video\";s:19:\"Caption_Dark_03.mp4\";s:4:\"name\";s:15:\"Caption_Dark_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25700;s:5:\"video\";i:38602;}}i:400;a:14:{s:2:\"id\";s:3:\"306\";s:6:\"handle\";s:21:\"Columns_3_Dark_01.png\";s:5:\"video\";s:21:\"Columns_3_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_3_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_3_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:55897;s:5:\"video\";i:21279;}}i:401;a:14:{s:2:\"id\";s:3:\"305\";s:6:\"handle\";s:19:\"Caption_Dark_05.png\";s:5:\"video\";s:19:\"Caption_Dark_05.mp4\";s:4:\"name\";s:15:\"Caption_Dark_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_05\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:39579;s:5:\"video\";i:22677;}}i:402;a:14:{s:2:\"id\";s:3:\"304\";s:6:\"handle\";s:20:\"Caption_Light_06.png\";s:5:\"video\";s:20:\"Caption_Light_06.mp4\";s:4:\"name\";s:16:\"Caption_Light_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_06\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:41903;s:5:\"video\";i:65515;}}i:403;a:14:{s:2:\"id\";s:3:\"303\";s:6:\"handle\";s:19:\"Header_Light_01.png\";s:5:\"video\";s:19:\"Header_Light_01.mp4\";s:4:\"name\";s:15:\"Header_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25902;s:5:\"video\";i:15295;}}i:404;a:14:{s:2:\"id\";s:3:\"302\";s:6:\"handle\";s:20:\"Caption_Light_03.png\";s:5:\"video\";s:20:\"Caption_Light_03.mp4\";s:4:\"name\";s:16:\"Caption_Light_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:40029;s:5:\"video\";i:28970;}}i:405;a:14:{s:2:\"id\";s:3:\"301\";s:6:\"handle\";s:19:\"Caption_Dark_01.png\";s:5:\"video\";s:19:\"Caption_Dark_01.mp4\";s:4:\"name\";s:15:\"Caption_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21834;s:5:\"video\";i:21250;}}i:406;a:14:{s:2:\"id\";s:3:\"300\";s:6:\"handle\";s:21:\"PromoCode_Dark_01.png\";s:5:\"video\";s:21:\"PromoCode_Dark_01.mp4\";s:4:\"name\";s:17:\"PromoCode_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"PromoCode_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:36633;s:5:\"video\";i:51973;}}i:407;a:14:{s:2:\"id\";s:3:\"299\";s:6:\"handle\";s:19:\"Caption_Dark_02.png\";s:5:\"video\";s:19:\"Caption_Dark_02.mp4\";s:4:\"name\";s:15:\"Caption_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22669;s:5:\"video\";i:46598;}}i:408;a:14:{s:2:\"id\";s:3:\"298\";s:6:\"handle\";s:18:\"Header_Dark_02.png\";s:5:\"video\";s:18:\"Header_Dark_02.mp4\";s:4:\"name\";s:14:\"Header_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:52537;s:5:\"video\";i:29580;}}i:409;a:14:{s:2:\"id\";s:3:\"297\";s:6:\"handle\";s:22:\"Columns_3_Light_01.png\";s:5:\"video\";s:22:\"Columns_3_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_3_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_3_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:34343;s:5:\"video\";i:18413;}}i:410;a:14:{s:2:\"id\";s:3:\"296\";s:6:\"handle\";s:20:\"Caption_Light_01.png\";s:5:\"video\";s:20:\"Caption_Light_01.mp4\";s:4:\"name\";s:16:\"Caption_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20519;s:5:\"video\";i:25391;}}i:411;a:14:{s:2:\"id\";s:3:\"295\";s:6:\"handle\";s:19:\"Caption_Dark_04.png\";s:5:\"video\";s:19:\"Caption_Dark_04.mp4\";s:4:\"name\";s:15:\"Caption_Dark_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_04\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16265;s:5:\"video\";i:75634;}}i:412;a:14:{s:2:\"id\";s:3:\"294\";s:6:\"handle\";s:20:\"Caption_Light_02.png\";s:5:\"video\";s:20:\"Caption_Light_02.mp4\";s:4:\"name\";s:16:\"Caption_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_02\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:41495;s:5:\"video\";i:49692;}}i:413;a:14:{s:2:\"id\";s:3:\"293\";s:6:\"handle\";s:20:\"Caption_Light_04.png\";s:5:\"video\";s:20:\"Caption_Light_04.mp4\";s:4:\"name\";s:16:\"Caption_Light_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_04\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:40417;s:5:\"video\";i:80078;}}i:414;a:14:{s:2:\"id\";s:3:\"292\";s:6:\"handle\";s:22:\"Columns_4_Light_01.png\";s:5:\"video\";s:22:\"Columns_4_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_4_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_4_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:34150;s:5:\"video\";i:23500;}}i:415;a:14:{s:2:\"id\";s:3:\"291\";s:6:\"handle\";s:20:\"Caption_Light_05.png\";s:5:\"video\";s:20:\"Caption_Light_05.mp4\";s:4:\"name\";s:16:\"Caption_Light_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_05\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15426;s:5:\"video\";i:21651;}}i:416;a:14:{s:2:\"id\";s:3:\"290\";s:6:\"handle\";s:22:\"PromoCode_Light_01.png\";s:5:\"video\";s:22:\"PromoCode_Light_01.mp4\";s:4:\"name\";s:18:\"PromoCode_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"PromoCode_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:33524;s:5:\"video\";i:46449;}}}s:4:\"tags\";a:18:{i:28;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:25;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:26;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:29;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}i:27;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}}", "no");
INSERT INTO `wp_options` VALUES("163", "revslider-templates-check", "1745832181", "yes");
INSERT INTO `wp_options` VALUES("164", "revslider-templates-hash", "4c00897d63a314040c6102cec77ae742", "yes");
INSERT INTO `wp_options` VALUES("165", "rs-templates-new", "", "no");
INSERT INTO `wp_options` VALUES("167", "rs-templates-counter", "0", "no");
INSERT INTO `wp_options` VALUES("168", "revslider_table_version", "1.0.13", "yes");
INSERT INTO `wp_options` VALUES("169", "action_scheduler_hybrid_store_demarkation", "6", "yes");
INSERT INTO `wp_options` VALUES("170", "schema-ActionScheduler_StoreSchema", "7.0.1700549189", "yes");
INSERT INTO `wp_options` VALUES("171", "schema-ActionScheduler_LoggerSchema", "3.0.1643118711", "yes");
INSERT INTO `wp_options` VALUES("174", "woocommerce_store_address", "خراسان رضوی-مشهد", "yes");
INSERT INTO `wp_options` VALUES("175", "woocommerce_store_address_2", "مشهد", "yes");
INSERT INTO `wp_options` VALUES("176", "woocommerce_store_city", "مشهد", "yes");
INSERT INTO `wp_options` VALUES("177", "woocommerce_default_country", "IR:RKH", "yes");
INSERT INTO `wp_options` VALUES("178", "woocommerce_store_postcode", "1234567890", "yes");
INSERT INTO `wp_options` VALUES("179", "woocommerce_allowed_countries", "all", "yes");
INSERT INTO `wp_options` VALUES("180", "woocommerce_all_except_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("181", "woocommerce_specific_allowed_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("182", "woocommerce_ship_to_countries", "", "yes");
INSERT INTO `wp_options` VALUES("183", "woocommerce_specific_ship_to_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("184", "woocommerce_default_customer_address", "base", "yes");
INSERT INTO `wp_options` VALUES("185", "woocommerce_calc_taxes", "no", "yes");
INSERT INTO `wp_options` VALUES("186", "woocommerce_enable_coupons", "yes", "yes");
INSERT INTO `wp_options` VALUES("187", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `wp_options` VALUES("188", "woocommerce_currency", "IRT", "yes");
INSERT INTO `wp_options` VALUES("189", "woocommerce_currency_pos", "right", "yes");
INSERT INTO `wp_options` VALUES("190", "woocommerce_price_thousand_sep", "", "yes");
INSERT INTO `wp_options` VALUES("191", "woocommerce_price_decimal_sep", "", "yes");
INSERT INTO `wp_options` VALUES("192", "woocommerce_price_num_decimals", "0", "on");
INSERT INTO `wp_options` VALUES("193", "woocommerce_shop_page_id", "8", "yes");
INSERT INTO `wp_options` VALUES("194", "woocommerce_cart_redirect_after_add", "no", "yes");
INSERT INTO `wp_options` VALUES("195", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `wp_options` VALUES("196", "woocommerce_placeholder_image", "6", "yes");
INSERT INTO `wp_options` VALUES("197", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `wp_options` VALUES("198", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `wp_options` VALUES("199", "woocommerce_enable_reviews", "yes", "yes");
INSERT INTO `wp_options` VALUES("200", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `wp_options` VALUES("201", "woocommerce_review_rating_verification_required", "no", "no");
INSERT INTO `wp_options` VALUES("202", "woocommerce_enable_review_rating", "yes", "yes");
INSERT INTO `wp_options` VALUES("203", "woocommerce_review_rating_required", "yes", "no");
INSERT INTO `wp_options` VALUES("204", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `wp_options` VALUES("205", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `wp_options` VALUES("206", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("207", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("208", "woocommerce_stock_email_recipient", "aliniyazi.email@gmail.com", "no");
INSERT INTO `wp_options` VALUES("209", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `wp_options` VALUES("210", "woocommerce_notify_no_stock_amount", "0", "yes");
INSERT INTO `wp_options` VALUES("211", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `wp_options` VALUES("212", "woocommerce_stock_format", "", "yes");
INSERT INTO `wp_options` VALUES("213", "woocommerce_file_download_method", "force", "no");
INSERT INTO `wp_options` VALUES("214", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `wp_options` VALUES("215", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `wp_options` VALUES("216", "woocommerce_downloads_add_hash_to_filename", "yes", "yes");
INSERT INTO `wp_options` VALUES("217", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `wp_options` VALUES("218", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `wp_options` VALUES("219", "woocommerce_shipping_tax_class", "inherit", "yes");
INSERT INTO `wp_options` VALUES("220", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `wp_options` VALUES("221", "woocommerce_tax_classes", "", "yes");
INSERT INTO `wp_options` VALUES("222", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `wp_options` VALUES("223", "woocommerce_tax_display_cart", "excl", "yes");
INSERT INTO `wp_options` VALUES("224", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `wp_options` VALUES("225", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `wp_options` VALUES("226", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `wp_options` VALUES("227", "woocommerce_shipping_cost_requires_address", "no", "yes");
INSERT INTO `wp_options` VALUES("228", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `wp_options` VALUES("229", "woocommerce_shipping_debug_mode", "no", "yes");
INSERT INTO `wp_options` VALUES("230", "woocommerce_enable_guest_checkout", "yes", "no");
INSERT INTO `wp_options` VALUES("231", "woocommerce_enable_checkout_login_reminder", "yes", "no");
INSERT INTO `wp_options` VALUES("232", "woocommerce_enable_signup_and_login_from_checkout", "yes", "no");
INSERT INTO `wp_options` VALUES("233", "woocommerce_enable_myaccount_registration", "yes", "no");
INSERT INTO `wp_options` VALUES("234", "woocommerce_registration_generate_username", "yes", "no");
INSERT INTO `wp_options` VALUES("235", "woocommerce_registration_generate_password", "yes", "no");
INSERT INTO `wp_options` VALUES("236", "woocommerce_erasure_request_removes_order_data", "no", "no");
INSERT INTO `wp_options` VALUES("237", "woocommerce_erasure_request_removes_download_data", "no", "no");
INSERT INTO `wp_options` VALUES("238", "woocommerce_allow_bulk_remove_personal_data", "no", "no");
INSERT INTO `wp_options` VALUES("239", "woocommerce_registration_privacy_policy_text", "از داده های شخصی شما برای پشتیبانی از تجربه شما در سراسر این وب سایت ، مدیریت دسترسی به حساب کاربری خود ، و اهداف دیگری که در [privacy_policy] ما شرح داده می شود ، استفاده می شود.", "yes");
INSERT INTO `wp_options` VALUES("240", "woocommerce_checkout_privacy_policy_text", "از داده های شخصی شما برای پردازش سفارش شما ، پشتیبانی از تجربه خود در سراسر این وب سایت و اهداف دیگری که در [privacy_policy] ما شرح داده می شود ، استفاده می شود.", "yes");
INSERT INTO `wp_options` VALUES("241", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("242", "woocommerce_trash_pending_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `wp_options` VALUES("243", "woocommerce_trash_failed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `wp_options` VALUES("244", "woocommerce_trash_cancelled_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `wp_options` VALUES("245", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("246", "woocommerce_email_from_name", "homeo", "no");
INSERT INTO `wp_options` VALUES("247", "woocommerce_email_from_address", "aref.dariavi@gmail.com", "no");
INSERT INTO `wp_options` VALUES("248", "woocommerce_email_header_image", "", "no");
INSERT INTO `wp_options` VALUES("249", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "no");
INSERT INTO `wp_options` VALUES("250", "woocommerce_email_base_color", "#96588a", "no");
INSERT INTO `wp_options` VALUES("251", "woocommerce_email_background_color", "#f7f7f7", "no");
INSERT INTO `wp_options` VALUES("252", "woocommerce_email_body_background_color", "#ffffff", "no");
INSERT INTO `wp_options` VALUES("253", "woocommerce_email_text_color", "#3c3c3c", "no");
INSERT INTO `wp_options` VALUES("254", "woocommerce_cart_page_id", "9", "no");
INSERT INTO `wp_options` VALUES("255", "woocommerce_checkout_page_id", "10", "no");
INSERT INTO `wp_options` VALUES("256", "woocommerce_myaccount_page_id", "11", "no");
INSERT INTO `wp_options` VALUES("257", "woocommerce_terms_page_id", "1397", "no");
INSERT INTO `wp_options` VALUES("258", "woocommerce_force_ssl_checkout", "no", "yes");
INSERT INTO `wp_options` VALUES("259", "woocommerce_unforce_ssl_checkout", "no", "yes");
INSERT INTO `wp_options` VALUES("260", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `wp_options` VALUES("261", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `wp_options` VALUES("262", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `wp_options` VALUES("263", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "yes");
INSERT INTO `wp_options` VALUES("264", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "yes");
INSERT INTO `wp_options` VALUES("265", "woocommerce_myaccount_orders_endpoint", "orders", "yes");
INSERT INTO `wp_options` VALUES("266", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `wp_options` VALUES("267", "woocommerce_myaccount_downloads_endpoint", "downloads", "yes");
INSERT INTO `wp_options` VALUES("268", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `wp_options` VALUES("269", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `wp_options` VALUES("270", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "yes");
INSERT INTO `wp_options` VALUES("271", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `wp_options` VALUES("272", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `wp_options` VALUES("273", "woocommerce_api_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("274", "woocommerce_allow_tracking", "no", "no");
INSERT INTO `wp_options` VALUES("275", "woocommerce_show_marketplace_suggestions", "no", "no");
INSERT INTO `wp_options` VALUES("276", "woocommerce_single_image_width", "600", "yes");
INSERT INTO `wp_options` VALUES("277", "woocommerce_thumbnail_image_width", "300", "yes");
INSERT INTO `wp_options` VALUES("278", "woocommerce_checkout_highlight_required_fields", "yes", "yes");
INSERT INTO `wp_options` VALUES("279", "woocommerce_demo_store", "no", "no");
INSERT INTO `wp_options` VALUES("280", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:8:\"/product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("281", "current_theme_supports_woocommerce", "yes", "yes");
INSERT INTO `wp_options` VALUES("282", "woocommerce_queue_flush_rewrite_rules", "no", "yes");
INSERT INTO `wp_options` VALUES("1782", "product_cat_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("285", "default_product_cat", "15", "yes");
INSERT INTO `wp_options` VALUES("286", "woocommerce_admin_notices", "a:1:{i:0;s:6:\"update\";}", "yes");
INSERT INTO `wp_options` VALUES("11068", "woocommerce_version", "9.8.2", "yes");
INSERT INTO `wp_options` VALUES("11241", "woocommerce_db_version", "8.5.2", "yes");
INSERT INTO `wp_options` VALUES("291", "recently_activated", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("292", "action_scheduler_lock_async-request-runner", "680f54a261d1e2.30536782|1745835230", "yes");
INSERT INTO `wp_options` VALUES("293", "revslider_update_version", "6.7.24", "yes");
INSERT INTO `wp_options` VALUES("294", "elementor_version", "3.28.3", "yes");
INSERT INTO `wp_options` VALUES("295", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"W7qZngTXFSTEgdxeJxaSlAC0hGsqzNFz\";}", "yes");
INSERT INTO `wp_options` VALUES("297", "widget_apus_custom_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("298", "widget_apus_recent_post", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("299", "widget_apus_search", "a:3:{i:1;a:2:{s:5:\"title\";s:0:\"\";s:9:\"post_type\";s:4:\"post\";}i:2;a:2:{s:5:\"title\";s:0:\"\";s:9:\"post_type\";s:7:\"product\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("300", "widget_apus_socials_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("301", "widget_apus_elementor_template", "a:6:{i:1;a:1:{s:16:\"item_template_id\";s:4:\"2426\";}i:2;a:1:{s:16:\"item_template_id\";s:4:\"2426\";}i:3;a:1:{s:16:\"item_template_id\";s:4:\"2441\";}i:4;a:1:{s:16:\"item_template_id\";s:4:\"2461\";}i:5;a:1:{s:16:\"item_template_id\";s:4:\"2901\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("302", "widget_apus_mortgage_calculator", "a:2:{i:1;a:1:{s:5:\"title\";s:26:\"ماشین حساب وام\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("303", "widget_apus_contact_form", "a:3:{i:1;a:1:{s:5:\"title\";s:17:\"تماس با %1s\";}i:2;a:1:{s:5:\"title\";s:17:\"تماس با %1s\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("304", "widget_apus_property_contact_form", "a:2:{i:1;a:1:{s:5:\"title\";s:17:\"تماس با %1s\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("305", "widget_apus_widget_property_list", "a:6:{i:1;a:5:{s:5:\"title\";s:21:\"آخرین املاک\";s:11:\"number_post\";s:1:\"4\";s:7:\"orderby\";s:0:\"\";s:5:\"order\";s:0:\"\";s:17:\"get_properties_by\";s:6:\"recent\";}i:2;a:5:{s:5:\"title\";s:21:\"آخرین املاک\";s:11:\"number_post\";s:1:\"3\";s:7:\"orderby\";s:0:\"\";s:5:\"order\";s:0:\"\";s:17:\"get_properties_by\";s:6:\"recent\";}i:3;a:5:{s:5:\"title\";s:21:\"آخرین املاک\";s:11:\"number_post\";s:1:\"3\";s:7:\"orderby\";s:0:\"\";s:5:\"order\";s:0:\"\";s:17:\"get_properties_by\";s:6:\"recent\";}i:4;a:5:{s:5:\"title\";s:21:\"آخرین املاک\";s:11:\"number_post\";s:1:\"4\";s:7:\"orderby\";s:0:\"\";s:5:\"order\";s:0:\"\";s:17:\"get_properties_by\";s:6:\"recent\";}i:5;a:5:{s:5:\"title\";s:21:\"آخرین املاک\";s:11:\"number_post\";s:1:\"3\";s:7:\"orderby\";s:0:\"\";s:5:\"order\";s:0:\"\";s:17:\"get_properties_by\";s:6:\"recent\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("306", "widget_apus_user_short_profile", "a:2:{i:1;a:4:{s:5:\"title\";s:0:\"\";s:14:\"nav_menu_agent\";s:85:\"%d8%af%d8%a7%d8%b4%d8%a8%d9%88%d8%b1%d8%af-%d9%86%d9%85%d8%a7%db%8c%d9%86%d8%af%d9%87\";s:15:\"nav_menu_agency\";s:73:\"%d8%af%d8%a7%d8%b4%d8%a8%d9%88%d8%b1%d8%af-%d8%a2%da%98%d8%a7%d9%86%d8%b3\";s:13:\"nav_menu_user\";s:30:\"%da%a9%d8%a7%d8%b1%d8%a8%d8%b1\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("307", "widget_apus_private_message_form", "a:4:{i:1;a:1:{s:5:\"title\";s:28:\"ارسال پیام به %1s\";}i:2;a:1:{s:5:\"title\";s:28:\"ارسال پیام به %1s\";}i:3;a:1:{s:5:\"title\";s:28:\"ارسال پیام به %1s\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("308", "widget_rev-slider-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("309", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("310", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("311", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("312", "widget_woocommerce_price_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("313", "widget_woocommerce_product_categories", "a:2:{i:1;a:8:{s:5:\"title\";s:32:\"دسته بندی محصولات\";s:7:\"orderby\";s:4:\"name\";s:8:\"dropdown\";i:0;s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:18:\"show_children_only\";i:0;s:10:\"hide_empty\";i:0;s:9:\"max_depth\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("314", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("315", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("316", "widget_woocommerce_products", "a:2:{i:1;a:7:{s:5:\"title\";s:23:\"محصولات اخیر\";s:6:\"number\";i:3;s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("317", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("318", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("319", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("320", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("321", "widget_mc4wp_form_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("322", "widget_property_filter_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("323", "widget_agent_filter_widget", "a:2:{i:1;a:3:{s:5:\"title\";s:41:\"نمایندگان را پیدا کنید\";s:11:\"button_text\";s:31:\"جستجوی نمایندگان\";s:4:\"sort\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("324", "widget_agency_filter_widget", "a:4:{i:1;a:3:{s:5:\"title\";s:37:\"نماینده را پیدا کنید\";s:11:\"button_text\";s:27:\"جستجوی نماینده\";s:4:\"sort\";s:0:\"\";}i:2;a:3:{s:5:\"title\";s:38:\"آژانس ها را پیدا کنید\";s:11:\"button_text\";s:28:\"جستجوی آژانس ها\";s:4:\"sort\";s:0:\"\";}i:3;a:3:{s:5:\"title\";s:38:\"آژانس ها را پیدا کنید\";s:11:\"button_text\";s:23:\"جستجوی آژانس\";s:4:\"sort\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("325", "woocommerce_onboarding_opt_in", "no", "yes");
INSERT INTO `wp_options` VALUES("329", "woocommerce_admin_install_timestamp", "1590138604", "yes");
INSERT INTO `wp_options` VALUES("15594", "woocommerce_admin_version", "3.1.0", "yes");
INSERT INTO `wp_options` VALUES("333", "redux_version_upgraded_from", "3.6.15", "yes");
INSERT INTO `wp_options` VALUES("591", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("340", "woocommerce_admin_last_orders_milestone", "1", "yes");
INSERT INTO `wp_options` VALUES("341", "woocommerce_onboarding_profile", "a:1:{s:9:\"completed\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("336", "homeo_theme_options", "a:152:{s:8:\"last_tab\";s:0:\"\";s:7:\"preload\";s:1:\"1\";s:18:\"media-preload-icon\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:18:\"image_lazy_loading\";s:1:\"0\";s:11:\"header_type\";s:8:\"header-2\";s:11:\"keep_header\";s:1:\"0\";s:17:\"media-mobile-logo\";a:9:{s:3:\"url\";s:61:\"https://homeo.tooswp.ir/wp-content/uploads/2020/02/logo-1.png\";s:2:\"id\";s:4:\"3126\";s:6:\"height\";s:2:\"47\";s:5:\"width\";s:3:\"150\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:4:\"logo\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:18:\"header_mobile_menu\";s:1:\"1\";s:19:\"header_mobile_login\";s:1:\"1\";s:30:\"header_mobile_add_property_btn\";s:1:\"1\";s:11:\"footer_type\";s:8:\"footer-1\";s:11:\"back_to_top\";s:1:\"1\";s:21:\"show_blog_breadcrumbs\";s:1:\"1\";s:21:\"blog_breadcrumb_color\";s:0:\"\";s:21:\"blog_breadcrumb_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:21:\"blog_breadcrumb_style\";s:10:\"horizontal\";s:19:\"blog_archive_layout\";s:10:\"main-right\";s:22:\"blog_archive_fullwidth\";s:0:\"\";s:25:\"blog_archive_left_sidebar\";s:0:\"\";s:26:\"blog_archive_right_sidebar\";s:12:\"blog-sidebar\";s:17:\"blog_display_mode\";s:4:\"grid\";s:12:\"blog_columns\";s:1:\"2\";s:19:\"blog_item_thumbsize\";s:7:\"510x330\";s:18:\"blog_single_layout\";s:10:\"main-right\";s:21:\"blog_single_fullwidth\";s:0:\"\";s:24:\"blog_single_left_sidebar\";s:0:\"\";s:25:\"blog_single_right_sidebar\";s:12:\"blog-sidebar\";s:22:\"show_blog_social_share\";s:1:\"1\";s:18:\"show_blog_releated\";s:1:\"1\";s:20:\"number_blog_releated\";s:1:\"2\";s:21:\"releated_blog_columns\";s:1:\"2\";s:24:\"show_product_breadcrumbs\";s:1:\"1\";s:20:\"woo_breadcrumb_color\";s:0:\"\";s:20:\"woo_breadcrumb_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:20:\"woo_breadcrumb_style\";s:7:\"default\";s:19:\"show_shop_cat_title\";s:1:\"1\";s:20:\"product_display_mode\";s:4:\"grid\";s:15:\"product_columns\";s:1:\"3\";s:24:\"number_products_per_page\";s:1:\"9\";s:17:\"enable_swap_image\";s:1:\"1\";s:25:\"product_archive_fullwidth\";s:0:\"\";s:22:\"product_archive_layout\";s:4:\"main\";s:28:\"product_archive_left_sidebar\";s:0:\"\";s:29:\"product_archive_right_sidebar\";s:0:\"\";s:23:\"product_thumbs_position\";s:17:\"thumbnails-bottom\";s:21:\"number_product_thumbs\";s:1:\"5\";s:25:\"show_product_social_share\";s:1:\"1\";s:23:\"show_product_review_tab\";s:1:\"1\";s:21:\"product_single_layout\";s:4:\"main\";s:24:\"product_single_fullwidth\";s:0:\"\";s:27:\"product_single_left_sidebar\";s:0:\"\";s:28:\"product_single_right_sidebar\";s:0:\"\";s:21:\"show_product_releated\";s:1:\"1\";s:23:\"number_product_releated\";s:1:\"3\";s:24:\"releated_product_columns\";s:1:\"3\";s:20:\"show_product_upsells\";s:1:\"1\";s:23:\"upsells_product_columns\";s:1:\"3\";s:25:\"show_property_breadcrumbs\";s:1:\"1\";s:25:\"property_breadcrumb_color\";s:0:\"\";s:25:\"property_breadcrumb_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:25:\"property_breadcrumb_style\";s:8:\"vertical\";s:23:\"listing_show_full_phone\";s:1:\"0\";s:23:\"listing_enable_favorite\";s:1:\"1\";s:22:\"listing_enable_compare\";s:1:\"1\";s:20:\"properties_fullwidth\";s:0:\"\";s:22:\"properties_layout_type\";s:7:\"default\";s:29:\"properties_elementor_template\";s:0:\"\";s:25:\"properties_layout_sidebar\";s:9:\"left-main\";s:23:\"properties_display_mode\";s:4:\"grid\";s:27:\"properties_inner_grid_style\";s:4:\"grid\";s:18:\"properties_columns\";s:1:\"2\";s:18:\"properties_gallery\";s:1:\"1\";s:21:\"properties_pagination\";s:7:\"default\";s:26:\"property_placeholder_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:18:\"property_fullwidth\";s:0:\"\";s:20:\"property_layout_type\";s:2:\"v1\";s:26:\"show_property_social_share\";s:1:\"1\";s:25:\"show_property_description\";s:1:\"1\";s:20:\"show_property_energy\";s:1:\"1\";s:20:\"show_property_detail\";s:1:\"1\";s:25:\"show_property_attachments\";s:1:\"1\";s:23:\"show_property_amenities\";s:1:\"1\";s:23:\"show_property_materials\";s:1:\"1\";s:22:\"show_property_location\";s:1:\"1\";s:25:\"show_property_floor-plans\";s:1:\"1\";s:32:\"show_property_tabs-video-virtual\";s:1:\"1\";s:24:\"show_property_facilities\";s:1:\"1\";s:23:\"show_property_valuation\";s:1:\"1\";s:25:\"show_property_stats_graph\";s:1:\"1\";s:25:\"show_property_nearby_yelp\";s:1:\"0\";s:24:\"show_property_walk_score\";s:1:\"0\";s:27:\"show_property_subproperties\";s:1:\"1\";s:21:\"show_property_related\";s:1:\"1\";s:29:\"property_subproperties_number\";s:1:\"2\";s:23:\"property_related_number\";s:1:\"2\";s:23:\"property_enable_printer\";s:1:\"1\";s:10:\"print-logo\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:17:\"show_print_header\";s:1:\"1\";s:17:\"show_print_qrcode\";s:1:\"1\";s:16:\"show_print_agent\";s:1:\"1\";s:22:\"show_print_description\";s:1:\"1\";s:17:\"show_print_energy\";s:1:\"1\";s:17:\"show_print_detail\";s:1:\"1\";s:20:\"show_print_amenities\";s:1:\"1\";s:22:\"show_print_floor-plans\";s:1:\"1\";s:21:\"show_print_facilities\";s:1:\"1\";s:20:\"show_print_valuation\";s:1:\"1\";s:18:\"show_print_gallery\";s:1:\"1\";s:22:\"show_agent_breadcrumbs\";s:1:\"1\";s:22:\"agent_breadcrumb_color\";s:0:\"\";s:22:\"agent_breadcrumb_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:22:\"agent_breadcrumb_style\";s:8:\"vertical\";s:16:\"agents_fullwidth\";s:0:\"\";s:21:\"agents_layout_sidebar\";s:9:\"left-main\";s:19:\"agents_display_mode\";s:4:\"grid\";s:14:\"agents_columns\";s:1:\"2\";s:17:\"agents_pagination\";s:7:\"default\";s:15:\"agent_fullwidth\";s:0:\"\";s:23:\"show_agent_social_share\";s:1:\"1\";s:19:\"agent_property_show\";s:1:\"1\";s:23:\"show_agency_breadcrumbs\";s:1:\"1\";s:23:\"agency_breadcrumb_color\";s:0:\"\";s:23:\"agency_breadcrumb_image\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:23:\"agency_breadcrumb_style\";s:8:\"vertical\";s:18:\"agencies_fullwidth\";s:0:\"\";s:23:\"agencies_layout_sidebar\";s:9:\"left-main\";s:21:\"agencies_display_mode\";s:4:\"grid\";s:16:\"agencies_columns\";s:1:\"2\";s:19:\"agencies_pagination\";s:7:\"default\";s:16:\"agency_fullwidth\";s:0:\"\";s:24:\"show_agency_social_share\";s:1:\"1\";s:17:\"agency_agent_show\";s:1:\"1\";s:20:\"agency_property_show\";s:1:\"1\";s:27:\"register_form_enable_agency\";s:1:\"1\";s:26:\"register_form_enable_agent\";s:1:\"1\";s:8:\"icon-img\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:6:\"bg-img\";a:9:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:5:\"title\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:11:\"description\";s:0:\"\";}s:9:\"404_title\";s:3:\"404\";s:15:\"404_description\";s:197:\"متأسفیم ، اما صفحه ای که به دنبال آن هستید وجود ندارد ، حذف شده ، نام آن تغییر یافته و یا موقت آن در دسترس نیست.\";s:10:\"main_color\";s:0:\"\";s:12:\"button_color\";s:0:\"\";s:18:\"button_hover_color\";s:0:\"\";s:19:\"header_mobile_color\";s:0:\"\";s:9:\"main_font\";a:5:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:0:\"\";}s:12:\"heading_font\";a:6:{s:11:\"font-family\";s:0:\"\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";}s:14:\"facebook_share\";s:1:\"1\";s:13:\"twitter_share\";s:1:\"1\";s:14:\"linkedin_share\";s:1:\"1\";s:15:\"pinterest_share\";s:1:\"1\";s:10:\"more_share\";s:1:\"1\";s:24:\"property_stats_graph_for\";s:0:\"\";s:34:\"show_property_nearby_google_places\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("337", "homeo_theme_options-transients", "a:2:{s:14:\"changed_values\";a:0:{}s:9:\"last_save\";i:1623342651;}", "yes");
INSERT INTO `wp_options` VALUES("344", "mc4wp_version", "4.10.3", "yes");
INSERT INTO `wp_options` VALUES("345", "_elementor_installed_time", "1588804074", "yes");
INSERT INTO `wp_options` VALUES("346", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:823:{i:0;a:20:{s:4:\"tmpl\";i:1280;s:2:\"id\";i:22403;s:5:\"title\";s:40:\"Hello Bar | Subscribe | Aesthetic Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/aesthetic-clinic-19.jpg\";s:12:\"tmpl_created\";i:1647354307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/hello-bar-subscribe-aesthetic-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:48:\"[\"Barbershop\",\"Business\",\"Discount\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:1;a:20:{s:4:\"tmpl\";i:1281;s:2:\"id\";i:22410;s:5:\"title\";s:32:\"Fly-In | Discount | Hair Stylist\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/hair-stylist-20.jpg\";s:12:\"tmpl_created\";i:1647354614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-discount-hair-stylist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Barbershop\",\"Discount\",\"Hair\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:2;a:20:{s:4:\"tmpl\";i:1285;s:2:\"id\";i:22440;s:5:\"title\";s:32:\"Classic | Subscribe | Shoe Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/shoes-store-21.jpg\";s:12:\"tmpl_created\";i:1647418620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-subscribe-shoe-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:37:\"[\"Ecommerce\",\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:3;a:20:{s:4:\"tmpl\";i:1286;s:2:\"id\";i:22446;s:5:\"title\";s:37:\"Full Screen | Subscribe | Denim Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/denim-store-22.jpg\";s:12:\"tmpl_created\";i:1647419614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/full-screen-subscribe-denim-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:4;a:20:{s:4:\"tmpl\";i:1287;s:2:\"id\";i:22452;s:5:\"title\";s:37:\"Fly-In | Subscribe | Pizza Restaurant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/pizza-restaurant-23.jpg\";s:12:\"tmpl_created\";i:1647420733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-subscribe-pizza-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:19:\"[\"Business\",\"Food\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:5;a:20:{s:4:\"tmpl\";i:1288;s:2:\"id\";i:22458;s:5:\"title\";s:38:\"Full Screen | Subscribe | Fashion Shop\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-shop-24.jpg\";s:12:\"tmpl_created\";i:1647426379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-subscribe-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Ecommerce\",\"Fashion\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:6;a:20:{s:4:\"tmpl\";i:1289;s:2:\"id\";i:22464;s:5:\"title\";s:32:\"Fly-In | Contact | Makeup Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/makeup-studio-25.jpg\";s:12:\"tmpl_created\";i:1647427026;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-makeup-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:7;a:20:{s:4:\"tmpl\";i:1290;s:2:\"id\";i:22470;s:5:\"title\";s:32:\"Fly-In | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-26.jpg\";s:12:\"tmpl_created\";i:1647428250;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:8;a:20:{s:4:\"tmpl\";i:1291;s:2:\"id\";i:22480;s:5:\"title\";s:27:\"Classic | CTA | MasterClass\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/master-class-27.jpg\";s:12:\"tmpl_created\";i:1647428474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-masterclass/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"cta\",\"Magazine\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:9;a:20:{s:4:\"tmpl\";i:1292;s:2:\"id\";i:22489;s:5:\"title\";s:29:\"Classic | CTA | Music Concert\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/music-concert-29.jpg\";s:12:\"tmpl_created\";i:1647429738;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-music-concert/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"cta\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:10;a:20:{s:4:\"tmpl\";i:1293;s:2:\"id\";i:22495;s:5:\"title\";s:27:\"Classic | CTA | Music Album\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/music-album-30.jpg\";s:12:\"tmpl_created\";i:1647430056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-music-album/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Ba\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:11;a:20:{s:4:\"tmpl\";i:1294;s:2:\"id\";i:22501;s:5:\"title\";s:37:\"Fly-In | CTA | Photography Exhibition\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/photography-exhibition-31.jpg\";s:12:\"tmpl_created\";i:1647430512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-photography-exhibition/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:12;a:20:{s:4:\"tmpl\";i:1295;s:2:\"id\";i:22507;s:5:\"title\";s:34:\"Classic | CTA | Clothing Shop Sale\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/clothing-shop-sale-32.jpg\";s:12:\"tmpl_created\";i:1647430774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-cta-clothing-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:13;a:20:{s:4:\"tmpl\";i:1296;s:2:\"id\";i:22486;s:5:\"title\";s:30:\"Classic | CTA | Shop Promotion\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/shop-promotion-28.jpg\";s:12:\"tmpl_created\";i:1647430951;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-shop-promotion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"cta\",\"Magazine\",\"Photography\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:14;a:20:{s:4:\"tmpl\";i:1297;s:2:\"id\";i:22516;s:5:\"title\";s:32:\"Fly-In | CTA | Glasses Shop Sale\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/glasses-shop-sale-33.jpg\";s:12:\"tmpl_created\";i:1647431136;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-cta-glasses-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:30:\"[\"Business\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:15;a:20:{s:4:\"tmpl\";i:1298;s:2:\"id\";i:22522;s:5:\"title\";s:30:\"Fly-In | Discount | Skate Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/50-skate-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647434058;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-skate-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:16;a:20:{s:4:\"tmpl\";i:1299;s:2:\"id\";i:22532;s:5:\"title\";s:43:\"Classic | Subscription | Basketball Academy\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/21-basketball-academy-Subscription.jpg\";s:12:\"tmpl_created\";i:1647434608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/classic-subscription-basketball-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Education\",\"Marketing\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:17;a:20:{s:4:\"tmpl\";i:1300;s:2:\"id\";i:22543;s:5:\"title\";s:38:\"Classic | Discount | Veterinary Clinic\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/veterinery-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647435581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-discount-veterinary-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Discount\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:18;a:20:{s:4:\"tmpl\";i:1301;s:2:\"id\";i:22553;s:5:\"title\";s:39:\"Classic | Contact | Business Consulting\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/27-business-consulting-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647439935;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/classic-contact-business-consulting/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:19;a:20:{s:4:\"tmpl\";i:1302;s:2:\"id\";i:22562;s:5:\"title\";s:28:\"Classic | Contact | Handyman\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/handyman-small.jpg\";s:12:\"tmpl_created\";i:1647440333;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-contact-handyman/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:20;a:20:{s:4:\"tmpl\";i:1303;s:2:\"id\";i:22573;s:5:\"title\";s:40:\"Classic | Discount | Online Fashion Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/31-online-fashion-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647462549;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-online-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:21;a:20:{s:4:\"tmpl\";i:1304;s:2:\"id\";i:22583;s:5:\"title\";s:36:\"Fly-In | Discount | Personal Trainer\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/personal-trainer-small.jpg\";s:12:\"tmpl_created\";i:1647503781;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-personal-trainer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:22;a:20:{s:4:\"tmpl\";i:1305;s:2:\"id\";i:22592;s:5:\"title\";s:41:\"Classic | Contact | Illustrator Portfolio\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/illustrator-protfolio-small.jpg\";s:12:\"tmpl_created\";i:1647504218;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-contact-illustrator-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:49:\"[\"Contact\",\"Creative Portfolio\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:23;a:20:{s:4:\"tmpl\";i:1306;s:2:\"id\";i:22602;s:5:\"title\";s:46:\"Bottom Bar | Discount | Handmade Ceramics Shop\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2022/03/handmade-ceramic-shop-36-small.jpg\";s:12:\"tmpl_created\";i:1647507007;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-ceramics-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:48:\"[\"Business\",\"cta\",\"Ecommerce\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:24;a:20:{s:4:\"tmpl\";i:1307;s:2:\"id\";i:22612;s:5:\"title\";s:51:\"Classic | Contact | Classic Car Restoration Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/restoration-car-shop-37-small.jpg\";s:12:\"tmpl_created\";i:1647507310;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/classic-contact-classic-car-restoration-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:25;a:20:{s:4:\"tmpl\";i:1308;s:2:\"id\";i:22621;s:5:\"title\";s:30:\"Classic | Booking | Life Coach\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/38-life-coach-Booking.jpg\";s:12:\"tmpl_created\";i:1647508596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-booking-life-coach/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Booking\",\"Business\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:26;a:20:{s:4:\"tmpl\";i:1309;s:2:\"id\";i:22632;s:5:\"title\";s:42:\"Classic |  Subscription | Merchandise Shop\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/Merchandise-Shop-39-small.jpg\";s:12:\"tmpl_created\";i:1647509196;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-subscription-merchandise-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Ecommerce\",\"Marketing\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:27;a:20:{s:4:\"tmpl\";i:1310;s:2:\"id\";i:22643;s:5:\"title\";s:48:\"Fly-In | Contact | Non-Governmental Organization\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/NGO-41-small.jpg\";s:12:\"tmpl_created\";i:1647509528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:150:\"https://library.elementor.com/popups/fly-in-contact-non-governmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:28;a:20:{s:4:\"tmpl\";i:1311;s:2:\"id\";i:22654;s:5:\"title\";s:35:\"Hello Bar | Contact | Family Doctor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/family-doctor-44-small.jpg\";s:12:\"tmpl_created\";i:1647509732;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/hello-bar-contact-family-doctor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Contact\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:29;a:20:{s:4:\"tmpl\";i:1312;s:2:\"id\";i:22663;s:5:\"title\";s:36:\"Classic | Subscription | Sports Blog\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/45-sport-blog-Subscription.jpg\";s:12:\"tmpl_created\";i:1647509908;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-sports-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:30;a:20:{s:4:\"tmpl\";i:1313;s:2:\"id\";i:22673;s:5:\"title\";s:30:\"Hello Bar | Booking | Event DJ\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/DJ-service-46-small.jpg\";s:12:\"tmpl_created\";i:1647510160;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/hello-bar-booking-event-dj/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Booking\",\"Events\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:31;a:20:{s:4:\"tmpl\";i:1314;s:2:\"id\";i:22684;s:5:\"title\";s:36:\"Fly-In | Discount | Cleaning Company\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/51-cleaning-company-Discount.jpg\";s:12:\"tmpl_created\";i:1647510546;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-cleaning-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Offer\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:32;a:20:{s:4:\"tmpl\";i:1315;s:2:\"id\";i:22693;s:5:\"title\";s:28:\"Fly-In | Contact | Carpenter\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/carpenter-53-small.jpg\";s:12:\"tmpl_created\";i:1647511972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-carpenter/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:33;a:20:{s:4:\"tmpl\";i:1316;s:2:\"id\";i:22703;s:5:\"title\";s:31:\"Classic | Booking | Yoga Studio\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/55-yoga-studio-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647512209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-booking-yoga-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Booking\",\"Contact\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:34;a:20:{s:4:\"tmpl\";i:1317;s:2:\"id\";i:22714;s:5:\"title\";s:37:\"Classic | Discount | Pet Care Company\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/56-Pet-Care-Discount.jpg\";s:12:\"tmpl_created\";i:1647513031;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-pet-care-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:35;a:20:{s:4:\"tmpl\";i:1318;s:2:\"id\";i:22725;s:5:\"title\";s:38:\"Fly-In | Discount | Online Coffee Shop\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/online-coffee-shop-57-small.jpg\";s:12:\"tmpl_created\";i:1647513325;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-discount-online-coffee-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Food\",\"Offer\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:36;a:20:{s:4:\"tmpl\";i:1319;s:2:\"id\";i:22737;s:5:\"title\";s:44:\"Fly-In | CTA | Moving &#038; Storage Company\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/moving-company-59-small.jpg\";s:12:\"tmpl_created\";i:1647520956;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-moving-storage-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:37;a:20:{s:4:\"tmpl\";i:1320;s:2:\"id\";i:22749;s:5:\"title\";s:47:\"Classic | Contact | Industrial Design Portfolio\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/60-industrial-design-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647528116;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/classic-contact-industrial-design-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:40:\"[\"Contact\",\"Interior Design\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:38;a:20:{s:4:\"tmpl\";i:1321;s:2:\"id\";i:22759;s:5:\"title\";s:25:\"Classic | Contact | Drone\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/drone-61-small.jpg\";s:12:\"tmpl_created\";i:1647528899;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-contact-drone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:39;a:20:{s:4:\"tmpl\";i:1322;s:2:\"id\";i:22768;s:5:\"title\";s:46:\"Full Screen | Menu | Fashion Stylist Portfolio\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/62-Fashion-Stylist-Menu.jpg\";s:12:\"tmpl_created\";i:1647529434;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/full-screen-menu-fashion-stylist-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Fashion\",\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:40;a:20:{s:4:\"tmpl\";i:1323;s:2:\"id\";i:22780;s:5:\"title\";s:31:\"Fly-In | CTA | Landscape Design\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/64-Landscape-Design-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647530337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-landscape-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:41;a:20:{s:4:\"tmpl\";i:1324;s:2:\"id\";i:22790;s:5:\"title\";s:48:\"Bottom Bar  | Contact | Architecture Photography\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/architecture-photography-65-small.jpg\";s:12:\"tmpl_created\";i:1647532358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/bottom-bar-contact-architecture-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:26:\"[\"Architecture\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:42;a:20:{s:4:\"tmpl\";i:1325;s:2:\"id\";i:22800;s:5:\"title\";s:41:\"Fly-In  | CTA | Speech-Language Therapist\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/66-Speech-Language-Therapist-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647532720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/fly-in-cta-speech-language-therapist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:25:\"[\"cta\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:43;a:20:{s:4:\"tmpl\";i:1326;s:2:\"id\";i:22812;s:5:\"title\";s:35:\"Full Screen | Verification | Winery\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/67-Winery-Verification.jpg\";s:12:\"tmpl_created\";i:1647761384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/full-screen-verification-winery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:24:\"[\"Alert\",\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:44;a:20:{s:4:\"tmpl\";i:1327;s:2:\"id\";i:22822;s:5:\"title\";s:36:\"Fly-In | Subscription | Nutritionist\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/nutritionist-69-small.jpg\";s:12:\"tmpl_created\";i:1647762620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-subscription-nutritionist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Food\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:45;a:20:{s:4:\"tmpl\";i:1328;s:2:\"id\";i:22833;s:5:\"title\";s:40:\"Classic | Subscription | App &#038; SaaS\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/app-70-small.jpg\";s:12:\"tmpl_created\";i:1647762955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscription-app-saas/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:14:\"[\"App\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:46;a:20:{s:4:\"tmpl\";i:1329;s:2:\"id\";i:22844;s:5:\"title\";s:41:\"Bottom Bar | Discount | Handmade Cupcakes\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/72-Handmade-Cupcakes-Discount.jpg\";s:12:\"tmpl_created\";i:1647763350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-cupcakes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:21:\"[\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:47;a:20:{s:4:\"tmpl\";i:1330;s:2:\"id\";i:22855;s:5:\"title\";s:40:\"Bottom Bar | Subscription | Fashion Blog\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-blog-75-small.jpg\";s:12:\"tmpl_created\";i:1647763907;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/bottom-bar-subscription-fashion-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:30:\"[\"Blog\",\"Fashion\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:48;a:20:{s:4:\"tmpl\";i:1331;s:2:\"id\";i:22866;s:5:\"title\";s:28:\"Fly-In | CTA | Private Tutor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-77-small.jpg\";s:12:\"tmpl_created\";i:1647764062;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-cta-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:49;a:20:{s:4:\"tmpl\";i:1332;s:2:\"id\";i:22876;s:5:\"title\";s:30:\"Classic | CTA | Tennis Academy\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/78-Tennis-Academy-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765192;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-tennis-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:50;a:20:{s:4:\"tmpl\";i:1333;s:2:\"id\";i:22887;s:5:\"title\";s:31:\"Fly-In | CTA | Shared Workspace\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/shared-workspace-79-small.jpg\";s:12:\"tmpl_created\";i:1647765419;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-shared-workspace/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Business\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:51;a:20:{s:4:\"tmpl\";i:1334;s:2:\"id\";i:22899;s:5:\"title\";s:30:\"Bottom Bar | CTA | Art Gallery\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/80-Art-Gallery-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765652;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/bottom-bar-cta-art-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:13:\"[\"Art\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:52;a:20:{s:4:\"tmpl\";i:1335;s:2:\"id\";i:22910;s:5:\"title\";s:44:\"Fly-In | Subscription | Hiking Tours Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/hiking-tours-company-81-small.jpg\";s:12:\"tmpl_created\";i:1647765835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscription-hiking-tours-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Subscribe\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:53;a:20:{s:4:\"tmpl\";i:1336;s:2:\"id\";i:22921;s:5:\"title\";s:26:\"Classic | CTA | Music Band\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/music-band-82-small.jpg\";s:12:\"tmpl_created\";i:1647769462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/classic-cta-music-band/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Marketing\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:54;a:20:{s:4:\"tmpl\";i:1337;s:2:\"id\";i:22935;s:5:\"title\";s:35:\"Classic | CTA | Computer Technician\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/comuter-technician-83-small.jpg\";s:12:\"tmpl_created\";i:1647769843;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-computer-technician/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:55;a:20:{s:4:\"tmpl\";i:1338;s:2:\"id\";i:22945;s:5:\"title\";s:37:\"Classic | Discount | Delivery Company\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/delivery-company-88-small.jpg\";s:12:\"tmpl_created\";i:1647770834;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-delivery-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Discount\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:56;a:20:{s:4:\"tmpl\";i:1339;s:2:\"id\";i:22959;s:5:\"title\";s:29:\"Classic | Discount | Eco Shop\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/echo-shop-89-small.jpg\";s:12:\"tmpl_created\";i:1647771211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-discount-eco-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:57;a:20:{s:4:\"tmpl\";i:1340;s:2:\"id\";i:22972;s:5:\"title\";s:54:\"Fly-In | Subscription | Health &#038; Mindfulness Blog\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small.jpg\";s:12:\"tmpl_created\";i:1647771461;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/fly-in-subscription-health-mindfulness-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:21:\"[\"Health\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:58;a:20:{s:4:\"tmpl\";i:1341;s:2:\"id\";i:22982;s:5:\"title\";s:31:\"Full Screen | Menu | Art Museum\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/art-museum-112-small.jpg\";s:12:\"tmpl_created\";i:1647771938;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-art-museum/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:59;a:20:{s:4:\"tmpl\";i:1342;s:2:\"id\";i:22992;s:5:\"title\";s:40:\"Classic | Discount | Urban Clothing Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small-1.jpg\";s:12:\"tmpl_created\";i:1647773067;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-urban-clothing-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Discount\",\"Ecommerce\",\"Fashion\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:60;a:20:{s:4:\"tmpl\";i:1343;s:2:\"id\";i:23004;s:5:\"title\";s:60:\"Full Screen | Menu | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small-1.jpg\";s:12:\"tmpl_created\";i:1647773366;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:155:\"https://library.elementor.com/popups/full-screen-menu-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:61;a:20:{s:4:\"tmpl\";i:1344;s:2:\"id\";i:23015;s:5:\"title\";s:62:\"Bottom Bar | Contact | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small.jpg\";s:12:\"tmpl_created\";i:1647773492;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/bottom-bar-contact-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:23:\"[\"Contact\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:62;a:20:{s:4:\"tmpl\";i:1345;s:2:\"id\";i:23025;s:5:\"title\";s:32:\"Full Screen | Menu | Flower Shop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small.jpg\";s:12:\"tmpl_created\";i:1647773820;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:63;a:20:{s:4:\"tmpl\";i:1346;s:2:\"id\";i:23037;s:5:\"title\";s:36:\"Classic | Subscription | Flower Shop\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small-1.jpg\";s:12:\"tmpl_created\";i:1647773949;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:64;a:20:{s:4:\"tmpl\";i:1347;s:2:\"id\";i:23056;s:5:\"title\";s:48:\"Classic | Discount | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small-1.jpg\";s:12:\"tmpl_created\";i:1647774468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-discount-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:65;a:20:{s:4:\"tmpl\";i:1348;s:2:\"id\";i:23067;s:5:\"title\";s:37:\"Fly-In | Menu | Baby Sleep Consultant\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small-1.jpg\";s:12:\"tmpl_created\";i:1647778954;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:66;a:20:{s:4:\"tmpl\";i:1349;s:2:\"id\";i:23077;s:5:\"title\";s:46:\"Classic | Subscription | Baby Sleep Consultant\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small.jpg\";s:12:\"tmpl_created\";i:1647779074;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/classic-subscription-baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:12:\"[\"Discount\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:67;a:20:{s:4:\"tmpl\";i:1350;s:2:\"id\";i:23090;s:5:\"title\";s:33:\"Full Screen | Menu | Luxury Hotel\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small.jpg\";s:12:\"tmpl_created\";i:1647779390;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/full-screen-menu-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:68;a:20:{s:4:\"tmpl\";i:1351;s:2:\"id\";i:23100;s:5:\"title\";s:31:\"Fly-In | Booking | Luxury Hotel\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small-1.jpg\";s:12:\"tmpl_created\";i:1647779500;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-booking-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Booking\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:69;a:20:{s:4:\"tmpl\";i:1352;s:2:\"id\";i:23109;s:5:\"title\";s:38:\"Full Screen | Menu | Design Conference\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small.jpg\";s:12:\"tmpl_created\";i:1647779675;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:70;a:20:{s:4:\"tmpl\";i:1353;s:2:\"id\";i:23120;s:5:\"title\";s:41:\"Full Screen | Booking | Design Conference\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small-1.jpg\";s:12:\"tmpl_created\";i:1647779793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/full-screen-booking-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Booking\",\"Conference\",\"Creative\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:71;a:20:{s:4:\"tmpl\";i:1354;s:2:\"id\";i:23129;s:5:\"title\";s:29:\"Slide-In | Menu | VR Headsets\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small.jpg\";s:12:\"tmpl_created\";i:1647781211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-menu-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:72;a:20:{s:4:\"tmpl\";i:1355;s:2:\"id\";i:23139;s:5:\"title\";s:31:\"Classic | Contact | VR Headsets\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small-1.jpg\";s:12:\"tmpl_created\";i:1647781384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:73;a:20:{s:4:\"tmpl\";i:1356;s:2:\"id\";i:23149;s:5:\"title\";s:38:\"Slide-In | Menu | Portrait Photography\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Menu.jpg\";s:12:\"tmpl_created\";i:1647782336;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/slide-in-menu-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:74;a:20:{s:4:\"tmpl\";i:1357;s:2:\"id\";i:23159;s:5:\"title\";s:47:\"Hello Bar | Subscription | Portrait Photography\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Subscription.jpg\";s:12:\"tmpl_created\";i:1647782478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/hello-bar-subscription-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Blog\",\"Photography\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:75;a:20:{s:4:\"tmpl\";i:1358;s:2:\"id\";i:23169;s:5:\"title\";s:32:\"Full Screen | Menu | English Pub\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Menu.jpg\";s:12:\"tmpl_created\";i:1647782664;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:76;a:20:{s:4:\"tmpl\";i:1359;s:2:\"id\";i:23179;s:5:\"title\";s:32:\"Classic | Discount | English Pub\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Discount.jpg\";s:12:\"tmpl_created\";i:1647782796;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:77;a:20:{s:4:\"tmpl\";i:1360;s:2:\"id\";i:23189;s:5:\"title\";s:27:\"Full Screen | Menu | Singer\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Menu.jpg\";s:12:\"tmpl_created\";i:1647783070;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/full-screen-menu-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:29:\"[\"Fullscreen\",\"menu\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:78;a:20:{s:4:\"tmpl\";i:1361;s:2:\"id\";i:23200;s:5:\"title\";s:31:\"Classic | Subscription | Singer\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Subscription.jpg\";s:12:\"tmpl_created\";i:1647783249;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-subscription-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Music\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:79;a:20:{s:4:\"tmpl\";i:1362;s:2:\"id\";i:23210;s:5:\"title\";s:38:\"Full Screen | Menu | Virtual Assistant\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistnt-73-small.jpg\";s:12:\"tmpl_created\";i:1647784292;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:80;a:20:{s:4:\"tmpl\";i:1363;s:2:\"id\";i:23223;s:5:\"title\";s:39:\"Hello Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/73-Virtual-Assistant-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647784616;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-contact-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:37:\"[\"Contact\",\"Psychologist\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:81;a:20:{s:4:\"tmpl\";i:1364;s:2:\"id\";i:23234;s:5:\"title\";s:32:\"Slide-In  | Menu | Personal Chef\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Menu.jpg\";s:12:\"tmpl_created\";i:1647798194;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-menu-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:82;a:20:{s:4:\"tmpl\";i:1365;s:2:\"id\";i:23244;s:5:\"title\";s:29:\"Classic | CTA | Personal Chef\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647798297;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Booking\",\"Chef\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:83;a:20:{s:4:\"tmpl\";i:1366;s:2:\"id\";i:23254;s:5:\"title\";s:31:\"Full Screen | Menu | Food Truck\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small-1.jpg\";s:12:\"tmpl_created\";i:1647798447;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:84;a:20:{s:4:\"tmpl\";i:1367;s:2:\"id\";i:23265;s:5:\"title\";s:30:\"Fly-In | Discount | Food Truck\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small.jpg\";s:12:\"tmpl_created\";i:1647798657;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:85;a:20:{s:4:\"tmpl\";i:1369;s:2:\"id\";i:23323;s:5:\"title\";s:28:\"Classic | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-6-Small.jpg\";s:12:\"tmpl_created\";i:1647855505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:86;a:20:{s:4:\"tmpl\";i:1370;s:2:\"id\";i:23329;s:5:\"title\";s:29:\"Slide-In | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-5-Small.jpg\";s:12:\"tmpl_created\";i:1647855865;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:87;a:20:{s:4:\"tmpl\";i:1371;s:2:\"id\";i:23335;s:5:\"title\";s:31:\"Slide-In | CTA | Black Friday 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-1-Small.jpg\";s:12:\"tmpl_created\";i:1647856357;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-cta-black-friday-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:88;a:20:{s:4:\"tmpl\";i:1372;s:2:\"id\";i:23341;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-3-Small.jpg\";s:12:\"tmpl_created\";i:1647856493;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:89;a:20:{s:4:\"tmpl\";i:1373;s:2:\"id\";i:23347;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-2-Small.jpg\";s:12:\"tmpl_created\";i:1647856891;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:90;a:20:{s:4:\"tmpl\";i:1374;s:2:\"id\";i:23354;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 4\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-4-Small.jpg\";s:12:\"tmpl_created\";i:1647856996;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:91;a:20:{s:4:\"tmpl\";i:1375;s:2:\"id\";i:23394;s:5:\"title\";s:27:\"Classic | CTA | Halloween 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-3-Small.jpg\";s:12:\"tmpl_created\";i:1647857351;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-halloween-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:31:\"[\"cta\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:92;a:20:{s:4:\"tmpl\";i:1376;s:2:\"id\";i:23401;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-2-Small.jpg\";s:12:\"tmpl_created\";i:1647857567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:93;a:20:{s:4:\"tmpl\";i:1377;s:2:\"id\";i:23407;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-1-Small.jpg\";s:12:\"tmpl_created\";i:1647857814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:94;a:20:{s:4:\"tmpl\";i:1378;s:2:\"id\";i:23416;s:5:\"title\";s:31:\"Fly-In | Discount | Halloween 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-5-Small.jpg\";s:12:\"tmpl_created\";i:1647858024;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-discount-halloween-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:44:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:95;a:20:{s:4:\"tmpl\";i:1379;s:2:\"id\";i:23422;s:5:\"title\";s:36:\"Classic | Subscription | Halloween 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-4-Small.jpg\";s:12:\"tmpl_created\";i:1647858246;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-halloween-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:48:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:96;a:20:{s:4:\"tmpl\";i:1380;s:2:\"id\";i:23471;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-2-Small.jpg\";s:12:\"tmpl_created\";i:1647859193;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:97;a:20:{s:4:\"tmpl\";i:1381;s:2:\"id\";i:23477;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-4-Small.jpg\";s:12:\"tmpl_created\";i:1647859838;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:98;a:20:{s:4:\"tmpl\";i:1382;s:2:\"id\";i:23483;s:5:\"title\";s:26:\"Fly-In | CTA | Christmas 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-1-Small.jpg\";s:12:\"tmpl_created\";i:1647860157;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/fly-in-cta-christmas-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:99;a:20:{s:4:\"tmpl\";i:1383;s:2:\"id\";i:23489;s:5:\"title\";s:33:\"Slide-In | Discount | Christmas 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-5-Small.jpg\";s:12:\"tmpl_created\";i:1647860302;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-christmas-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:100;a:20:{s:4:\"tmpl\";i:1384;s:2:\"id\";i:23496;s:5:\"title\";s:32:\"Classic | Discount | Christmas 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-3-Small.jpg\";s:12:\"tmpl_created\";i:1647860454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-christmas-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Christmas\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:101;a:20:{s:4:\"tmpl\";i:1385;s:2:\"id\";i:23523;s:5:\"title\";s:30:\"Classic | CTA | Valentines Day\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-2-Small.jpg\";s:12:\"tmpl_created\";i:1647860912;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-valentines-day/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:102;a:20:{s:4:\"tmpl\";i:1386;s:2:\"id\";i:23529;s:5:\"title\";s:39:\"Hello Bar | Discount | Valentines Day 2\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-1-Small.jpg\";s:12:\"tmpl_created\";i:1647861064;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-discount-valentines-day-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:30:\"[\"Discount\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:103;a:20:{s:4:\"tmpl\";i:1387;s:2:\"id\";i:23536;s:5:\"title\";s:32:\"Classic | CTA | Valentines Day 3\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-3-Small.jpg\";s:12:\"tmpl_created\";i:1647861536;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-cta-valentines-day-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:104;a:20:{s:4:\"tmpl\";i:1388;s:2:\"id\";i:23586;s:5:\"title\";s:51:\"Fly-In | Subscribe | Health &#038; Wellness Company\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/35-Subscribe-Health-Wellness-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647862008;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscribe-health-wellness-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:24:\"[\"Business\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:105;a:20:{s:4:\"tmpl\";i:1389;s:2:\"id\";i:23592;s:5:\"title\";s:34:\"Classic | Subscribe | Tech Company\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/36-Subscribe-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647866706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-subscribe-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:106;a:20:{s:4:\"tmpl\";i:1390;s:2:\"id\";i:23598;s:5:\"title\";s:36:\"Classic | Contact Us | Fight Classes\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/37-Contact-Us-Fight-Classes-Small.jpg\";s:12:\"tmpl_created\";i:1647866869;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-contact-us-fight-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:107;a:20:{s:4:\"tmpl\";i:1391;s:2:\"id\";i:23611;s:5:\"title\";s:31:\"Classic | CTA | Mochi Shop Sale\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2022/03/39-Click-Through-Mochi-Shop-Sale-Small.jpg\";s:12:\"tmpl_created\";i:1647867750;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-cta-mochi-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"cta\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:108;a:20:{s:4:\"tmpl\";i:1392;s:2:\"id\";i:23618;s:5:\"title\";s:28:\"Classic | CTA | Fashion Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/40-Click-Through-Fashion-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647868251;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:109;a:20:{s:4:\"tmpl\";i:1393;s:2:\"id\";i:23624;s:5:\"title\";s:29:\"Fly-In | Login | Tech Company\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/41-Login-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647868704;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/fly-in-login-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:110;a:20:{s:4:\"tmpl\";i:1394;s:2:\"id\";i:23630;s:5:\"title\";s:36:\"Fly-In | Verification | Liquor Store\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/42-Verification-Liquor-Store-Small.jpg\";s:12:\"tmpl_created\";i:1647870308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-verification-liquor-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:111;a:20:{s:4:\"tmpl\";i:1395;s:2:\"id\";i:23636;s:5:\"title\";s:39:\"Hello Bar | Subscribe | Online Magazine\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/44-Subscribe-Online-Magazine-Small.jpg\";s:12:\"tmpl_created\";i:1647870465;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-subscribe-online-magazine/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:112;a:20:{s:4:\"tmpl\";i:1396;s:2:\"id\";i:23642;s:5:\"title\";s:27:\"Fly-In | Login | Health Spa\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/43-Login-Health-Spa-Small.jpg\";s:12:\"tmpl_created\";i:1647872427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/fly-in-login-health-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Login\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:113;a:20:{s:4:\"tmpl\";i:1397;s:2:\"id\";i:23648;s:5:\"title\";s:33:\"Fly-In | Verification | Wine Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/45-Verification-Wine-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647872627;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/fly-in-verification-wine-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:114;a:20:{s:4:\"tmpl\";i:1421;s:2:\"id\";i:24235;s:5:\"title\";s:24:\"Ladydog Club &#8211; NFT\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/05/Ladydog_Club.jpg\";s:12:\"tmpl_created\";i:1651525072;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/ladydog-club-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:115;a:20:{s:4:\"tmpl\";i:1422;s:2:\"id\";i:24166;s:5:\"title\";s:15:\"Dot &#8211; NFT\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/05/Dot-250_280.jpg\";s:12:\"tmpl_created\";i:1651525117;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/lp/dot-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:116;a:20:{s:4:\"tmpl\";i:1423;s:2:\"id\";i:24191;s:5:\"title\";s:28:\"Cosmic Neighbors &#8211; NFT\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Cosmic_Neighbors-250_280.jpg\";s:12:\"tmpl_created\";i:1651525124;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/cosmic-neighbors-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:117;a:20:{s:4:\"tmpl\";i:1424;s:2:\"id\";i:24255;s:5:\"title\";s:30:\"Happy Food Friends &#8211; NFT\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/05/Featured_Image.jpg\";s:12:\"tmpl_created\";i:1651525475;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/happy-food-friends-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:118;a:20:{s:4:\"tmpl\";i:1443;s:2:\"id\";i:24599;s:5:\"title\";s:27:\"Wireframe &#8211; Courses 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Courses-1.jpg\";s:12:\"tmpl_created\";i:1653989626;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-courses-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:180:\"[\"About\",\"Academy\",\"Booking\",\"Business\",\"Course Online\",\"Features\",\"Footer\",\"Landing Pages\",\"Online Service\",\"Professional\",\"School\",\"Services\",\"Subscribe\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:119;a:20:{s:4:\"tmpl\";i:1444;s:2:\"id\";i:24614;s:5:\"title\";s:28:\"Wireframe &#8211; Services 1\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1-2.jpg\";s:12:\"tmpl_created\";i:1653990084;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:139:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:120;a:20:{s:4:\"tmpl\";i:1445;s:2:\"id\";i:24629;s:5:\"title\";s:28:\"Wireframe &#8211; Services 2\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2-2.jpg\";s:12:\"tmpl_created\";i:1653990132;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:123:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:121;a:20:{s:4:\"tmpl\";i:1446;s:2:\"id\";i:24644;s:5:\"title\";s:27:\"Wireframe &#8211; Webinar 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Webinar-1.jpg\";s:12:\"tmpl_created\";i:1653990164;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-webinar-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:177:\"[\"About\",\"Academy\",\"Booking\",\"Conference\",\"Course Online\",\"Education\",\"Features\",\"Footer\",\"Form\",\"Landing Pages\",\"Online Event\",\"Online Service\",\"Subscribe\",\"Virtual\",\"Webinar\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:122;a:20:{s:4:\"tmpl\";i:1447;s:2:\"id\";i:24655;s:5:\"title\";s:28:\"Wireframe &#8211; Services 3\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3-2.jpg\";s:12:\"tmpl_created\";i:1653990198;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:143:\"[\"About\",\"Agency\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Portfolio\",\"Professional\",\"Project\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:123;a:20:{s:4:\"tmpl\";i:1448;s:2:\"id\";i:24677;s:5:\"title\";s:28:\"Wireframe &#8211; Services 4\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-4.jpg\";s:12:\"tmpl_created\";i:1653990233;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:102:\"[\"About\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:124;a:20:{s:4:\"tmpl\";i:1449;s:2:\"id\";i:24687;s:5:\"title\";s:28:\"Wireframe &#8211; Products 1\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Products-1.jpg\";s:12:\"tmpl_created\";i:1653990273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-products-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:128:\"[\"About\",\"Booking\",\"Business\",\"Clients\",\"Ecommerce\",\"Features\",\"Footer\",\"Landing Pages\",\"Products\",\"Sales\",\"Shop\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:125;a:20:{s:4:\"tmpl\";i:1450;s:2:\"id\";i:24706;s:5:\"title\";s:28:\"Wireframe &#8211; Services 5\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-5.jpg\";s:12:\"tmpl_created\";i:1653990322;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:149:\"[\"About\",\"Booking\",\"Consulting\",\"Contact\",\"Doctor\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:126;a:20:{s:4:\"tmpl\";i:1451;s:2:\"id\";i:23604;s:5:\"title\";s:38:\"Classic | Subscribe | Nail Polish Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/38-Subscribe-Nail-Polish-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1660205114;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-subscribe-nail-polish-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:127;a:20:{s:4:\"tmpl\";i:1452;s:2:\"id\";i:23047;s:5:\"title\";s:46:\"Fly-In | Contact | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small.jpg\";s:12:\"tmpl_created\";i:1660205149;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/fly-in-contact-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Contact\",\"Ebook\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:128;a:20:{s:4:\"tmpl\";i:1199;s:2:\"id\";i:18839;s:5:\"title\";s:27:\"Hello Bar | CTA | eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/05/350x250.png\";s:12:\"tmpl_created\";i:1621870603;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/hello-bar-cta-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:41:\"[\"Ecommerce\",\"Online Shop\",\"Sale\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:129;a:20:{s:4:\"tmpl\";i:1247;s:2:\"id\";i:21907;s:5:\"title\";s:50:\"Fly-In | Team Details  | Electronic Music Festival\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/Kit-8-electronic-music-festival-CTA-image-1.jpg\";s:12:\"tmpl_created\";i:1646660881;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/fly-in-team-details-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:130;a:20:{s:4:\"tmpl\";i:1253;s:2:\"id\";i:22162;s:5:\"title\";s:46:\"Full Screen | Menu | Electronic Music Festival\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/8-music-festival-Team-Details.jpg\";s:12:\"tmpl_created\";i:1647272934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:154:\"https://library.elementor.com/popups/full-screen-menu-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:131;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:22172;s:5:\"title\";s:45:\"Classic | Discount | Health &#038; Beauty Spa\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/health-beauty-spa-small.jpg\";s:12:\"tmpl_created\";i:1647273547;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-discount-popup-health-beauty-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:36:\"[\"Hair\",\"Health\",\"Sales\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:132;a:20:{s:4:\"tmpl\";i:1255;s:2:\"id\";i:22183;s:5:\"title\";s:44:\"Hello Bar | CTA | Environmental Organization\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/11-Environmental-Organization-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647274384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:152:\"https://library.elementor.com/popups/hello-bar-cta-popup-environmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:133;a:20:{s:4:\"tmpl\";i:1256;s:2:\"id\";i:22195;s:5:\"title\";s:39:\"Classic | Discount | Italian Restaurant\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/restaurant-small.jpg\";s:12:\"tmpl_created\";i:1647329432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-discount-popup-italian-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Restaurant\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:134;a:20:{s:4:\"tmpl\";i:1257;s:2:\"id\";i:22210;s:5:\"title\";s:45:\"Bottom Bar | Discount | Technology Conference\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tech-conference-small.jpg\";s:12:\"tmpl_created\";i:1647330423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/bottom-bar-discount-popup-technology-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:38:\"[\"Conference\",\"Sales\",\"Save the Date\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:135;a:20:{s:4:\"tmpl\";i:1258;s:2:\"id\";i:22221;s:5:\"title\";s:32:\"Hello Bar | Menu | Tattoo Studio\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small-1.jpg\";s:12:\"tmpl_created\";i:1647330705;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/hello-bar-menu-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:17:\"[\"Header\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:136;a:20:{s:4:\"tmpl\";i:1259;s:2:\"id\";i:22231;s:5:\"title\";s:37:\"Full Screen | Booking | Tattoo Studio\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small.jpg\";s:12:\"tmpl_created\";i:1647331823;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-booking-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:137;a:20:{s:4:\"tmpl\";i:1260;s:2:\"id\";i:22251;s:5:\"title\";s:34:\"Classic | Discount | Dental Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/dental-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647332171;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-popup-dental-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Health\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:138;a:20:{s:4:\"tmpl\";i:1261;s:2:\"id\";i:22261;s:5:\"title\";s:34:\"Slide-In | Contact | Makeup Artist\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/20-Makeup-Artist-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647333946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/slide-in-contact-popup-makeup-artist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:139;a:20:{s:4:\"tmpl\";i:1262;s:2:\"id\";i:22271;s:5:\"title\";s:24:\"Fly-In | CTA | Headphone\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/headphones-1-small.jpg\";s:12:\"tmpl_created\";i:1647334784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-cta-popup-headphone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:41:\"[\"cta\",\"Ecommerce\",\"Marketing\",\"Product\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:140;a:20:{s:4:\"tmpl\";i:1263;s:2:\"id\";i:22277;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/online-course-2.jpg\";s:12:\"tmpl_created\";i:1647337110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-popup-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Course Online\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:141;a:20:{s:4:\"tmpl\";i:1264;s:2:\"id\";i:22283;s:5:\"title\";s:40:\"Bottom Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistant-3.jpg\";s:12:\"tmpl_created\";i:1647337517;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-contact-popup-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:142;a:20:{s:4:\"tmpl\";i:1265;s:2:\"id\";i:22289;s:5:\"title\";s:32:\"Fly-In | Contact | Private Tutor\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-4.jpg\";s:12:\"tmpl_created\";i:1647337676;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-contact-popup-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:27:\"[\"Contact\",\"Course Online\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:143;a:20:{s:4:\"tmpl\";i:1266;s:2:\"id\";i:22295;s:5:\"title\";s:31:\"Classic |  Login | Login Travel\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/login-travel-6.jpg\";s:12:\"tmpl_created\";i:1647339467;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-login-popup-login-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:144;a:20:{s:4:\"tmpl\";i:1267;s:2:\"id\";i:22301;s:5:\"title\";s:36:\"Full Screen | Login | Login Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/login-business-7.jpg\";s:12:\"tmpl_created\";i:1647339782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/full-screen-login-popup-login-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:16:\"[\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:145;a:20:{s:4:\"tmpl\";i:1268;s:2:\"id\";i:22307;s:5:\"title\";s:28:\"Classic | Login | Login Blog\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/login-blog-8.jpg\";s:12:\"tmpl_created\";i:1647339986;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-login-popup-login-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:146;a:20:{s:4:\"tmpl\";i:1269;s:2:\"id\";i:22313;s:5:\"title\";s:31:\"Classic | Login | Login Fashion\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/login-fashion-9.jpg\";s:12:\"tmpl_created\";i:1647340204;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-login-popup-login-fashion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Fashion\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:147;a:20:{s:4:\"tmpl\";i:1270;s:2:\"id\";i:22319;s:5:\"title\";s:40:\"Classic |  Login | Login Design Platform\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/03/login-design-platform-10.jpg\";s:12:\"tmpl_created\";i:1647340531;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-login-popup-login-design-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Design\",\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:148;a:20:{s:4:\"tmpl\";i:1271;s:2:\"id\";i:22325;s:5:\"title\";s:36:\"Fly-In | Contact | Digital Marketing\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-marketing-11.jpg\";s:12:\"tmpl_created\";i:1647340770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-contact-popup-digital-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:51:\"[\"Business\",\"Contact\",\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:149;a:20:{s:4:\"tmpl\";i:1272;s:2:\"id\";i:22331;s:5:\"title\";s:36:\"Fly-In | CTA | Dog Cat Food Delivery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/dog-cat-food-delivery-5.jpg\";s:12:\"tmpl_created\";i:1647341069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-cta-popup-dog-cat-food-delivery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Delivery Service\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:150;a:20:{s:4:\"tmpl\";i:1273;s:2:\"id\";i:22337;s:5:\"title\";s:37:\"Full Screen | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-12.jpg\";s:12:\"tmpl_created\";i:1647341370;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-contact-popup-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:151;a:20:{s:4:\"tmpl\";i:1274;s:2:\"id\";i:22343;s:5:\"title\";s:44:\"Classic | Contact | Support Product Platform\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/03/support-13.jpg\";s:12:\"tmpl_created\";i:1647341972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-contact-support-product-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Contact\",\"Support\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:152;a:20:{s:4:\"tmpl\";i:1275;s:2:\"id\";i:22371;s:5:\"title\";s:38:\"Full Screen | Contact | Small Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/small-business-14.jpg\";s:12:\"tmpl_created\";i:1647342508;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-contact-small-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:40:\"[\"Business\",\"Contact\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:153;a:20:{s:4:\"tmpl\";i:1276;s:2:\"id\";i:22377;s:5:\"title\";s:31:\"Classic | Contact | Online Shop\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/online-shop-15.jpg\";s:12:\"tmpl_created\";i:1647352786;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-online-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:154;a:20:{s:4:\"tmpl\";i:1277;s:2:\"id\";i:22383;s:5:\"title\";s:40:\"Classic | Booking | Children Optometrist\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/children-optometrist-16.jpg\";s:12:\"tmpl_created\";i:1647352963;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-booking-children-optometrist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:53:\"[\"Booking\",\"Business\",\"Contact\",\"Education\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:155;a:20:{s:4:\"tmpl\";i:1278;s:2:\"id\";i:22389;s:5:\"title\";s:28:\"Fly-In | Contact | Open Week\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/03/open-week17.jpg\";s:12:\"tmpl_created\";i:1647353281;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-open-week/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:34:\"[\"Business\",\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:156;a:20:{s:4:\"tmpl\";i:1279;s:2:\"id\";i:22397;s:5:\"title\";s:43:\"Full Screen | CTA | Plant Pots Online Store\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/plant-pots-online-store-18.jpg\";s:12:\"tmpl_created\";i:1647353429;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-cta-plant-pots-online-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:33:\"[\"Ecommerce\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:157;a:20:{s:4:\"tmpl\";i:1054;s:2:\"id\";i:15414;s:5:\"title\";s:32:\"Classic | Contact | Dance Studio\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/PopUp.jpg\";s:12:\"tmpl_created\";i:1603180596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-dance-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:762;s:11:\"trend_index\";i:650;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:158;a:20:{s:4:\"tmpl\";i:1398;s:2:\"id\";i:23687;s:5:\"title\";s:32:\"Pizza Promotion &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/48-Pizza-Promotion.jpg\";s:12:\"tmpl_created\";i:1649670575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/pizza-promotion-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:92:\"[\"Business\",\"Cooking\",\"Delivery\",\"Discount\",\"Fast Food\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:159;a:20:{s:4:\"tmpl\";i:1400;s:2:\"id\";i:23751;s:5:\"title\";s:33:\"Baby Sleep Webinar &#8211; Events\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/63-Baby-Sleep-Webinar.jpg\";s:12:\"tmpl_created\";i:1649676065;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/baby-sleep-webinar-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:227:\"[\"Baby\",\"Booking\",\"Business\",\"Children\",\"Course Online\",\"Education\",\"Events\",\"Health\",\"Landing Pages\",\"Life Coach\",\"Lifestyle\",\"Online Event\",\"Online Service\",\"Parenting\",\"Professional\",\"Remote\",\"Services\",\"Training\",\"Webinar\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:160;a:20:{s:4:\"tmpl\";i:1401;s:2:\"id\";i:23776;s:5:\"title\";s:34:\"Ski Hotel Promotion &#8211; Travel\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/04/64-Ski-Hotel-Promotion.jpg\";s:12:\"tmpl_created\";i:1649691720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/ski-hotel-promotion-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Travel\";s:4:\"tags\";s:118:\"[\"Accommodation\",\"Booking\",\"Discount. Landing Pages\",\"Lifestyle\",\"Luxury\",\"Services\",\"Spa\",\"Travel\",\"Trip\",\"Vacation\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:161;a:20:{s:4:\"tmpl\";i:1402;s:2:\"id\";i:23804;s:5:\"title\";s:30:\"Cake Delivery &#8211; Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/04/67-Cake-Delivery.jpg\";s:12:\"tmpl_created\";i:1649692909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/cake-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:101:\"[\"Bakery\",\"Business\",\"Cake\",\"Cooking\",\"Delivery\",\"Discount\",\"Food\",\"Landing Pages\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:162;a:20:{s:4:\"tmpl\";i:1403;s:2:\"id\";i:23832;s:5:\"title\";s:32:\"Furniture Store &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/87-Furniture-Store.jpg\";s:12:\"tmpl_created\";i:1649694812;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/furniture-store-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:232:\"[\"Architecture\",\"Art\",\"Business\",\"Construction\",\"Coupon\",\"Creative\",\"Decor\",\"Designer\",\"Discount\",\"Fashion\",\"Furniture Design\",\"Home\",\"House\",\"Interior Design\",\"Landing Pages\",\"Lifestyle\",\"Products\",\"Professional\",\"Services\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:163;a:20:{s:4:\"tmpl\";i:1404;s:2:\"id\";i:23746;s:5:\"title\";s:22:\"Nails &#8211; Business\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/04/62-Nails-1.jpg\";s:12:\"tmpl_created\";i:1649704635;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/nails-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:173:\"[\"Art\",\"Beauty\",\"Business\",\"Colorful\",\"Cosmetics\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Girly\",\"Landing Pages\",\"Lifestyle\",\"Manicure\",\"Modern\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:164;a:20:{s:4:\"tmpl\";i:1405;s:2:\"id\";i:23846;s:5:\"title\";s:29:\"Music Festival &#8211; Events\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/04/88-Music-Festival.jpg\";s:12:\"tmpl_created\";i:1649707763;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/music-festival-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:128:\"[\"Author\",\"Booking\",\"Business\",\"Creative\",\"Discount\",\"Events\",\"Landing Pages\",\"Music\",\"Online\",\"Online Event\",\"Party\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:165;a:20:{s:4:\"tmpl\";i:1406;s:2:\"id\";i:23872;s:5:\"title\";s:40:\"Fashion Styling Course &#8211; Education\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/89-Fashion-Styling-Course.jpg\";s:12:\"tmpl_created\";i:1649708569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/fashion-styling-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:173:\"[\"Aesthetic\",\"Art\",\"Beauty\",\"Business\",\"Course Online\",\"Creative\",\"Discount\",\"Education\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Online\",\"Online Service\",\"Stylist\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:166;a:20:{s:4:\"tmpl\";i:1407;s:2:\"id\";i:23897;s:5:\"title\";s:33:\"Bags Online Shop &#8211; Business\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/04/90-Bags-Online-Shop.jpg\";s:12:\"tmpl_created\";i:1649709513;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/bags-online-shop-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:170:\"[\"Art\",\"Bag\",\"Business\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Luxury\",\"Modern\",\"Online\",\"Online Shop\",\"Products\",\"Sales\",\"Shop\",\"Stylist\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:167;a:20:{s:4:\"tmpl\";i:1408;s:2:\"id\";i:23932;s:5:\"title\";s:32:\"Cooking Academy &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/91-Cooking-Academy.jpg\";s:12:\"tmpl_created\";i:1649710216;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/cooking-academy-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:145:\"[\"Academy\",\"Booking\",\"Business\",\"Chef\",\"Cooking\",\"Education\",\"Food\",\"Free Trial\",\"Landing Pages\",\"Professional\",\"School\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:168;a:20:{s:4:\"tmpl\";i:1409;s:2:\"id\";i:23970;s:5:\"title\";s:45:\"Ophthalmology Medical Clinic &#8211; Business\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/04/92-Ophthalmology-Medical-Clinic.jpg\";s:12:\"tmpl_created\";i:1649711096;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/ophthalmology-medical-clinic-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:165:\"[\"About\",\"Business\",\"Care\",\"Consulting\",\"Eye\",\"Free Trial\",\"Glasses\",\"Health\",\"Landing Pages\",\"Lifestyle\",\"Medical\",\"Modern\",\"Optometrist\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:169;a:20:{s:4:\"tmpl\";i:1425;s:2:\"id\";i:24331;s:5:\"title\";s:24:\"Wireframe &#8211; Home 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-1.jpg\";s:12:\"tmpl_created\";i:1653988363;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:170;a:20:{s:4:\"tmpl\";i:1218;s:2:\"id\";i:20792;s:5:\"title\";s:26:\"Luxury Car &#8211; Product\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/11/250x280-1.jpg\";s:12:\"tmpl_created\";i:1636903770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/lp/luxury-car-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:54:\"[\"car\",\"Ecommerce\",\"Landing Pages\",\"Luxury\",\"Product\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:171;a:20:{s:4:\"tmpl\";i:1428;s:2:\"id\";i:24398;s:5:\"title\";s:25:\"Wireframe &#8211; About 1\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-1.jpg\";s:12:\"tmpl_created\";i:1653988534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:83:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Professional\",\"Services\",\"Team\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:172;a:20:{s:4:\"tmpl\";i:991;s:2:\"id\";i:13413;s:5:\"title\";s:33:\"Classic | Contact | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Help.jpg\";s:12:\"tmpl_created\";i:1587474761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-contact-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:530;s:11:\"trend_index\";i:369;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:173;a:20:{s:4:\"tmpl\";i:1053;s:2:\"id\";i:15272;s:5:\"title\";s:32:\"Classic | Contact | Psychologist\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/PopUp.png\";s:12:\"tmpl_created\";i:1600170487;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:578;s:11:\"trend_index\";i:312;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:174;a:20:{s:4:\"tmpl\";i:899;s:2:\"id\";i:11839;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Header_small.png\";s:12:\"tmpl_created\";i:1569430015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"header\",\"portfolio\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:189;s:11:\"trend_index\";i:20;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:175;a:20:{s:4:\"tmpl\";i:1433;s:2:\"id\";i:24477;s:5:\"title\";s:27:\"Wireframe &#8211; Gallery 2\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-2.jpg\";s:12:\"tmpl_created\";i:1653988835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-gallery-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"Business\",\"Contact\",\"Design\",\"Footer\",\"Gallery\",\"Header\",\"Portfolio\",\"Services\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:176;a:20:{s:4:\"tmpl\";i:1205;s:2:\"id\";i:20233;s:5:\"title\";s:32:\"Art Magazine &#8211; Coming Soon\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633881371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/art-magazine-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:48:\"[\"Art\",\"Coming Soon\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:177;a:20:{s:4:\"tmpl\";i:1214;s:2:\"id\";i:20539;s:5:\"title\";s:31:\"Design Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:47:\"[\"Blog\",\"Coming Soon\",\"Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:178;a:20:{s:4:\"tmpl\";i:1224;s:2:\"id\";i:21013;s:5:\"title\";s:24:\"Restaurant &#8211; About\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/12/7-About-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638795588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/restaurant-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:36:\"[\"About\",\"Chef\",\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:179;a:20:{s:4:\"tmpl\";i:992;s:2:\"id\";i:13402;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/04/Popup-Course-Completed.jpg\";s:12:\"tmpl_created\";i:1587474772;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:619;s:11:\"trend_index\";i:582;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:180;a:20:{s:4:\"tmpl\";i:1206;s:2:\"id\";i:20254;s:5:\"title\";s:41:\"Digital Marketing Agency &#8211; Business\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Digital-Marketing-Agency-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/lp/digital-marketing-agency-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:65:\"[\"Agency\",\"Business\",\"Digital Agency\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:181;a:20:{s:4:\"tmpl\";i:1235;s:2:\"id\";i:21281;s:5:\"title\";s:25:\"Law Firm &#8211; Services\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/16-Services-Law-firm.jpg\";s:12:\"tmpl_created\";i:1638819128;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/law-firm-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Consulting\",\"Law\",\"Law Firm\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:182;a:20:{s:4:\"tmpl\";i:1017;s:2:\"id\";i:14111;s:5:\"title\";s:36:\"Classic | Japanese restaurant | Sale\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1592300400;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-japanese-restaurant-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:717;s:11:\"trend_index\";i:697;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:183;a:20:{s:4:\"tmpl\";i:1213;s:2:\"id\";i:20509;s:5:\"title\";s:40:\"Dogs Adoption &#8211; Social Involvement\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/10/Dog-Adoption-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/dogs-adoption-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:49:\"[\"Adoption\",\"Involvement\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:184;a:20:{s:4:\"tmpl\";i:1233;s:2:\"id\";i:21205;s:5:\"title\";s:29:\"Photographer &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/25-Projects-Photographer.jpg\";s:12:\"tmpl_created\";i:1638818372;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/photographer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:43:\"[\"Black and white\",\"Photography\",\"Project\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:185;a:20:{s:4:\"tmpl\";i:993;s:2:\"id\";i:13422;s:5:\"title\";s:30:\"Classic | Menu | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1587474782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-menu-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:516;s:11:\"trend_index\";i:432;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:186;a:20:{s:4:\"tmpl\";i:925;s:2:\"id\";i:12540;s:5:\"title\";s:33:\"Classic | Menu | Travel and tours\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_Menu_s.png\";s:12:\"tmpl_created\";i:1575960267;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-menu-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:690;s:11:\"trend_index\";i:714;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:187;a:20:{s:4:\"tmpl\";i:1208;s:2:\"id\";i:20361;s:5:\"title\";s:51:\"Exercise &#038; Fitness Equipment &#8211; eCommerce\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2021/10/Exercise-Fitness-Equipment-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633883766;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/lp/exercise-fitness-equipment-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Fitness\",\"Health\",\"Landing Pages\",\"Online Shop\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:188;a:20:{s:4:\"tmpl\";i:1239;s:2:\"id\";i:21373;s:5:\"title\";s:28:\"Photographer &#8211; Gallery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/18-Gallery-Photographer.jpg\";s:12:\"tmpl_created\";i:1638821177;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/photographer-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Gallery\",\"Photography\",\"Portfolio\",\"Project\",\"Travel\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:189;a:20:{s:4:\"tmpl\";i:1426;s:2:\"id\";i:24348;s:5:\"title\";s:24:\"Wireframe &#8211; Home 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-2.jpg\";s:12:\"tmpl_created\";i:1653988444;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:190;a:20:{s:4:\"tmpl\";i:958;s:2:\"id\";i:13129;s:5:\"title\";s:28:\"Classic | Menu | Photography\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/PopUp_s.png\";s:12:\"tmpl_created\";i:1582092645;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-menu-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:646;s:11:\"trend_index\";i:521;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:191;a:20:{s:4:\"tmpl\";i:1427;s:2:\"id\";i:24366;s:5:\"title\";s:24:\"Wireframe &#8211; Home 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-3.jpg\";s:12:\"tmpl_created\";i:1653988491;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:192;a:20:{s:4:\"tmpl\";i:1207;s:2:\"id\";i:20299;s:5:\"title\";s:51:\"Interior Design Consultation &#8211; Online Service\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2021/10/Interior-Design-Consultation-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882989;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/lp/interior-design-consultation-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:65:\"[\"Consulting\",\"Interior Design\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:193;a:20:{s:4:\"tmpl\";i:952;s:2:\"id\";i:12726;s:5:\"title\";s:52:\"Classic | Newsletter | Subscribe | Magazine and Blog\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_Newsletter_s.png\";s:12:\"tmpl_created\";i:1579061019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:152:\"https://library.elementor.com/popups/classic-newsletter-subscribe-magazine-and-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:357;s:11:\"trend_index\";i:281;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:194;a:20:{s:4:\"tmpl\";i:883;s:2:\"id\";i:11468;s:5:\"title\";s:20:\"Classic | Sale | Gym\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/PopUp_Small.png\";s:12:\"tmpl_created\";i:1567393182;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-sale-gym/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:696;s:11:\"trend_index\";i:740;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:195;a:20:{s:4:\"tmpl\";i:1216;s:2:\"id\";i:20623;s:5:\"title\";s:57:\"Luxurious Camping Accommodation For Events &#8211; Events\";s:9:\"thumbnail\";s:113:\"https://library.elementor.com/wp-content/uploads/2021/10/Luxurious-Camping-Accommodation-For-Events-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634041681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:151:\"https://library.elementor.com/lp/luxurious-camping-accommodation-for-events-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:43:\"[\"Event\",\"Events\",\"Landing Pages\",\"Travel\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:196;a:20:{s:4:\"tmpl\";i:1219;s:2:\"id\";i:20886;s:5:\"title\";s:28:\"Online Training &#8211; Home\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/12/2-Home-Online-Training.jpg\";s:12:\"tmpl_created\";i:1638784769;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/online-training-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Online\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:197;a:20:{s:4:\"tmpl\";i:1065;s:2:\"id\";i:15570;s:5:\"title\";s:33:\"Classic | Subscribe | Travel Blog\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp.jpg\";s:12:\"tmpl_created\";i:1606215555;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscribe-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:709;s:11:\"trend_index\";i:459;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:198;a:20:{s:4:\"tmpl\";i:1431;s:2:\"id\";i:24437;s:5:\"title\";s:25:\"Wireframe &#8211; About 4\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-4.jpg\";s:12:\"tmpl_created\";i:1653988733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:74:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:199;a:20:{s:4:\"tmpl\";i:1210;s:2:\"id\";i:20414;s:5:\"title\";s:45:\"Online English Courses &#8211; Online Service\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Online-English-Courses-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/online-english-courses-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:50:\"[\"Course Online\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:200;a:20:{s:4:\"tmpl\";i:1132;s:2:\"id\";i:16553;s:5:\"title\";s:31:\"Fly-In | Contact | Beauty Salon\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/12/PopUp.jpg\";s:12:\"tmpl_created\";i:1608622602;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-contact-beauty-salon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:691;s:11:\"trend_index\";i:428;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:201;a:20:{s:4:\"tmpl\";i:1441;s:2:\"id\";i:24574;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 5\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-5.jpg\";s:12:\"tmpl_created\";i:1653989135;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:88:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Google Maps\",\"Header\",\"Professional\",\"Subscribe\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:202;a:20:{s:4:\"tmpl\";i:1217;s:2:\"id\";i:20333;s:5:\"title\";s:40:\"Plant Pots Online Shop &#8211; eCommerce\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Plant-Pots-Online-Shop-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634042184;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/plant-pots-online-shop-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Ecommerce\",\"Landing Pages\",\"Online Shop\",\"Shop\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:203;a:20:{s:4:\"tmpl\";i:1211;s:2:\"id\";i:20447;s:5:\"title\";s:33:\"Shared Workspace &#8211; Business\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Shared-Workspace.jpg\";s:12:\"tmpl_created\";i:1633884934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/shared-workspace-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:28:\"[\"Business\",\"Landing Pages\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:204;a:20:{s:4:\"tmpl\";i:1237;s:2:\"id\";i:21313;s:5:\"title\";s:34:\"Spa &#038; Beauty &#8211; Services\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/12/Spa-Beauty-Treatments-page-1.jpg\";s:12:\"tmpl_created\";i:1638819709;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/spa-beauty-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:55:\"[\"Beauty\",\"Hair\",\"Health\",\"Services\",\"Spa\",\"Treatment\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:205;a:20:{s:4:\"tmpl\";i:1004;s:2:\"id\";i:13538;s:5:\"title\";s:32:\"Fly-In | Newsletter | Barbershop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/05/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1589893364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-newsletter-barbershop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:710;s:11:\"trend_index\";i:667;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:206;a:20:{s:4:\"tmpl\";i:924;s:2:\"id\";i:12550;s:5:\"title\";s:32:\"Fly-in | Sale | Travel and Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_s.png\";s:12:\"tmpl_created\";i:1575960263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/flyin-sale-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:754;s:11:\"trend_index\";i:791;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:207;a:20:{s:4:\"tmpl\";i:1212;s:2:\"id\";i:20479;s:5:\"title\";s:49:\"Teeth Straightening &#8211; Health &#038; Fitness\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Teeth-Whitening.jpg\";s:12:\"tmpl_created\";i:1633886115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/teeth-straightening-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:46:\"[\"Business\",\"Dental\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:208;a:20:{s:4:\"tmpl\";i:1234;s:2:\"id\";i:21234;s:5:\"title\";s:34:\"Insurance Company &#8211; Services\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/12/15-Services-Insurance-Company.jpg\";s:12:\"tmpl_created\";i:1638818688;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/insurance-company-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"Faq\",\"Form\",\"Insurance\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:209;a:20:{s:4:\"tmpl\";i:1035;s:2:\"id\";i:15062;s:5:\"title\";s:35:\"Fly-In | Sign up | Flooring Company\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp.png\";s:12:\"tmpl_created\";i:1597739629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/fly-in-sign-up-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:625;s:11:\"trend_index\";i:309;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:210;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:20394;s:5:\"title\";s:30:\"Time Management &#8211; Events\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/10/Time-Management-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884077;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/time-management-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:17:\"[\"Landing Pages\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:211;a:20:{s:4:\"tmpl\";i:1229;s:2:\"id\";i:21118;s:5:\"title\";s:28:\"Contact &#8211; Plants Store\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/12-Contact-Plants-Store.jpg\";s:12:\"tmpl_created\";i:1638802472;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/contact-plants-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:40:\"[\"Contact\",\"Info\",\"Plant\",\"Testimonial\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:212;a:20:{s:4:\"tmpl\";i:893;s:2:\"id\";i:11822;s:5:\"title\";s:30:\"Full Screen | Menu | Portfolio\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/PopUp_small.png\";s:12:\"tmpl_created\";i:1569429896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/full-screen-menu-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:654;s:11:\"trend_index\";i:626;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:213;a:20:{s:4:\"tmpl\";i:1203;s:2:\"id\";i:18591;s:5:\"title\";s:28:\"Coffee Sale &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280-7.png\";s:12:\"tmpl_created\";i:1633877319;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/coffee-sale-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:33:\"[\"Coffee\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:214;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:21184;s:5:\"title\";s:28:\"Dental Care &#8211; Services\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/14-Services-Dental-Care.jpg\";s:12:\"tmpl_created\";i:1638807148;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dental-care-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:45:\"[\"Dental\",\"Medical\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:215;a:20:{s:4:\"tmpl\";i:1064;s:2:\"id\";i:15580;s:5:\"title\";s:31:\"Fullscreen | Menu | Travel Blog\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1606215358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fullscreen-menu-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:673;s:11:\"trend_index\";i:348;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:216;a:20:{s:4:\"tmpl\";i:1133;s:2:\"id\";i:16645;s:5:\"title\";s:28:\"Headphones &#8211; eCommerce\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_headphones.png\";s:12:\"tmpl_created\";i:1609944115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/commerce-headphones/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:39:\"[\"Ecommerce\",\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:633;s:11:\"trend_index\";i:87;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:217;a:20:{s:4:\"tmpl\";i:1442;s:2:\"id\";i:24584;s:5:\"title\";s:27:\"Wireframe &#8211; Pricing 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Pricing-1.jpg\";s:12:\"tmpl_created\";i:1653989152;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-pricing-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:146:\"[\"Booking\",\"Business\",\"Clients\",\"Contact\",\"Faq\",\"Features\",\"Footer\",\"Online Service\",\"Pricing\",\"Products\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:218;a:20:{s:4:\"tmpl\";i:1138;s:2:\"id\";i:16762;s:5:\"title\";s:25:\"Conference &#8211; Events\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Conference.png\";s:12:\"tmpl_created\";i:1610455119;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/conference-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:60:\"[\"Conference\",\"Convention\",\"Event\",\"Events\",\"Landing Pages\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:705;s:11:\"trend_index\";i:216;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:219;a:20:{s:4:\"tmpl\";i:1438;s:2:\"id\";i:24539;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 2\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-2.jpg\";s:12:\"tmpl_created\";i:1653989019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:69:\"[\"Business\",\"Contact\",\"Footer\",\"Google Maps\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:220;a:20:{s:4:\"tmpl\";i:981;s:2:\"id\";i:13281;s:5:\"title\";s:37:\"Hello Bar | Contact | Interior Design\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp.png\";s:12:\"tmpl_created\";i:1586148801;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/hello-bar-contact-interior-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:19:\"[\"Interior Design\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:763;s:11:\"trend_index\";i:679;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:221;a:20:{s:4:\"tmpl\";i:1052;s:2:\"id\";i:15259;s:5:\"title\";s:31:\"Hello Bar | Menu | Psychologist\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Menu-PopUp.png\";s:12:\"tmpl_created\";i:1600170209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/hello-bar-menu-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:739;s:11:\"trend_index\";i:583;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:222;a:20:{s:4:\"tmpl\";i:1434;s:2:\"id\";i:24494;s:5:\"title\";s:28:\"Wireframe &#8211; Services 1\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1.jpg\";s:12:\"tmpl_created\";i:1653988874;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:53:\"[\"Business\",\"Faq\",\"Footer\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:223;a:20:{s:4:\"tmpl\";i:1194;s:2:\"id\";i:18701;s:5:\"title\";s:32:\"Digital Course &#8211; eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280.jpg\";s:12:\"tmpl_created\";i:1618995134;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/digital-course-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:57:\"[\"Course Online\",\"Ecommerce\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:224;a:20:{s:4:\"tmpl\";i:1192;s:2:\"id\";i:18612;s:5:\"title\";s:34:\"Bag Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bag-Product.jpeg\";s:12:\"tmpl_created\";i:1618395406;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/bag-product-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:61:\"[\"Bag\",\"Ecommerce\",\"Landing Pages\",\"Product\",\"Sale\",\"Travel\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:875;s:11:\"trend_index\";i:605;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:225;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:21083;s:5:\"title\";s:26:\"Conference &#8211; Contact\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/10-Contact-Conference.jpg\";s:12:\"tmpl_created\";i:1638799208;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/conference-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:44:\"[\"Conference\",\"Contact\",\"Form\",\"Info\",\"Map\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:226;a:20:{s:4:\"tmpl\";i:1193;s:2:\"id\";i:18644;s:5:\"title\";s:37:\"Camera Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/camera_sale_featured-img.jpg\";s:12:\"tmpl_created\";i:1618396388;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/camera-product-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:59:\"[\"Camera\",\"Ecommerce\",\"Landing Pages\",\"Photography\",\"Sale\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:873;s:11:\"trend_index\";i:535;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:227;a:20:{s:4:\"tmpl\";i:951;s:2:\"id\";i:12736;s:5:\"title\";s:41:\"Slide In | Contact Us | Magazine and Blog\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_contact_s.png\";s:12:\"tmpl_created\";i:1579060978;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/slide-in-contact-us/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:734;s:11:\"trend_index\";i:686;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:228;a:20:{s:4:\"tmpl\";i:1222;s:2:\"id\";i:20960;s:5:\"title\";s:26:\"Travel Agency &#8211; Home\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/5-Home-Travel-Agency.jpg\";s:12:\"tmpl_created\";i:1638788432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/travel-agency-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:53:\"[\"Adventures\",\"Experience\",\"Explore\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:229;a:20:{s:4:\"tmpl\";i:1196;s:2:\"id\";i:18815;s:5:\"title\";s:25:\"Car Wash &#8211; Business\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Car-Wash.png\";s:12:\"tmpl_created\";i:1621336431;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/car-wash-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:45:\"[\"Business\",\"car\",\"Discount\",\"Landing Pages\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:230;a:20:{s:4:\"tmpl\";i:1242;s:2:\"id\";i:21473;s:5:\"title\";s:40:\"Architecture Photography &#8211; Gallery\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2021/12/20-Gallery-Architecture-Photography.jpg\";s:12:\"tmpl_created\";i:1638822115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/architecture-photography-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:52:\"[\"Architecture\",\"Gallery\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:231;a:20:{s:4:\"tmpl\";i:1015;s:2:\"id\";i:14067;s:5:\"title\";s:37:\"Slide In | Japanese restaurant | Menu\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Menu-Pop-Up-Small.jpg\";s:12:\"tmpl_created\";i:1592290352;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/slide-in-japanese-restaurant-menu/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:650;s:11:\"trend_index\";i:565;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:232;a:20:{s:4:\"tmpl\";i:923;s:2:\"id\";i:12229;s:5:\"title\";s:33:\"Slide In | Law Firm | Information\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/11/popup.png\";s:12:\"tmpl_created\";i:1572847842;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-law-firm-information/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:547;s:11:\"trend_index\";i:413;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:233;a:20:{s:4:\"tmpl\";i:1198;s:2:\"id\";i:18824;s:5:\"title\";s:33:\"Design School &#8211; Coming Soon\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/05/250x280-1.png\";s:12:\"tmpl_created\";i:1621336756;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/design-school-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:49:\"[\"Coming Soon\",\"Design\",\"Landing Pages\",\"School\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:234;a:20:{s:4:\"tmpl\";i:1236;s:2:\"id\";i:21259;s:5:\"title\";s:28:\"3D Designer &#8211; Projects\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/24-Projects-3D-Designer.jpg\";s:12:\"tmpl_created\";i:1638819185;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/3d-designer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:69:\"[\"3D\",\"Creative Portfolio\",\"Design\",\"Designer\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:235;a:20:{s:4:\"tmpl\";i:1028;s:2:\"id\";i:14827;s:5:\"title\";s:39:\"Slide-In | Contact | Luxury Real Estate\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/07/PopUp.png\";s:12:\"tmpl_created\";i:1595323523;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/slide-in-contact-luxury-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:559;s:11:\"trend_index\";i:284;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:236;a:20:{s:4:\"tmpl\";i:1197;s:2:\"id\";i:18819;s:5:\"title\";s:27:\"Dog Walker &#8211; Business\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Dog-Walker.png\";s:12:\"tmpl_created\";i:1621336601;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/dog-walker-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:41:\"[\"Business\",\"Dog\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:237;a:20:{s:4:\"tmpl\";i:1238;s:2:\"id\";i:21349;s:5:\"title\";s:29:\"Architecture &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/23-Projects-Architecture.jpg\";s:12:\"tmpl_created\";i:1638820870;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/architecture-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:70:\"[\"Architecture\",\"Creative\",\"Creative Portfolio\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:238;a:20:{s:4:\"tmpl\";i:1034;s:2:\"id\";i:15075;s:5:\"title\";s:34:\"Slide-In | Menu | Flooring Company\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp-1.png\";s:12:\"tmpl_created\";i:1597739605;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/slide-in-menu-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:383;s:11:\"trend_index\";i:162;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:239;a:20:{s:4:\"tmpl\";i:1414;s:2:\"id\";i:24079;s:5:\"title\";s:32:\"Fashion Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Fashion-Shop.jpg\";s:12:\"tmpl_created\";i:1650988089;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/fashion-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:88:\"[\"Aesthetic\",\"Business\",\"Coming Soon\",\"Ecommerce\",\"Girly\",\"Lifestyle\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:240;a:20:{s:4:\"tmpl\";i:1195;s:2:\"id\";i:18761;s:5:\"title\";s:33:\"Fashion Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png\";s:12:\"tmpl_created\";i:1621336146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/fashion-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:56:\"[\"Coming Soon\",\"Fashion\",\"Landing Pages\",\"Shop\",\"store\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:241;a:20:{s:4:\"tmpl\";i:1153;s:2:\"id\";i:17060;s:5:\"title\";s:36:\"Private Tutor &#8211; Online Service\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Tutor-2.png\";s:12:\"tmpl_created\";i:1610631042;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/private-tutor-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:64:\"[\"Education\",\"Landing Pages\",\"Online Service\",\"Teacher\",\"Tutor\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:780;s:11:\"trend_index\";i:628;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:242;a:20:{s:4:\"tmpl\";i:1430;s:2:\"id\";i:24434;s:5:\"title\";s:25:\"Wireframe &#8211; About 3\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-3.jpg\";s:12:\"tmpl_created\";i:1653988697;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:76:\"[\"About\",\"Business\",\"Contact\",\"Faq\",\"Footer\",\"Header\",\"Professional\",\"Team\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:243;a:20:{s:4:\"tmpl\";i:1158;s:2:\"id\";i:17232;s:5:\"title\";s:33:\"Life Coach &#8211; Online Service\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Life-Coach.png\";s:12:\"tmpl_created\";i:1610902793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/life-coach-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:38:\"[\"Coach\",\"Landing Pages\",\"Life Coach\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:787;s:11:\"trend_index\";i:751;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:244;a:20:{s:4:\"tmpl\";i:1436;s:2:\"id\";i:24515;s:5:\"title\";s:28:\"Wireframe &#8211; Services 3\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3.jpg\";s:12:\"tmpl_created\";i:1653988946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:66:\"[\"Business\",\"Contact\",\"Footer\",\"Header\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:245;a:20:{s:4:\"tmpl\";i:875;s:2:\"id\";i:11241;s:5:\"title\";s:36:\"Classic | Digital Agency | Marketing\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/PopUp_small.jpg\";s:12:\"tmpl_created\";i:1564643043;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-digital-agency-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:362;s:11:\"trend_index\";i:315;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:246;a:20:{s:4:\"tmpl\";i:1146;s:2:\"id\";i:16932;s:5:\"title\";s:35:\"Finance Consulting &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/01/Finance-Consulting.png\";s:12:\"tmpl_created\";i:1610532170;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/lp/finance-consulting-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:80:\"[\"Advisor\",\"Business\",\"Consulting\",\"Finance\",\"Investment\",\"Landing Pages\",\"Tax\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:790;s:11:\"trend_index\";i:630;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:247;a:20:{s:4:\"tmpl\";i:1429;s:2:\"id\";i:24421;s:5:\"title\";s:25:\"Wireframe &#8211; About 2\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-2.jpg\";s:12:\"tmpl_created\";i:1653988579;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:87:\"[\"About\",\"Business\",\"Contact\",\"Faq\",\"Features\",\"Footer\",\"Header\",\"Professional\",\"Team\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:248;a:20:{s:4:\"tmpl\";i:674;s:2:\"id\";i:8505;s:5:\"title\";s:11:\"404 page 01\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/001.jpg\";s:12:\"tmpl_created\";i:1526415501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:533;s:11:\"trend_index\";i:222;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:249;a:20:{s:4:\"tmpl\";i:1136;s:2:\"id\";i:16721;s:5:\"title\";s:35:\"Dental &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2021/01/Dental.jpg\";s:12:\"tmpl_created\";i:1610448567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/dental-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:44:\"[\"Dental\",\"Doctor\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:801;s:11:\"trend_index\";i:655;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:250;a:20:{s:4:\"tmpl\";i:1417;s:2:\"id\";i:24116;s:5:\"title\";s:32:\"Tech Company &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Tech-Company.jpg\";s:12:\"tmpl_created\";i:1650989265;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/tech-company-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:87:\"[\"Business\",\"Coding\",\"Coming Soon\",\"Computer\",\"Developer\",\"IT\",\"Services\",\"Technology\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:251;a:20:{s:4:\"tmpl\";i:675;s:2:\"id\";i:8511;s:5:\"title\";s:11:\"404 page 02\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/002.jpg\";s:12:\"tmpl_created\";i:1526415528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-02/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:347;s:11:\"trend_index\";i:155;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:252;a:20:{s:4:\"tmpl\";i:1161;s:2:\"id\";i:17269;s:5:\"title\";s:34:\"Electronics Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Electronic-Products.png\";s:12:\"tmpl_created\";i:1610903298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/electronics-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:29:\"[\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:800;s:11:\"trend_index\";i:556;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:253;a:20:{s:4:\"tmpl\";i:1220;s:2:\"id\";i:20908;s:5:\"title\";s:42:\"Packing &#038; Moving Company &#8211; Home\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/12/3-Home-Packing-Moving-Company.jpg\";s:12:\"tmpl_created\";i:1638786127;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/packing-moving-company-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Movers\",\"Moving\",\"Storge\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:254;a:20:{s:4:\"tmpl\";i:1152;s:2:\"id\";i:17032;s:5:\"title\";s:42:\"Donate Computer &#8211; Social Involvement\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Donation-2.png\";s:12:\"tmpl_created\";i:1610630585;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/donate-computer-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:67:\"[\"Computer\",\"Donate\",\"Donation\",\"Kids\",\"Landing Pages\",\"Nonprofit\"]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:718;s:11:\"trend_index\";i:278;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:255;a:20:{s:4:\"tmpl\";i:672;s:2:\"id\";i:8512;s:5:\"title\";s:11:\"404 page 03\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/003.jpg\";s:12:\"tmpl_created\";i:1526415449;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-03/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:450;s:11:\"trend_index\";i:375;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:256;a:20:{s:4:\"tmpl\";i:1245;s:2:\"id\";i:21546;s:5:\"title\";s:28:\"Interior Design &#8211; Home\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/1-Home-Interior-Design-1.jpg\";s:12:\"tmpl_created\";i:1639046269;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/interior-design-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:68:\"[\"Design\",\"Form\",\"Furniture Design\",\"Interior Design\",\"Testimonial\"]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:257;a:20:{s:4:\"tmpl\";i:1135;s:2:\"id\";i:16684;s:5:\"title\";s:34:\"SaaS HR Management &#8211; Product\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_hr.png\";s:12:\"tmpl_created\";i:1609945486;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/saas-hr-management-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:39:\"[\"HR\",\"Landing Pages\",\"Product\",\"SaaS\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:708;s:11:\"trend_index\";i:292;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:258;a:20:{s:4:\"tmpl\";i:671;s:2:\"id\";i:8513;s:5:\"title\";s:11:\"404 page 04\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/004.jpg\";s:12:\"tmpl_created\";i:1526415417;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-04/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:420;s:11:\"trend_index\";i:176;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:259;a:20:{s:4:\"tmpl\";i:1249;s:2:\"id\";i:22137;s:5:\"title\";s:31:\"Design Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1647177194;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:47:\"[\"Blog\",\"Coming Soon\",\"Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:260;a:20:{s:4:\"tmpl\";i:1134;s:2:\"id\";i:16660;s:5:\"title\";s:37:\"Medical center &#8211; Online service\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-medical-cosultation-250_280.png\";s:12:\"tmpl_created\";i:1609945122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/medical-center-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:44:\"[\"Landing Pages\",\"Medical\",\"Online Service\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:750;s:11:\"trend_index\";i:332;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:261;a:20:{s:4:\"tmpl\";i:1226;s:2:\"id\";i:21069;s:5:\"title\";s:21:\"Hotel &#8211; Contact\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/12/9-Contact-Hotel.jpg\";s:12:\"tmpl_created\";i:1638798545;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/hotel-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:36:\"[\"Contact\",\"from\",\"Info\",\"Vacation\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:262;a:20:{s:4:\"tmpl\";i:1150;s:2:\"id\";i:17001;s:5:\"title\";s:36:\"Parental Counseling &#8211; Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2021/01/Parenting-Coach-2.png\";s:12:\"tmpl_created\";i:1610534999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/parental-counseling-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:99:\"[\"Advisor\",\"Business\",\"Coach\",\"Counseling\",\"Landing Pages\",\"Online Service\",\"Parental\",\"Parenting\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:817;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:263;a:20:{s:4:\"tmpl\";i:1432;s:2:\"id\";i:24461;s:5:\"title\";s:27:\"Wireframe &#8211; Gallery 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-1.jpg\";s:12:\"tmpl_created\";i:1653988784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-gallery-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"Business\",\"Contact\",\"Design\",\"Footer\",\"Gallery\",\"Header\",\"Portfolio\",\"Services\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:264;a:20:{s:4:\"tmpl\";i:676;s:2:\"id\";i:8514;s:5:\"title\";s:11:\"404 Page 05\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/005.jpg\";s:12:\"tmpl_created\";i:1526415558;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-05/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:419;s:11:\"trend_index\";i:220;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:265;a:20:{s:4:\"tmpl\";i:1137;s:2:\"id\";i:16742;s:5:\"title\";s:31:\"Online Course &#8211; Education\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Course.png\";s:12:\"tmpl_created\";i:1610454122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/online-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:55:\"[\"Academy\",\"Course Online\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:777;s:11:\"trend_index\";i:776;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:266;a:20:{s:4:\"tmpl\";i:668;s:2:\"id\";i:8523;s:5:\"title\";s:11:\"404 page 06\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/006.jpg\";s:12:\"tmpl_created\";i:1526415291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-06/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:298;s:11:\"trend_index\";i:268;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:267;a:20:{s:4:\"tmpl\";i:1440;s:2:\"id\";i:24563;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 4\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-4.jpg\";s:12:\"tmpl_created\";i:1653989095;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:84:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Gallery\",\"Header\",\"Professional\",\"Subscribe\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:268;a:20:{s:4:\"tmpl\";i:1162;s:2:\"id\";i:17284;s:5:\"title\";s:38:\"Dietitian &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/01/Dietitian.png\";s:12:\"tmpl_created\";i:1610903484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/dietitian-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Health\",\"landscape design\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:814;s:11:\"trend_index\";i:800;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:269;a:20:{s:4:\"tmpl\";i:1439;s:2:\"id\";i:24553;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 3\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-3.jpg\";s:12:\"tmpl_created\";i:1653989057;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:67:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Professional\",\"Testimonial\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:270;a:20:{s:4:\"tmpl\";i:1144;s:2:\"id\";i:16897;s:5:\"title\";s:30:\"Personal Chef &#8211; Business\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Personal-Chef.png\";s:12:\"tmpl_created\";i:1610466247;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/personal-chef-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:53:\"[\"Business\",\"Chef\",\"Food\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:795;s:11:\"trend_index\";i:617;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:271;a:20:{s:4:\"tmpl\";i:1435;s:2:\"id\";i:24504;s:5:\"title\";s:28:\"Wireframe &#8211; Services 2\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2.jpg\";s:12:\"tmpl_created\";i:1653988910;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:80:\"[\"Business\",\"Contact\",\"Footer\",\"Header\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:272;a:20:{s:4:\"tmpl\";i:669;s:2:\"id\";i:8524;s:5:\"title\";s:11:\"404 page 07\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/007.jpg\";s:12:\"tmpl_created\";i:1526415337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-07/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:303;s:11:\"trend_index\";i:171;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:273;a:20:{s:4:\"tmpl\";i:1147;s:2:\"id\";i:16946;s:5:\"title\";s:52:\"Online Full-Stack Developer Course &#8211; Education\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Full-Stack-Developer-Course.png\";s:12:\"tmpl_created\";i:1610532778;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/lp/online-full-stack-developer-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:76:\"[\"Academy\",\"Coding\",\"Course Online\",\"Developer\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:805;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:274;a:20:{s:4:\"tmpl\";i:1437;s:2:\"id\";i:24528;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-1.jpg\";s:12:\"tmpl_created\";i:1653988981;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:76:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Google Maps\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:275;a:20:{s:4:\"tmpl\";i:1143;s:2:\"id\";i:16868;s:5:\"title\";s:40:\"Virtual Assistant &#8211; Online Service\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/01/Virtual-Assistant-250x280-1.png\";s:12:\"tmpl_created\";i:1610465656;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/virtual-assistant-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:46:\"[\"Assistant\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:793;s:11:\"trend_index\";i:757;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:276;a:20:{s:4:\"tmpl\";i:673;s:2:\"id\";i:8526;s:5:\"title\";s:11:\"404 page 09\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/009.jpg\";s:12:\"tmpl_created\";i:1526415474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-09/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:477;s:11:\"trend_index\";i:285;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:277;a:20:{s:4:\"tmpl\";i:1228;s:2:\"id\";i:21104;s:5:\"title\";s:26:\"Restaurant &#8211; Contact\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/11-Contact-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638800146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/restaurant-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:60:\"[\"Contact\",\"Food\",\"Form\",\"Google Maps\",\"Info\",\"Testimonial\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:278;a:20:{s:4:\"tmpl\";i:1140;s:2:\"id\";i:16812;s:5:\"title\";s:40:\"Construction Project &#8211; Real Estate\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/01/Construction-Project.png\";s:12:\"tmpl_created\";i:1610463582;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/construction-project-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:59:\"[\"Construction\",\"Landing Pages\",\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:796;s:11:\"trend_index\";i:724;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:279;a:20:{s:4:\"tmpl\";i:1244;s:2:\"id\";i:21393;s:5:\"title\";s:34:\"Interior Designer &#8211; Projects\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2021/12/big-22-Projects-Interior-Designer-New.jpeg\";s:12:\"tmpl_created\";i:1638823945;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/interior-designer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:93:\"[\"Creative\",\"Creative Portfolio\",\"Design\",\"Designer\",\"Interior Design\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:280;a:20:{s:4:\"tmpl\";i:1148;s:2:\"id\";i:16960;s:5:\"title\";s:44:\"Dog &amp; Cat Food Delivery &#8211; Business\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2021/01/Dog-Food.png\";s:12:\"tmpl_created\";i:1610533581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/lp/dog-cat-food-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:71:\"[\"Business\",\"Cat\",\"Delivery\",\"Dog\",\"Food\",\"Landing Pages\",\"Pet\",\"Pets\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:782;s:11:\"trend_index\";i:510;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:281;a:20:{s:4:\"tmpl\";i:670;s:2:\"id\";i:8525;s:5:\"title\";s:11:\"404 page 08\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/008.jpg\";s:12:\"tmpl_created\";i:1526415374;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-08/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:510;s:11:\"trend_index\";i:575;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:282;a:20:{s:4:\"tmpl\";i:1251;s:2:\"id\";i:22143;s:5:\"title\";s:33:\"Fashion Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png\";s:12:\"tmpl_created\";i:1647177389;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/fashion-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Coming Soon\",\"Fashion\",\"Landing Pages\",\"Shop\",\"store\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:283;a:20:{s:4:\"tmpl\";i:1155;s:2:\"id\";i:17095;s:5:\"title\";s:36:\"Mobile Pet Grooming &#8211; Business\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Mobile-Pet-Grooming.png\";s:12:\"tmpl_created\";i:1610632115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/mobile-pet-grooming-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:38:\"[\"Dog\",\"Groom\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:786;s:11:\"trend_index\";i:731;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:284;a:20:{s:4:\"tmpl\";i:1241;s:2:\"id\";i:21451;s:5:\"title\";s:26:\"Exhibition &#8211; Gallery\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/21-Gallery-Exhibition.jpg\";s:12:\"tmpl_created\";i:1638821855;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/exhibition-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:74:\"[\"Art\",\"Creative\",\"Creative Portfolio\",\"Exhibition\",\"Gallery\",\"Portfolio\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:285;a:20:{s:4:\"tmpl\";i:502;s:2:\"id\";i:5438;s:5:\"title\";s:7:\"About 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_4.png\";s:12:\"tmpl_created\";i:1520443512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:147;s:11:\"trend_index\";i:9;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:286;a:20:{s:4:\"tmpl\";i:1159;s:2:\"id\";i:17245;s:5:\"title\";s:34:\"Marketing Course &#8211; Education\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2021/01/PPC.png\";s:12:\"tmpl_created\";i:1610902958;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/marketing-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:45:\"[\"Course Online\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:770;s:11:\"trend_index\";i:430;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:287;a:20:{s:4:\"tmpl\";i:1240;s:2:\"id\";i:21430;s:5:\"title\";s:30:\"Travel Blogger &#8211; Gallery\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/12/19-Gallery-Travel-Blogger.jpg\";s:12:\"tmpl_created\";i:1638821592;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/travel-blogger-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:43:\"[\"Gallery\",\"Photography\",\"Slider\",\"Travel\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:288;a:20:{s:4:\"tmpl\";i:1149;s:2:\"id\";i:16983;s:5:\"title\";s:41:\"Pilates Instructor &#8211; Online Service\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/01/Pilates-Instructor.png\";s:12:\"tmpl_created\";i:1610534138;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/lp/pilates-instructor-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:70:\"[\"Free Trial\",\"Instructor\",\"Landing Pages\",\"Online Service\",\"Pilates\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:778;s:11:\"trend_index\";i:412;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:289;a:20:{s:4:\"tmpl\";i:1416;s:2:\"id\";i:24104;s:5:\"title\";s:33:\"Ceramics Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Ceramics-Shop.jpg\";s:12:\"tmpl_created\";i:1650988949;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/ceramics-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:115:\"[\"Art\",\"Business\",\"Coming Soon\",\"Creative\",\"Decor\",\"Design\",\"Furniture Design\",\"Interior Design\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:290;a:20:{s:4:\"tmpl\";i:557;s:2:\"id\";i:6135;s:5:\"title\";s:8:\"About 10\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_2.png\";s:12:\"tmpl_created\";i:1520443663;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:77;s:11:\"trend_index\";i:47;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:291;a:20:{s:4:\"tmpl\";i:1412;s:2:\"id\";i:24033;s:5:\"title\";s:37:\"Dance Studio &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Dance-Studio.jpg\";s:12:\"tmpl_created\";i:1649881344;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/dance-studio-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:113:\"[\"Academy\",\"Business\",\"Dance Studio\",\"Form\",\"Pilates\",\"School\",\"Sport\",\"Teacher\",\"Training\",\"Under Construction\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:292;a:20:{s:4:\"tmpl\";i:1190;s:2:\"id\";i:18568;s:5:\"title\";s:32:\"Flower Delivery &#8211; Business\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/04/Flower-Delivery.png\";s:12:\"tmpl_created\";i:1617546716;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/flower-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:37:\"[\"Delivery\",\"Flower\",\"Landing Pages\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:874;s:11:\"trend_index\";i:763;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:293;a:20:{s:4:\"tmpl\";i:1145;s:2:\"id\";i:16917;s:5:\"title\";s:22:\"Webinar &#8211; Events\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Webinar-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610466822;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/webinar-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:36:\"[\"Events\",\"Landing Pages\",\"Webinar\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:821;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:294;a:20:{s:4:\"tmpl\";i:1413;s:2:\"id\";i:24049;s:5:\"title\";s:33:\"ECO Shop &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-ECO-Shop.jpg\";s:12:\"tmpl_created\";i:1649882053;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/eco-shop-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:110:\"[\"Aesthetic\",\"Business\",\"Creative\",\"Decor\",\"Health\",\"Help\",\"Lifestyle\",\"Products\",\"Shop\",\"Under Construction\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:295;a:20:{s:4:\"tmpl\";i:497;s:2:\"id\";i:5397;s:5:\"title\";s:8:\"About 11\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1.png\";s:12:\"tmpl_created\";i:1520443503;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:148;s:11:\"trend_index\";i:43;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:296;a:20:{s:4:\"tmpl\";i:1154;s:2:\"id\";i:17079;s:5:\"title\";s:42:\"Calls Volunteer &#8211; Social Involvement\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/01/Calls-Volunteer.png\";s:12:\"tmpl_created\";i:1610631774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/calls-volunteer-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:68:\"[\"Care\",\"Covid-19\",\"Help\",\"Involvement\",\"Landing Pages\",\"Volunteer\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:854;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:297;a:20:{s:4:\"tmpl\";i:1419;s:2:\"id\";i:24136;s:5:\"title\";s:29:\"Food Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Food-Blog.jpg\";s:12:\"tmpl_created\";i:1650990034;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/food-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:62:\"[\"Blog\",\"Business\",\"Coming Soon\",\"Cooking\",\"Education\",\"Food\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:298;a:20:{s:4:\"tmpl\";i:1142;s:2:\"id\";i:16836;s:5:\"title\";s:33:\"Marketing Agency &#8211; Business\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/01/Marketing-Agency-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610464490;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/marketing-agency-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:74:\"[\"Agency\",\"Business\",\"Landing Pages\",\"Marketing\",\"Marketing Landing Page\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:816;s:11:\"trend_index\";i:787;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:299;a:20:{s:4:\"tmpl\";i:1411;s:2:\"id\";i:24020;s:5:\"title\";s:35:\"Mobile App &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Mobile-App.jpg\";s:12:\"tmpl_created\";i:1649880955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/mobile-app-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:77:\"[\"App\",\"Business\",\"Coding\",\"Computer\",\"Launch\",\"Mobile\",\"Under Construction\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:300;a:20:{s:4:\"tmpl\";i:498;s:2:\"id\";i:5405;s:5:\"title\";s:8:\"About 12\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1.png\";s:12:\"tmpl_created\";i:1520443505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:216;s:11:\"trend_index\";i:50;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:301;a:20:{s:4:\"tmpl\";i:1139;s:2:\"id\";i:16785;s:5:\"title\";s:42:\"Gym Promotion &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2021/01/Gym-LP.jpg\";s:12:\"tmpl_created\";i:1610455496;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/gym-promotion-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:42:\"[\"Fitness\",\"Gym\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:820;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:302;a:20:{s:4:\"tmpl\";i:1420;s:2:\"id\";i:24152;s:5:\"title\";s:32:\"Perfume Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Perfume-Shop.jpg\";s:12:\"tmpl_created\";i:1650990353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/perfume-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:68:\"[\"Business\",\"Coming Soon\",\"Cosmetics\",\"Lifestyle\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:303;a:20:{s:4:\"tmpl\";i:1185;s:2:\"id\";i:18492;s:5:\"title\";s:34:\"Bicycle Pre-Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bike-Landing-Page.png\";s:12:\"tmpl_created\";i:1617535552;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/bicycle-pre-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:34:\"[\"Bicycle\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:50;s:16:\"popularity_index\";i:871;s:11:\"trend_index\";i:826;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:304;a:20:{s:4:\"tmpl\";i:1418;s:2:\"id\";i:24126;s:5:\"title\";s:28:\"Skincare &#8211; Coming Soon\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Skincare.jpg\";s:12:\"tmpl_created\";i:1650989585;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/skincare-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:128:\"[\"Aesthetic\",\"Beauty\",\"Beauty Salon\",\"Business\",\"Coming Soon\",\"Cosmetics\",\"Girly\",\"Lifestyle\",\"Services\",\"Skincare\",\"Treatment\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:305;a:20:{s:4:\"tmpl\";i:1181;s:2:\"id\";i:18349;s:5:\"title\";s:39:\"Virtual try-on glasses &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-8.png\";s:12:\"tmpl_created\";i:1614772569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/lp/virtual-try-on-glasses-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:64:\"[\"Fashion\",\"Glasses\",\"Landing Pages\",\"Online Service\",\"Virtual\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:848;s:11:\"trend_index\";i:803;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:306;a:20:{s:4:\"tmpl\";i:500;s:2:\"id\";i:5421;s:5:\"title\";s:8:\"About 13\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_3.png\";s:12:\"tmpl_created\";i:1520443509;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:215;s:11:\"trend_index\";i:77;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:307;a:20:{s:4:\"tmpl\";i:513;s:2:\"id\";i:5533;s:5:\"title\";s:8:\"About 15\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_10.png\";s:12:\"tmpl_created\";i:1520443534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:21;s:11:\"trend_index\";i:57;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:308;a:20:{s:4:\"tmpl\";i:1410;s:2:\"id\";i:24004;s:5:\"title\";s:33:\"Skincare &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Skincare.jpg\";s:12:\"tmpl_created\";i:1649880534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/skincare-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:144:\"[\"Aesthetic\",\"Beauty\",\"Beauty Salon\",\"Business\",\"Cosmetics\",\"Girly\",\"Lifestyle\",\"Makeup\",\"Services\",\"Skincare\",\"Treatment\",\"Under Construction\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:309;a:20:{s:4:\"tmpl\";i:1172;s:2:\"id\";i:17458;s:5:\"title\";s:31:\"Moving Company &#8211; Business\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Moving-Company.png\";s:12:\"tmpl_created\";i:1612727025;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/moving-company-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:46:\"[\"Business\",\"Landing Pages\",\"Movers\",\"Moving\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:826;s:11:\"trend_index\";i:767;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:310;a:20:{s:4:\"tmpl\";i:1415;s:2:\"id\";i:24092;s:5:\"title\";s:29:\"Vase Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Vase-Shop.jpg\";s:12:\"tmpl_created\";i:1650988613;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/vase-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:115:\"[\"Art\",\"Business\",\"Coming Soon\",\"Creative\",\"Decor\",\"Design\",\"Furniture Design\",\"Interior Design\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:311;a:20:{s:4:\"tmpl\";i:1186;s:2:\"id\";i:18517;s:5:\"title\";s:29:\"Food Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Food-Blog.png\";s:12:\"tmpl_created\";i:1617539897;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/food-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:45:\"[\"Blog\",\"Coming Soon\",\"Food\",\"Landing Pages\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:844;s:11:\"trend_index\";i:672;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:312;a:20:{s:4:\"tmpl\";i:1167;s:2:\"id\";i:17379;s:5:\"title\";s:33:\"IT Service &#8211; Online Service\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-IT-Service.png\";s:12:\"tmpl_created\";i:1612713022;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/it-service-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:41:\"[\"IT\",\"Landing Pages\",\"Remote\",\"Support\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:806;s:11:\"trend_index\";i:634;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:313;a:20:{s:4:\"tmpl\";i:1248;s:2:\"id\";i:22134;s:5:\"title\";s:32:\"Art Magazine &#8211; Coming Soon\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1647176713;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/art-magazine-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:48:\"[\"Art\",\"Coming Soon\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:314;a:20:{s:4:\"tmpl\";i:512;s:2:\"id\";i:5525;s:5:\"title\";s:8:\"About 14\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_10.png\";s:12:\"tmpl_created\";i:1520443532;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:9;s:11:\"trend_index\";i:29;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:315;a:20:{s:4:\"tmpl\";i:1189;s:2:\"id\";i:18560;s:5:\"title\";s:52:\"Finance Learning Platform &#8211; Under Construction\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Finance-Platform.png\";s:12:\"tmpl_created\";i:1617542761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/lp/finance-learning-platform-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:27:\"[\"Finance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:843;s:11:\"trend_index\";i:561;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:316;a:20:{s:4:\"tmpl\";i:1225;s:2:\"id\";i:21041;s:5:\"title\";s:41:\"Business Consulting Company &#8211; About\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2021/12/8-About-Business-Consulting-Company.jpg\";s:12:\"tmpl_created\";i:1638797560;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/business-consulting-company-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"Coach\",\"Collaboration\",\"Consulting\",\"Life Coach\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:317;a:20:{s:4:\"tmpl\";i:1187;s:2:\"id\";i:18528;s:5:\"title\";s:36:\"Home Decor Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Home-Decore.png\";s:12:\"tmpl_created\";i:1617541784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/home-decor-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:57:\"[\"Coming Soon\",\"Decor\",\"Interior Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:872;s:11:\"trend_index\";i:819;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:318;a:20:{s:4:\"tmpl\";i:1243;s:2:\"id\";i:21135;s:5:\"title\";s:28:\"Construction &#8211; Service\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/13-Service-Construction.jpg\";s:12:\"tmpl_created\";i:1638823202;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/construction-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:48:\"[\"Architecture\",\"Construction\",\"Faq\",\"Services\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:319;a:20:{s:4:\"tmpl\";i:501;s:2:\"id\";i:5429;s:5:\"title\";s:8:\"About 16\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_4.png\";s:12:\"tmpl_created\";i:1520443510;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:59;s:11:\"trend_index\";i:8;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:320;a:20:{s:4:\"tmpl\";i:1174;s:2:\"id\";i:17504;s:5:\"title\";s:29:\"Hair Stylist &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-3.png\";s:12:\"tmpl_created\";i:1612883014;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/hair-stylist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:59:\"[\"Business\",\"Hair\",\"hairdresser\",\"Landing Pages\",\"Stylist\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:840;s:11:\"trend_index\";i:806;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:321;a:20:{s:4:\"tmpl\";i:1223;s:2:\"id\";i:20981;s:5:\"title\";s:37:\"Creative Digital Agency &#8211; About\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2021/12/6-About-Creative-Digital-Agency.jpg\";s:12:\"tmpl_created\";i:1638789303;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/creative-digital-agency-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"About\",\"Advisor\",\"Creative\",\"Creative Portfolio\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:322;a:20:{s:4:\"tmpl\";i:1184;s:2:\"id\";i:18449;s:5:\"title\";s:45:\"Aesthetic Clinic &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2021/03/Aesthetic-Clinic.png\";s:12:\"tmpl_created\";i:1616682181;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/lp/aesthetic-clinic-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:57:\"[\"Aesthetic\",\"Beauty\",\"Fitness\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:859;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:323;a:20:{s:4:\"tmpl\";i:1221;s:2:\"id\";i:20926;s:5:\"title\";s:33:\"Doctors Online Consultation -Home\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/12/4-Home-Doctors-Online-Consultation.jpg\";s:12:\"tmpl_created\";i:1638787371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/doctors-online-consultation-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:35:\"[\"App\",\"Health\",\"Medical\",\"Online\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:324;a:20:{s:4:\"tmpl\";i:505;s:2:\"id\";i:5464;s:5:\"title\";s:8:\"About 17\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_6.png\";s:12:\"tmpl_created\";i:1520443518;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:220;s:11:\"trend_index\";i:142;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:325;a:20:{s:4:\"tmpl\";i:1165;s:2:\"id\";i:17353;s:5:\"title\";s:44:\"Online Cooking Course &#8211; Online Service\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-2.png\";s:12:\"tmpl_created\";i:1612705144;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/lp/online-cooking-course-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:50:\"[\"Cooking\",\"Course Online\",\"Food\",\"Landing Pages\"]\";s:10:\"menu_order\";i:59;s:16:\"popularity_index\";i:845;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:326;a:20:{s:4:\"tmpl\";i:1188;s:2:\"id\";i:18550;s:5:\"title\";s:39:\"Online Store &#8211; Under Construction\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Online-Store.png\";s:12:\"tmpl_created\";i:1617542506;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/lp/online-store-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:59:\"[\"Landing Pages\",\"Online Shop\",\"Shop\",\"Under Construction\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:832;s:11:\"trend_index\";i:600;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:327;a:20:{s:4:\"tmpl\";i:1250;s:2:\"id\";i:22140;s:5:\"title\";s:33:\"Design School &#8211; Coming Soon\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/05/250x280-1.png\";s:12:\"tmpl_created\";i:1647177317;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/design-school-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:49:\"[\"Coming Soon\",\"Design\",\"Landing Pages\",\"School\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:328;a:20:{s:4:\"tmpl\";i:510;s:2:\"id\";i:5504;s:5:\"title\";s:8:\"About 18\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_9.png\";s:12:\"tmpl_created\";i:1520443528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:104;s:11:\"trend_index\";i:46;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:329;a:20:{s:4:\"tmpl\";i:1191;s:2:\"id\";i:18539;s:5:\"title\";s:40:\"Travel Agency &#8211; Under Construction\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Travel-Agency-1.png\";s:12:\"tmpl_created\";i:1617610273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/travel-agency-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:56:\"[\"Agency\",\"Landing Pages\",\"Travel\",\"Under Construction\"]\";s:10:\"menu_order\";i:61;s:16:\"popularity_index\";i:876;s:11:\"trend_index\";i:652;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:330;a:20:{s:4:\"tmpl\";i:1175;s:2:\"id\";i:18270;s:5:\"title\";s:24:\"Open week &#8211; Events\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280.png\";s:12:\"tmpl_created\";i:1614767186;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/open-week-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:59:\"[\"Education\",\"Event\",\"Events\",\"Landing Pages\",\"University\"]\";s:10:\"menu_order\";i:62;s:16:\"popularity_index\";i:831;s:11:\"trend_index\";i:673;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:331;a:20:{s:4:\"tmpl\";i:1177;s:2:\"id\";i:18300;s:5:\"title\";s:30:\"Makeup Artist &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-2.png\";s:12:\"tmpl_created\";i:1614768608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/makeup-artist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:79:\"[\"Beauty\",\"Business\",\"Course Online\",\"Landing Pages\",\"Makeup\",\"Online Service\"]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:861;s:11:\"trend_index\";i:783;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:332;a:20:{s:4:\"tmpl\";i:511;s:2:\"id\";i:5515;s:5:\"title\";s:8:\"About 19\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_9.png\";s:12:\"tmpl_created\";i:1520443530;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-19/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:268;s:11:\"trend_index\";i:161;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:333;a:20:{s:4:\"tmpl\";i:1179;s:2:\"id\";i:18329;s:5:\"title\";s:63:\"Online Real Estate Investment Conference &#8211; Online Service\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-5.png\";s:12:\"tmpl_created\";i:1614770404;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/lp/online-real-estate-investment-conference-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:76:\"[\"Conference\",\"Event\",\"Events\",\"Landing Pages\",\"Online Event\",\"Real estate\"]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:866;s:11:\"trend_index\";i:779;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:334;a:20:{s:4:\"tmpl\";i:506;s:2:\"id\";i:5472;s:5:\"title\";s:7:\"About 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_7.png\";s:12:\"tmpl_created\";i:1520443520;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:210;s:11:\"trend_index\";i:116;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:335;a:20:{s:4:\"tmpl\";i:1183;s:2:\"id\";i:18391;s:5:\"title\";s:45:\"Children&#8217;s Optometrist &#8211; Business\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Childrens-Optometrist.png\";s:12:\"tmpl_created\";i:1614773564;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/lp/childrens-optometrist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:85:\"[\"Business\",\"Children\",\"Eye\",\"Glasses\",\"Health\",\"Kids\",\"Landing Pages\",\"Optometrist\"]\";s:10:\"menu_order\";i:65;s:16:\"popularity_index\";i:877;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:336;a:20:{s:4:\"tmpl\";i:1182;s:2:\"id\";i:18366;s:5:\"title\";s:30:\"Car Insurance &#8211; Business\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Car-Insurance.png\";s:12:\"tmpl_created\";i:1614773263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/car-insurance-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:46:\"[\"Business\",\"car\",\"Insurance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:869;s:11:\"trend_index\";i:797;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:337;a:20:{s:4:\"tmpl\";i:1201;s:2:\"id\";i:19144;s:5:\"title\";s:25:\"Birthday Party Invitation\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/06/250x280.png\";s:12:\"tmpl_created\";i:1623848691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/birthday-party-invitation/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:67:\"[\"Birthday\",\"Event\",\"Landing Pages\",\"Party\",\"RSVD\",\"Save the Date\"]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:338;a:20:{s:4:\"tmpl\";i:1124;s:2:\"id\";i:16473;s:5:\"title\";s:26:\"Beauty Salon &#8211; About\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/12/about-1.jpg\";s:12:\"tmpl_created\";i:1608622373;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/beauty-salon-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:615;s:11:\"trend_index\";i:184;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:339;a:20:{s:4:\"tmpl\";i:1176;s:2:\"id\";i:18291;s:5:\"title\";s:47:\"Grill Restaurant Food Delivery &#8211; Business\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Food-Delivery-LP.png\";s:12:\"tmpl_created\";i:1614767830;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/lp/grill-restaurant-food-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:79:\"[\"Delivery\",\"Delivery Service\",\"Fast Food\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:819;s:11:\"trend_index\";i:685;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:340;a:20:{s:4:\"tmpl\";i:504;s:2:\"id\";i:5455;s:5:\"title\";s:8:\"About 20\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_6.png\";s:12:\"tmpl_created\";i:1520443516;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-20/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:134;s:11:\"trend_index\";i:70;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:341;a:20:{s:4:\"tmpl\";i:1125;s:2:\"id\";i:16488;s:5:\"title\";s:28:\"Beauty Salon &#8211; Contact\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/12/contact.jpg\";s:12:\"tmpl_created\";i:1608622374;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/beauty-salon-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:548;s:11:\"trend_index\";i:101;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:342;a:20:{s:4:\"tmpl\";i:1180;s:2:\"id\";i:18340;s:5:\"title\";s:30:\"Restaurant &#8211; Coming Soon\";s:9:\"thumbnail\";s:98:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Restuarant-Coming-Soon-LP.png\";s:12:\"tmpl_created\";i:1614772183;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/restaurant-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:51:\"[\"Coming Soon\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:810;s:11:\"trend_index\";i:809;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:343;a:20:{s:4:\"tmpl\";i:499;s:2:\"id\";i:5413;s:5:\"title\";s:8:\"About 21\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2.png\";s:12:\"tmpl_created\";i:1520443507;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-21/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:83;s:11:\"trend_index\";i:52;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:344;a:20:{s:4:\"tmpl\";i:1126;s:2:\"id\";i:16496;s:5:\"title\";s:28:\"Beauty Salon &#8211; Gallery\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/12/gallery-1.jpg\";s:12:\"tmpl_created\";i:1608622379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/beauty-salon-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:491;s:11:\"trend_index\";i:90;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:345;a:20:{s:4:\"tmpl\";i:1173;s:2:\"id\";i:17480;s:5:\"title\";s:42:\"At-home Massage Therapist &#8211; Business\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/02/At-Home-Massage-Therapist.jpg\";s:12:\"tmpl_created\";i:1612879264;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/at-home-massage-therapist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:60:\"[\"Business\",\"Health\",\"Landing Pages\",\"Services\",\"Therapist\"]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:856;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:346;a:20:{s:4:\"tmpl\";i:1127;s:2:\"id\";i:16457;s:5:\"title\";s:25:\"Beauty Salon &#8211; Home\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/12/home-1.jpg\";s:12:\"tmpl_created\";i:1608622383;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/beauty-salon-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:70;s:16:\"popularity_index\";i:408;s:11:\"trend_index\";i:56;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:347;a:20:{s:4:\"tmpl\";i:1178;s:2:\"id\";i:18317;s:5:\"title\";s:26:\"Insurance &#8211; Business\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Life-Insirance.png\";s:12:\"tmpl_created\";i:1614769488;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/lp/insurance-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:61:\"[\"Business\",\"Family\",\"Financial\",\"Insurance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:70;s:16:\"popularity_index\";i:870;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:348;a:20:{s:4:\"tmpl\";i:1128;s:2:\"id\";i:16518;s:5:\"title\";s:29:\"Beauty Salon &#8211; Services\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/12/services-1.jpg\";s:12:\"tmpl_created\";i:1608622386;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/beauty-salon-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:664;s:11:\"trend_index\";i:261;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:349;a:20:{s:4:\"tmpl\";i:1168;s:2:\"id\";i:17401;s:5:\"title\";s:40:\"Conference Thank You Page &#8211; Events\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280.png\";s:12:\"tmpl_created\";i:1612724753;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/conference-thank-you-page-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:59:\"[\"Conference\",\"Event\",\"Events\",\"Landing Pages\",\"Thank You\"]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:799;s:11:\"trend_index\";i:540;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:350;a:20:{s:4:\"tmpl\";i:503;s:2:\"id\";i:5447;s:5:\"title\";s:7:\"About 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_5.png\";s:12:\"tmpl_created\";i:1520443514;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/about-3-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:48;s:11:\"trend_index\";i:12;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:351;a:20:{s:4:\"tmpl\";i:1073;s:2:\"id\";i:15486;s:5:\"title\";s:25:\"Travel Blog &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/11/About.jpg\";s:12:\"tmpl_created\";i:1606215720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/travel-blog-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:72;s:16:\"popularity_index\";i:608;s:11:\"trend_index\";i:343;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:352;a:20:{s:4:\"tmpl\";i:1166;s:2:\"id\";i:17368;s:5:\"title\";s:38:\"Real Estate Agency &#8211; Real-Estate\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Real-Estate.png\";s:12:\"tmpl_created\";i:1612711814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/lp/real-estate-agency-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:73:\"[\"Landing Pages\",\"listing\",\"Real estate\",\"Realestate\",\"realtor\",\"realty\"]\";s:10:\"menu_order\";i:72;s:16:\"popularity_index\";i:858;s:11:\"trend_index\";i:777;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:353;a:20:{s:4:\"tmpl\";i:1074;s:2:\"id\";i:15478;s:5:\"title\";s:27:\"Travel Blog &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/11/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1606215735;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/travel-blog-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:687;s:11:\"trend_index\";i:564;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:354;a:20:{s:4:\"tmpl\";i:1170;s:2:\"id\";i:17423;s:5:\"title\";s:57:\"Volunteer Calls Thank You Page &#8211; Social Involvement\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/02/Volunteer-Calls-TYP.jpg\";s:12:\"tmpl_created\";i:1612726058;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:151:\"https://library.elementor.com/lp/volunteer-calls-thank-you-page-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:62:\"[\"Care\",\"Involvement\",\"Landing Pages\",\"Thank You\",\"Volunteer\"]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:857;s:11:\"trend_index\";i:818;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:355;a:20:{s:4:\"tmpl\";i:507;s:2:\"id\";i:5480;s:5:\"title\";s:7:\"About 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_7-1.png\";s:12:\"tmpl_created\";i:1520443522;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/about-4-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:428;s:11:\"trend_index\";i:303;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:356;a:20:{s:4:\"tmpl\";i:1075;s:2:\"id\";i:15467;s:5:\"title\";s:24:\"Travel Blog &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/11/Home.jpg\";s:12:\"tmpl_created\";i:1606215756;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/travel-blog-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:74;s:16:\"popularity_index\";i:567;s:11:\"trend_index\";i:224;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:357;a:20:{s:4:\"tmpl\";i:1169;s:2:\"id\";i:17409;s:5:\"title\";s:37:\"Webinar Thank You Page &#8211; Events\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Webinar-TYP.png\";s:12:\"tmpl_created\";i:1612725644;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/webinar-thank-you-page-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:56:\"[\"Event\",\"Events\",\"Landing Pages\",\"Thank You\",\"Webinar\"]\";s:10:\"menu_order\";i:74;s:16:\"popularity_index\";i:868;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:358;a:20:{s:4:\"tmpl\";i:1056;s:2:\"id\";i:15317;s:5:\"title\";s:25:\"Dance Studio &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/10/Home.jpg\";s:12:\"tmpl_created\";i:1603181291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/dance-studio-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:596;s:11:\"trend_index\";i:301;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:359;a:20:{s:4:\"tmpl\";i:545;s:2:\"id\";i:6027;s:5:\"title\";s:7:\"About 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1-1.png\";s:12:\"tmpl_created\";i:1520443639;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/about-5-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:40;s:11:\"trend_index\";i:40;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:360;a:20:{s:4:\"tmpl\";i:1160;s:2:\"id\";i:17258;s:5:\"title\";s:32:\"Beauty Product &#8211; eCommerce\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2021/01/Beauty-Product.png\";s:12:\"tmpl_created\";i:1610903153;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/beauty-product-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:38:\"[\"Beauty\",\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:797;s:11:\"trend_index\";i:703;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:361;a:20:{s:4:\"tmpl\";i:1057;s:2:\"id\";i:15334;s:5:\"title\";s:26:\"Dance Studio &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/About.jpg\";s:12:\"tmpl_created\";i:1603181364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/dance-studio-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:626;s:11:\"trend_index\";i:373;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:362;a:20:{s:4:\"tmpl\";i:546;s:2:\"id\";i:6036;s:5:\"title\";s:7:\"About 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1-1.png\";s:12:\"tmpl_created\";i:1520443641;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/about-6-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:90;s:11:\"trend_index\";i:123;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:363;a:20:{s:4:\"tmpl\";i:1171;s:2:\"id\";i:17435;s:5:\"title\";s:39:\"Gym &#8211; App Service &#8211; Product\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-4.png\";s:12:\"tmpl_created\";i:1612726462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/gym-app-service-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:58:\"[\"App\",\"Fitness\",\"Gym\",\"Health\",\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:767;s:11:\"trend_index\";i:577;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:364;a:20:{s:4:\"tmpl\";i:1058;s:2:\"id\";i:15349;s:5:\"title\";s:28:\"Dance Studio &#8211; Classes\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/10/Classes.jpg\";s:12:\"tmpl_created\";i:1603181425;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dance-studio-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:77;s:16:\"popularity_index\";i:629;s:11:\"trend_index\";i:458;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:365;a:20:{s:4:\"tmpl\";i:1156;s:2:\"id\";i:17111;s:5:\"title\";s:33:\"Sunglasses Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/01/Sunglasses-LP-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610632408;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/sunglasses-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:59:\"[\"Ecommerce\",\"Fashion\",\"Landing Pages\",\"Sale\",\"Sunglasses\"]\";s:10:\"menu_order\";i:77;s:16:\"popularity_index\";i:812;s:11:\"trend_index\";i:732;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:366;a:20:{s:4:\"tmpl\";i:1055;s:2:\"id\";i:15366;s:5:\"title\";s:29:\"Dance Studio &#8211; Schedule\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2020/10/Classes-Schedule.jpg\";s:12:\"tmpl_created\";i:1603181056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/dance-studio-schedule/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:78;s:16:\"popularity_index\";i:698;s:11:\"trend_index\";i:602;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:367;a:20:{s:4:\"tmpl\";i:1157;s:2:\"id\";i:17223;s:5:\"title\";s:25:\"Fashion &#8211; eCommerce\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2021/01/Commerce-Fashion.png\";s:12:\"tmpl_created\";i:1610902553;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/fashion-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:29:\"[\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:78;s:16:\"popularity_index\";i:808;s:11:\"trend_index\";i:745;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:368;a:20:{s:4:\"tmpl\";i:1059;s:2:\"id\";i:15373;s:5:\"title\";s:28:\"Dance Studio &#8211; Pricing\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/10/Pricing.jpg\";s:12:\"tmpl_created\";i:1603181678;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dance-studio-pricing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:731;s:11:\"trend_index\";i:661;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:369;a:20:{s:4:\"tmpl\";i:1151;s:2:\"id\";i:17017;s:5:\"title\";s:28:\"Shoes Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/01/Shoes-LP-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610535361;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/shoes-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:55:\"[\"Discount\",\"Ecommerce\",\"Landing Pages\",\"Sale\",\"Shoes\"]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:803;s:11:\"trend_index\";i:642;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:370;a:20:{s:4:\"tmpl\";i:508;s:2:\"id\";i:5488;s:5:\"title\";s:7:\"About 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_8.png\";s:12:\"tmpl_created\";i:1520443524;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:307;s:11:\"trend_index\";i:169;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:371;a:20:{s:4:\"tmpl\";i:1060;s:2:\"id\";i:15384;s:5:\"title\";s:28:\"Dance Studio &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/10/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1603181738;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dance-studio-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:741;s:11:\"trend_index\";i:721;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:372;a:20:{s:4:\"tmpl\";i:556;s:2:\"id\";i:6122;s:5:\"title\";s:7:\"About 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2-1.png\";s:12:\"tmpl_created\";i:1520443661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:38;s:11:\"trend_index\";i:26;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:373;a:20:{s:4:\"tmpl\";i:1163;s:2:\"id\";i:17301;s:5:\"title\";s:53:\"Personal Chef &#8211; Thank You Page &#8211; Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2021/01/TYP-Personal-Chef.jpg\";s:12:\"tmpl_created\";i:1610903622;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/personal-chef-thank-you-page-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:43:\"[\"Chef\",\"Food\",\"Landing Pages\",\"Thank You\"]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:823;s:11:\"trend_index\";i:754;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:374;a:20:{s:4:\"tmpl\";i:1042;s:2:\"id\";i:15158;s:5:\"title\";s:26:\"Psychologist &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/About.jpg\";s:12:\"tmpl_created\";i:1600157561;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/psychologist-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:81;s:16:\"popularity_index\";i:618;s:11:\"trend_index\";i:426;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:375;a:20:{s:4:\"tmpl\";i:1164;s:2:\"id\";i:17313;s:5:\"title\";s:60:\"Development Course  &#8211; Thank You Page &#8211; Education\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/01/Dev-Course-TYP-.png\";s:12:\"tmpl_created\";i:1610903776;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/lp/development-course-thank-you-page-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:57:\"[\"Course Online\",\"Education\",\"Landing Pages\",\"Thank You\"]\";s:10:\"menu_order\";i:81;s:16:\"popularity_index\";i:834;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:376;a:20:{s:4:\"tmpl\";i:1045;s:2:\"id\";i:15197;s:5:\"title\";s:28:\"Psychologist &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1600160499;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/psychologist-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:82;s:16:\"popularity_index\";i:666;s:11:\"trend_index\";i:558;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:377;a:20:{s:4:\"tmpl\";i:509;s:2:\"id\";i:5496;s:5:\"title\";s:7:\"About 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_8-1.png\";s:12:\"tmpl_created\";i:1520443526;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:82;s:16:\"popularity_index\";i:523;s:11:\"trend_index\";i:453;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:378;a:20:{s:4:\"tmpl\";i:1041;s:2:\"id\";i:15142;s:5:\"title\";s:25:\"Psychologist &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/09/Home.jpg\";s:12:\"tmpl_created\";i:1600156308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/psychologist-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:83;s:16:\"popularity_index\";i:464;s:11:\"trend_index\";i:297;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:379;a:20:{s:4:\"tmpl\";i:1044;s:2:\"id\";i:15188;s:5:\"title\";s:28:\"Psychologist &#8211; Pricing\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/09/Pricing.jpg\";s:12:\"tmpl_created\";i:1600159731;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/psychologist-pricing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:84;s:16:\"popularity_index\";i:732;s:11:\"trend_index\";i:537;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:380;a:20:{s:4:\"tmpl\";i:684;s:2:\"id\";i:8961;s:5:\"title\";s:9:\"archive 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.1.jpg\";s:12:\"tmpl_created\";i:1528639909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:84;s:16:\"popularity_index\";i:79;s:11:\"trend_index\";i:15;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:381;a:20:{s:4:\"tmpl\";i:1043;s:2:\"id\";i:15167;s:5:\"title\";s:29:\"Psychologist &#8211; Services\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/09/Services.jpg\";s:12:\"tmpl_created\";i:1600158206;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/psychologist-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:85;s:16:\"popularity_index\";i:606;s:11:\"trend_index\";i:379;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:382;a:20:{s:4:\"tmpl\";i:1036;s:2:\"id\";i:14932;s:5:\"title\";s:30:\"Flooring Company &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/About.png\";s:12:\"tmpl_created\";i:1597740110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/flooring-company-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:86;s:16:\"popularity_index\";i:488;s:11:\"trend_index\";i:319;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:383;a:20:{s:4:\"tmpl\";i:685;s:2:\"id\";i:8969;s:5:\"title\";s:9:\"archive 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.2.jpg\";s:12:\"tmpl_created\";i:1528700014;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:86;s:16:\"popularity_index\";i:250;s:11:\"trend_index\";i:124;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:384;a:20:{s:4:\"tmpl\";i:1037;s:2:\"id\";i:14998;s:5:\"title\";s:32:\"Flooring Company &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/08/Contact-Us.png\";s:12:\"tmpl_created\";i:1597740222;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/flooring-company-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:87;s:16:\"popularity_index\";i:553;s:11:\"trend_index\";i:380;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:385;a:20:{s:4:\"tmpl\";i:1038;s:2:\"id\";i:14965;s:5:\"title\";s:32:\"Flooring Company &#8211; Gallery\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/08/Gallery.png\";s:12:\"tmpl_created\";i:1597740353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/flooring-company-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:88;s:16:\"popularity_index\";i:371;s:11:\"trend_index\";i:291;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:386;a:20:{s:4:\"tmpl\";i:686;s:2:\"id\";i:8973;s:5:\"title\";s:9:\"archive 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.3.jpg\";s:12:\"tmpl_created\";i:1528700205;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:88;s:16:\"popularity_index\";i:176;s:11:\"trend_index\";i:54;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:387;a:20:{s:4:\"tmpl\";i:1282;s:2:\"id\";i:22417;s:5:\"title\";s:52:\"Finance Learning Platform &#8211; Under Construction\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Finance-Platform.png\";s:12:\"tmpl_created\";i:1647354987;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/finance-learning-platform-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Finance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:89;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:388;a:20:{s:4:\"tmpl\";i:1040;s:2:\"id\";i:14947;s:5:\"title\";s:33:\"Flooring company &#8211; Services\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/08/Services.png\";s:12:\"tmpl_created\";i:1597740551;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/flooring-company-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:90;s:16:\"popularity_index\";i:538;s:11:\"trend_index\";i:392;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:389;a:20:{s:4:\"tmpl\";i:1039;s:2:\"id\";i:14901;s:5:\"title\";s:29:\"Flooring Company &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/08/Home.png\";s:12:\"tmpl_created\";i:1597740474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/flooring-company-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:91;s:16:\"popularity_index\";i:387;s:11:\"trend_index\";i:185;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:390;a:20:{s:4:\"tmpl\";i:687;s:2:\"id\";i:8977;s:5:\"title\";s:9:\"archive 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.4.jpg\";s:12:\"tmpl_created\";i:1528700326;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:91;s:16:\"popularity_index\";i:354;s:11:\"trend_index\";i:396;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:391;a:20:{s:4:\"tmpl\";i:1252;s:2:\"id\";i:22146;s:5:\"title\";s:36:\"Home Decor Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Home-Decore.png\";s:12:\"tmpl_created\";i:1647177514;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/home-decor-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:57:\"[\"Coming Soon\",\"Decor\",\"Interior Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:92;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:392;a:20:{s:4:\"tmpl\";i:688;s:2:\"id\";i:8981;s:5:\"title\";s:9:\"archive 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.5.jpg\";s:12:\"tmpl_created\";i:1528700484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:93;s:16:\"popularity_index\";i:333;s:11:\"trend_index\";i:195;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:393;a:20:{s:4:\"tmpl\";i:1021;s:2:\"id\";i:14737;s:5:\"title\";s:32:\"Luxury Real Estate &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/07/About.png\";s:12:\"tmpl_created\";i:1595313527;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/luxury-real-estate-about-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:93;s:16:\"popularity_index\";i:150;s:11:\"trend_index\";i:447;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:394;a:20:{s:4:\"tmpl\";i:689;s:2:\"id\";i:8985;s:5:\"title\";s:9:\"archive 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.6.jpg\";s:12:\"tmpl_created\";i:1528700612;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:94;s:16:\"popularity_index\";i:204;s:11:\"trend_index\";i:95;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:395;a:20:{s:4:\"tmpl\";i:1020;s:2:\"id\";i:14756;s:5:\"title\";s:34:\"Luxury Real Estate &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/07/Contact-Us.png\";s:12:\"tmpl_created\";i:1595313519;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/luxury-real-estate-contact-us-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:94;s:16:\"popularity_index\";i:610;s:11:\"trend_index\";i:569;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:396;a:20:{s:4:\"tmpl\";i:1019;s:2:\"id\";i:14716;s:5:\"title\";s:31:\"Luxury Real Estate &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/07/Home.png\";s:12:\"tmpl_created\";i:1595313512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/luxury-real-estate-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:95;s:16:\"popularity_index\";i:394;s:11:\"trend_index\";i:165;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:397;a:20:{s:4:\"tmpl\";i:690;s:2:\"id\";i:8989;s:5:\"title\";s:9:\"archive 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.7.jpg\";s:12:\"tmpl_created\";i:1528701063;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:96;s:16:\"popularity_index\";i:208;s:11:\"trend_index\";i:111;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:398;a:20:{s:4:\"tmpl\";i:1018;s:2:\"id\";i:14763;s:5:\"title\";s:31:\"Luxury Real Estate &#8211; News\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/07/news-Archive.png\";s:12:\"tmpl_created\";i:1595313273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/luxury-real-estate-news-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:96;s:16:\"popularity_index\";i:404;s:11:\"trend_index\";i:167;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:399;a:20:{s:4:\"tmpl\";i:1283;s:2:\"id\";i:22423;s:5:\"title\";s:39:\"Online Store &#8211; Under Construction\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Online-Store.png\";s:12:\"tmpl_created\";i:1647355154;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/online-store-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:59:\"[\"Landing Pages\",\"Online Shop\",\"Shop\",\"Under Construction\"]\";s:10:\"menu_order\";i:97;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:400;a:20:{s:4:\"tmpl\";i:691;s:2:\"id\";i:8996;s:5:\"title\";s:9:\"archive 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.8.jpg\";s:12:\"tmpl_created\";i:1528701290;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:98;s:16:\"popularity_index\";i:227;s:11:\"trend_index\";i:153;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:401;a:20:{s:4:\"tmpl\";i:1010;s:2:\"id\";i:13960;s:5:\"title\";s:32:\"Japanese restaurant &#8211; Home\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/06/Home-Page.jpg\";s:12:\"tmpl_created\";i:1592289775;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/japanese-restaurant-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:98;s:16:\"popularity_index\";i:537;s:11:\"trend_index\";i:287;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:402;a:20:{s:4:\"tmpl\";i:1284;s:2:\"id\";i:22428;s:5:\"title\";s:40:\"Travel Agency &#8211; Under Construction\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Travel-Agency-1.png\";s:12:\"tmpl_created\";i:1647355339;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/travel-agency-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Agency\",\"Landing Pages\",\"Travel\",\"Under Construction\"]\";s:10:\"menu_order\";i:99;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:403;a:20:{s:4:\"tmpl\";i:692;s:2:\"id\";i:9001;s:5:\"title\";s:9:\"archive 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.9.jpg\";s:12:\"tmpl_created\";i:1528701433;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/archive-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:100;s:16:\"popularity_index\";i:265;s:11:\"trend_index\";i:208;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:404;a:20:{s:4:\"tmpl\";i:1007;s:2:\"id\";i:13993;s:5:\"title\";s:45:\"Japanese restaurant &#8211; Chef&#8217;s Menu\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2020/06/Chef_s-Menu-Page.jpg\";s:12:\"tmpl_created\";i:1592289691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/japanese-restaurant-chefs-menu/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:100;s:16:\"popularity_index\";i:651;s:11:\"trend_index\";i:675;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:405;a:20:{s:4:\"tmpl\";i:1006;s:2:\"id\";i:14012;s:5:\"title\";s:36:\"Japanese restaurant &#8211; Bar Menu\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2020/06/Bar-Menu-Page.jpg\";s:12:\"tmpl_created\";i:1592289665;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/japanese-restaurant-bar-menu/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:101;s:16:\"popularity_index\";i:735;s:11:\"trend_index\";i:829;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:406;a:20:{s:4:\"tmpl\";i:1005;s:2:\"id\";i:13917;s:5:\"title\";s:33:\"Japanese restaurant &#8211; About\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/06/About-Page.jpg\";s:12:\"tmpl_created\";i:1592289629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/japanese-restaurant-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:102;s:16:\"popularity_index\";i:640;s:11:\"trend_index\";i:389;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:407;a:20:{s:4:\"tmpl\";i:997;s:2:\"id\";i:13528;s:5:\"title\";s:22:\"Barbershop &#8211; 404\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/05/404-Page.jpg\";s:12:\"tmpl_created\";i:1589893152;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/barbershop-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:34:\"[\"404\",\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:103;s:16:\"popularity_index\";i:768;s:11:\"trend_index\";i:681;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:408;a:20:{s:4:\"tmpl\";i:1009;s:2:\"id\";i:13937;s:5:\"title\";s:35:\"Japanese restaurant &#8211; Gallery\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/06/Gallery-Page.jpg\";s:12:\"tmpl_created\";i:1592289748;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/japanese-restaurant-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:103;s:16:\"popularity_index\";i:648;s:11:\"trend_index\";i:551;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:409;a:20:{s:4:\"tmpl\";i:1008;s:2:\"id\";i:14030;s:5:\"title\";s:34:\"Japanese restaurant &#8211; Events\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/06/Events-Page.jpg\";s:12:\"tmpl_created\";i:1592289713;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/japanese-restaurant-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:104;s:16:\"popularity_index\";i:723;s:11:\"trend_index\";i:711;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:410;a:20:{s:4:\"tmpl\";i:998;s:2:\"id\";i:13518;s:5:\"title\";s:26:\"Barbershop &#8211; Archive\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/05/Blog-Page.jpg\";s:12:\"tmpl_created\";i:1589893157;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/blocks/barbershop-archive/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:105;s:16:\"popularity_index\";i:737;s:11:\"trend_index\";i:523;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:411;a:20:{s:4:\"tmpl\";i:1016;s:2:\"id\";i:13984;s:5:\"title\";s:40:\"Japanese restaurant &#8211; Reservations\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/06/reservations.jpg\";s:12:\"tmpl_created\";i:1592294757;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/japanese-restaurant-reservations/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:105;s:16:\"popularity_index\";i:715;s:11:\"trend_index\";i:727;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:412;a:20:{s:4:\"tmpl\";i:999;s:2:\"id\";i:13479;s:5:\"title\";s:23:\"Barbershop &#8211; Home\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/05/Home-Page.jpg\";s:12:\"tmpl_created\";i:1589893275;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/barbershop-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:106;s:16:\"popularity_index\";i:683;s:11:\"trend_index\";i:832;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:413;a:20:{s:4:\"tmpl\";i:996;s:2:\"id\";i:13604;s:5:\"title\";s:25:\"Barbershop &#8211; Footer\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/05/Footer-Small.jpg\";s:12:\"tmpl_created\";i:1589893147;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/barbershop-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:37:\"[\"Barber Shop\",\"Barbershop\",\"Footer\"]\";s:10:\"menu_order\";i:107;s:16:\"popularity_index\";i:555;s:11:\"trend_index\";i:267;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:414;a:20:{s:4:\"tmpl\";i:1000;s:2:\"id\";i:13503;s:5:\"title\";s:24:\"Barbershop &#8211; About\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/05/About-Page.jpg\";s:12:\"tmpl_created\";i:1589893289;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/barbershop-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:107;s:16:\"popularity_index\";i:744;s:11:\"trend_index\";i:739;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:415;a:20:{s:4:\"tmpl\";i:995;s:2:\"id\";i:13612;s:5:\"title\";s:25:\"Barbershop &#8211; Header\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/06/barber-shop-header.jpg\";s:12:\"tmpl_created\";i:1589893142;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/barbershop-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:37:\"[\"Barber Shop\",\"Barbershop\",\"Header\"]\";s:10:\"menu_order\";i:108;s:16:\"popularity_index\";i:343;s:11:\"trend_index\";i:137;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:416;a:20:{s:4:\"tmpl\";i:1001;s:2:\"id\";i:13548;s:5:\"title\";s:27:\"Barbershop &#8211; Services\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2020/05/Services-Page.jpg\";s:12:\"tmpl_created\";i:1589893298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/barbershop-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:108;s:16:\"popularity_index\";i:761;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:417;a:20:{s:4:\"tmpl\";i:1002;s:2:\"id\";i:13560;s:5:\"title\";s:26:\"Barbershop &#8211; Gallery\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/05/Gallery-Page.jpg\";s:12:\"tmpl_created\";i:1589893307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/barbershop-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:109;s:16:\"popularity_index\";i:756;s:11:\"trend_index\";i:822;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:418;a:20:{s:4:\"tmpl\";i:1003;s:2:\"id\";i:13587;s:5:\"title\";s:26:\"Barbershop &#8211; Contact\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/05/Contact-Us-Page.jpg\";s:12:\"tmpl_created\";i:1589893315;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/barbershop-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:110;s:16:\"popularity_index\";i:753;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:419;a:20:{s:4:\"tmpl\";i:982;s:2:\"id\";i:13307;s:5:\"title\";s:26:\"Online Course &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/04/Home.jpg\";s:12:\"tmpl_created\";i:1587474541;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/online-course-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:111;s:16:\"popularity_index\";i:230;s:11:\"trend_index\";i:125;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:420;a:20:{s:4:\"tmpl\";i:994;s:2:\"id\";i:13621;s:5:\"title\";s:30:\"Barbershop &#8211; Single Post\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/05/Single-Page.jpg\";s:12:\"tmpl_created\";i:1589893137;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/blocks/barbershop-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:111;s:16:\"popularity_index\";i:736;s:11:\"trend_index\";i:580;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:421;a:20:{s:4:\"tmpl\";i:1131;s:2:\"id\";i:16527;s:5:\"title\";s:24:\"Beauty Salon &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/12/404.jpg\";s:12:\"tmpl_created\";i:1608622517;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/beauty-salon-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:29:\"[\"404\",\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:112;s:16:\"popularity_index\";i:742;s:11:\"trend_index\";i:563;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:422;a:20:{s:4:\"tmpl\";i:983;s:2:\"id\";i:13328;s:5:\"title\";s:27:\"Online Course &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/About.jpg\";s:12:\"tmpl_created\";i:1587474558;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/online-course-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:112;s:16:\"popularity_index\";i:508;s:11:\"trend_index\";i:429;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:423;a:20:{s:4:\"tmpl\";i:984;s:2:\"id\";i:13338;s:5:\"title\";s:33:\"Online Course &#8211; Course Page\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/Course-Page.png\";s:12:\"tmpl_created\";i:1587474574;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/online-course-course-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:113;s:16:\"popularity_index\";i:337;s:11:\"trend_index\";i:310;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:424;a:20:{s:4:\"tmpl\";i:985;s:2:\"id\";i:13352;s:5:\"title\";s:29:\"Online Course &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1587474591;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/online-course-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:114;s:16:\"popularity_index\";i:565;s:11:\"trend_index\";i:533;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:425;a:20:{s:4:\"tmpl\";i:1130;s:2:\"id\";i:16535;s:5:\"title\";s:27:\"Beauty Salon &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/12/Footer.jpg\";s:12:\"tmpl_created\";i:1608622498;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/beauty-salon-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:32:\"[\"Beauty Salon\",\"Footer\",\"Hair\"]\";s:10:\"menu_order\";i:115;s:16:\"popularity_index\";i:524;s:11:\"trend_index\";i:126;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:426;a:20:{s:4:\"tmpl\";i:971;s:2:\"id\";i:13187;s:5:\"title\";s:33:\"Interior Design &#8211; Home Page\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/04/Home.png\";s:12:\"tmpl_created\";i:1586148661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/interior-design-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Business\",\"Interior Design\"]\";s:10:\"menu_order\";i:115;s:16:\"popularity_index\";i:331;s:11:\"trend_index\";i:264;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:427;a:20:{s:4:\"tmpl\";i:1453;s:2:\"id\";i:16346;s:5:\"title\";s:33:\"Your New Home &#8211; Real Estate\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2017/03/lp3-l.png\";s:12:\"tmpl_created\";i:1660205402;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/your-new-home-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:31:\"[\"Landing Pages\",\"Real estate\"]\";s:10:\"menu_order\";i:116;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:428;a:20:{s:4:\"tmpl\";i:972;s:2:\"id\";i:13199;s:5:\"title\";s:29:\"Interior Design &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/About.png\";s:12:\"tmpl_created\";i:1586148666;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/interior-design-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Business\",\"Interior Design\"]\";s:10:\"menu_order\";i:116;s:16:\"popularity_index\";i:316;s:11:\"trend_index\";i:334;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:429;a:20:{s:4:\"tmpl\";i:1129;s:2:\"id\";i:16545;s:5:\"title\";s:27:\"Beauty Salon &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/12/Header.jpg\";s:12:\"tmpl_created\";i:1608622495;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/beauty-salon-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:32:\"[\"Beauty Salon\",\"Hair\",\"Header\"]\";s:10:\"menu_order\";i:117;s:16:\"popularity_index\";i:356;s:11:\"trend_index\";i:49;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:430;a:20:{s:4:\"tmpl\";i:973;s:2:\"id\";i:13214;s:5:\"title\";s:32:\"Interior Design &#8211; Projects\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/portfolio_s.jpg\";s:12:\"tmpl_created\";i:1586148672;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/interior-design-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Business\",\"Interior Design\"]\";s:10:\"menu_order\";i:117;s:16:\"popularity_index\";i:367;s:11:\"trend_index\";i:323;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:431;a:20:{s:4:\"tmpl\";i:641;s:2:\"id\";i:7686;s:5:\"title\";s:12:\"Blog Posts 1\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2018/03/blog_posts.png\";s:12:\"tmpl_created\";i:1521558047;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/blog-posts-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:26:\"[\"Archive\",\"Blog\",\"posts\"]\";s:10:\"menu_order\";i:118;s:16:\"popularity_index\";i:131;s:11:\"trend_index\";i:152;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:432;a:20:{s:4:\"tmpl\";i:974;s:2:\"id\";i:13229;s:5:\"title\";s:31:\"Interior Design &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/Contact-Us.png\";s:12:\"tmpl_created\";i:1586148677;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/interior-design-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Business\",\"Interior Design\"]\";s:10:\"menu_order\";i:118;s:16:\"popularity_index\";i:395;s:11:\"trend_index\";i:337;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:433;a:20:{s:4:\"tmpl\";i:959;s:2:\"id\";i:12948;s:5:\"title\";s:29:\"Photography &#8211; Home Page\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/02/Home_s.png\";s:12:\"tmpl_created\";i:1582093442;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/photography-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:119;s:16:\"popularity_index\";i:241;s:11:\"trend_index\";i:201;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:434;a:20:{s:4:\"tmpl\";i:960;s:2:\"id\";i:12798;s:5:\"title\";s:25:\"Photography &#8211; About\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/About_s.png\";s:12:\"tmpl_created\";i:1582093446;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/photography-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:120;s:16:\"popularity_index\";i:499;s:11:\"trend_index\";i:374;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:435;a:20:{s:4:\"tmpl\";i:484;s:2:\"id\";i:5283;s:5:\"title\";s:9:\"Clients 1\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_2.png\";s:12:\"tmpl_created\";i:1520443478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/clients-1-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:120;s:16:\"popularity_index\";i:294;s:11:\"trend_index\";i:202;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:436;a:20:{s:4:\"tmpl\";i:961;s:2:\"id\";i:12868;s:5:\"title\";s:27:\"Photography &#8211; Contact\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/02/Contact_s.png\";s:12:\"tmpl_created\";i:1582093450;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/photography-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:121;s:16:\"popularity_index\";i:531;s:11:\"trend_index\";i:350;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:437;a:20:{s:4:\"tmpl\";i:962;s:2:\"id\";i:13056;s:5:\"title\";s:28:\"Photography &#8211; Wildlife\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/02/Wildlife_s.png\";s:12:\"tmpl_created\";i:1582093454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/photography-wildlife/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:122;s:16:\"popularity_index\";i:579;s:11:\"trend_index\";i:656;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:438;a:20:{s:4:\"tmpl\";i:487;s:2:\"id\";i:5306;s:5:\"title\";s:10:\"Clients 10\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_3.png\";s:12:\"tmpl_created\";i:1520443484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:122;s:16:\"popularity_index\";i:657;s:11:\"trend_index\";i:581;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:439;a:20:{s:4:\"tmpl\";i:963;s:2:\"id\";i:12922;s:5:\"title\";s:37:\"Photography &#8211; Glowing Jellyfish\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/02/Jellyfish_S.png\";s:12:\"tmpl_created\";i:1582093457;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/photography-glowing-jellyfish/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:123;s:16:\"popularity_index\";i:628;s:11:\"trend_index\";i:532;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:440;a:20:{s:4:\"tmpl\";i:964;s:2:\"id\";i:12875;s:5:\"title\";s:36:\"Photography &#8211; Fluttering Birds\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/Birds_s.png\";s:12:\"tmpl_created\";i:1582093461;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/photography-fluttering-birds/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:124;s:16:\"popularity_index\";i:693;s:11:\"trend_index\";i:766;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:441;a:20:{s:4:\"tmpl\";i:965;s:2:\"id\";i:12962;s:5:\"title\";s:26:\"Photography &#8211; Nature\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/02/Nature_s.png\";s:12:\"tmpl_created\";i:1582093465;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/photography-nature/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:125;s:16:\"popularity_index\";i:592;s:11:\"trend_index\";i:778;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:442;a:20:{s:4:\"tmpl\";i:491;s:2:\"id\";i:5341;s:5:\"title\";s:10:\"Clients 11\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_4.png\";s:12:\"tmpl_created\";i:1520443491;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:125;s:16:\"popularity_index\";i:603;s:11:\"trend_index\";i:633;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:443;a:20:{s:4:\"tmpl\";i:966;s:2:\"id\";i:12833;s:5:\"title\";s:38:\"Photography &#8211; Blossoming Flowers\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/02/Flowers_s.png\";s:12:\"tmpl_created\";i:1582093469;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/photography-blossoming-flowers/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:126;s:16:\"popularity_index\";i:597;s:11:\"trend_index\";i:750;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:444;a:20:{s:4:\"tmpl\";i:488;s:2:\"id\";i:5315;s:5:\"title\";s:10:\"Clients 12\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_4-1.png\";s:12:\"tmpl_created\";i:1520443486;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:126;s:16:\"popularity_index\";i:485;s:11:\"trend_index\";i:263;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:445;a:20:{s:4:\"tmpl\";i:967;s:2:\"id\";i:12898;s:5:\"title\";s:36:\"Photography &#8211; Forest Mushrooms\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/02/Mushrooms_s.png\";s:12:\"tmpl_created\";i:1582093473;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/photography-forest-mushrooms/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:127;s:16:\"popularity_index\";i:667;s:11:\"trend_index\";i:649;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:446;a:20:{s:4:\"tmpl\";i:968;s:2:\"id\";i:12994;s:5:\"title\";s:24:\"Photography &#8211; Pets\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/02/Pets_s.png\";s:12:\"tmpl_created\";i:1582093477;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/photography-pets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:128;s:16:\"popularity_index\";i:612;s:11:\"trend_index\";i:508;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:447;a:20:{s:4:\"tmpl\";i:969;s:2:\"id\";i:12805;s:5:\"title\";s:37:\"Photography &#8211; B&amp;W Portraits\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/Black_s.png\";s:12:\"tmpl_created\";i:1582093481;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/photography-bw-portraits/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:129;s:16:\"popularity_index\";i:695;s:11:\"trend_index\";i:735;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:448;a:20:{s:4:\"tmpl\";i:490;s:2:\"id\";i:5333;s:5:\"title\";s:10:\"Clients 13\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_6.png\";s:12:\"tmpl_created\";i:1520443489;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:129;s:16:\"popularity_index\";i:234;s:11:\"trend_index\";i:128;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:449;a:20:{s:4:\"tmpl\";i:970;s:2:\"id\";i:13031;s:5:\"title\";s:33:\"Photography &#8211; Vivid Parrots\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/02/Parrots_s.png\";s:12:\"tmpl_created\";i:1582093484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/photography-vivid-parrots/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:130;s:16:\"popularity_index\";i:660;s:11:\"trend_index\";i:643;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:450;a:20:{s:4:\"tmpl\";i:496;s:2:\"id\";i:5389;s:5:\"title\";s:10:\"Clients 14\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_9.png\";s:12:\"tmpl_created\";i:1520443501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:130;s:16:\"popularity_index\";i:407;s:11:\"trend_index\";i:307;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:451;a:20:{s:4:\"tmpl\";i:940;s:2:\"id\";i:12621;s:5:\"title\";s:26:\"Magazine &#8211; Home Page\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/01/Home_s.png\";s:12:\"tmpl_created\";i:1579060604;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/magazine-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:131;s:16:\"popularity_index\";i:167;s:11:\"trend_index\";i:121;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:452;a:20:{s:4:\"tmpl\";i:936;s:2:\"id\";i:12352;s:5:\"title\";s:24:\"Travel &#8211; Home Page\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/12/Home_s.png\";s:12:\"tmpl_created\";i:1575960464;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/travel-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:132;s:16:\"popularity_index\";i:291;s:11:\"trend_index\";i:194;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:453;a:20:{s:4:\"tmpl\";i:486;s:2:\"id\";i:5298;s:5:\"title\";s:10:\"Clients 15\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_3.png\";s:12:\"tmpl_created\";i:1520443482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:132;s:16:\"popularity_index\";i:465;s:11:\"trend_index\";i:520;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:454;a:20:{s:4:\"tmpl\";i:932;s:2:\"id\";i:12400;s:5:\"title\";s:20:\"Travel &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/12/About.png\";s:12:\"tmpl_created\";i:1575960441;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/travel-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:133;s:16:\"popularity_index\";i:444;s:11:\"trend_index\";i:445;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:455;a:20:{s:4:\"tmpl\";i:938;s:2:\"id\";i:12479;s:5:\"title\";s:20:\"Travel &#8211; Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/Tours_s.png\";s:12:\"tmpl_created\";i:1575960474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/travel-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:134;s:16:\"popularity_index\";i:539;s:11:\"trend_index\";i:726;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:456;a:20:{s:4:\"tmpl\";i:495;s:2:\"id\";i:5381;s:5:\"title\";s:10:\"Clients 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_9.png\";s:12:\"tmpl_created\";i:1520443499;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/clients-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:134;s:16:\"popularity_index\";i:198;s:11:\"trend_index\";i:168;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:457;a:20:{s:4:\"tmpl\";i:937;s:2:\"id\";i:12466;s:5:\"title\";s:27:\"Travel &#8211; Testimonials\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/Testimonials.png\";s:12:\"tmpl_created\";i:1575960469;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/travel-testimonials/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:135;s:16:\"popularity_index\";i:527;s:11:\"trend_index\";i:481;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:458;a:20:{s:4:\"tmpl\";i:935;s:2:\"id\";i:12443;s:5:\"title\";s:22:\"Travel &#8211; Gallery\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/Gallery.png\";s:12:\"tmpl_created\";i:1575960459;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/travel-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:136;s:16:\"popularity_index\";i:467;s:11:\"trend_index\";i:501;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:459;a:20:{s:4:\"tmpl\";i:934;s:2:\"id\";i:12431;s:5:\"title\";s:18:\"Travel &#8211; FAQ\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/12/FAQ.png\";s:12:\"tmpl_created\";i:1575960453;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/travel-faq/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:137;s:16:\"popularity_index\";i:501;s:11:\"trend_index\";i:387;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:460;a:20:{s:4:\"tmpl\";i:493;s:2:\"id\";i:5357;s:5:\"title\";s:9:\"Clients 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_7.png\";s:12:\"tmpl_created\";i:1520443495;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/clients-2-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:137;s:16:\"popularity_index\";i:341;s:11:\"trend_index\";i:232;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:461;a:20:{s:4:\"tmpl\";i:933;s:2:\"id\";i:12421;s:5:\"title\";s:27:\"Travel &#8211; Contact Page\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/12/Contsct-Us.png\";s:12:\"tmpl_created\";i:1575960445;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/travel-contact-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:138;s:16:\"popularity_index\";i:571;s:11:\"trend_index\";i:536;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:462;a:20:{s:4:\"tmpl\";i:892;s:2:\"id\";i:11763;s:5:\"title\";s:27:\"Portfolio &#8211; Home Page\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Homepage_small.png\";s:12:\"tmpl_created\";i:1569428959;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/portfolio-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Creative Portfolio\",\"Portfolio\"]\";s:10:\"menu_order\";i:139;s:16:\"popularity_index\";i:280;s:11:\"trend_index\";i:241;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:463;a:20:{s:4:\"tmpl\";i:485;s:2:\"id\";i:5290;s:5:\"title\";s:9:\"Clients 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_2.png\";s:12:\"tmpl_created\";i:1520443480;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/clients-3-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"Clients\"]\";s:10:\"menu_order\";i:139;s:16:\"popularity_index\";i:545;s:11:\"trend_index\";i:502;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:464;a:20:{s:4:\"tmpl\";i:891;s:2:\"id\";i:11781;s:5:\"title\";s:23:\"Portfolio &#8211; About\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/About_small.png\";s:12:\"tmpl_created\";i:1569428955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/portfolio-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Creative Portfolio\",\"Portfolio\"]\";s:10:\"menu_order\";i:140;s:16:\"popularity_index\";i:349;s:11:\"trend_index\";i:290;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:465;a:20:{s:4:\"tmpl\";i:482;s:2:\"id\";i:5266;s:5:\"title\";s:9:\"Clients 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_1.png\";s:12:\"tmpl_created\";i:1520443474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/clients-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s