<?php

/**
 * @author Iman Yazdani Charati
 * @copyright 2017
 * @package ICP - Blog
 * @license ICLASSIC
 */

     function head_title($title='',$url='',$image='',$desc='...',$writer='admin',$key=''){
         global $ic_app_url;
         global $ic_app_title;
         return '<title>'.$title.'</title>
         <meta name="copyright" content="'.$writer.'" />
         <meta name="description" content="'.mb_strcut($desc,0,150).'" />
         <meta name="keywords" content="'.str_replace("-",",",$key).'" />
         <meta name="application-name" content="'.$ic_app_title.'" />
         <meta property="og:url" content="'.$url.'" />
         <meta property="og:image" content="'.$image.'" />
         <meta property="og:description" content="'.$desc.'" />
         <meta property="og:title" content="'.$title.'" />
         <meta property="og:site_name" content="'.$ic_app_title.'" />
         <meta property="og:determiner" content="the" />
         <meta property="og:locale" content="fa_IR" />
         <meta property="og:site_name" content="'.$title.'" />
         <meta property="og:type" content="website" />
         <meta name="twitter:card" content="summary" />
         <meta name="twitter:url" content="'.$url.'" />
         <meta name="twitter:title" content="'.$title.'" />
         <meta name="twitter:description" content="'.$desc.'" />
         <meta name="twitter:image" content="'.$image.'" />
         <link rel="Author" href="'.$writer.'" />
         <link rel="canonical" href="'.$url.'" />';
     }

     function price_detect($var,$zero='',$lang='fa'){
        if($var>0){
            return tr_num(number_format($var/10),$lang).' تومان';
        }else{
            return $zero;
        }
     } 
     function price_detect2($var,$var2,$zero='',$lang='fa'){
        if($var>0){
            if($var2>0){
                return '<span style="text-decoration:line-through;" class="tt grey-text ml-1 right">'.tr_num(number_format($var2/10),$lang).' تومان</span>'.tr_num(number_format($var/10),$lang).' تومان';
            }else{
                return tr_num(number_format($var/10),$lang).' تومان';
            }
        }else{
            return $zero;
        }
     }
     
     function checkEmail($email) {
       $find1 = strpos($email, '@');
       $find2 = strpos($email, '.');
       return ($find1 !== false && $find2 !== false && $find2 > $find1);
    }
     
     function titlize($string){
        $url = trim($string);
        $url = str_replace("-","_",$url);
        $url = str_replace(" ","-",$url);
        $url = str_replace("/","-slash-",$url);
        return $url;
     }
     function untitlize($string){
        $url = trim($string);
        $url = str_replace("-"," ",$url);
        $url = str_replace("_","-",$url);
        $url = str_replace("-slash-","/",$url);
        return $url;
     }
     
     function expire($date){
            $date=explode(' ',$date);
            //time
            $date['1']=explode(':',$date['1']);
            $time=$date['1']['0'].':'.$date['1']['1'];
            //date
            $date['0']=explode('/',$date['0']);
            $date2=jalali_to_gregorian($date['0']['0'],$date['0']['1'],$date['0']['2'],'/');
            
            if(time() > strtotime($date2.' '.$time)){
                return true;
            }else{
                return false;
            }
     }
     function timeadd($date,$timeup){
            $date=explode(' ',$date);
            //time
            $date['1']=explode(':',$date['1']);
            $time=$date['1']['0'].':'.$date['1']['1'];
            //date
            $date['0']=explode('/',$date['0']);
            $date2=jalali_to_gregorian($date['0']['0'],$date['0']['1'],$date['0']['2'],'/');
            
            $time=date('Y/m/d H:i',(strtotime(date($date2.' '.$time))+$timeup));
  
            $time=explode(' ',$time);
            $time['1']=explode(':',$time['1']);
            $date['0']=explode('/',$time['0']);  
            $time=$time['1']['0'].':'.$time['1']['1'];
            $date3=gregorian_to_jalali($date['0']['0'],$date['0']['1'],$date['0']['2'],'/');
            $date=$date3.' '.$time;
            return $date;
  }
  function time_ago($date,$time=null,$full=false){
            if(!empty($date)){
            $date=explode('/',$date);
            $date2=jalali_to_gregorian($date['0'],$date['1'],$date['2'],'/');
			$now = new DateTime;
            if($time==null){
                $ago = new DateTime($date2);
            }else{
                $ago = new DateTime($date2.' '.$time);
            }
			$diff = $now->diff($ago);
			$diff->w = floor($diff->d / 7);
			$diff->d -= $diff->w * 7;
			$string = array(
				'y' => 'سال',
				'm' => 'ماه',
				'w' => 'هفته',
				'd' => 'روز',
				'h' => 'ساعت',
				'i' => 'دقیقه',
				's' => 'ثانیه',
			);
			foreach ($string as $k => &$v) {
				if ($diff->$k) {
					$v = $diff->$k . ' ' . $v . ($diff->$k > 1 ? '' : '');
				} else {
					unset($string[$k]);
				}
			}
			if (!$full) $string = array_slice($string, 0, 1);
			return $string ? implode(', ', $string) . ' پیش' : 'لحظاتی پیش';     
            }else{
                return $date;   
            }           
   }
   function clearstr($var) {
			$var = str_replace("'","",$var);
			$var = str_replace("--","",$var);
			$var = str_replace(" / ","",$var);
			$var = str_replace("\\","",$var);
			$var = str_replace("\"","",$var);
			$var = str_replace("!","",$var);
			$var = str_replace("?","",$var);
			$var = str_replace("$","",$var);
			$var = str_replace(" * ","",$var);
			$var = str_replace(" SELECT ","",$var);
			$var = str_replace(" UNION ","",$var);
			$var = str_replace(" from ","",$var);
			$var = str_replace("=","",$var);
			$var = str_replace(" where ","",$var);
			$var = str_replace(" WHERE ","",$var);
			$var = str_replace(" select ","",$var);
			$var = str_replace(" union ","",$var);
			$var = str_replace(";","",$var);
			$var = str_replace("&","",$var);
			$var = str_replace(" OR ","",$var);
			$var = str_replace(" or ","",$var);
			$var = str_replace(" and ","",$var);
			$var = str_replace(" AND ","",$var);
			$var = str_replace("--","",$var);
			$var = trim($var);
			return $var;
    }
    
    function post_tag($tag=null){
    if(strlen($tag)>3){
        $tag=explode(',',$tag);
        foreach($tag as $to){
            if(strlen($to)>2){
                $to2=str_replace(' ','-',$to);
                echo '<a class="chip" href="tag/'.$to2.'"><strong>'.$to.'</strong></a>&nbsp;';
            }
        }        
    }
    }
    function findexts ($filename) {
          $filename=strtolower($filename);
          $exts=explode(".", $filename);
          $n=count($exts)-1;
          $exts=$exts[$n];
          return $exts;
    }
	function format($name){
	$extn=findexts($name);
            switch ($extn){
            case "png": return "PNG Image"; break;
            case "jpg": return "JPEG Image"; break;
            case "svg": return "SVG Image"; break;
            case "gif": return "GIF Image"; break;
            case "ico": return "Windows Icon"; break;
            case "txt": return "Text File"; break;
            case "log": return "Log File"; break;
            case "htm": return "HTML File"; break;
            case "php": return "PHP Script"; break;
            case "js": return "Javascript"; break;
            case "css": return "Stylesheet"; break;
            case "pdf": return "PDF Document"; break;
            case "zip": return "ZIP Archive"; break;
            case "bak": return "Backup File"; break;
            default: return strtoupper($extn)." File"; break;
          }
    }
    function roundToTheNearestAnything($value, $roundTo){
        $mod = $value%$roundTo;
        return intval($value+($mod<($roundTo/2)?-$mod:$roundTo-$mod));
    }
    function ftime($name){
          $modtime=jdate("H:i - Y/m/d", filemtime($name));
          return $modtime;
    }
    function fsize($name,$unit='بایت'){
		// Gets file size 
        $size=filesize($name);
        if($size>0 && $size<999){
            return '<b>'.$size.'</b> '.$unit;
        }elseif($size>999 && $size<999999){
            return '<b>'.round($size/1000).'</b> کیلو'.$unit;
        }elseif($size>999999 && $size<999999999){
            return '<b>'.round($size/1000000,2).'</b> مگا'.$unit;
        }else{
            return $size;
        }
    }
    function tsize($size,$unit='بایت'){
        if($size>0 && $size<999){
            return '<b>'.$size.'</b> '.$unit;
        }elseif($size>999 && $size<999999){
            return '<b>'.round($size/1000).'</b> کیلو'.$unit;
        }elseif($size>999999 && $size<999999999){
            return '<b>'.round($size/1000000,2).'</b> مگا'.$unit;
        }else{
            return $size;
        }
    } 
    function getDistanceBetweenPointsNew($latitude1, $longitude1, $latitude2, $longitude2, $unit = 'Km') {
       $theta = $longitude1 - $longitude2;
       $distance = (sin(deg2rad($latitude1)) * sin(deg2rad($latitude2)))+(cos(deg2rad($latitude1)) * cos(deg2rad($latitude2)) * cos(deg2rad($theta)));
       $distance = acos($distance); $distance = rad2deg($distance); 
       $distance = $distance * 60 * 1.1515;
    
       switch($unit){ 
         case 'Mi': break;
         case 'Km' : $distance = $distance * 1.609344; 
       } 
       return (round($distance,2)); 
    }
    function en_status($sts){
            switch ($sts){
            case true: return "<strong class=\"green-text\">فعال</strong>"; break;
            case false: return "<em class=\"red-text\">غیرفعال</em>"; break;
            case "1": return "<strong class=\"green-text\">فعال</strong>"; break;
            case "0": return "<em class=\"red-text\">غیرفعال</em>"; break;
            default: return "..."; break;
          }
    }
    function admin_notif(){
        global $ic_app_url;
        global $PRIME;
        $message='';
        //===========
        $count=$PRIME->getnrow('flag',0,'pm');
        if($count>0){
            $message.='<a href="'.$ic_app_url.'mypanel/panel/pm" class="ml-3">'.$count.' پیام نخوانده</a>';
        }
        //===========
        $count=$PRIME->getnrow('status',0,'comments');
        if($count>0){
            $message.='<a href="'.$ic_app_url.'mypanel/panel/comment" class="ml-3">'.$count.' نظر تایید نشده</a>';
        }
        //===========
        $count=$PRIME->getnrow4('repmid','0','pmto','0','flagpmto','0','part','پشتیبانی','inegar');
        if($count>0){
            $message.='<a href="'.$ic_app_url.'mypanel/panel/inegar?part=پشتیبانی" class="ml-3">'.$count.' پیام پشتیبانی</a>';
        }
        //===========
        $count=$PRIME->getnrow4('repmid','0','pmto','0','flagpmto','0','part','مدیریت','inegar');
        if($count>0){
            $message.='<a href="'.$ic_app_url.'mypanel/panel/inegar?part=مدیریت" class="ml-3">'.$count.' پیام مدیریت</a>';
        }
        //===========
        $count=$PRIME->getnrow4('repmid','0','pmto','0','flagpmto','0','part','مالی','inegar');
        if($count>0){
            $message.='<a href="'.$ic_app_url.'mypanel/panel/inegar?part=مالی" class="ml-3">'.$count.' پیام امور مالی</a>';
        }
        //echo alert('گزارش بدست آمده از موارد بررسی نشده : '.$message,'warning','موارد بررسی نشده','موارد فوق باید بررسی شوند');
    }
    

        function getOS($userAgent) {
            $osPlatform    =   "Unknown OS Platform";
            $os_array       =   array(
                'windows nt 10.0'    => 'Windows 10',
                'windows nt 6.2'     =>  'Windows 8',
                'windows nt 6.1'     =>  'Windows 7',
                'windows nt 6.0'     =>  'Windows Vista',
                'windows nt 5.2'     =>  'Windows Server 2003/XP x64',
                'windows nt 5.1'     =>  'Windows XP',
                'windows xp'         =>  'Windows XP',
                'windows nt 5.0'     =>  'Windows 2000',
                'windows me'         =>  'Windows ME',
                'win98'              =>  'Windows 98',
                'win95'              =>  'Windows 95',
                'win16'              =>  'Windows 3.11',
                'macintosh|mac os x' =>  'Mac OS X',
                'mac_powerpc'        =>  'Mac OS 9',
                'linux'              =>  'Linux',
                'ubuntu'             =>  'Ubuntu',
                'phone'             =>  'iPhone',
                'pod'               =>  'iPod',
                'pad'               =>  'iPad',
                'android'            =>  'Android',
                'blackberry'         =>  'BlackBerry',
                'webos'              =>  'Mobile'
            );
            foreach ($os_array as $label => $value) {
                if (stripos($userAgent, $label)) {
                    return $value;
                }
            }
            return $osPlatform;
        }

        function getBrowser($userAgent) {
            // Make case insensitive.
            $t = strtolower($userAgent);
    
            // If the string *starts* with the string, strpos returns 0 (i.e., FALSE). Do a ghetto hack and start with a space.
            // "[strpos()] may return Boolean FALSE, but may also return a non-Boolean value which evaluates to FALSE."
            //        http://php.net/manual/en/function.strpos.php
            $t = " " . $t;
    
            // Humans / Regular Users      
            if     (strpos($t, 'opera'     ) || strpos($t, 'opr/')     ) return 'Opera'            ;
            elseif (strpos($t, 'edge'      )                           ) return 'Edge'             ;
            elseif (strpos($t, 'chrome'    )                           ) return 'Chrome'           ;
            elseif (strpos($t, 'safari'    )                           ) return 'Safari'           ;
            elseif (strpos($t, 'firefox'   )                           ) return 'Firefox'          ;
            elseif (strpos($t, 'msie'      ) || strpos($t, 'trident/7')) return 'Internet Explorer';
    
            // Search Engines  
            elseif (strpos($t, 'google'    )                           ) return '[Bot] Googlebot'   ;
            elseif (strpos($t, 'bing'      )                           ) return '[Bot] Bingbot'     ;
            elseif (strpos($t, 'slurp'     )                           ) return '[Bot] Yahoo! Slurp';
            elseif (strpos($t, 'duckduckgo')                           ) return '[Bot] DuckDuckBot' ;
            elseif (strpos($t, 'baidu'     )                           ) return '[Bot] Baidu'       ;
            elseif (strpos($t, 'yandex'    )                           ) return '[Bot] Yandex'      ;
            elseif (strpos($t, 'sogou'     )                           ) return '[Bot] Sogou'       ;
            elseif (strpos($t, 'exabot'    )                           ) return '[Bot] Exabot'      ;
            elseif (strpos($t, 'msn'       )                           ) return '[Bot] MSN'         ;
    
            // Common Tools and Bots
            elseif (strpos($t, 'mj12bot'   )                           ) return '[Bot] Majestic'     ;
            elseif (strpos($t, 'ahrefs'    )                           ) return '[Bot] Ahrefs'       ;
            elseif (strpos($t, 'semrush'   )                           ) return '[Bot] SEMRush'      ;
            elseif (strpos($t, 'rogerbot'  ) || strpos($t, 'dotbot')   ) return '[Bot] Moz or OpenSiteExplorer';
            elseif (strpos($t, 'frog'      ) || strpos($t, 'screaming')) return '[Bot] Screaming Frog';
            elseif (strpos($t, 'blex'      )                           ) return '[Bot] BLEXBot'       ;
            
            // Miscellaneous 
            elseif (strpos($t, 'facebook'  )                           ) return '[Bot] Facebook'     ;
            elseif (strpos($t, 'pinterest' )                           ) return '[Bot] Pinterest'    ;
            
            // Check for strings commonly used in bot user agents   
            elseif (strpos($t, 'crawler' ) || strpos($t, 'api'    ) ||
                    strpos($t, 'spider'  ) || strpos($t, 'http'   ) ||
                    strpos($t, 'bot'     ) || strpos($t, 'archive') || 
                    strpos($t, 'info'    ) || strpos($t, 'data'   )    ) return '[Bot] Other'   ;
            
            return 'Other (Unknown)';
        }


?>