<?php 
ob_start();
session_start();
require_once 'ic-prime/config_app.php'; 
?>
<!DOCTYPE>
<html lang="fa">
<head>
    <?php include_once 'index-meta.php'; ?>
    <title><?php echo $ic_app_title.""; ?></title>
    <style>
    .new-box-main {
        background-image: url(http://qqtheme.scooait.com/wp-content/uploads/2020/04/call-to-action.jpg);
        background-position: center center;
        background-repeat: no-repeat;
        background-size: cover;
    }
    .new-select-main {
        background-color: #303441;
        background-image: url(http://qqtheme.scooait.com/wp-content/uploads/2020/04/transparent-ancient-right_new.png);
        background-position: top left;
        background-repeat: no-repeat;
    }
    .new-select-main .card-panel {
        padding: 36px 20px 30px 30px;
        border-style: solid;
        border-width: 3px 0px 0px 0px;
        border-color: #43c370;
        border-radius: 0!important;
        transition: 0.3s;
    }
    .new-select-main .card-panel:hover{
        background-color: #43c370!important;
    }
    .last-agahi{
        background-color: #ededed;
        background-image: url(http://qqtheme.scooait.com/wp-content/uploads/2020/04/location_bg.jpg);
        background-position: top right;
        background-repeat: no-repeat;
    }
    .main-white-layer {
        background-color: #ededed;
        background-image: url(http://qqtheme.scooait.com/wp-content/uploads/2020/04/location_bg.jpg);
        background-position: top right;
        background-repeat: no-repeat;
    }
    </style>
</head>
<body class="fss white" dir="rtl">
    <?php include_once 'index-header.php'; ?>
    <section class="grey lighten-3 main-white-layer">
        <div class="container">
            <div class="row pt-3">
                <div class="col l8 m6 s12">
                    <h4 class="m mb-0 blue-grey-text text-darken-3 fss-bold py-3 lh28">
                        <i class="material-icons right small">star</i>جدید ترین آگهی ها
                    </h4>
                    <hr class="op-1 w-50 m-0 right mb-3 mr-0 bg-footer hh1" />
                </div>
                <div class="col l4 m6 s12">
                    <h5 class="fss-bold s p-3 left-align blue-grey-text text-darken-2">تعداد کل : <span class="green-text text-accent-3"><?php echo $agahi_new=$PRIME->getnrow('status',1,'agahi'); ?> آگهی</span></h5>
                </div>
            </div>
            <div class="sl2 owl-carousel owl-theme" dir="ltr">
                <?php 
                if($agahi_new>0){
            	    $agahi_new1=$PRIME->getrow('status',1,'agahi',true);
                    foreach($agahi_new1 as $agahi_new1_data){
                        echo '<div class="item p-2"><a href="'.$ic_app_url.'agahi/'.titlize($agahi_new1_data['title']).'">
                        <div class="card hoverable border" dir="rtl">
                              <div class="card-image waves-effect waves-block waves-light">
                                <img src="'.$ic_app_url.'ic-media/content/agahi/thumb/'.$agahi_new1_data['picture'].'" />
                              </div>
                              <div class="card-content">
                                <span class="card-title fss-medium blue-grey-text text-darken-2 ss">'.$agahi_new1_data['title'].'</span>
                                <p class="text-justify tt grey-text" style="height:80px;">'.$agahi_new1_data['content'].'</p>
                              </div>
                              <div class="card-action blue-grey-text left-align fss-bold">
                                '.price_detect($agahi_new1_data['price'],'<span class="blue-text">تماس بگیرید</span>').'
                              </div>
                            </div></a>
                        </div>';
                    }
               	}
                ?>
            </div>
        </div>
    </section>
    <section class="white">
        <div class="container">
            <div class="row py-5">
            <div class="col l12 m12 s12">
                <h4 class="m mb-0 blue-grey-text text-darken-3 fss-bold py-3 lh28">
                    <i class="material-icons right small">list</i>دسته بندی ها
                </h4>
                <hr class="op-1 w-50 m-0 right mb-3 mr-0 bg-footer hh1" />
            </div>
            <?php if($PRIME->getnrow2('type','agahi','sub',0,'cats')>0){
        	       $cat_pree=$PRIME->getrow2('type','agahi','sub',0,'cats',true);
                    foreach($cat_pree as $cat_dataa){
                        echo '<div class="col l4 m6 s12 mb-3">
                            <a class="card-panel grey lighten-4 blue-grey-text fss-bold ss text-darken-2 z-depth-0 border center-align btn-block" href="'.$ic_app_url.'cat/'.titlize($cat_dataa['title']).'">
                                <img width="95" class="circle center-block mb-3" src="'.$ic_app_url.'ic-media/content/cat/'.$cat_dataa['thumb'].'" />
                                '.$cat_dataa['title'].'
                                <br /><span class="grey-text tt fss-medium">( '.$PRIME->getnrow('sub',$cat_dataa['id'],'cats').' زیر دسته بندی )</span>
                            </a>
                        </div>';
                    }
           	} ?>
            <div class="col l12 m12 s12">
                <h4 class="m mb-0 blue-grey-text text-darken-3 fss-bold py-3 lh28">
                    <i class="material-icons right small">location_city</i>آخرین آگهی های آپارتمان
                    <span class="fss-bold s p-3 left-align blue-grey-text text-darken-2 left">تعداد کل : <span class="green-text text-accent-3"><?php echo $agahi_new=$PRIME->getnrow2('status',1,'cat',2223,'agahi'); ?> آگهی</span></span>
                </h4>
                <hr class="op-1 w-50 m-0 right mb-3 mr-0 bg-footer hh1" />
                <div class="row w-100 mt-2">
                <div class="col l12 m12 s12"></div>
                <?php 
                
                if($agahi_new>0){
            	    $agahi_new1=$PRIME->getrow2('status',1,'cat',2223,'agahi',true);
                    foreach($agahi_new1 as $agahi_new1_data){
                        echo '<div class="col l3 m6 s12">
                        <a href="'.$ic_app_url.'agahi/'.titlize($agahi_new1_data['title']).'">
                        <div class="card hoverable border" dir="rtl">
                              <div class="card-image waves-effect waves-block waves-light">
                                <img src="'.$ic_app_url.'ic-media/content/agahi/thumb/'.$agahi_new1_data['picture'].'" />
                              </div>
                              <div class="card-content">
                                <span class="card-title fss-medium blue-grey-text text-darken-2 ss">'.$agahi_new1_data['title'].'</span>
                              </div>
                              <div class="card-action blue-grey-text left-align fss-bold">
                                '.price_detect($agahi_new1_data['price'],'<span class="blue-text">تماس بگیرید</span>').'
                              </div>
                            </div></a>
                        </div>';
                    }
               	}
                ?>
                </div>
            </div>
            </div>
        </div>
    </section>
    <section class="new-box-main">
        <div class="container py-5">
            <div class="row py-5">
                <div class="col l6 m12 s12">
                    <div class="card-panel amber accent-4">
                        <div class="row">
                            <div class="col l5 m12 s12">
                                <svg class="responsive-img center-block" xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="100" height="100" viewBox="0 0 172 172" style=" fill:#000000;"><g fill="none" fill-rule="nonzero" stroke="none" stroke-width="1" stroke-linecap="butt" stroke-linejoin="miter" stroke-miterlimit="10" stroke-dasharray="" stroke-dashoffset="0" font-family="none" font-weight="none" font-size="none" text-anchor="none" style="mix-blend-mode: normal"><path d="M0,172v-172h172v172z" fill="none"></path><g fill="#ffffff"><path d="M83.302,16.16699c-0.16797,0 -0.32544,0.0105 -0.49341,0.04199c-0.16797,0.04199 -0.33594,0.08398 -0.50391,0.14697c-0.15747,0.07348 -0.30444,0.15747 -0.46191,0.25195c-0.07349,0.05249 -0.17847,0.07348 -0.25195,0.13647l-33.21582,27.49439v-9.1438c0,-1.49072 -1.19678,-2.6875 -2.6875,-2.6875c-1.49072,0 -2.6875,1.19678 -2.6875,2.6875v13.4375c0,0.04199 0.021,0.08398 0.03149,0.13647l-5.40649,4.46167v-28.79614c0,-1.48023 -1.19678,-2.6875 -2.6875,-2.6875c-1.49072,0 -2.6875,1.20727 -2.6875,2.6875v32.2605c0,0.29395 0.08398,0.57739 0.16797,0.85034l-28.76465,23.79907c-1.14429,0.94482 -1.29126,2.63501 -0.35693,3.7793c0.5354,0.64038 1.31226,0.97632 2.07861,0.97632c0.60889,0 1.21777,-0.19946 1.72168,-0.61939l9.02832,-7.47461v67.21899h-8.0625c-1.49072,0 -2.6875,1.20728 -2.6875,2.6875c0,1.48022 1.19678,2.6875 2.6875,2.6875h150.5c1.49072,0 2.6875,-1.20728 2.6875,-2.6875c0,-1.48022 -1.19678,-2.6875 -2.6875,-2.6875h-8.0625v-67.21899l9.02832,7.47461c0.50391,0.41992 1.11279,0.61939 1.72168,0.61939c0.76636,0 1.53272,-0.33594 2.06811,-0.96582c0.94483,-1.15478 0.78735,-2.84497 -0.35693,-3.78979l-77.9375,-64.5c-0.07349,-0.06299 -0.16797,-0.08398 -0.25195,-0.13647c-0.15747,-0.10498 -0.30444,-0.18897 -0.48291,-0.25195c-0.15747,-0.06299 -0.30444,-0.10498 -0.47241,-0.14697c-0.16797,-0.03149 -0.33594,-0.04199 -0.5144,-0.04199zM83.3125,22.29785l61.8125,51.15698v44.79517h-43v-21.5c0,-2.96045 -2.41455,-5.375 -5.375,-5.375h-26.875c-2.96045,0 -5.375,2.41455 -5.375,5.375v21.5h-43v-44.79517zM83.3125,48.375c-7.41162,0 -13.4375,6.02588 -13.4375,13.4375c0,7.41162 6.02588,13.4375 13.4375,13.4375c7.41162,0 13.4375,-6.02588 13.4375,-13.4375c0,-7.41162 -6.02588,-13.4375 -13.4375,-13.4375zM83.3125,53.1936c4.75561,0 8.6189,3.86328 8.6189,8.6189c0,4.75561 -3.86328,8.6189 -8.6189,8.6189c-4.75561,0 -8.6189,-3.86328 -8.6189,-8.6189c0,-4.75561 3.86328,-8.6189 8.6189,-8.6189zM69.875,96.75h26.875v48.23853h-26.875zM88.6875,115.5625c-1.49072,0 -2.6875,1.20728 -2.6875,2.6875v5.375c0,1.48022 1.19678,2.6875 2.6875,2.6875c1.49072,0 2.6875,-1.20728 2.6875,-2.6875v-5.375c0,-1.48022 -1.19678,-2.6875 -2.6875,-2.6875zM21.5,123.625h43v21.5h-43zM102.125,123.625h43v21.5h-43zM29.5625,129c-1.49072,0 -2.6875,1.20728 -2.6875,2.6875v5.375c0,1.48022 1.19678,2.6875 2.6875,2.6875c1.49072,0 2.6875,-1.20728 2.6875,-2.6875v-5.375c0,-1.48022 -1.19678,-2.6875 -2.6875,-2.6875zM43,129c-1.49072,0 -2.6875,1.20728 -2.6875,2.6875v5.375c0,1.48022 1.19678,2.6875 2.6875,2.6875c1.49072,0 2.6875,-1.20728 2.6875,-2.6875v-5.375c0,-1.48022 -1.19678,-2.6875 -2.6875,-2.6875zM56.4375,129c-1.49072,0 -2.6875,1.20728 -2.6875,2.6875v5.375c0,1.48022 1.19678,2.6875 2.6875,2.6875c1.49072,0 2.6875,-1.20728 2.6875,-2.6875v-5.375c0,-1.48022 -1.19678,-2.6875 -2.6875,-2.6875zM110.1875,129c-1.49072,0 -2.6875,1.20728 -2.6875,2.6875v5.375c0,1.48022 1.19678,2.6875 2.6875,2.6875c1.49072,0 2.6875,-1.20728 2.6875,-2.6875v-5.375c0,-1.48022 -1.19678,-2.6875 -2.6875,-2.6875zM123.625,129c-1.49072,0 -2.6875,1.20728 -2.6875,2.6875v5.375c0,1.48022 1.19678,2.6875 2.6875,2.6875c1.49072,0 2.6875,-1.20728 2.6875,-2.6875v-5.375c0,-1.48022 -1.19678,-2.6875 -2.6875,-2.6875zM137.0625,129c-1.49072,0 -2.6875,1.20728 -2.6875,2.6875v5.375c0,1.48022 1.19678,2.6875 2.6875,2.6875c1.49072,0 2.6875,-1.20728 2.6875,-2.6875v-5.375c0,-1.48022 -1.19678,-2.6875 -2.6875,-2.6875z"></path></g></g></svg>
                            </div>
                            <div class="col l7 m12 s12">
                                <h4 class="fss-bold white-text m">به دنبال ملک جدید هستید؟</h4>
                                <p class="tt white-text fss-thin text-justify">هر روز دهها آگهی جدید و صدها پیشنهاد در سایت،که مورد اعتماد جامعه ای از هزاران نفر از کاربران است، دراختیار شماست.</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col l6 m12 s12">
                    <div class="card-panel amber accent-4">
                        <div class="row">
                            <div class="col l5 m12 s12">
                                <svg class="responsive-img center-block" xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="100" height="100" viewBox="0 0 172 172" style=" fill:#000000;"><g fill="none" fill-rule="nonzero" stroke="none" stroke-width="1" stroke-linecap="butt" stroke-linejoin="miter" stroke-miterlimit="10" stroke-dasharray="" stroke-dashoffset="0" font-family="none" font-weight="none" font-size="none" text-anchor="none" style="mix-blend-mode: normal"><path d="M0,172v-172h172v172z" fill="none"></path><g fill="#ffffff"><path d="M86,24.07664c-0.3612,0 -0.72173,0.11382 -1.03133,0.34602l-60.2,44.72c-0.43,0.3268 -0.68867,0.82694 -0.68867,1.37734v17.2c0,0.6536 0.36254,1.23947 0.94734,1.53187c0.5848,0.2924 1.27078,0.24107 1.80398,-0.15453l4.12867,-3.06711v56.72977c0,0.94944 0.76884,1.72 1.72,1.72h106.64c0.95116,0 1.72,-0.77056 1.72,-1.72v-56.72977l4.12867,3.06711c0.3096,0.2236 0.67013,0.34266 1.03133,0.34266c0.258,0 0.53186,-0.06772 0.77266,-0.18812c0.5848,-0.2924 0.94734,-0.87828 0.94734,-1.53187v-17.2c0,-0.5504 -0.25867,-1.05054 -0.68867,-1.37734l-14.79133,-10.98516v-20.3175h2.58c0.47472,0 0.86,-0.38528 0.86,-0.86v-6.88c0,-0.47472 -0.38528,-0.86 -0.86,-0.86h-17.2c-0.47472,0 -0.86,0.38528 -0.86,0.86v6.88c0,0.47472 0.38528,0.86 0.86,0.86h2.58v11.36477l-33.36867,-24.78211c-0.3096,-0.2322 -0.67013,-0.34602 -1.03133,-0.34602zM86,27.95l34.4,25.55477v4.97523c0,0.27004 0.12594,0.52699 0.34266,0.68867l5.16,3.87c0.3784,0.28552 0.9205,0.21051 1.20602,-0.17133c0.2838,-0.38012 0.20543,-0.9205 -0.17469,-1.20602l-4.81734,-3.61133v-3.26867v-4.3v-13.50133c0,-0.47472 -0.38528,-0.86 -0.86,-0.86h-2.57664v-5.16h15.48v5.16h-2.58c-0.47472,0 -0.86,0.38528 -0.86,0.86v19.90094v4.2832v3.33586l-0.34266,-0.25867c-0.37668,-0.28208 -0.91878,-0.21051 -1.20602,0.17133c-0.2838,0.38012 -0.20543,0.9205 0.17469,1.20602l1.72,1.29c0.15136,0.11352 0.3333,0.17133 0.51734,0.17133c0.13072,0 0.26085,-0.0305 0.38297,-0.0907c0.28896,-0.1462 0.47367,-0.44422 0.47367,-0.7693v-3.7793l12.04,8.9393v12.9168l-57.44867,-42.67414c-0.3096,-0.2236 -0.67013,-0.34266 -1.03133,-0.34266c-0.3612,0 -0.72173,0.11906 -1.03133,0.34266l-57.44867,42.67414v-12.9168zM86,45.15l51.6,38.32375v57.56625h-103.2v-57.56625zM87.01453,72.24c-0.48504,0 -0.8829,0.12201 -1.19594,0.36281c-0.31476,0.24768 -0.47367,0.54763 -0.47367,0.90367v2.07609c-3.36604,0.2236 -6.19302,1.23923 -8.48578,3.04695c-2.29276,1.80944 -3.44,4.63806 -3.44,8.48914c0,0.8514 0.05453,1.64555 0.16461,2.38515c0.10836,0.7396 0.2945,1.42478 0.55766,2.05258l0.71891,1.67969c0.21844,0.49364 0.59071,0.9862 1.11531,1.47813c0.5246,0.49364 0.92893,0.89797 1.21273,1.21273c0.2838,0.31304 0.79555,0.64669 1.53859,1.00445l1.44117,0.80961c0.30616,0.17888 0.89663,0.44849 1.77039,0.80625l1.63938,0.60469l1.76703,0.67188v19.55492c-1.83524,-0.043 -3.47005,-0.35755 -4.91141,-0.94062c-1.44308,-0.57964 -2.49241,-1.20701 -3.14773,-1.88125l-1.83422,-1.88125c-0.5246,-0.53836 -0.94189,-0.80625 -1.24633,-0.80625c-0.47988,0 -0.92923,0.28084 -1.34375,0.83984c-0.41624,0.56244 -0.62148,1.10773 -0.62148,1.6461c0,1.44824 1.24679,2.98366 3.73562,4.60906c2.49056,1.62368 5.6111,2.45466 9.3693,2.49938v2.49938c0,0.3698 0.15555,0.67935 0.47031,0.93391c0.31476,0.25456 0.71426,0.38297 1.1993,0.38297c0.387,0 0.76411,-0.13964 1.12875,-0.41656c0.3612,-0.27692 0.54422,-0.57695 0.54422,-0.90031v-2.7043c3.42968,-0.44204 6.13325,-1.75934 8.10953,-3.95062c1.97456,-2.193 2.96297,-5.21243 2.96297,-9.06695c0,-2.19472 -0.30323,-4.10881 -0.91039,-5.74453c-0.60716,-1.63572 -1.49602,-2.98197 -2.66734,-4.03461c-1.17304,-1.05264 -2.30429,-1.86926 -3.38961,-2.45234c-1.08532,-0.58136 -2.45396,-1.18626 -4.10516,-1.81406v-16.65578c1.90232,0.08944 3.68021,0.52428 5.32797,1.30344c1.64604,0.78088 2.53662,1.17242 2.66735,1.17242c0.45064,0 0.83571,-0.28084 1.15562,-0.83985c0.3182,-0.55728 0.48039,-1.10446 0.48039,-1.63937c0,-1.07328 -0.99489,-1.99732 -2.97976,-2.7782c-1.9866,-0.77916 -4.20392,-1.21564 -6.65492,-1.3068v-1.94172c0,-0.31132 -0.1813,-0.60176 -0.54422,-0.87008c-0.36292,-0.2666 -0.73839,-0.39977 -1.12539,-0.39977zM85.47594,79.65078v15.53711c-2.61956,-0.9374 -4.59802,-1.98501 -5.9293,-3.14773c-1.333,-1.161 -1.99883,-2.92602 -1.99883,-5.29102c0,-4.28624 2.64256,-6.65116 7.92812,-7.09836zM88.4893,100.89883c2.29276,0.98556 4.04818,2.18577 5.26078,3.59789c1.2126,1.4104 1.81742,3.45766 1.81742,6.1443c0,4.97424 -2.36024,7.83968 -7.0782,8.60336z"></path></g></g></svg>
                            </div>
                            <div class="col l7 m12 s12">
                                <h4 class="fss-bold white-text m">میخواهید ملک خود را بفروشید؟</h4>
                                <p class="tt white-text fss-thin text-justify">هر روز دهها آگهی جدید و صدها پیشنهاد در سایت،که مورد اعتماد جامعه ای از هزاران نفر از کاربران است، دراختیار شماست.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="new-select-main">
        <div class="container py-5">
            <div class="row py-5">
                <div class="col l4 m12 s12">
                    <div class="card-panel transparent z-depth-0">
                        <div class="row">
                            <div class="col l3 m12 s12">
                                <svg class="responsive-img center-block" xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="75" height="75" viewBox="0 0 172 172" style=" fill:#000000;"><g fill="none" fill-rule="nonzero" stroke="none" stroke-width="1" stroke-linecap="butt" stroke-linejoin="miter" stroke-miterlimit="10" stroke-dasharray="" stroke-dashoffset="0" font-family="none" font-weight="none" font-size="none" text-anchor="none" style="mix-blend-mode: normal"><path d="M0,172v-172h172v172z" fill="none"></path><g fill="#ffffff"><path d="M45.15,21.5c-8.28365,0 -15.0475,6.7649 -15.05,15.05c0,8.28409 6.76591,15.05 15.05,15.05c8.28588,0 15.05,-6.76635 15.05,-15.05v-2.15h-0.43672c-1.08937,-7.22936 -7.08968,-12.9 -14.61328,-12.9zM86,21.5c-8.28365,0 -15.0475,6.7649 -15.05,15.05c0,8.28409 6.76591,15.05 15.05,15.05c8.28588,0 15.05,-6.76635 15.05,-15.05v-2.15h-0.43672c-1.08937,-7.22936 -7.08968,-12.9 -14.61328,-12.9zM126.85,21.5c-8.28642,0 -15.05,6.76358 -15.05,15.05c0,8.28642 6.76358,15.05 15.05,15.05c8.28642,0 15.05,-6.76358 15.05,-15.05c0,-8.28642 -6.76358,-15.05 -15.05,-15.05zM45.15,25.8c5.96045,0 10.75,4.78955 10.75,10.75c0,5.95795 -4.78998,10.75 -10.75,10.75c-5.95751,0 -10.75,-4.79249 -10.75,-10.75c0.0018,-5.9608 4.79205,-10.75 10.75,-10.75zM86,25.8c5.96045,0 10.75,4.78955 10.75,10.75c0,5.95795 -4.78998,10.75 -10.75,10.75c-5.95751,0 -10.75,-4.79249 -10.75,-10.75c0.0018,-5.9608 4.79205,-10.75 10.75,-10.75zM126.85,25.8c5.96253,0 10.75,4.78747 10.75,10.75c0,5.96253 -4.78747,10.75 -10.75,10.75c-5.96253,0 -10.75,-4.78747 -10.75,-10.75c0,-5.96253 4.78747,-10.75 10.75,-10.75zM36.55,55.9c-9.47384,0 -17.2,7.72616 -17.2,17.2v32.25c0,4.72427 3.87573,8.6 8.6,8.6h2.15v27.95c0,4.72427 3.87573,8.6 8.6,8.6h15.05c0.77537,0.01097 1.49657,-0.39641 1.88746,-1.06613c0.39088,-0.66972 0.39088,-1.49803 0,-2.16775c-0.39088,-0.66972 -1.11209,-1.07709 -1.88746,-1.06613h-15.05c-2.40083,0 -4.3,-1.89917 -4.3,-4.3v-32.25h-6.45c-2.40083,0 -4.3,-1.89917 -4.3,-4.3v-32.25c0,-7.14996 5.75004,-12.9 12.9,-12.9h17.2c2.3579,0 4.55227,0.62778 6.45,1.72588c0.66588,0.40751 1.50032,0.42209 2.18003,0.03809c0.67971,-0.384 1.09789,-1.10624 1.09253,-1.8869c-0.00537,-0.78066 -0.43344,-1.49708 -1.11836,-1.8717c-2.53127,-1.4647 -5.4796,-2.30537 -8.6042,-2.30537zM90.51416,55.9v4.3l-1.48652,-3.70791l-2.95625,2.81768l-2.61191,-2.73789c-0.40598,-0.42648 -0.96909,-0.66781 -1.55791,-0.66768c-5.84225,0 -10.41291,2.14665 -13.62647,5.79912c-3.21356,3.65247 -5.16559,8.60647 -6.72295,14.39912c-0.01083,0.03752 -0.02063,0.07533 -0.02939,0.11338l-5.41699,25.49346c-0.82013,3.4407 1.33858,6.94856 4.77871,7.76855c0.0014,0 0.0028,0 0.0042,0c0.60442,0.14239 1.22111,0.20056 1.83086,0.16797c2.79343,-0.14566 5.25824,-2.12082 5.9335,-4.94668l2.29697,-8.65879v45.85967c0,4.72427 3.87573,8.6 8.6,8.6h12.9c4.72427,0 8.6,-3.87573 8.6,-8.6v-32.25h1.32695h0.82305c4.72427,0 8.6,-3.87573 8.6,-8.6v-23.86416c0,-11.849 -9.45232,-21.28584 -21.28584,-21.28584zM118.25,55.9c-1.7044,0 -3.35655,0.2486 -4.91728,0.71387c-0.75966,0.19886 -1.35051,0.79603 -1.54127,1.55777c-0.19076,0.76174 0.04889,1.56689 0.62517,2.10032c0.57628,0.53343 1.39751,0.71028 2.14227,0.46135c1.16546,-0.34743 2.40271,-0.5333 3.69111,-0.5333h17.2c7.14996,0 12.9,5.75004 12.9,12.9v32.25c0,2.40083 -1.89917,4.3 -4.3,4.3h-6.45v32.25c0,2.40083 -1.89917,4.3 -4.3,4.3h-12.9c-2.40083,0 -4.3,-1.89917 -4.3,-4.3v-27.95c0.01097,-0.77537 -0.39641,-1.49657 -1.06613,-1.88746c-0.66972,-0.39088 -1.49803,-0.39088 -2.16775,0c-0.66972,0.39088 -1.07709,1.11209 -1.06613,1.88746v27.95c0,4.72427 3.87573,8.6 8.6,8.6h12.9c4.72427,0 8.6,-3.87573 8.6,-8.6v-27.95h2.15c4.72427,0 8.6,-3.87573 8.6,-8.6v-32.25c0,-9.47384 -7.72616,-17.2 -17.2,-17.2zM91.22803,60.33857c9.20866,0.38001 16.27197,7.50795 16.27197,16.84727v23.86416c0,2.40083 -1.89917,4.3 -4.3,4.3h-0.82305h-3.47695c-1.18736,0.00012 -2.14988,0.96264 -2.15,2.15v34.4c0,2.40083 -1.89917,4.3 -4.3,4.3h-12.9c-2.40083,0 -4.3,-1.89917 -4.3,-4.3v-62.35c-0.00049,-1.07993 -0.80193,-1.99196 -1.87283,-2.13127c-1.07091,-0.13931 -2.07901,0.53731 -2.35578,1.58117l-6.53818,24.64521c-0.00444,0.01814 -0.00864,0.03634 -0.0126,0.05459c-0.23195,0.97105 -1.06036,1.60245 -1.97783,1.65029c-0.19303,0.01032 -0.39784,-0.0043 -0.61309,-0.05459h-0.0042c-1.17585,-0.28227 -1.86768,-1.41464 -1.5873,-2.59092c0.0044,-0.01675 0.0086,-0.03354 0.0126,-0.05039l5.40439,-25.43467l0.0042,-0.0168c1.47759,-5.49049 3.30891,-9.83089 5.79492,-12.65645c2.32914,-2.64725 5.27857,-4.01853 9.61621,-4.19922l3.32578,3.48535c0.81817,0.85775 2.1762,0.89156 3.03603,0.07559zM85.96641,66.62061c-1.18576,0.01854 -2.13264,0.9936 -2.11641,2.17939v19.35c-0.01097,0.77537 0.39641,1.49657 1.06613,1.88746c0.66972,0.39088 1.49803,0.39088 2.16775,0c0.66972,-0.39088 1.07709,-1.11209 1.06613,-1.88746v-19.35c0.00796,-0.58115 -0.21968,-1.14076 -0.63105,-1.55134c-0.41137,-0.41057 -0.97142,-0.63714 -1.55255,-0.62806zM32.25,75.25c-1.18741,0 -2.15,0.96259 -2.15,2.15c0,1.18741 0.96259,2.15 2.15,2.15c1.18741,0 2.15,-0.96259 2.15,-2.15c0,-1.18741 -0.96259,-2.15 -2.15,-2.15zM139.75,75.25c-1.18741,0 -2.15,0.96259 -2.15,2.15c0,1.18741 0.96259,2.15 2.15,2.15c1.18741,0 2.15,-0.96259 2.15,-2.15c0,-1.18741 -0.96259,-2.15 -2.15,-2.15zM98.9,79.55c-1.18741,0 -2.15,0.96259 -2.15,2.15c0,1.18741 0.96259,2.15 2.15,2.15c1.18741,0 2.15,-0.96259 2.15,-2.15c0,-1.18741 -0.96259,-2.15 -2.15,-2.15zM32.25,83.85c-1.18741,0 -2.15,0.96259 -2.15,2.15c0,1.18741 0.96259,2.15 2.15,2.15c1.18741,0 2.15,-0.96259 2.15,-2.15c0,-1.18741 -0.96259,-2.15 -2.15,-2.15zM139.75,83.85c-1.18741,0 -2.15,0.96259 -2.15,2.15c0,1.18741 0.96259,2.15 2.15,2.15c1.18741,0 2.15,-0.96259 2.15,-2.15c0,-1.18741 -0.96259,-2.15 -2.15,-2.15zM98.9,88.15c-1.18741,0 -2.15,0.96259 -2.15,2.15c0,1.18741 0.96259,2.15 2.15,2.15c1.18741,0 2.15,-0.96259 2.15,-2.15c0,-1.18741 -0.96259,-2.15 -2.15,-2.15zM32.25,92.45c-1.18741,0 -2.15,0.96259 -2.15,2.15c0,1.18741 0.96259,2.15 2.15,2.15c1.18741,0 2.15,-0.96259 2.15,-2.15c0,-1.18741 -0.96259,-2.15 -2.15,-2.15zM139.75,92.45c-1.18741,0 -2.15,0.96259 -2.15,2.15c0,1.18741 0.96259,2.15 2.15,2.15c1.18741,0 2.15,-0.96259 2.15,-2.15c0,-1.18741 -0.96259,-2.15 -2.15,-2.15zM98.9,96.75c-1.18741,0 -2.15,0.96259 -2.15,2.15c0,1.18741 0.96259,2.15 2.15,2.15c1.18741,0 2.15,-0.96259 2.15,-2.15c0,-1.18741 -0.96259,-2.15 -2.15,-2.15zM32.25,101.05c-1.18741,0 -2.15,0.96259 -2.15,2.15c0,1.18741 0.96259,2.15 2.15,2.15c1.18741,0 2.15,-0.96259 2.15,-2.15c0,-1.18741 -0.96259,-2.15 -2.15,-2.15zM139.75,101.05c-1.18741,0 -2.15,0.96259 -2.15,2.15c0,1.18741 0.96259,2.15 2.15,2.15c1.18741,0 2.15,-0.96259 2.15,-2.15c0,-1.18741 -0.96259,-2.15 -2.15,-2.15zM55.9,113.95c-1.18736,0.00012 -2.14988,0.96264 -2.15,2.15v21.5c0.00012,1.18736 0.96264,2.14988 2.15,2.15h8.6c1.18736,-0.00012 2.14988,-0.96264 2.15,-2.15v-21.5c-0.00012,-1.18736 -0.96264,-2.14988 -2.15,-2.15zM58.05,118.25h4.3v17.2h-4.3z"></path></g></g></svg>
                            </div>
                            <div class="col l9 m12 s12">
                                <h4 class="fss-bold white-text ss">تأیید شده توسط هزاران نفر</h4>
                                <p class="tt white-text fss-thin text-justify">هر روز دهها آگهی جدید و صدها پیشنهاد در سایت،که مورد اعتماد جامعه ای از هزاران نفر از کاربران است، دراختیار شماست.</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col l4 m12 s12">
                    <div class="card-panel transparent z-depth-0">
                        <div class="row">
                            <div class="col l3 m12 s12">
                                <svg class="responsive-img center-block" xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="75" height="75" viewBox="0 0 172 172" style=" fill:#000000;"><g fill="none" fill-rule="nonzero" stroke="none" stroke-width="1" stroke-linecap="butt" stroke-linejoin="miter" stroke-miterlimit="10" stroke-dasharray="" stroke-dashoffset="0" font-family="none" font-weight="none" font-size="none" text-anchor="none" style="mix-blend-mode: normal"><path d="M0,172v-172h172v172z" fill="none"></path><g fill="#ffffff"><path d="M86,20.64c-26.57815,0 -48.16,21.58185 -48.16,48.16c0,14.7275 11.85304,34.85707 23.5257,51.71758c11.67266,16.86051 23.33758,30.25117 23.33758,30.25117c0.32668,0.37479 0.79954,0.5899 1.29672,0.5899c0.49718,0 0.97004,-0.21511 1.29672,-0.5899c0,0 11.66492,-13.39066 23.33758,-30.25117c11.67266,-16.86051 23.5257,-36.99008 23.5257,-51.71758c0,-26.57815 -21.58185,-48.16 -48.16,-48.16zM86,24.08c24.71913,0 44.72,20.00087 44.72,44.72c0,12.7925 -11.36696,33.08293 -22.9143,49.76242c-10.51067,15.18207 -20.00199,26.28696 -21.8057,28.38336c-1.80372,-2.0964 -11.29504,-13.20129 -21.8057,-28.38336c-11.54734,-16.67949 -22.9143,-36.96992 -22.9143,-49.76242c0,-24.71913 20.00087,-44.72 44.72,-44.72zM86,32.68c-19.9386,0 -36.12,16.1814 -36.12,36.12c0,19.9386 16.1814,36.12 36.12,36.12c19.64124,0 35.60433,-15.71018 36.07633,-35.23984c0.0073,-0.30731 -0.14994,-0.59516 -0.41246,-0.75508c-0.26252,-0.15992 -0.59043,-0.16761 -0.86015,-0.02016c-0.26973,0.14745 -0.44028,0.42761 -0.44738,0.73493c-0.44992,18.6165 -15.63125,33.56016 -34.35633,33.56016c-19.00908,0 -34.4,-15.39092 -34.4,-34.4c0,-19.00908 15.39092,-34.4 34.4,-34.4c5.7639,0 11.1773,1.43153 15.94023,3.94055c0.27312,0.15635 0.60982,0.15106 0.87788,-0.01381c0.26806,-0.16486 0.42469,-0.46297 0.40836,-0.77725c-0.01633,-0.31428 -0.203,-0.59455 -0.48671,-0.73074c-4.99979,-2.63379 -10.6907,-4.13875 -16.73977,-4.13875zM106.82477,39.55328c-0.36603,0.01707 -0.68104,0.26417 -0.78481,0.6156c-0.10376,0.35143 0.02652,0.73 0.32457,0.94315c2.58125,1.90992 4.88778,4.16934 6.8464,6.71203c0.18008,0.26309 0.49091,0.40499 0.80766,0.3687c0.31675,-0.03629 0.58743,-0.24482 0.70333,-0.54183c0.1159,-0.29701 0.058,-0.63376 -0.15044,-0.875c-2.05585,-2.66891 -4.47287,-5.04317 -7.18234,-7.04797c-0.1616,-0.12304 -0.36153,-0.18492 -0.56437,-0.17469zM86.01008,46.44c-0.35278,-0.00179 -0.69757,0.10494 -0.98765,0.3057l-16.985,11.75781c-0.15236,0.0752 -0.29274,0.17256 -0.41656,0.28891l-4.95844,3.43328c-0.52774,0.34009 -0.82828,0.94069 -0.78411,1.56697c0.04417,0.62628 0.42605,1.17874 0.9963,1.44139c0.57026,0.26264 1.23831,0.19374 1.74296,-0.17976l2.46242,-1.7032v24.36891c0.00009,0.94989 0.77011,1.71991 1.72,1.72h34.4c0.94989,-0.00009 1.71991,-0.77011 1.72,-1.72v-24.36891l2.46242,1.7032c0.50465,0.37351 1.1727,0.44241 1.74296,0.17976c0.57026,-0.26264 0.95213,-0.81511 0.9963,-1.44139c0.04417,-0.62628 -0.25636,-1.22688 -0.78411,-1.56697l-4.96851,-3.44c-0.12141,-0.11197 -0.25831,-0.20588 -0.40649,-0.27883l-4.20258,-2.91258v-5.7143c0.00637,-0.46492 -0.17574,-0.91261 -0.50484,-1.24107c-0.32909,-0.32846 -0.77713,-0.50971 -1.24204,-0.50245c-0.94861,0.01483 -1.70612,0.79488 -1.69313,1.74352v3.3325l-9.34242,-6.4668c-0.28443,-0.19686 -0.6216,-0.3034 -0.9675,-0.3057zM86,50.25289l10.8743,7.525c0.11935,0.11145 0.25395,0.20533 0.39977,0.27883l4.20594,2.91258v25.0307h-8.6v-12.9c-0.00005,-0.47495 -0.38505,-0.85995 -0.86,-0.86h-12.04c-0.47495,0.00005 -0.85995,0.38505 -0.86,0.86v12.9h-8.6v-25.0307zM117.21531,51.58992c-0.30367,-0.00107 -0.58539,0.15808 -0.74122,0.41872c-0.15583,0.26064 -0.16267,0.58413 -0.018,0.85112c0.84294,1.60864 1.5665,3.28854 2.15,5.03234c0.08475,0.3066 0.3318,0.54139 0.64232,0.61044c0.31052,0.06904 0.63378,-0.03893 0.84047,-0.28073c0.20669,-0.2418 0.26304,-0.57793 0.14651,-0.87392c-0.61362,-1.8338 -1.3702,-3.60078 -2.25414,-5.28766c-0.14657,-0.28831 -0.4425,-0.47003 -0.76594,-0.47031zM80.84,73.96h10.32v12.04h-10.32z"></path></g></g></svg>
                            </div>
                            <div class="col l9 m12 s12">
                                <h4 class="fss-bold white-text ss">تنوع گسترده ای از املاک</h4>
                                <p class="tt white-text fss-thin text-justify">هر روز دهها آگهی جدید و صدها پیشنهاد در سایت،که مورد اعتماد جامعه ای از هزاران نفر از کاربران است، دراختیار شماست.</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col l4 m12 s12">
                    <div class="card-panel transparent z-depth-0">
                        <div class="row">
                            <div class="col l3 m12 s12">
                                <svg class="responsive-img center-block" xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="75" height="75" viewBox="0 0 172 172" style=" fill:#000000;"><g fill="none" fill-rule="nonzero" stroke="none" stroke-width="1" stroke-linecap="butt" stroke-linejoin="miter" stroke-miterlimit="10" stroke-dasharray="" stroke-dashoffset="0" font-family="none" font-weight="none" font-size="none" text-anchor="none" style="mix-blend-mode: normal"><path d="M0,172v-172h172v172z" fill="none"></path><g fill="#ffffff"><path d="M62.35,40.85c-3.46016,0 -6.51719,1.68809 -8.49082,4.24121c-1.65449,-0.83984 -3.31738,-1.45293 -4.98027,-1.78047c-2.15,-0.41992 -4.3168,-0.39472 -6.51719,0.12598c-4.39238,1.03301 -8.77637,3.82969 -14.10098,8.23887c-6.03008,4.99707 -18.88809,15.72188 -18.88809,15.72188c-0.91543,0.76426 -1.03301,2.12481 -0.27715,3.03184c0.76426,0.91543 2.11641,1.04141 3.03184,0.27715c0,0 12.86641,-10.7332 18.87969,-15.71348c5.10625,-4.23281 9.04512,-6.59277 12.3457,-7.38223c2.93945,-0.68867 5.50937,-0.24355 8.6084,1.37734c-0.21836,0.84824 -0.36113,1.70488 -0.36113,2.61191v43.97422l-5.83691,2.75469c-0.70547,0.31914 -1.19258,0.99941 -1.25976,1.77207c-0.06719,0.77266 0.28555,1.52012 0.92383,1.96523c0.64668,0.43672 1.47812,0.49551 2.1752,0.15117l37.99453,-17.93066l-1.0666,-1.0666c0.65508,0.65508 1.6377,0.81465 2.46914,0.41992c1.80566,-0.88184 3.83809,-1.94004 5.45059,-1.94004c4.77031,0 8.6,3.82969 8.6,8.6c0,2.72109 -1.27656,5.09785 -3.26699,6.68516c-0.88184,0.70547 -1.0666,1.97363 -0.42832,2.90586l-1.19258,-1.55371l-35.33223,27.22774c-6.31562,4.8627 -14.05899,7.4998 -22.0291,7.4998h-25.90078c-0.77266,-0.0084 -1.49492,0.39473 -1.88965,1.0666c-0.38633,0.67188 -0.38633,1.49492 0,2.1668c0.39473,0.67188 1.11699,1.075 1.88965,1.0666h25.90078c7.76016,0 15.32715,-2.24238 21.81914,-6.40801c2.1668,2.72949 5.50937,4.49316 9.25508,4.49316c3.67852,0 6.4752,-2.36836 8.41524,-4.44277c0.15117,-0.16797 0.10078,-0.16797 0.25195,-0.33594c1.87285,4.05645 5.9377,6.92871 10.68281,6.92871c3.65332,0 6.49199,-1.83926 8.29766,-4.09844c0.85664,-1.075 1.0834,-2.20879 1.6209,-3.35937c1.6125,1.64609 4.2916,3.15781 8.28086,3.15781c3.19141,0 6.05527,-1.22617 8.23047,-3.2502c2.1752,-2.02402 3.70371,-4.78711 4.65273,-7.96172l0.0168,-0.03359l2.26758,-8.10449h30.05801c5.9125,0 10.75,-4.8375 10.75,-10.75v-51.6c0,-5.9125 -4.8375,-10.75 -10.75,-10.75zM62.35,45.15h90.3c3.58613,0 6.45,2.86387 6.45,6.45v4.3h-103.2v-4.3c0,-3.58613 2.86387,-6.45 6.45,-6.45zM55.9,64.5h103.2v38.7c0,3.58613 -2.86387,6.45 -6.45,6.45h-64.12207l11.95938,-9.21309c0.32754,-0.25195 0.57949,-0.59629 0.71387,-0.99102c2.44394,-2.33476 4.14883,-5.48418 4.14883,-9.1459c0,-7.09668 -5.80332,-12.9 -12.9,-12.9c-3.14101,0 -5.66055,1.54531 -7.21426,2.30957c-0.03359,0.0168 -0.06719,0.03359 -0.10078,0.04199l-29.23496,13.79863zM66.65,68.8c-1.18418,0 -2.15,0.96582 -2.15,2.15c0,1.18418 0.96582,2.15 2.15,2.15c1.18418,0 2.15,-0.96582 2.15,-2.15c0,-1.18418 -0.96582,-2.15 -2.15,-2.15zM75.25,68.8c-1.18418,0 -2.15,0.96582 -2.15,2.15c0,1.18418 0.96582,2.15 2.15,2.15c1.18418,0 2.15,-0.96582 2.15,-2.15c0,-1.18418 -0.96582,-2.15 -2.15,-2.15zM83.85,68.8c-1.18418,0 -2.15,0.96582 -2.15,2.15c0,1.18418 0.96582,2.15 2.15,2.15c1.18418,0 2.15,-0.96582 2.15,-2.15c0,-1.18418 -0.96582,-2.15 -2.15,-2.15zM92.45,68.8c-1.18418,0 -2.15,0.96582 -2.15,2.15c0,1.18418 0.96582,2.15 2.15,2.15c1.18418,0 2.15,-0.96582 2.15,-2.15c0,-1.18418 -0.96582,-2.15 -2.15,-2.15zM86,88.15c-1.18418,0 -2.15,0.96582 -2.15,2.15c0,1.18418 0.96582,2.15 2.15,2.15c1.18418,0 2.15,-0.96582 2.15,-2.15c0,-1.18418 -0.96582,-2.15 -2.15,-2.15zM90.3,94.6c-1.18418,0 -2.15,0.96582 -2.15,2.15c0,1.18418 0.96582,2.15 2.15,2.15c1.18418,0 2.15,-0.96582 2.15,-2.15c0,-1.18418 -0.96582,-2.15 -2.15,-2.15zM82.94297,113.95h35.18105l-1.93164,6.92031c-0.78105,2.59512 -1.99883,4.66953 -3.46855,6.03848c-1.46973,1.36895 -3.14941,2.09121 -5.29941,2.09121c-3.14941,0 -4.57715,-1.03301 -5.42539,-1.98203c-0.84824,-0.94062 -0.99941,-1.70488 -0.99941,-1.70488l-4.15723,-0.14277c-0.57949,1.92324 -1.44453,4.09844 -2.6791,5.64375c-1.23457,1.54531 -2.62031,2.48594 -4.93828,2.48594c-4.18242,0 -7.525,-3.34258 -7.525,-7.525l-4.01445,-1.075c0,0 -0.98262,1.68809 -2.54473,3.36777c-1.56211,1.68809 -3.60293,3.08223 -5.26582,3.08223c-2.32637,0 -4.37559,-1.0498 -5.75293,-2.6959zM81.7,116.1c-1.18418,0 -2.15,0.96582 -2.15,2.15c0,1.18418 0.96582,2.15 2.15,2.15c1.18418,0 2.15,-0.96582 2.15,-2.15c0,-1.18418 -0.96582,-2.15 -2.15,-2.15zM101.05,116.1c-1.18418,0 -2.15,0.96582 -2.15,2.15c0,1.18418 0.96582,2.15 2.15,2.15c1.18418,0 2.15,-0.96582 2.15,-2.15c0,-1.18418 -0.96582,-2.15 -2.15,-2.15z"></path></g></g></svg>
                            </div>
                            <div class="col l9 m12 s12">
                                <h4 class="fss-bold white-text ss">تأمین مالی آسان وام های بانکی</h4>
                                <p class="tt white-text fss-thin text-justify">هر روز دهها آگهی جدید و صدها پیشنهاد در سایت،که مورد اعتماد جامعه ای از هزاران نفر از کاربران است، دراختیار شماست.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="green accent-3">
        <div class="container"><div class="row py-5">
            <div class="col l3 m12 s12">
            <svg class="responsive-img center-block" xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="75" height="75" viewBox="0 0 172 172" style=" fill:#000000;"><g fill="none" fill-rule="nonzero" stroke="none" stroke-width="1" stroke-linecap="butt" stroke-linejoin="miter" stroke-miterlimit="10" stroke-dasharray="" stroke-dashoffset="0" font-family="none" font-weight="none" font-size="none" text-anchor="none" style="mix-blend-mode: normal"><path d="M0,172v-172h172v172z" fill="none"></path><g fill="#ffffff"><path d="M86,5.375c-5.9209,0 -14.38232,1.84766 -19.64185,5.396c-10.00464,0.36743 -16.84936,7.39063 -17.97266,18.52905c-0.68237,6.87622 -0.05249,11.7998 0.35693,15.0542c0.14697,1.13379 0.30444,2.41455 0.25195,2.79248c-0.08398,0.50391 -0.16797,1.00781 -0.24146,1.51172c-0.44092,0.02099 -0.82935,0.09448 -1.17578,0.17847c-4.43017,1.18628 -6.28833,7.66358 -4.3042,15.0647c1.43823,5.3645 4.45117,9.39575 7.74756,10.63452c1.6062,4.91309 3.93677,9.79468 6.80273,14.24585l-35.64087,17.04883c-10.2041,4.88159 -16.80737,15.34815 -16.80737,26.66504v20.69165c0,4.44067 3.62183,8.0625 8.0625,8.0625h56.4375v2.6875c0,2.96045 2.41455,5.375 5.375,5.375h21.5c2.96045,0 5.375,-2.41455 5.375,-5.375v-2.6875h56.4375c4.44067,0 8.0625,-3.62183 8.0625,-8.0625v-20.69165c0,-11.31689 -6.59277,-21.78345 -16.80737,-26.66504l-35.64087,-17.05933c2.86597,-4.44067 5.19653,-9.32227 6.80273,-14.23535c3.29639,-1.23877 6.30933,-5.27002 7.74756,-10.63452c1.98413,-7.40112 0.12598,-13.87842 -4.3042,-15.0647c-0.33594,-0.09448 -0.72436,-0.15747 -1.16528,-0.17847c-0.37793,-2.87647 -1.11279,-5.56397 -2.46704,-9.23828c-0.04199,-0.10498 -0.07349,-0.20996 -0.10498,-0.29395c0.95532,0.07349 2.46704,0.47241 3.70581,0.97632c0.93433,0.38843 1.99463,0.22046 2.76099,-0.41992c0.76636,-0.64038 1.11279,-1.65869 0.90283,-2.63501c-4.3357,-19.83081 -19.05396,-31.67261 -39.36768,-31.67261zM86,10.75h2.6875c16.31397,0 28.09277,8.33545 32.92188,23.06421c-1.85815,-0.20996 -3.7793,0.021 -5.09155,1.29126c-1.02881,0.97632 -1.99463,2.85547 -0.77686,6.17285c1.65869,4.50366 2.24658,7.17017 2.42505,10.94946c0.04199,0.96582 0.59839,1.82666 1.45923,2.26758c0.85034,0.43042 1.87915,0.38843 2.698,-0.14697c0.43042,-0.28345 0.66138,-0.31494 0.71387,-0.31494c0.65088,0.22046 1.82666,3.49585 0.49341,8.47192c-1.32276,4.95508 -3.86328,7.04419 -4.65064,7.04419c-1.18628,0 -2.23608,0.78735 -2.57202,1.92114c-4.53516,15.24316 -16.39795,30.6543 -30.30786,30.6543c-13.90991,0 -25.77271,-15.42163 -30.30786,-30.6543c-0.33594,-1.13379 -1.37524,-1.92114 -2.57202,-1.92114c-0.78735,0 -3.32788,-2.08911 -4.65064,-7.03369c-1.34375,-5.02857 -0.13647,-8.31445 0.48291,-8.48242c0.0105,0 0.24146,0 0.72436,0.31494c0.81885,0.5249 1.83716,0.57739 2.698,0.14697c0.86084,-0.44092 1.41724,-1.30176 1.45923,-2.26758c0.06299,-1.39624 0.22046,-2.79248 0.46191,-4.14673c0.19946,-1.15478 0.03149,-2.44604 -0.22046,-4.40918c-0.38843,-3.01294 -0.96582,-7.56909 -0.33594,-13.83642c0.86084,-8.57691 5.8894,-13.71045 13.50049,-13.71045c0.57739,0 1.14429,-0.18896 1.6167,-0.5354c3.67432,-2.76098 11.04395,-4.8396 17.14331,-4.8396zM71.29224,27.21094c-1.92114,-0.16797 -3.85278,0.70337 -4.95508,2.39355l-4.3147,6.54028c-0.81885,1.23877 -0.47241,2.90796 0.76636,3.72681c0.46191,0.30444 0.96582,0.44092 1.46973,0.44092c0.88184,0 1.73218,-0.41992 2.25708,-1.20728l4.3042,-6.54028l4.19922,2.04712c7.65308,3.72681 16.19848,5.70044 24.7124,5.70044h6.87622c1.48022,0 2.6875,-1.20728 2.6875,-2.6875c0,-1.48022 -1.20728,-2.6875 -2.6875,-2.6875h-6.87622c-7.69507,0 -15.43213,-1.78467 -22.35034,-5.16504l-4.19922,-2.04712c-0.60889,-0.29395 -1.24927,-0.46191 -1.88965,-0.5144zM61.01465,93.22266c6.60327,8.33545 15.31665,14.27734 24.98535,14.27734c9.6687,0 18.38208,-5.94189 24.98535,-14.27734l6.79224,3.2334l-24.89087,32.54395h-13.77344l-24.89087,-32.54395zM49.26733,98.83911l23.54712,30.78027c-1.74267,0.88184 -2.93945,2.677 -2.93945,4.75561v21.5h-56.4375c-1.48022,0 -2.6875,-1.20728 -2.6875,-2.6875v-20.69165c0,-9.25928 5.396,-17.82568 13.75244,-21.81494zM122.73267,98.83911l24.76489,11.8418c8.35645,3.98926 13.75244,12.55566 13.75244,21.81494v20.69165c0,1.48022 -1.20728,2.6875 -2.6875,2.6875h-56.4375v-21.5c0,-2.07861 -1.19678,-3.87378 -2.93945,-4.75561zM83.21802,134.375h10.98096c0.0105,0 0.0105,0 0.021,0c0.0105,0 0.0105,0 0.0105,0h2.51953v29.5625h-21.5v-29.5625h1.20728l4.58765,6.00488c-0.27295,0.62988 -0.41992,1.32276 -0.41992,2.05762c0,2.96045 2.41455,5.375 5.375,5.375c2.96045,0 5.375,-2.41455 5.375,-5.375c0,-2.96045 -2.41455,-5.375 -5.375,-5.375c-0.23096,0 -0.45142,0.04199 -0.67187,0.07349zM18.8125,139.75c-1.48022,0 -2.6875,1.20728 -2.6875,2.6875v5.375c0,1.48022 1.20728,2.6875 2.6875,2.6875c1.48022,0 2.6875,-1.20728 2.6875,-2.6875v-5.375c0,-1.48022 -1.20728,-2.6875 -2.6875,-2.6875zM32.25,139.75c-1.48022,0 -2.6875,1.20728 -2.6875,2.6875v5.375c0,1.48022 1.20728,2.6875 2.6875,2.6875c1.48022,0 2.6875,-1.20728 2.6875,-2.6875v-5.375c0,-1.48022 -1.20728,-2.6875 -2.6875,-2.6875zM45.6875,139.75c-1.48022,0 -2.6875,1.20728 -2.6875,2.6875v5.375c0,1.48022 1.20728,2.6875 2.6875,2.6875c1.48022,0 2.6875,-1.20728 2.6875,-2.6875v-5.375c0,-1.48022 -1.20728,-2.6875 -2.6875,-2.6875zM59.125,139.75c-1.48022,0 -2.6875,1.20728 -2.6875,2.6875v5.375c0,1.48022 1.20728,2.6875 2.6875,2.6875c1.48022,0 2.6875,-1.20728 2.6875,-2.6875v-5.375c0,-1.48022 -1.20728,-2.6875 -2.6875,-2.6875zM112.875,139.75c-1.48022,0 -2.6875,1.20728 -2.6875,2.6875v5.375c0,1.48022 1.20728,2.6875 2.6875,2.6875c1.48022,0 2.6875,-1.20728 2.6875,-2.6875v-5.375c0,-1.48022 -1.20728,-2.6875 -2.6875,-2.6875zM126.3125,139.75c-1.48022,0 -2.6875,1.20728 -2.6875,2.6875v5.375c0,1.48022 1.20728,2.6875 2.6875,2.6875c1.48022,0 2.6875,-1.20728 2.6875,-2.6875v-5.375c0,-1.48022 -1.20728,-2.6875 -2.6875,-2.6875zM139.75,139.75c-1.48022,0 -2.6875,1.20728 -2.6875,2.6875v5.375c0,1.48022 1.20728,2.6875 2.6875,2.6875c1.48022,0 2.6875,-1.20728 2.6875,-2.6875v-5.375c0,-1.48022 -1.20728,-2.6875 -2.6875,-2.6875zM153.1875,139.75c-1.48022,0 -2.6875,1.20728 -2.6875,2.6875v5.375c0,1.48022 1.20728,2.6875 2.6875,2.6875c1.48022,0 2.6875,-1.20728 2.6875,-2.6875v-5.375c0,-1.48022 -1.20728,-2.6875 -2.6875,-2.6875z"></path></g></g></svg>
            </div>
            <div class="col l6 m12 s12"><h4 class="mm white-text center-align">نماینده فروش شما می شویم ، شروع کنید</h4></div>
            <div class="col l3 m12 s12"><a href="#" class="btn2 btn-block s white-text border-white">شروع کنید</a></div>
        </div></div>
    </section>
    <script type="text/javascript">
    	$(document).ready(function(){
            $('.sl2').owlCarousel({
                loop:true,
                margin:0,
                nav:false,
                dots:false,
                autoplay:true,
                autoplayTimeout:3500,
                autoplayHoverPause:false,
                responsive:{
                    0:{
                        items:2
                    },
                    600:{
                        items:2
                    },
                    1000:{
                        items:4
                    }
                }
            });
        });
    </script>
    <?php include_once 'index-footer.php'; ?>
</body>
</html>
